/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.permit.dto.SysConfRolesetDto;
import com.jxdinfo.hussar.authorization.permit.model.SysConfRoleset;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesetService;
import com.jxdinfo.hussar.authorization.permit.vo.SysConfRolesetVo;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6"})
@RestController
@RequestMapping(value={"/incompatibleRolesFront"})
public class IncompatibleRolesFrontController
extends HussarBaseController<SysConfRoleset, ISysConfRolesetService> {
    @Resource
    private ISysConfRolesetService isConfRolesetService;
    @Resource
    private ISysConfRolesService isConfRolesService;

    @ApiOperation(value="\u83b7\u53d6\u4e0d\u76f8\u5bb9\u89d2\u8272\u5217\u8868", notes="\u83b7\u53d6\u4e0d\u76f8\u5bb9\u89d2\u8272\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysConfRolesetDto", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6dto", paramType="query")})
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"incompatibleRolesFront:getList"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u83b7\u53d6\u4e0d\u76f8\u5bb9\u89d2\u8272\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysConfRolesetVo>> list(Page<SysConfRolesetVo> page, SysConfRolesetDto sysConfRolesetDto) {
        sysConfRolesetDto.setSetName(sysConfRolesetDto.getSetName().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.isConfRolesetService.getRolesList(page, sysConfRolesetDto));
    }

    @ApiOperation(value="\u6dfb\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", notes="\u6dfb\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    @ApiImplicitParam(name="sysConfRoleset", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", required=true, paramType="body")
    @PostMapping(value={"/addRole"})
    @CheckPermission(value={"incompatibleRolesFront:addRole"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u6dfb\u52a0\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Long> addRole(@RequestBody SysConfRoleset sysConfRoleset) {
        return this.isConfRolesetService.saveRoleSet(sysConfRoleset);
    }

    @ApiOperation(value="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", notes="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    @ApiImplicitParam(name="sysConfRoleset", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", required=true, paramType="body")
    @PostMapping(value={"/editRole"})
    @CheckPermission(value={"incompatibleRolesFront:editRole"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u4fee\u6539\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> editRole(@RequestBody SysConfRoleset sysConfRoleset) {
        return this.isConfRolesetService.updateRoleSet(sysConfRoleset);
    }

    @ApiOperation(value="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", notes="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    @ApiImplicitParam(name="setIds", value="\u5220\u9664\u7684\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6id\u5b57\u7b26\u4e32", required=true, paramType="form")
    @PostMapping(value={"/delRole"})
    @CheckPermission(value={"incompatibleRolesFront:delRole"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u5220\u9664\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delRole(@RequestBody String ids) {
        return this.isConfRolesetService.deleteRoleSet(ids);
    }

    @ApiOperation(value="\u67e5\u770b\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", notes="\u67e5\u770b\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6")
    @ApiImplicitParam(name="setId", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6id", required=true, paramType="form")
    @CheckPermission(value={"incompatibleRolesFront:roleView"})
    @GetMapping(value={"/roleView"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u67e5\u770b\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> roleView(String id) {
        return ApiResponse.success((Object)this.isConfRolesetService.getRoleView(id));
    }

    @ApiOperation(value="\u52a0\u8f7d\u5f53\u524d\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u5f53\u524d\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u89d2\u8272\u6811")
    @ApiImplicitParam(name="roleIds", value="\u89d2\u8272ids", required=true, paramType="form")
    @GetMapping(value={"/selfRoleTree"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u52a0\u8f7d\u5f53\u524d\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> selfRoleTree(String roleIds) {
        String[] ids = roleIds == null ? "".split(",") : roleIds.split(",");
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.isConfRolesService.getSelfRoleTree(ids)));
    }

    @ApiOperation(value="\u83b7\u53d6\u7a7f\u68ad\u6846\u7684\u6570\u636e", notes="\u7ef4\u62a4\u4e0d\u76f8\u5bb9\u89d2\u8272\u65f6\u83b7\u53d6\u7a7f\u68ad\u6846\u7684\u6570\u636e")
    @CheckPermission(value={"incompatibleRoles:transferData"})
    @GetMapping(value={"/transferData"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u83b7\u53d6\u7a7f\u68ad\u6846\u6570\u636e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysConfRolesetVo>> getTransferData() {
        return ApiResponse.success((Object)this.isConfRolesetService.getTransferData());
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e0d\u76f8\u5bb9\u89d2\u8272", notes="\u4fdd\u5b58\u4e0d\u76f8\u5bb9\u89d2\u8272")
    @ApiImplicitParam(name="sysConfRolesetDto", value="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6dto", paramType="body")
    @PostMapping(value={"/saveInRoles"})
    @CheckPermission(value={"incompatibleRolesFront:saveInRoles"})
    @AuditLog(moduleName="\u4e0d\u76f8\u5bb9\u89d2\u8272\u96c6", eventDesc="\u4fdd\u5b58\u4e0d\u76f8\u5bb9\u89d2\u8272", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveInRoles(@RequestBody SysConfRolesetDto sysConfRolesetDto) {
        return this.isConfRolesService.saveBatchSysConfRoles(sysConfRolesetDto);
    }
}

