/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganTypeDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class SysOrganTypeServiceImpl
extends HussarServiceImpl<SysOrganTypeMapper, SysOrganType>
implements ISysOrganTypeService {
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private ISysStruRuleService isSysStruRuleService;

    public IPage<SysOrganTypeVo> getOrganTypeList(Page<SysOrganTypeVo> page, SysOrganType sysOrganType) {
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganType)) {
            throw new BaseException("\u7c7b\u578b\u5b9a\u4e49Dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        page.setRecords(this.sysOrganTypeMapper.getOrganTypeList(page, sysOrganType));
        return page;
    }

    public List<SysOrganType> getOrgTypeOption() {
        return this.sysOrganTypeMapper.getOrgTypeOption();
    }

    @DSTransactional
    public ApiResponse updateSysOrganType(SysOrganTypeDto sysOrganTypeDto) {
        List orgList;
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto)) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578bdto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getId())) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOldOrgName()) || ToolUtil.isEmpty((Object)sysOrganTypeDto.getTypeName())) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u6216\u539f\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysOrganType sysOrganType = new SysOrganType();
        BeanUtils.copyProperties((Object)sysOrganTypeDto, (Object)sysOrganType);
        if (!sysOrganTypeDto.getTypeName().equals(sysOrganTypeDto.getOldOrgName()) && (orgList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getTypeName, (Object)sysOrganTypeDto.getTypeName()))).size() != 0) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        boolean flag = this.updateById(sysOrganType);
        if (!flag) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "update", (Object)sysOrganType, Constants.NONE_ID);
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse saveSysOrganType(SysOrganType sysOrganType) {
        if (ToolUtil.isEmpty((Object)sysOrganType)) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganType.getId())) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganType.getTypeName())) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysOrganType org = (SysOrganType)this.getById(sysOrganType.getId());
        if (org != null) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801\u5df2\u5b58\u5728\uff01\uff09");
        }
        List orgList = this.list((Wrapper)new LambdaQueryWrapper().eq(SysOrganType::getTypeName, (Object)sysOrganType.getTypeName()));
        if (orgList.size() != 0) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\uff08\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u5df2\u5b58\u5728\uff01\uff09");
        }
        sysOrganType.setInUse("1");
        sysOrganType.setIsSystem("0");
        boolean flag = this.save(sysOrganType);
        if (!flag) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "add", (Object)sysOrganType, Constants.NONE_ID);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse deleteByIds(String ids) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u9700\u8981\u5220\u9664\u7684\u7ec4\u7ec7\u7c7b\u578bid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        List orgList = this.list((Wrapper)new LambdaQueryWrapper().in(SysOrganType::getParentType, idList));
        List topOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRule::getSysOrganType, idList));
        List dowOrg = this.isSysStruRuleService.list((Wrapper)new LambdaQueryWrapper().in(SysStruRule::getOrganType, idList));
        if (orgList.size() != 0 || topOrg.size() != 0 || dowOrg.size() != 0) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\uff08\u7ec4\u7ec7\u7c7b\u578b\u5df2\u5e94\u7528\uff09");
        }
        boolean flag = this.removeByIds(idList);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        JSONObject typeIds = new JSONObject();
        typeIds.put("idList", idList);
        this.abstractPushMsgMatcher.insertOperation("sysOrganType", "delete", (Object)typeIds, Constants.NONE_ID);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void checkOrganTypeInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": {
                SysOrganType sysOrganType = (SysOrganType)JSONObject.parseObject((String)JSON.toJSONString((Object)object), SysOrganType.class);
                if (ToolUtil.isEmpty((Object)sysOrganType)) {
                    messageList.add("\u7c7b\u578b\u5b9a\u4e49\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)sysOrganType.getParentType())) {
                    messageList.add("\u672a\u9009\u62e9\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b");
                }
                if (ToolUtil.isEmpty((Object)sysOrganType.getTypeName().trim())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0");
                } else if (sysOrganType.getTypeName().trim().length() > 32) {
                    messageList.add("\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)sysOrganType.getId())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801");
                    break;
                }
                if (String.valueOf(sysOrganType.getId()).length() <= 10) break;
                messageList.add("\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801\u6700\u591a\u53ef\u8f93\u516510\u4e2a\u6570\u5b57");
                break;
            }
            case "edit": {
                SysOrganTypeDto sysOrganTypeDto = (SysOrganTypeDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), SysOrganTypeDto.class);
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto)) {
                    messageList.add("\u7c7b\u578b\u5b9a\u4e49dto\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getOldOrgName())) {
                    messageList.add("\u672a\u586b\u5199\u65e7\u7ec4\u7ec7\u540d\u79f0");
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getTypeName().trim())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0");
                } else if (sysOrganTypeDto.getTypeName().trim().length() > 32) {
                    messageList.add("\u7ec4\u7ec7\u7c7b\u578b\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)sysOrganTypeDto.getId())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801");
                    break;
                }
                if (String.valueOf(sysOrganTypeDto.getId()).length() <= 10) break;
                messageList.add("\u7ec4\u7ec7\u7c7b\u578b\u4ee3\u7801\u6700\u591a\u53ef\u8f93\u516510\u4e2a\u6570\u5b57");
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }
}

