/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.audit.dao.SysUsersAuditMapper;
import com.jxdinfo.hussar.authorization.audit.model.SysOfficeAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStaffAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAssistOrganAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysOfficeAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAssistOrganAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.bspinterface.service.ISysOrgEventService;
import com.jxdinfo.hussar.authorization.enums.UserRoleStatus;
import com.jxdinfo.hussar.authorization.organ.dao.SysOfficeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysOrganTypeMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOffice;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOfficeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganInfoVo;
import com.jxdinfo.hussar.authorization.organ.vo.ProxyTreeVo;
import com.jxdinfo.hussar.authorization.organ.vo.RoleOrgUserVo;
import com.jxdinfo.hussar.authorization.organ.vo.StruSaveVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysConfRolesetMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruAssistOrganMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleAuditMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.RoleUserQueryDto;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRoleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.bpm.messagepush.AbstractBpmPushMsgMatcher;
import com.jxdinfo.hussar.general.idtable.model.SysIdtable;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.general.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysOrgManageServiceImpl
extends HussarServiceImpl<SysStruMapper, SysStru>
implements SysOrgManageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysOrgManageServiceImpl.class);
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysOrganTypeMapper sysOrganTypeMapper;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SysRolesMapper sysRolesMapper;
    @Resource
    private SysConfRolesetMapper sysConfRolesetMapper;
    @Resource
    private SysOfficeMapper sysOfficeMapper;
    @Resource
    private ISysOfficeService iSysOfficeService;
    @Resource
    private ISysOrgEventService iSysOrgEventService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;
    @Resource
    ISysOrganAuditService iSysOrganAuditService;
    @Resource
    ISysStruAuditService iSysStruAuditService;
    @Resource
    ISysStaffAuditService iSysStaffAuditService;
    @Resource
    ISysUsersAuditService iSysUsersAuditService;
    @Resource
    ISysOfficeAuditService iSysOfficeAuditService;
    @Resource
    private SysUsersAuditMapper sysUsersAuditMapper;
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private AbstractBpmPushMsgMatcher bpmAbstractPushMsgMatcher;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;
    @Resource
    SysStruAssistOrganMapper sysStruAssistOrganMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private SysStruRoleAuditMapper sysStruRoleAuditMapper;
    @Resource
    private ISysStruRoleAuditService sysStruRoleAuditService;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private ISysStruAssistOrganAuditService iSysStruAssistOrganAuditService;

    public List<JSTreeModel> getOrgTree(String isEmployee) {
        return this.sysStruMapper.getOrgTree(isEmployee);
    }

    public SysOrganVo getOrgInfoById(Long struId) {
        if (ToolUtil.isEmpty((Object)struId)) {
            throw new BaseException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LOGGER.debug("\u6b63\u5728\u83b7\u53d6id\u4e3a{}\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", (Object)struId);
        return this.sysStruMapper.getOrgInfoByOrgId(struId);
    }

    public IPage<SysOrganVo> getOrgInfoListByParentId(Page page, SysOrganDto sysOrganDto) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysOrganDto)) {
            throw new BaseException("\u8282\u70b9Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IPage<SysOrganVo> iPage = null;
        Long parentStruId = sysOrganDto.getParentId();
        String orangeName = sysOrganDto.getOrganName() == null ? "" : sysOrganDto.getOrganName();
        String orangeCode = sysOrganDto.getOrganCode() == null ? "" : sysOrganDto.getOrganCode();
        HashMap queryOrgParams = Maps.newHashMap();
        queryOrgParams.put("parentStruId", parentStruId);
        queryOrgParams.put("orangeName", orangeName);
        queryOrgParams.put("orangeCode", orangeCode);
        queryOrgParams.put("gradeAdminFlag", "0");
        queryOrgParams.put("gradeDepStruLevel", 1L);
        SecurityUser currentUser = BaseSecurityUtil.getUser();
        if (currentUser.isGradeadmin()) {
            LOGGER.debug("\u6b63\u5728\u83b7\u53d6\u5206\u7ea7\u7ba1\u7406\u5458\u4fe1\u606f");
            queryOrgParams.put("gradeAdminFlag", ADD);
            String gradeDepStruLevel = this.sysStruMapper.selectStruLevel(BaseSecurityUtil.getUser().getDeptId());
            queryOrgParams.put("gradeDepStruLevel", Long.valueOf(gradeDepStruLevel));
            String searchStruLevel = "0";
            if (!ToolUtil.equals((Object)Constants.ROOT_NODE_ID, (Object)parentStruId)) {
                searchStruLevel = this.sysStruMapper.selectStruLevel(parentStruId);
            }
            if (Integer.parseInt(searchStruLevel) < Integer.parseInt(gradeDepStruLevel)) {
                HashSet parenetStruIdSet = Sets.newHashSet((Object[])new Long[]{BaseSecurityUtil.getUser().getDeptId()});
                List ancestorStrus = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().le(SysStru::getStruLevel, (Object)gradeDepStruLevel)).orderByDesc(SysStru::getStruLevel));
                for (SysStru sysStru : ancestorStrus) {
                    if (!parenetStruIdSet.contains(sysStru.getId())) continue;
                    parenetStruIdSet.add(sysStru.getParentId());
                    LOGGER.debug("\u83b7\u53d6\u5230\u4e0a\u7ea7id{}", (Object)sysStru.getParentId());
                }
                if (CollectionUtils.isNotEmpty((Collection)parenetStruIdSet)) {
                    queryOrgParams.put("ancestorStruIds", new ArrayList(parenetStruIdSet));
                }
            }
            iPage = this.sysStruMapper.getOrgInfoListByParentId(page, queryOrgParams);
        } else {
            iPage = this.sysStruMapper.getOrgInfoListByParentId(page, queryOrgParams);
        }
        if (currentUser.isGradeadmin()) {
            List sysOrganVoList = iPage.getRecords();
            Long deptId = currentUser.getDeptId();
            List childIdList = this.sysStruService.getChildOrgId(deptId, "01");
            sysOrganVoList.forEach(o -> {
                Long struId = Long.valueOf(o.getStruId());
                if (struId.equals(deptId)) {
                    o.setLevel("02");
                } else if (childIdList.contains(struId)) {
                    o.setLevel("03");
                } else {
                    o.setLevel("01");
                }
            });
            iPage.setRecords(sysOrganVoList);
        }
        return iPage;
    }

    @DSTransactional
    public String saveOrgInfoVue(StruSaveDto struSaveDto) {
        String msg;
        SysStru sysStru;
        if (ToolUtil.isEmpty((Object)struSaveDto)) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String organName = struSaveDto.getSysOrgan().getOrganName();
        String shortName = struSaveDto.getSysOrgan().getShortName();
        if (ToolUtil.isEmpty((Object)organName.trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)shortName.trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!organName.equals(organName.trim()) || !shortName.equals(shortName.trim())) {
            SysOrgan sysOrgan = struSaveDto.getSysOrgan();
            sysOrgan.setOrganName(organName.trim());
            sysOrgan.setShortName(shortName.trim());
            struSaveDto.setSysOrgan(sysOrgan);
        }
        LOGGER.debug("\u540d\u79f0\u4e3a{}\u7684\u7ec4\u7ec7\u673a\u6784\u524d\u540e\u7a7a\u683c\u8fc7\u6ee4\u5b8c\u6bd5", (Object)struSaveDto.getSysOrgan().getOrganName());
        LOGGER.debug("\u7b80\u79f0\u4e3a{}\u7684\u7ec4\u7ec7\u673a\u6784\u524d\u540e\u7a7a\u683c\u8fc7\u6ee4\u5b8c\u6bd5", (Object)struSaveDto.getSysOrgan().getShortName());
        String organAlias = struSaveDto.getSysStru().getOrganAlias();
        if (ToolUtil.isEmpty((Object)organAlias.trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!organAlias.equals(organAlias.trim())) {
            sysStru = struSaveDto.getSysStru();
            sysStru.setOrganAlias(organAlias.trim());
            struSaveDto.setSysStru(sysStru);
        }
        LOGGER.debug("\u522b\u540d\u4e3a{}\u7684\u7ec4\u7ec7\u673a\u6784\u524d\u540e\u7a7a\u683c\u8fc7\u6ee4\u5b8c\u6bd5", (Object)struSaveDto.getSysStru().getOrganAlias());
        sysStru = struSaveDto.getSysStru();
        SysOffice sysOffice = struSaveDto.getSysOffice();
        SysOrgan sysOrgan = struSaveDto.getSysOrgan();
        if (ToolUtil.isEmpty((Object)sysStru.getOrganAlias())) {
            sysStru.setOrganAlias(sysOrgan.getOrganName());
        }
        sysStru.setOrganId(null);
        sysStru.setIsLeaf("0");
        sysStru.setStruPath("");
        sysOrgan.setId(null);
        sysStru.setStruLevel(sysStru.getStruLevel().add(new BigDecimal(1)));
        long orderTree = 1L;
        Long maxOrder = this.getMaxOrderById(sysStru.getParentId());
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1L;
        }
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        sysStru.setStruOrder(struOrder);
        String roleId = struSaveDto.getRoleIds() != null ? struSaveDto.getRoleIds().trim() : "";
        Object[] roleIds = roleId.split(",");
        LOGGER.debug("\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784id{}", roleIds);
        Long parentId = sysStru.getParentId();
        boolean b = this.iSysStruAuditService.checkCanOperate(parentId);
        if (!b) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01(\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u6570\u636e\uff01)");
        }
        LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5168\u90e8\u5ba1\u6838");
        this.iSysOrgEventService.beforeAdd(sysStru, sysOrgan, sysOffice);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u9700\u8981\u5ba1\u6838");
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, ADD);
            msg = "\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u4e0d\u9700\u8981\u5ba1\u6838");
            this.sysOrganMapper.insert(sysOrgan);
            sysStru.setOrganId(sysOrgan.getId());
            this.sysStruMapper.insert(sysStru);
            Long struId = sysStru.getId();
            LOGGER.debug("\u65b0\u589e\u7ec4\u7ec7\u673a\u6784\u6210\u529f,id\u4e3a{}", (Object)struId);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                sysOffice.setStruId(sysStru.getId());
                this.sysOfficeMapper.insert(sysOffice);
            }
            msg = "\u65b0\u589e\u6210\u529f\uff01";
            JSONObject object = new JSONObject();
            object.put("sysOrgan", (Object)sysOrgan);
            object.put("sysStru", (Object)sysStru);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                object.put("sysOffice", (Object)sysOffice);
            }
            this.abstractPushMsgMatcher.insertOperation("organ", "add", (Object)object, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "add");
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
                ArrayList auditList = new ArrayList();
                ArrayList<Object> adds = new ArrayList<Object>(Arrays.asList(roleIds));
                msg = ToolUtil.isNotEmpty(adds) ? "\u65b0\u589e\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01" : "\u65b0\u589e\u6210\u529f\uff01";
            } else {
                ArrayList<SysStruRole> struRoleList = new ArrayList<SysStruRole>();
                for (Object roleId1 : roleIds) {
                    if (ToolUtil.isEmpty((Object)roleId1)) continue;
                    SysStruRole sysStruRole = new SysStruRole();
                    sysStruRole.setStruId(struId);
                    sysStruRole.setGrantedRole(Long.valueOf((String)roleId1));
                    struRoleList.add(sysStruRole);
                }
                if (ToolUtil.isNotEmpty(struRoleList)) {
                    this.abstractPushMsgMatcher.insertOperation("struRole", "add", struRoleList, Constants.NONE_ID);
                }
            }
        }
        this.iSysOrgEventService.afterAdd(sysStru, sysOrgan, sysOffice);
        return msg;
    }

    @DSTransactional
    public String updateOrgInfoVue(StruSaveDto struSaveDto) {
        String msg;
        SysStru sysStru;
        String organAlias;
        if (ToolUtil.isEmpty((Object)struSaveDto)) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String organName = struSaveDto.getSysOrgan().getOrganName();
        String shortName = struSaveDto.getSysOrgan().getShortName();
        if (ToolUtil.isEmpty((Object)organName.trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)shortName.trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!organName.equals(organName.trim()) || !shortName.equals(shortName.trim())) {
            SysOrgan sysOrgan = struSaveDto.getSysOrgan();
            sysOrgan.setOrganName(organName.trim());
            sysOrgan.setShortName(shortName.trim());
            struSaveDto.setSysOrgan(sysOrgan);
        }
        if (ToolUtil.isEmpty((Object)(organAlias = struSaveDto.getSysStru().getOrganAlias()).trim())) {
            throw new BaseException("\u7ec4\u7ec7\u673a\u6784\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!organAlias.equals(organAlias.trim())) {
            sysStru = struSaveDto.getSysStru();
            sysStru.setOrganAlias(organAlias.trim());
            struSaveDto.setSysStru(sysStru);
        }
        sysStru = struSaveDto.getSysStru();
        SysOffice sysOffice = struSaveDto.getSysOffice();
        SysOrgan sysOrgan = struSaveDto.getSysOrgan();
        if (!this.iSysStruAuditService.checkCanOperate(sysStru.getId())) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u4fee\u6539\uff01");
        }
        Long struId = sysStru.getId();
        String roleId = struSaveDto.getRoleIds() != null ? struSaveDto.getRoleIds().trim() : "";
        String[] roleIds = roleId.split(",");
        this.iSysOrgEventService.beforeEdit(sysStru, sysOrgan, sysOffice);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            this.auditAdd(sysOrgan, sysStru, null, sysOffice, DELETE);
            msg = "\u4fee\u6539\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            this.sysOrganMapper.updateById(sysOrgan);
            this.sysStruMapper.updateById(sysStru);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                this.iSysOfficeService.saveOrUpdate((Object)sysOffice);
            }
            msg = "\u4fee\u6539\u6210\u529f\uff01";
            JSONObject object = new JSONObject();
            object.put("sysOrgan", (Object)sysOrgan);
            object.put("sysStru", (Object)sysStru);
            if (ToolUtil.isNotEmpty((Object)sysOffice)) {
                object.put("sysOffice", (Object)sysOffice);
            }
            this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushOrgan(sysOrgan, sysStru, "update");
        }
        this.iSysOrgEventService.afterEdit(sysStru, sysOrgan, sysOffice);
        return msg;
    }

    public List<SysStruRole> getStruRole(Long id) {
        return this.sysStruRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysStruRole::getStruId, (Object)id));
    }

    private void insertAndUpdateStruRoleAudit(List<String> roleIds, List<SysStruRoleAudit> auditList, Long struId, String operationType) {
        ArrayList<SysStruRoleAudit> updateAuditList = new ArrayList<SysStruRoleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysStruRoleAudit> addAuditList = new ArrayList<SysStruRoleAudit>();
        for (String roleId : roleIds) {
            boolean isExist = false;
            for (SysStruRoleAudit sysStruRoleAudit : auditList) {
                if (!roleId.equals(sysStruRoleAudit.getRoleId().toString())) continue;
                isExist = true;
                updateAuditList.add(sysStruRoleAudit);
                break;
            }
            if (isExist) continue;
            SysStruRoleAudit sysStruRoleAudit = new SysStruRoleAudit();
            sysStruRoleAudit.setStruId(struId);
            sysStruRoleAudit.setRoleId(Long.valueOf(roleId));
            sysStruRoleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
            sysStruRoleAudit.setOperationType(operationType);
            addAuditList.add(sysStruRoleAudit);
        }
        if (updateAuditList.size() > 0) {
            updateMap.put("struId", struId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("updateAuditList", updateAuditList);
            this.sysStruRoleAuditMapper.updateAuditBatch(updateMap);
        }
        if (addAuditList.size() > 0) {
            this.sysStruRoleAuditService.saveBatch(addAuditList);
        }
    }

    private void auditAdd(SysOrgan sysOrgan, SysStru sysStru, SysStaff sysStaff, SysOffice sysOffice, String flag) {
        SysOrganAudit sysOrganAudit = new SysOrganAudit();
        CopyPropertieUtils.copyProperties((Object)sysOrganAudit, (Object)sysOrgan);
        sysOrganAudit.setInUse(flag);
        if (DELETE.equals(flag)) {
            sysOrganAudit.setRealOrganId(sysOrgan.getId());
            sysOrganAudit.setId(null);
        }
        this.iSysOrganAuditService.save((Object)sysOrganAudit);
        SysStruAudit sysStruAudit = new SysStruAudit();
        CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
        sysStruAudit.setOrganId(sysOrganAudit.getId());
        if (DELETE.equals(flag)) {
            sysStruAudit.setOrganId(sysOrganAudit.getId());
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setId(null);
        }
        sysStruAudit.setState("0");
        sysStruAudit.setInUse(flag);
        this.iSysStruAuditService.save((Object)sysStruAudit);
        if (ToolUtil.isNotEmpty((Object)sysStaff)) {
            SysStaffAudit sysStaffAudit = new SysStaffAudit();
            CopyPropertieUtils.copyProperties((Object)sysStaffAudit, (Object)sysStaff);
            sysStaffAudit.setStruId(sysStruAudit.getId());
            if (DELETE.equals(flag)) {
                sysStaffAudit.setStruId(sysStruAudit.getId());
                sysStaffAudit.setRealStaffId(sysStaff.getId());
                sysStaffAudit.setId(null);
            }
            this.iSysStaffAuditService.save((Object)sysStaffAudit);
        }
        if (ToolUtil.isNotEmpty((Object)sysOffice)) {
            SysOfficeAudit sysOfficeAudit = new SysOfficeAudit();
            CopyPropertieUtils.copyProperties((Object)sysOfficeAudit, (Object)sysOffice);
            sysOfficeAudit.setStruId(sysStruAudit.getId());
            if (DELETE.equals(flag)) {
                sysOfficeAudit.setStruId(sysStruAudit.getId());
                sysOfficeAudit.setRealOfficeId(sysOffice.getId());
                sysOfficeAudit.setId(null);
            }
            this.iSysOfficeAuditService.save((Object)sysOfficeAudit);
        }
    }

    public List<SysStruRule> getOrgRoleByCode(String orgType, String isRoot) {
        return this.sysStruRuleMapper.getOrgRoleByCode(orgType, isRoot);
    }

    public List<JSTreeModel> getOrgTreeById(Long orgId, String isEmployee) {
        return this.sysStruMapper.getOrgTreeById(orgId, isEmployee);
    }

    public List<JSTreeModel> selfRoleTree(String[] roleIds) {
        return this.sysStruMapper.selfRoleTree(roleIds);
    }

    @DSTransactional
    public void updateOrgTreeOrder(List<Long> idList) {
        if (ToolUtil.isEmpty(idList)) {
            return;
        }
        ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
        for (int i = 0; i < idList.size(); ++i) {
            Long struId = idList.get(i);
            SysStru sysStru = new SysStru();
            sysStru.setId(struId);
            sysStru.setStruOrder(BigDecimal.valueOf(i + 1));
            sysStruList.add(sysStru);
        }
        if (ToolUtil.isNotEmpty(sysStruList)) {
            this.updateBatchById(sysStruList, sysStruList.size());
        }
        this.abstractPushMsgMatcher.insertOperation("organ", "update", idList, Constants.NONE_ID);
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(idList.get(0));
        if (ToolUtil.isNotEmpty((Object)sysStru) && ToolUtil.isNotEmpty((Object)sysStru.getOrganId())) {
            String organType = ((SysOrgan)this.sysOrganMapper.selectById(sysStru.getOrganId())).getOrganType();
            if (idList.size() != 0 && !ToolUtil.equals((Object)"9", (Object)organType)) {
                this.bpmAbstractPushMsgMatcher.pushOrganSort(null, null, (JSONArray)JSONArray.toJSON(idList));
            }
        }
    }

    public List<JSTreeModel> getUserTree() {
        return this.sysStruMapper.getUserTree();
    }

    public List<String> getEmpolyeeId(List<String> list6) {
        return this.sysStruMapper.getEmpolyeeId(list6);
    }

    public List<ProxyTreeVo> getProxyTree(String[] proxys) {
        return this.sysStruMapper.getProxyTree(proxys);
    }

    public List<JSTreeModel> getUserOrderTree(String orgId) {
        return this.sysStruMapper.getUserOrderTree(orgId);
    }

    @DSTransactional
    public JSONObject delOrgById(Long orgId) {
        this.iSysOrgEventService.beforeDel(orgId);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(orgId);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(orgId);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(orgId);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(orgId);
        boolean isDel = true;
        StringBuffer msg = new StringBuffer();
        msg.append("\u65e0\u6cd5\u5220\u9664\uff01");
        StringBuilder reason = new StringBuilder();
        boolean hasOther = false;
        if (ToolUtil.isNotEmpty(orgList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(userList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (ToolUtil.isNotEmpty(noRoleList)) {
            isDel = false;
            reason.append("\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
            hasOther = true;
        }
        if (hasOther) {
            msg.append("\uff08");
            msg.append((CharSequence)reason);
            msg.append("\uff09");
        }
        this.iSysOrgEventService.afterDel(orgId);
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
            return json;
        }
        if (isDel) {
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
                sysStruAudit.setId(null);
                sysStruAudit.setRealStruId(sysStru.getId());
                sysStruAudit.setState("0");
                sysStruAudit.setInUse("3");
                this.iSysStruAuditService.save((Object)sysStruAudit);
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.deleteByOrgId(orgId);
                this.abstractPushMsgMatcher.insertOperation("organ", "delete", (Object)orgId, Constants.NONE_ID);
                if (!ToolUtil.equals((Object)"9", (Object)((SysOrgan)this.sysOrganMapper.selectById(((SysStru)this.sysStruMapper.selectById(orgId)).getOrganId())).getOrganType())) {
                    this.bpmAbstractPushMsgMatcher.delete("organ", orgId, "");
                }
                json.put("msg", (Object)"\u5220\u9664\u6210\u529f\uff01");
            }
        } else {
            json.put("msg", (Object)msg);
        }
        return json;
    }

    @DSTransactional
    public String deleteOrgByIdVue(Long orgId) {
        String msg;
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.iSysOrgEventService.beforeDel(orgId);
        List<Map<String, Object>> orgList = this.sysStruMapper.getOrgListByParentId(orgId);
        List<Map<String, Object>> userList = this.sysUsersMapper.getUsersByOrgId(orgId);
        List<Map<String, Object>> roleList = this.sysRolesMapper.getRolesByOrgId(orgId);
        List<Map<String, Object>> noRoleList = this.sysConfRolesetMapper.getRolesByOrgId(orgId);
        List assistOrganChildrenList = this.iSysStruAssistOrganService.getAssistOrganByParent(orgId);
        if (ToolUtil.isNotEmpty(orgList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        }
        if (ToolUtil.isNotEmpty(userList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u7528\u6237\uff01");
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u89d2\u8272\uff01");
        }
        if (ToolUtil.isNotEmpty(noRoleList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u5173\u8054\u4e0d\u76f8\u5bb9\u89d2\u8272\uff01");
        }
        if (ToolUtil.isNotEmpty((Object)assistOrganChildrenList)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u4e0b\u7ea7\u517c\u4efb\u4eba\u5458\uff01");
        }
        this.iSysOrgEventService.afterDel(orgId);
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u5220\u9664\uff01");
        }
        SysStru sysStruById = (SysStru)this.sysStruService.getById((Serializable)orgId);
        LambdaQueryWrapper wrapper1 = new LambdaQueryWrapper();
        wrapper1.eq(SysStruAudit::getParentId, (Object)orgId);
        wrapper1.eq(SysStruAudit::getState, (Object)"0");
        ArrayList<String> inUseList = new ArrayList<String>();
        inUseList.add(ADD);
        inUseList.add("4");
        wrapper1.in(SysStruAudit::getInUse, inUseList);
        List list1 = this.iSysStruAuditService.list((Wrapper)wrapper1);
        if (HussarUtils.isNotEmpty((Object)list1)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u6216\u4eba\u5458\uff01");
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(SysUsersAudit::getDepartmentId, (Object)orgId);
        wrapper2.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList1 = new ArrayList<String>();
        currentStatusList1.add("0");
        currentStatusList1.add("3");
        currentStatusList1.add(ADD);
        wrapper2.in(SysUsersAudit::getCurrentStatus, currentStatusList1);
        List list2 = this.iSysUsersAuditService.list((Wrapper)wrapper2);
        if (HussarUtils.isNotEmpty((Object)list2)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        }
        LambdaQueryWrapper wrapper3 = new LambdaQueryWrapper();
        wrapper3.eq(SysUsersAudit::getEmployeeId, (Object)orgId);
        wrapper3.eq(SysUsersAudit::getIsAudit, (Object)"0");
        ArrayList<String> currentStatusList2 = new ArrayList<String>();
        currentStatusList2.add("0");
        currentStatusList2.add(ADD);
        wrapper3.in(SysUsersAudit::getCurrentStatus, currentStatusList2);
        List list3 = this.iSysUsersAuditService.list((Wrapper)wrapper3);
        if (HussarUtils.isNotEmpty((Object)list3)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u5173\u8054\u7528\u6237\uff01");
        }
        LambdaQueryWrapper wrapper4 = new LambdaQueryWrapper();
        wrapper4.eq(SysStruAssistOrganAudit::getAssistParentId, (Object)orgId);
        wrapper4.eq(SysStruAssistOrganAudit::getState, (Object)"0");
        List list4 = this.iSysStruAssistOrganAuditService.list((Wrapper)wrapper4);
        if (HussarUtils.isNotEmpty((Object)list4)) {
            throw new BaseException("\u65e0\u6cd5\u5220\u9664\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u4eba\u5458\uff01");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setInUse("3");
            this.iSysStruAuditService.save((Object)sysStruAudit);
            msg = "\u5220\u9664\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01";
        } else {
            this.sysStruMapper.deleteById(orgId);
            LambdaQueryWrapper delOrgan = new LambdaQueryWrapper();
            delOrgan.eq(SysOrgan::getId, (Object)sysStruById.getOrganId());
            this.sysOrganMapper.delete((Wrapper)delOrgan);
            LambdaQueryWrapper delOffice = new LambdaQueryWrapper();
            delOffice.eq(SysOffice::getStruId, (Object)orgId);
            this.sysOfficeMapper.delete((Wrapper)delOffice);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysStruRoleAudit::getStruId, (Object)orgId);
            this.sysStruRoleAuditMapper.delete((Wrapper)queryWrapper);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(SysStruAssistOrgan::getStruId, (Object)orgId);
            this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
            this.abstractPushMsgMatcher.insertOperation("organ", "delete", (Object)orgId, Constants.NONE_ID);
            if (ToolUtil.isNotEmpty((Object)this.sysOrganMapper.selectById((Serializable)this.sysStruMapper.selectById(orgId))) && !ToolUtil.equals((Object)"9", (Object)((SysOrgan)this.sysOrganMapper.selectById(((SysStru)this.sysStruMapper.selectById(orgId)).getOrganId())).getOrganType())) {
                this.bpmAbstractPushMsgMatcher.delete("organ", orgId, "");
            }
            msg = "\u5220\u9664\u6210\u529f\uff01";
            if ("9".equals(sysStruById.getStruType())) {
                Long organId = sysStruById.getOrganId();
                if (ToolUtil.isNotEmpty((Object)organId)) {
                    this.sysOrganService.removeById((Serializable)organId);
                }
                QueryWrapper sysStaffQueryWrapper = new QueryWrapper();
                sysStaffQueryWrapper.lambda().eq(SysStaff::getStruId, (Object)orgId);
                this.sysStaffService.remove((Wrapper)sysStaffQueryWrapper);
            }
        }
        return msg;
    }

    public Long getMaxOrderById(Long parentId) {
        return this.sysStruMapper.getMaxOrderById(parentId);
    }

    public Page<Map<String, Object>> getPageList(Page page, String string) {
        page.setRecords(this.sysOrganMapper.selectOrgList(page, "string"));
        return page;
    }

    public Page getPrincipalSelectList(Page page, SysStaffDto sysStaffDto) {
        if (ToolUtil.isEmpty((Object)page)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysStaffDto)) {
            sysStaffDto = new SysStaffDto();
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        String userName = sysStaffDto.getName();
        String userAccount = sysStaffDto.getUserAccount();
        String departmentName = sysStaffDto.getParentStruName();
        if (isGradeAdmin) {
            page.setRecords(this.sysUsersMapper.getGrantPrincipalSelectList(page, userName, userAccount, departmentName, shiroUser.getDeptId()));
        } else {
            page.setRecords(this.sysUsersMapper.getPrincipalSelectList(page, userName, departmentName, userAccount));
        }
        return page;
    }

    public Page getPrincipalSelectListByOrgIds(Page page, String userName, String departmentName, Set<String> orgIds, String type) {
        if ("4".equals(type)) {
            orgIds.addAll(this.getSelfOrgList());
        }
        page.setRecords(this.sysUsersMapper.getPrincipalSelectListByOrgIds(page, userName, departmentName, orgIds));
        return page;
    }

    public List<JSTreeModel> orgChangeById(Long orgId, String isEmployee) {
        return this.sysStruMapper.orgChangeById(orgId, isEmployee);
    }

    @DSTransactional
    public JSONObject orgTreeChange(Long orgId, Long parentId, String orgType, String isRoot, Long changeLevel) {
        this.iSysOrgEventService.beforeOrgChange(orgId, parentId);
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && ADD.equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
            return json;
        }
        if (map.size() == 0) {
            json.put("success", (Object)false);
            json.put("msg", (Object)"\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        } else {
            SysUsers user = null;
            if ("9".equals(orgType) && (user = (SysUsers)SqlHelper.getObject((Log)this.log, (List)this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)orgId)))) != null) {
                if (this.iSysUsersAuditService.adjustEdit(user.getId())) {
                    json.put("success", (Object)false);
                    json.put("msg", (Object)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                    return json;
                }
                user.setCorporationId(parentId);
                user.setDepartmentId(parentId);
            }
            long orderTree = 1L;
            Long maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
            if (ToolUtil.isNotEmpty((Object)maxOrder)) {
                orderTree = maxOrder + 1L;
            }
            BigDecimal struOrder = BigDecimal.valueOf(orderTree);
            Long level = changeLevel + 1L;
            if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
                SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
                SysStruAudit sysStruAudit = new SysStruAudit();
                CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
                sysStruAudit.setId(null);
                sysStruAudit.setInUse("4");
                sysStruAudit.setStruOrder(struOrder);
                sysStruAudit.setRealStruId(sysStru.getId());
                sysStruAudit.setState("0");
                sysStruAudit.setStruLevel(BigDecimal.valueOf(level));
                sysStruAudit.setParentId(parentId);
                this.iSysStruAuditService.save((Object)sysStruAudit);
                if (user != null) {
                    SysUsersAudit sysUsersAudit = new SysUsersAudit();
                    CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)user);
                    sysUsersAudit.setIsAudit("0");
                    sysUsersAudit.setCurrentStatus("3");
                    this.sysUsersAuditMapper.insert(sysUsersAudit);
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            } else {
                this.sysStruMapper.orgTreeChange(orgId, parentId, struOrder, level);
                if (user != null) {
                    this.sysUsersMapper.updateById(user);
                    this.bpmAbstractPushMsgMatcher.pushUser(user, "update", null);
                } else {
                    this.bpmAbstractPushMsgMatcher.pushOrgan((SysOrgan)this.sysOrganMapper.selectById(orgId), (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)orgId)), "update");
                }
                json.put("success", (Object)true);
                json.put("msg", (Object)"\u8f6c\u79fb\u6210\u529f\uff01");
                SysStru sysStru = new SysStru();
                sysStru.setId(orgId);
                sysStru.setParentId(parentId);
                sysStru.setStruOrder(struOrder);
                sysStru.setStruLevel(new BigDecimal(level));
                JSONObject object = new JSONObject();
                object.put("sysStru", (Object)sysStru);
                this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_ID);
            }
            this.iSysOrgEventService.afterOrgChange(orgId, parentId);
        }
        return json;
    }

    @DSTransactional
    public ApiResponse<Tip> orgTreeChangeVue(StruChangeDto struChangeDto) {
        boolean flag;
        if (ToolUtil.isEmpty((Object)struChangeDto)) {
            throw new BaseException("\u7ec4\u7ec7\u8f6c\u79fbdto\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List allSysStruList = this.sysStruService.list();
        Long parentIds = struChangeDto.getParentId();
        boolean bl = flag = parentIds != 11L;
        while (flag) {
            Long finalParentId = parentIds;
            List parentSysStruList = allSysStruList.stream().filter(o -> finalParentId.equals(o.getId())).collect(Collectors.toList());
            if (ToolUtil.isNotEmpty(parentSysStruList)) {
                SysStru sysStru = (SysStru)parentSysStruList.get(0);
                parentIds = sysStru.getParentId();
                if (struChangeDto.getStruId().equals(parentIds)) {
                    flag = false;
                    throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
                }
                if (parentIds != 11L) continue;
                flag = false;
                continue;
            }
            flag = false;
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        }
        if (struChangeDto.getStruId().equals(struChangeDto.getParentId())) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        }
        Long orgId = struChangeDto.getStruId();
        Long parentId = struChangeDto.getParentId();
        String isRoot = struChangeDto.getIsRoot();
        String orgType = struChangeDto.getStruType();
        String changeLevel = struChangeDto.getParentLevel();
        this.iSysOrgEventService.beforeOrgChange(orgId, parentId);
        List<Map<String, Object>> map = this.sysStruRuleMapper.getOrgRoleById(parentId, orgType);
        if (ToolUtil.isNotEmpty((Object)isRoot) && ADD.equals(isRoot)) {
            map = this.sysStruRuleMapper.getOrgTypeByType(orgType, isRoot);
        }
        JSONObject json = new JSONObject();
        if (!this.iSysStruAuditService.checkCanOperate(orgId)) {
            throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
        }
        if (!this.iSysStruAuditService.checkCanOperate(parentId)) {
            throw new BaseException("\u8f6c\u79fb\u540e\u7684\u7236\u7ea7\u7ec4\u7ec7\u673a\u6784\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6570\u636e\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
        }
        if (map.size() == 0) {
            throw new BaseException("\u8f6c\u79fb\u5931\u8d25\uff01\uff08\u8be5\u8f6c\u79fb\u4e0d\u7b26\u5408\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\uff01\uff09");
        }
        List sysUsersList = new ArrayList();
        if ("9".equals(orgType)) {
            sysUsersList = this.sysUsersMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getEmployeeId, (Object)orgId));
            for (SysUsers sysUsers : sysUsersList) {
                if (sysUsers == null) continue;
                if (this.iSysUsersAuditService.adjustEdit(sysUsers.getId())) {
                    throw new BaseException("\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff0c\u7981\u6b62\u8f6c\u79fb\uff01");
                }
                sysUsers.setCorporationId(parentId);
                sysUsers.setDepartmentId(parentId);
            }
        }
        long orderTree = 1L;
        Long maxOrder = this.sysStruMapper.getMaxOrderById(parentId);
        if (ToolUtil.isNotEmpty((Object)maxOrder)) {
            orderTree = maxOrder + 1L;
        }
        BigDecimal struOrder = BigDecimal.valueOf(orderTree);
        long level = Long.valueOf(changeLevel) + 1L;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            SysStruAudit sysStruAudit = new SysStruAudit();
            CopyPropertieUtils.copyProperties((Object)sysStruAudit, (Object)sysStru);
            sysStruAudit.setId(null);
            sysStruAudit.setInUse("4");
            sysStruAudit.setStruOrder(struOrder);
            sysStruAudit.setRealStruId(sysStru.getId());
            sysStruAudit.setState("0");
            sysStruAudit.setStruLevel(BigDecimal.valueOf(level));
            sysStruAudit.setParentId(parentId);
            this.iSysStruAuditService.save((Object)sysStruAudit);
            return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        this.orgCodeChange(orgId, parentId, orgType, level);
        this.sysStruMapper.orgTreeChange(orgId, parentId, struOrder, level);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAssistOrgan::getStruId, (Object)orgId)).eq(SysStruAssistOrgan::getAssistParentId, (Object)parentId);
        this.sysStruAssistOrganMapper.delete((Wrapper)wrapper);
        if (ToolUtil.isNotEmpty(sysUsersList)) {
            for (SysUsers sysUsers : sysUsersList) {
                this.sysUsersMapper.updateById(sysUsers);
            }
        } else {
            this.bpmAbstractPushMsgMatcher.pushOrgan((SysOrgan)this.sysOrganMapper.selectById(orgId), (SysStru)this.sysStruMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysStru::getOrganId, (Object)orgId)), "update");
        }
        SysStru sysStru = new SysStru();
        sysStru.setId(orgId);
        sysStru.setParentId(parentId);
        sysStru.setStruOrder(struOrder);
        sysStru.setStruLevel(new BigDecimal(level));
        JSONObject object = new JSONObject();
        object.put("sysStru", (Object)sysStru);
        this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_ID);
        this.iSysOrgEventService.afterOrgChangeVue();
        return ApiResponse.success((String)"\u8f6c\u79fb\u6210\u529f\uff01");
    }

    @DSTransactional
    public void updateMoveNode(Long orgId, boolean isUp) {
        SysStru thatStru;
        if (ToolUtil.isEmpty((Object)orgId)) {
            throw new BaseException("\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysStru thisStru = (SysStru)this.sysStruMapper.selectById(orgId);
        if (ToolUtil.isEmpty((Object)thisStru)) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7\u673a\u6784");
        }
        LambdaQueryWrapper ew = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)thisStru.getParentId());
        if (isUp) {
            ew.lt(SysStru::getStruOrder, (Object)thisStru.getStruOrder());
        } else {
            ew.gt(SysStru::getStruOrder, (Object)thisStru.getStruOrder());
        }
        ((LambdaQueryWrapper)ew.eq(HussarDelflagEntity::getDelFlag, (Object)"0")).ne(SysStru::getStruType, (Object)"9");
        if (isUp) {
            ew.orderByDesc(SysStru::getStruOrder);
        } else {
            ew.orderByAsc(SysStru::getStruOrder);
        }
        List thatStruList = this.sysStruMapper.selectList((Wrapper)ew);
        if (thatStruList.size() > 0 && (thatStru = (SysStru)thatStruList.get(0)) != null) {
            BigDecimal temp = thisStru.getStruOrder();
            thisStru.setStruOrder(thatStru.getStruOrder());
            thatStru.setStruOrder(temp);
            this.sysStruMapper.updateById(thisStru);
            JSONObject object = new JSONObject();
            object.put("sysStru", (Object)thisStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object, Constants.NONE_ID);
            this.sysStruMapper.updateById(thatStru);
            JSONObject object1 = new JSONObject();
            object1.put("sysStru", (Object)thatStru);
            this.abstractPushMsgMatcher.insertOperation("organ", "update", (Object)object1, Constants.NONE_ID);
            this.bpmAbstractPushMsgMatcher.pushOrganSort(thisStru, thatStru, null);
        }
    }

    public List<JSTreeModel> getUserTree(Long parentId) {
        return this.sysStruMapper.getLazyLoadingUserTree(parentId);
    }

    public List<JSTreeModel> getUserDepChildTree(Long parentId) {
        return this.sysStruMapper.getLazyLoadingUserDepTree(parentId);
    }

    public JSTreeModel getOneOrg(Long struId) {
        return this.sysStruMapper.getOneOrg(struId);
    }

    public JSTreeModel getThisOneOrg(Long struId) {
        return this.sysStruMapper.getThisOneOrg(struId);
    }

    public List<JSTreeModel> getGradeStruTree(List<JSTreeModel> list1, int currentLevel) {
        Long struId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long currentStruId = shiroUser.getEmployeeId();
        Long currentUserId = shiroUser.getId();
        Long deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        List<SysStru> childList = this.sysStruMapper.getChildStruTree(currentLevel - 1);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (SysStru sysStru : list) {
            Long id = sysStru.getId();
            Long parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        Long parentId = currentStruId;
        ArrayList<Long> idList = new ArrayList<Long>();
        do {
            struId = parentId;
            parentId = (Long)idMap.get(struId);
            idList.add(struId);
            idList.add(parentId);
        } while (idMap.containsKey(parentId));
        HashMap<Long, Long> childIdMap = new HashMap<Long, Long>();
        for (SysStru sysStru : childList) {
            Long id = sysStru.getId();
            Long parentId2 = sysStru.getParentId();
            childIdMap.put(id, parentId2);
        }
        ArrayList<Long> childIdList = new ArrayList<Long>();
        struId = deptId;
        this.getAllChilden(childIdMap, childIdList, struId);
        int i = -1;
        ArrayList<JSTreeModel> rtnList = new ArrayList<JSTreeModel>();
        for (JSTreeModel jsTreeModel : list1) {
            String type;
            ++i;
            Long modelId = jsTreeModel.getId();
            String struLevelStr = jsTreeModel.getStruLevel();
            int struLevel = 0;
            if (struLevelStr != null) {
                struLevel = Integer.parseInt(struLevelStr);
            }
            if (struLevel == currentLevel - 1) {
                jsTreeModel.getState().put("changeDisabled", true);
            }
            if (struLevel < currentLevel) {
                if (!idList.contains(modelId)) continue;
                if (struLevel < currentLevel - 1) {
                    jsTreeModel.getState().put("gradeDisabled", true);
                }
                rtnList.add(jsTreeModel);
                continue;
            }
            if (struLevel == currentLevel) {
                if (list1.get(i).getPrime() != null && "0".equals(list1.get(i).getPrime())) {
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                    rtnList.add(jsTreeModel);
                    continue;
                }
                Long parent = jsTreeModel.getParent();
                if (!deptId.equals(parent)) continue;
                type = jsTreeModel.getType();
                rtnList.add(jsTreeModel);
                if ("ORGANROLE".equals(type)) {
                    jsTreeModel.getState().put("isOrganRoleNode", true);
                    continue;
                }
                if ("USER".equals(type)) {
                    if (!modelId.equals(currentUserId)) continue;
                    jsTreeModel.getState().put("currentUser", true);
                    continue;
                }
                if (!modelId.equals(currentStruId)) continue;
                jsTreeModel.getState().put("currentEmployee", true);
                continue;
            }
            Long id = jsTreeModel.getId();
            type = jsTreeModel.getType();
            if ("ORGANROLE".equals(type)) {
                id = jsTreeModel.getParent();
                jsTreeModel.getState().put("isOrganRoleNode", true);
            }
            if ("USER".equals(type)) {
                id = jsTreeModel.getEmployeeId();
            }
            if (!childIdList.contains(id)) continue;
            rtnList.add(jsTreeModel);
        }
        return rtnList;
    }

    public List<JSTreeModel> getGradeStruTreeForCopy(List<JSTreeModel> list1, int currentLevel) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long currentStruId = shiroUser.getEmployeeId();
        Long deptId = shiroUser.getDeptId();
        List<SysStru> list = this.sysStruMapper.getParentStruTree(currentLevel);
        HashMap<Long, Long> idMap = new HashMap<Long, Long>();
        for (SysStru sysStru : list) {
            Long id = sysStru.getId();
            Long parentId = sysStru.getParentId();
            idMap.put(id, parentId);
        }
        Long parentId = currentStruId;
        List<Object> idList = new ArrayList<Long>();
        do {
            Long struId = parentId;
            parentId = (Long)idMap.get(struId);
            idList.add(struId);
            idList.add(parentId);
        } while (idMap.containsKey(parentId));
        List childrenIdList = this.sysStruService.getChildOrgId(deptId, "03");
        QueryWrapper sysUsersQueryWrapper = new QueryWrapper();
        sysUsersQueryWrapper.lambda().in(SysUsers::getEmployeeId, (Collection)childrenIdList);
        List userIdList = this.sysUsersService.list((Wrapper)sysUsersQueryWrapper).stream().map(SysUsers::getId).collect(Collectors.toList());
        idList.addAll(childrenIdList);
        idList.addAll(userIdList);
        idList = idList.stream().distinct().collect(Collectors.toList());
        int i = -1;
        ArrayList<JSTreeModel> rtnList = new ArrayList<JSTreeModel>();
        for (JSTreeModel jsTreeModel : list1) {
            ++i;
            Long modelId = jsTreeModel.getId();
            String struLevelStr = jsTreeModel.getStruLevel();
            int struLevel = 0;
            if (struLevelStr != null) {
                struLevel = Integer.parseInt(struLevelStr);
            }
            if (struLevel == currentLevel - 1) {
                jsTreeModel.getState().put("changeDisabled", true);
            }
            if (struLevel < currentLevel) {
                if (!idList.contains(modelId)) continue;
                if (struLevel < currentLevel - 1) {
                    jsTreeModel.getState().put("gradeDisabled", true);
                }
                rtnList.add(jsTreeModel);
                continue;
            }
            if (!idList.contains(modelId)) continue;
            rtnList.add(jsTreeModel);
        }
        return rtnList;
    }

    public List<JSTreeModel> getOrgTree(String isEmployee, Long parentId) {
        return this.sysStruMapper.getLazyLoadingOrgTree(isEmployee, parentId);
    }

    public OrganInfoVo getOldOrgInfoById(Long struId) {
        return this.sysStruMapper.getOldOrgInfoById(struId);
    }

    public IPage<RoleOrgUserVo> getRoleOrgUser(Page<RoleOrgUserVo> page, RoleUserQueryDto roleUserQueryDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String orgId = roleUserQueryDto.getOrgId();
        String roleId = roleUserQueryDto.getRoleId();
        String account = roleUserQueryDto.getAccount();
        String name = roleUserQueryDto.getName();
        if (user.isGradeadmin()) {
            Long deptId = user.getDeptId();
            if (ToolUtil.isEmpty((Object)deptId)) {
                return page;
            }
            int checkResult = 1;
            if (ToolUtil.isNotEmpty((Object)orgId) && !"11".equals(orgId)) {
                checkResult = this.sysStruMapper.checkIsGradeStru(deptId, orgId);
            }
            if (checkResult == 1) {
                List<Object> roleOrgUserVoList = new ArrayList();
                if (!ToolUtil.isEmpty((Object)orgId)) {
                    roleOrgUserVoList = this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account);
                    page.setRecords(roleOrgUserVoList);
                    return page;
                }
                roleOrgUserVoList = this.sysStruMapper.getRoleOrgUserNoPage(roleId, orgId, name, account);
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> !o.getAccount().contains("admin") && !o.getAccount().contains("hussar")).collect(Collectors.toList());
                Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
                Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
                List userStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "02");
                userStruIdList.add(BaseSecurityUtil.getUser().getId());
                QueryWrapper sysUsersQueryWrapper = new QueryWrapper();
                sysUsersQueryWrapper.lambda().in(SysUsers::getEmployeeId, (Collection)userStruIdList);
                List userIdList = this.sysUsersService.list((Wrapper)sysUsersQueryWrapper).stream().map(SysUsers::getId).collect(Collectors.toList());
                roleOrgUserVoList = roleOrgUserVoList.stream().filter(o -> userIdList.contains(o.getId())).collect(Collectors.toList());
                int current = Integer.parseInt(String.valueOf(page.getCurrent()));
                int size = Integer.parseInt(String.valueOf(page.getSize()));
                ArrayList<Object> roleOrgUserVoLists = new ArrayList<Object>();
                int num = (current - 1) * size;
                if (num < roleOrgUserVoList.size()) {
                    for (int i = (current - 1) * size; i < size * current && num < roleOrgUserVoList.size(); ++num, ++i) {
                        roleOrgUserVoLists.add(roleOrgUserVoList.get(i));
                    }
                }
                page.setRecords(roleOrgUserVoLists);
                page.setTotal((long)roleOrgUserVoList.size());
            }
        } else {
            page.setRecords(this.sysStruMapper.getRoleOrgUser(page, roleId, orgId, name, account));
        }
        return page;
    }

    public List<RoleOrgUserVo> getAllUserByRole(RoleUserQueryDto roleUserQueryDto) {
        String orgId = roleUserQueryDto.getOrgId();
        String roleId = roleUserQueryDto.getRoleId();
        String account = roleUserQueryDto.getAccount();
        String name = roleUserQueryDto.getName();
        return this.sysStruMapper.getRoleOrgUserNoPage(roleId, orgId, name, account);
    }

    public List<JSTreeModel> geOrganRoleTree(Long parentId) {
        return this.sysStruMapper.getLazyLoadingOrganRoleTree(parentId);
    }

    private List<Long> getKey(Map<Long, Long> map, Object value) {
        Set<Map.Entry<Long, Long>> set = map.entrySet();
        Iterator<Map.Entry<Long, Long>> iterator = set.iterator();
        ArrayList<Long> arrayList = new ArrayList<Long>();
        while (iterator.hasNext()) {
            Map.Entry<Long, Long> entry = iterator.next();
            if (!entry.getValue().equals(value)) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    private void getAllChilden(Map<Long, Long> childIdMap, List<Long> childIdList, Long struId) {
        List<Long> tmpList;
        if (childIdMap.containsValue(struId) && (tmpList = this.getKey(childIdMap, struId)).size() > 0) {
            for (Long string : tmpList) {
                childIdList.add(string);
                this.getAllChilden(childIdMap, childIdList, string);
            }
        }
    }

    public void exportData(String ids, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u9700\u8981\u5bfc\u51fa\u7684\u7ec4\u7ec7id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        List strus = this.sysStruMapper.selectBatchIds(idList);
        ArrayList<Long> organIdList = new ArrayList<Long>();
        ArrayList<String> struTypeList = new ArrayList<String>();
        for (SysStru sysStru : strus) {
            Long organId = sysStru.getOrganId();
            String struType = sysStru.getStruType();
            organIdList.add(organId);
            struTypeList.add(struType);
        }
        if (ToolUtil.isEmpty(organIdList)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u7ec4\u7ec7\u5217\u8868");
        }
        List organs = this.sysOrganMapper.selectBatchIds(organIdList);
        List organTypes = this.sysOrganTypeMapper.selectBatchIds(struTypeList);
        List offices = this.sysOfficeMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysOffice::getStruId, idList));
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", strus);
        data.put("organs", organs);
        data.put("organTypes", organTypes);
        data.put("offices", offices);
        data.put("export_type", "organ");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "organ_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    @DSTransactional
    public ApiResponse importData(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"organ".equals(export_type)) {
            return ApiResponse.fail((String)("\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("organ")));
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List organTypes = (List)data.get("organTypes");
        List offices = (List)data.get("offices");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> organTypeCount = this.insertOrUpdateList(organTypes);
        Map<String, Integer> officeCount = this.insertOrUpdateList(offices);
        return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\u3002\u7ec4\u7ec7\u7ed3\u6784\u65b0\u589e\u6570\u636e" + struCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + struCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u673a\u6784\u65b0\u589e\u6570\u636e" + organCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organCount.get("update") + "\u6761\uff1b\u7ec4\u7ec7\u7c7b\u578b\u65b0\u589e\u6570\u636e" + organTypeCount.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + organTypeCount.get("update") + "\u6761\u3002"));
    }

    @DSTransactional
    public Map<String, String> importVueOrg(byte[] content) {
        HashMap<String, String> map = new HashMap<String, String>();
        Map data = null;
        try {
            if (content != null && content.length > 0) {
                data = (Map)SerializeUtils.deserialize((byte[])content);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty(data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"organ".equals(export_type)) {
            map.put("success", "false");
            map.put("errorImport", export_type);
            map.put("import", "organ");
            return map;
        }
        List strus = (List)data.get("strus");
        List organs = (List)data.get("organs");
        List organTypes = (List)data.get("organTypes");
        List offices = (List)data.get("offices");
        Map<String, Integer> struCount = this.insertOrUpdateList(strus);
        Map<String, Integer> organCount = this.insertOrUpdateList(organs);
        Map<String, Integer> organTypeCount = this.insertOrUpdateList(organTypes);
        Map<String, Integer> officeCount = this.insertOrUpdateList(offices);
        map.put("success", "true");
        map.put("struInsert", "" + struCount.get("insert"));
        map.put("struUpdate", "" + struCount.get("update"));
        map.put("orgType", "" + struCount.get("insert"));
        map.put("orgUpdate", "" + organTypeCount.get("update"));
        return map;
    }

    public JSONObject getImgUrl(HttpServletRequest request) {
        List<SysOrganTypeVo> list = this.sysOrganTypeMapper.getOrganTypeList(new Page(0L, 99999L), null);
        JSONObject json = new JSONObject();
        for (SysOrganTypeVo sysOrganTypeVo : list) {
            JSONObject jsonObject = new JSONObject();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hreq = request;
                String contextPath = "";
                contextPath = hreq.getSession().getServletContext().getContextPath();
                jsonObject.put("icon", (Object)(contextPath + sysOrganTypeVo.getImgUrl()));
            } else {
                jsonObject.put("icon", (Object)(request.getServletContext().getContextPath() + sysOrganTypeVo.getImgUrl()));
            }
            json.put(String.valueOf(sysOrganTypeVo.getId()), (Object)jsonObject);
        }
        return json;
    }

    public List<JSTreeModel> getOrgTreeByIdVue(OrganTreeDto organTreeDto) {
        Long orgId = organTreeDto.getParentId();
        String isEmployee = organTreeDto.getIsEmployee();
        List<JSTreeModel> result = this.getOrgTreeById(orgId, isEmployee);
        if (ToolUtil.isNotEmpty((Object)organTreeDto.getIsRoot()) && organTreeDto.getIsRoot().booleanValue()) {
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.ROOT_NODE_ID);
            root.setCode("");
            root.setText("\u7ec4\u7ec7\u673a\u6784");
            root.setStruLevel("0");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            result.add(root);
        }
        return result;
    }

    private List<SysOrganVo> pageSysOrganList(List<SysOrganVo> allSysOrganVOList, long pageNo, long limit) {
        ArrayList<SysOrganVo> currentPageList = new ArrayList<SysOrganVo>();
        if (allSysOrganVOList != null && allSysOrganVOList.size() > 0) {
            long currIdx = pageNo > 1L ? (pageNo - 1L) * limit : 0L;
            int i = 0;
            while ((long)i < limit && (long)i < (long)allSysOrganVOList.size() - currIdx) {
                SysOrganVo itemData = allSysOrganVOList.get(new Long(currIdx + (long)i).intValue());
                currentPageList.add(itemData);
                ++i;
            }
        }
        return currentPageList;
    }

    /*
     * WARNING - void declaration
     */
    private List<SysOrganVo> getOrganVOInDataScope(List<SysOrganVo> allSysOrganVOList, String dataScopeType, Set<String> optStruIdList) {
        List<Object> orgCodeList = new ArrayList<String>();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty(optStruIdList)) {
            orgCodeList = this.sysStruMapper.getOrgCodeListByIdList(new ArrayList<String>(optStruIdList));
        }
        if ("4".equals(dataScopeType)) {
            orgCodeList.addAll(this.sysOrganMapper.selfOrgCode(user.getId()));
            if (ToolUtil.isNotEmpty(orgCodeList)) {
                optStruIdList = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(orgCodeList));
            }
        }
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("STRU_CODE", "SYS_STRU");
        int idLength = sysIdtable.getIdLength().intValue();
        HashSet<String> parentCodeList = new HashSet<String>();
        for (String string : orgCodeList) {
            int length = string.length();
            for (int i = length - idLength; i >= 0; i -= idLength) {
                String parentCode = string.substring(0, i);
                parentCodeList.add(parentCode);
            }
        }
        ArrayList<SysOrganVo> dataScopeOrgList = new ArrayList<SysOrganVo>();
        ArrayList arrayList = new ArrayList();
        if (ToolUtil.isNotEmpty(optStruIdList)) {
            if (ToolUtil.isNotEmpty(parentCodeList)) {
                List<String> list = this.sysStruMapper.getStruIdByOrgCodeList(new ArrayList<String>(parentCodeList));
            }
            for (SysOrganVo sysOrganVo : allSysOrganVOList) {
                void var10_13;
                String struId = sysOrganVo.getStruId();
                if (optStruIdList.contains(struId)) {
                    dataScopeOrgList.add(sysOrganVo);
                    continue;
                }
                if (!var10_13.contains(struId)) continue;
                sysOrganVo.setDataScopeDisabled(ADD);
                dataScopeOrgList.add(sysOrganVo);
            }
        }
        return dataScopeOrgList;
    }

    public List<JSTreeModel> getDataScopeTree(List<JSTreeModel> list, String type, Set<String> orgListParam) {
        Set<String> orgList = orgListParam;
        ArrayList<String> codeList = new ArrayList<String>();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty(orgList)) {
            codeList = this.sysStruMapper.getOrgCodeListByIdList(new ArrayList<String>(orgList));
        }
        if ("4".equals(type)) {
            codeList.addAll(this.sysOrganMapper.selfOrgCode(user.getId()));
            if (ToolUtil.isNotEmpty(codeList)) {
                orgList = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(codeList));
            }
        }
        HashSet<String> parentCodeList = new HashSet<String>();
        SysIdtable sysIdtable = this.sysIdtableService.getIdtableByQuery("STRU_CODE", "SYS_STRU");
        int idLength = sysIdtable.getIdLength().intValue();
        ArrayList<JSTreeModel> dataScopeList = new ArrayList<JSTreeModel>();
        for (String code : codeList) {
            int length = code.length();
            for (int i = length - idLength; i >= 0; i -= idLength) {
                String parentCode = code.substring(0, i);
                parentCodeList.add(parentCode);
            }
        }
        List<Object> parentIdList = new ArrayList();
        if (ToolUtil.isNotEmpty(orgList)) {
            if (ToolUtil.isNotEmpty(parentCodeList)) {
                parentIdList = this.sysStruMapper.getStruIdByOrgCodeList(new ArrayList<String>(parentCodeList));
            }
            for (JSTreeModel jsTreeModel : list) {
                Long id = jsTreeModel.getId();
                if (orgList.contains(id)) {
                    dataScopeList.add(jsTreeModel);
                } else if (parentIdList.contains(id)) {
                    jsTreeModel.getState().put("dataScopeDisabled", true);
                    dataScopeList.add(jsTreeModel);
                }
                if (!ADD.equals(jsTreeModel.getIsEmployee()) && !"USER".equals(jsTreeModel.getType()) || !orgList.contains(jsTreeModel.getParent())) continue;
                if (jsTreeModel.getId().equals(user.getEmployeeId())) {
                    jsTreeModel.getState().put("currentEmployee", true);
                }
                if (jsTreeModel.getId().equals(user.getId())) {
                    jsTreeModel.getState().put("currentUser", true);
                }
                dataScopeList.add(jsTreeModel);
            }
        }
        return dataScopeList;
    }

    public void orgCodeChange(Long orgId, Long parentId, String orgType, Long level) {
        SysOrgan parentOrg = this.sysStruMapper.getOrganInfoByDeparmentId(parentId);
        SysOrgan sysOrgan = this.sysStruMapper.getOrganInfoByDeparmentId(orgId);
        if ("9".equals(orgType)) {
            String parentTypeCode = sysOrgan.getParentTypeCode();
            String newCode = sysOrgan.getOrganCode().replaceFirst(HussarUtils.isEmpty((Object)parentTypeCode) ? "" : parentTypeCode, parentOrg.getOrganCode());
            sysOrgan.setOrganCode(newCode);
            sysOrgan.setParentTypeCode(parentOrg.getOrganCode());
            this.sysOrganMapper.updateById(sysOrgan);
        } else {
            SysStru sysStru = (SysStru)this.sysStruMapper.selectById(orgId);
            long oldLevel = sysStru.getStruLevel().longValue();
            long subLevel = level - oldLevel;
            String businessName = "STRU_CODE";
            String tableName = "SYS_STRU";
            String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, parentOrg.getOrganCode());
            sysOrgan.setParentTypeCode(parentOrg.getOrganCode());
            List oldOrganList = this.sysOrganMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().likeRight(SysOrgan::getOrganCode, (Object)sysOrgan.getOrganCode())).eq(HussarDelflagEntity::getDelFlag, (Object)ADD));
            ArrayList<SysOrgan> organList = new ArrayList<SysOrgan>();
            ArrayList<Long> organIdList = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty((Object)oldOrganList)) {
                for (SysOrgan organ : oldOrganList) {
                    String newCode = organ.getOrganCode().replace(sysOrgan.getOrganCode(), currentCode);
                    organ.setOrganCode(newCode);
                    organ.setParentTypeCode(currentCode);
                    organList.add(organ);
                    organIdList.add(organ.getId());
                }
            }
            sysOrgan.setOrganCode(currentCode);
            organList.add(sysOrgan);
            this.sysOrganService.updateBatchById(organList);
            if (ToolUtil.isNotEmpty(organIdList)) {
                List oldStruList = this.sysStruMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStru::getOrganId, organIdList)).eq(HussarDelflagEntity::getDelFlag, (Object)ADD));
                ArrayList<SysStru> sysStruList = new ArrayList<SysStru>();
                for (SysStru stru : oldStruList) {
                    long struLevel = stru.getStruLevel().intValue();
                    stru.setStruLevel(new BigDecimal(struLevel + subLevel));
                    sysStruList.add(stru);
                }
                this.sysStruService.updateBatchById(sysStruList);
            }
        }
    }

    public boolean isExistChildOrgTypeByOrgType(String orgType, String isRoot) {
        SysStruRule sysStruRule;
        List<SysStruRule> ruleList = this.getOrgRoleByCode(orgType, isRoot);
        boolean result = true;
        boolean isEmpl = false;
        if (ruleList != null && ruleList.size() == 1 && "9".equals((sysStruRule = ruleList.get(0)).getSysOrganType())) {
            isEmpl = true;
        }
        if (ruleList != null && ruleList.size() == 0 || isEmpl) {
            result = false;
        }
        return result;
    }

    public StruSaveVo getAddOrganInfo(Long struId) {
        SysOrganVo orgInfo = this.getOrgInfoById(struId);
        String orgParentCode = "";
        String orgParentName = "";
        String parentTypeCode = "";
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            orgParentCode = orgInfo.getOrganCode();
            if (ToolUtil.isEmpty((Object)orgParentCode)) {
                orgParentCode = "";
            }
            orgParentName = orgInfo.getOrganName();
            parentTypeCode = orgInfo.getParentTypeCode();
            if (ToolUtil.isEmpty((Object)parentTypeCode)) {
                parentTypeCode = "";
            }
        }
        String businessName = "STRU_CODE";
        String tableName = "SYS_STRU";
        String currentCode = this.sysIdtableService.getCurrentCode(businessName, tableName, orgParentCode);
        StruSaveVo struSaveVo = new StruSaveVo();
        struSaveVo.setCurrentCode(currentCode);
        struSaveVo.setOrgParentCode(orgParentCode);
        struSaveVo.setOrgParentId(struId);
        struSaveVo.setOrgParentName(orgParentName);
        if (ToolUtil.isNotEmpty((Object)orgInfo)) {
            struSaveVo.setStruLevel(orgInfo.getStruLevel());
        } else {
            struSaveVo.setStruLevel("0");
        }
        struSaveVo.setParentTypeCode(parentTypeCode);
        return struSaveVo;
    }

    private Map<String, Integer> insertOrUpdateList(List<?> objects) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        if (CollectionUtils.isEmpty(objects)) {
            result.put("update", update);
            result.put("insert", insert);
            return result;
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = objects.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                Object object = objects.get(i);
                if (object instanceof SysStru) {
                    SysStru stru = (SysStru)object;
                    if (this.updateById(stru)) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.save(stru);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrgan) {
                    SysOrgan organ = (SysOrgan)object;
                    if (SqlHelper.retBool((Integer)this.sysOrganMapper.updateById(organ))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganMapper.insert(organ);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOffice) {
                    SysOffice office = (SysOffice)object;
                    if (SqlHelper.retBool((Integer)this.sysOfficeMapper.updateById(office))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOfficeMapper.insert(office);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (object instanceof SysOrganType) {
                    SysOrganType organType = (SysOrganType)object;
                    if (SqlHelper.retBool((Integer)this.sysOrganTypeMapper.updateById(organType))) {
                        n2 = update;
                        n = update = Integer.valueOf(update + 1);
                    } else {
                        this.sysOrganTypeMapper.insert(organType);
                        n2 = insert;
                        n = insert = Integer.valueOf(insert + 1);
                    }
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }

    private Set<String> getSelfOrgList() {
        SecurityUser user = BaseSecurityUtil.getUser();
        HashSet<String> orgIds = new HashSet<String>();
        List<String> codeList = this.sysOrganMapper.selfOrgCode(user.getId());
        if (ToolUtil.isNotEmpty(codeList)) {
            orgIds = new HashSet<String>(this.sysStruMapper.getStruIdByOrgCodeList(codeList));
        }
        return orgIds;
    }

    public void checkOrganInfo(Object object, String type) {
        ArrayList<String> messageList = new ArrayList<String>();
        switch (type) {
            case "add": 
            case "edit": {
                StruSaveDto struSaveDto = (StruSaveDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), StruSaveDto.class);
                if (ToolUtil.isEmpty((Object)struSaveDto)) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan())) {
                    messageList.add("\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOffice())) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                    break;
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getOrganAlias().trim())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0");
                } else if (struSaveDto.getSysStru().getOrganAlias().trim().length() > 32) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0\u6700\u591a\u53ef\u8f93\u516532\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getOrganCode().trim())) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u7f16\u7801\u672a\u751f\u6210");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getShortName().trim())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u522b\u540d");
                } else if (struSaveDto.getSysOrgan().getShortName().trim().length() > 64) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u522b\u540d\u6700\u591a\u53ef\u8f93\u516564\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getOrganType().trim())) {
                    messageList.add("\u672a\u9009\u62e9\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getOrganName().trim())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u540d\u79f0");
                } else if (struSaveDto.getSysOrgan().getOrganName().trim().length() > 64) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784\u540d\u79f0\u6700\u591a\u53ef\u8f93\u516564\u4e2a\u5b57\u7b26");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getBeginDate())) {
                    messageList.add("\u672a\u9009\u62e9\u7ec4\u7ec7\u673a\u6784\u751f\u6548\u65f6\u95f4");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getEndDate())) {
                    messageList.add("\u672a\u9009\u62e9\u7ec4\u7ec7\u673a\u6784\u5931\u6548\u65f6\u95f4");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getStruType())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getParentId())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7236\u7ea7id");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getStruLevel())) {
                    messageList.add("\u672a\u586b\u5199\u7ec4\u7ec7\u673a\u6784\u7ea7\u522b");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getStruOrder())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u6210\u5458\u5c40\u90e8\u6392\u5e8f\u503c\u4e3a\u7a7a");
                }
                if (!"edit".equals(type)) break;
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOrgan().getId())) {
                    messageList.add("\u7ec4\u7ec7id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getId())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysStru().getOrganId())) {
                    messageList.add("\u7ec4\u7ec7\u7ed3\u6784\u7684\u7ec4\u7ec7id\u4e3a\u7a7a");
                }
                if (ToolUtil.isEmpty((Object)struSaveDto.getSysOffice().getId())) {
                    messageList.add("\u7ec4\u7ec7\u673a\u6784id\u4e3a\u7a7a");
                }
                if (!ToolUtil.isEmpty((Object)struSaveDto.getSysOffice().getStruId())) break;
                messageList.add("\u7ec4\u7ec7\u673a\u6784\u4e2d\u7ec4\u7ec7\u7ed3\u6784id\u4e3a\u7a7a");
                break;
            }
            case "parentId": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u7236\u7ea7id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "orgDepTree": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u67e5\u8be2\u7684\u7236\u7ea7id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "orgInfoList": {
                SysOrganDto sysOrganDto = (SysOrganDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), SysOrganDto.class);
                if (!ToolUtil.isEmpty((Object)sysOrganDto)) break;
                messageList.add("\u8282\u70b9Id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "page": {
                Page page = (Page)JSONObject.parseObject((String)JSON.toJSONString((Object)object), Page.class);
                if (!ToolUtil.isEmpty((Object)page)) break;
                messageList.add("\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "orgChangeById": {
                OrganTreeDto organTreeDto = (OrganTreeDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), OrganTreeDto.class);
                if (!ToolUtil.isEmpty((Object)organTreeDto)) break;
                messageList.add("\u67e5\u8be2\u7ec4\u7ec7\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "orgInfo": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u67e5\u8be2\u7ec4\u7ec7\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "updateMoveNode": {
                StruChangeDto struChangeDto = (StruChangeDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), StruChangeDto.class);
                if (!ToolUtil.isEmpty((Object)struChangeDto.isUp())) break;
                messageList.add("\u4e0a\u4e0b\u79fb\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "orgTreeChange": {
                StruChangeDto struChangeDtoForChange = (StruChangeDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), StruChangeDto.class);
                if (ToolUtil.isEmpty((Object)struChangeDtoForChange.getParentId())) {
                    messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u5230\u7684\u8282\u70b9id");
                }
                if (ToolUtil.isEmpty((Object)struChangeDtoForChange.getParentLevel())) {
                    messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u5230\u7684\u8282\u70b9\u7ea7\u522b");
                }
                if (!ToolUtil.isEmpty((Object)struChangeDtoForChange.getStruId())) break;
                messageList.add("\u8bf7\u586b\u5199\u8981\u8f6c\u79fb\u5230\u7684\u7ec4\u7ec7\u7ed3\u6784id");
                break;
            }
            case "getOrganAlias": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u83b7\u53d6\u7ec4\u7ec7\u7ed3\u6784\u522b\u540d\u65f6\u7ec4\u7ec7\u7ed3\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "checkRoleId": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
            case "struId": {
                if (!ToolUtil.isEmpty((Object)object)) break;
                messageList.add("\u7ec4\u7ec7\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
                break;
            }
        }
        if (ToolUtil.isNotEmpty(messageList)) {
            String allMessage = StringUtils.join((Object[])messageList.toArray(), (String)",");
            throw new BaseException(allMessage);
        }
    }
}

