/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.service.impl;

import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrgService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruResourcesService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IGlobalService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ISysOrgServiceImpl
implements ISysOrgService {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private IGlobalService globalService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private ISysStruResourcesService sysStruResourcesService;
    @Resource
    private ISysStruFunctionsService sysStruFunctionsService;
    @Resource
    private SysStruRuleMapper sysStruRuleMapper;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysOrganTypeService organTypeService;

    public List<JSTreeModel> getOrgTree(String isEmployee, String isExport, Long resourceId, String type, String handle, Long parentId) {
        String newType = type;
        Long newParentId = parentId;
        Long newResourceId = resourceId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (Boolean.parseBoolean(isExport)) {
            root.setState(false, false, true);
        }
        List list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee);
        }
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        if (newResourceId != null && newType != null) {
            Long treeId;
            newType = newType.trim();
            List resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            List struResourceCount = this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
            if ("delegate".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (!struResourceCount.contains(treeId)) continue;
                    jsTreeModel.setState(true, true, true);
                }
            }
            if ("retrieve".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (struResourceCount.contains(treeId)) {
                        jsTreeModel.setState(true, true, false);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        result.addAll(list);
        return result;
    }

    public List<Long> getResourceStruId(Long resourceId, String type) {
        if (ToolUtil.isEmpty((Object)resourceId)) {
            throw new BaseException("\u8d44\u6e90id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)type)) {
            throw new BaseException("\u8d44\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String newType = type;
        Long newResourceId = resourceId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        List list = new ArrayList();
        List baseTreeList = new ArrayList();
        List<Long> struIdResource = new ArrayList<Long>();
        baseTreeList = this.orgMaintenanceService.getOrgTree(null);
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(baseTreeList, level) : baseTreeList;
        if (newResourceId != null && newType != null) {
            newType = newType.trim();
            List resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            struIdResource = this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
        }
        return struIdResource;
    }

    public List<Long> getFunctionStruId(Long functionId) {
        if (ToolUtil.isEmpty((Object)functionId)) {
            throw new HussarException("\u529f\u80fdid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long newFunctionId = functionId;
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        List list = new ArrayList();
        List baseTreeList = new ArrayList();
        List<Long> struIdFunction = new ArrayList<Long>();
        baseTreeList = this.orgMaintenanceService.getOrgTree(null);
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(baseTreeList, level) : baseTreeList;
        if (newFunctionId != null) {
            ArrayList<Long> functionIdList = new ArrayList<Long>();
            functionIdList.add(newFunctionId);
            struIdFunction = this.sysStruFunctionsService.getStruFunctionCountMap(list, functionIdList);
        }
        return struIdFunction;
    }

    public List<String> getAllParentId() {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        Long struId = shiroUser.getEmployeeId();
        List<String> idList = new ArrayList<String>();
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin && ToolUtil.isNotEmpty((Object)struId)) {
            idList = this.getInfo(struId, idList);
            return idList;
        }
        return idList;
    }

    public List<JSTreeModel> getOrgTreeVue(OrganTreeDto organTreeDto) {
        if (ToolUtil.isEmpty((Object)organTreeDto)) {
            throw new BaseException("\u67e5\u8be2\u7ec4\u7ec7\u6811\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String newType = organTreeDto.getType() == null ? "" : organTreeDto.getType();
        Long newParentId = organTreeDto.getParentId();
        Long newResourceId = organTreeDto.getResourceId();
        String isEmployee = organTreeDto.getIsEmployee() == null ? "" : organTreeDto.getIsEmployee();
        String handle = organTreeDto.getHandle() == null ? "" : organTreeDto.getHandle();
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        if (organTreeDto.isExport()) {
            root.setState(false, false, true);
        }
        List list = new ArrayList();
        List list1 = new ArrayList();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)newParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)newParentId)) {
                newParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee, newParentId);
        } else {
            result.add(root);
            list1 = this.orgMaintenanceService.getOrgTree(isEmployee);
        }
        list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        if (newResourceId != null && newType != null) {
            Long treeId;
            newType = newType.trim();
            List resourceIdList = this.sysStruResourcesService.getResourceIdList(newResourceId, newType);
            List struResourceCount = new ArrayList();
            struResourceCount = "func".equals(newType) ? this.sysStruFunctionsService.getStruFunctionCountMap(list, resourceIdList) : this.sysStruResourcesService.getStruResourceCountMap(list, resourceIdList);
            if ("delegate".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (!struResourceCount.contains(treeId)) continue;
                    jsTreeModel.setState(true, true, true);
                }
            }
            if ("retrieve".equals(handle)) {
                for (JSTreeModel jsTreeModel : list) {
                    treeId = jsTreeModel.getId();
                    if (struResourceCount.contains(treeId)) {
                        jsTreeModel.setState(true, true, false);
                        continue;
                    }
                    jsTreeModel.setState(false, false, true);
                }
            }
        }
        result.addAll(list);
        List listOrganType = this.organTypeService.list();
        Map mapOrganType = listOrganType.stream().collect(Collectors.toMap(SysOrganType::getId, Function.identity()));
        mapOrganType.get(1);
        if (CollectionUtils.isNotEmpty(result)) {
            for (JSTreeModel jsTreeModel : result) {
                if (!StringUtils.isNotBlank((CharSequence)jsTreeModel.getStruType())) continue;
                jsTreeModel.setImgUrl(((SysOrganType)mapOrganType.get(Long.parseLong(jsTreeModel.getStruType()))).getImgUrl());
            }
        }
        return result;
    }

    public List<JSTreeModel> getOrgDepTreeVue(Long struParentId) {
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        int level = 0;
        boolean isGradeAdmin = shiroUser.isGradeadmin();
        if (isGradeAdmin) {
            Long empolyeeId = shiroUser.getEmployeeId();
            String struLevel = this.sysEmployeeService.selectStruLevel(empolyeeId);
            level = Integer.parseInt(struLevel);
        }
        ArrayList<JSTreeModel> result = new ArrayList<JSTreeModel>();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.ROOT_NODE_ID);
        root.setCode(String.valueOf(Constants.ROOT_NODE_ID));
        root.setText("\u7ec4\u7ec7\u673a\u6784");
        root.setIsLeaf("0");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setStruLevel("0");
        root.setType("isRoot");
        root.setContainsRules("1");
        if (isGradeAdmin) {
            root.getState().put("gradeDisabled", true);
        }
        List<Object> list1 = new ArrayList<JSTreeModel>();
        if (this.globalService.isTreeLazyLoad() && ToolUtil.isNotEmpty((Object)struParentId)) {
            if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)struParentId)) {
                struParentId = Constants.ROOT_NODE_ID;
                result.add(root);
            }
            list1 = this.orgMaintenanceService.getOrgTree(null, struParentId);
        }
        List<Object> list = isGradeAdmin ? this.orgMaintenanceService.getGradeStruTree(list1, level) : list1;
        this.toSetContainsRules(list);
        result.addAll(list);
        return result;
    }

    public void toSetContainsRules(List<JSTreeModel> list) {
        List<String> stringList = this.sysStruRuleMapper.getAllSysOrganType();
        for (JSTreeModel jsTreeModel : list) {
            boolean contains = stringList.contains(jsTreeModel.getStruType());
            if (contains) {
                jsTreeModel.setContainsRules("1");
                continue;
            }
            jsTreeModel.setContainsRules("0");
        }
    }

    public List<JSTreeModel> getOrgChangeTreeById(OrganTreeDto organTreeDto) {
        List<JSTreeModel> result = this.getOrgTreeVue(organTreeDto);
        for (JSTreeModel jsTreeModel : result) {
            jsTreeModel.setChildren("false");
        }
        return result;
    }

    public List<JSTreeModel> getDelegateRetrieveTree(OrganTreeDto organTreeDto) {
        boolean isGradeAdmin;
        List<JSTreeModel> list = this.getOrgTreeVue(organTreeDto);
        List<String> idList = this.getAllParentId();
        if (ToolUtil.isNotEmpty(idList)) {
            for (JSTreeModel jsTreeModel : list) {
                Long treeId = jsTreeModel.getId();
                if (!idList.contains(treeId)) continue;
                jsTreeModel.setState(false, false, true);
            }
        }
        if (isGradeAdmin = Objects.requireNonNull(BaseSecurityUtil.getUser()).isGradeadmin()) {
            Long struId = Objects.requireNonNull(BaseSecurityUtil.getUser()).getEmployeeId();
            Long gradeParentId = this.orgMaintenanceService.getOneOrg(struId).getId();
            List childrenStruIdList = this.sysStruService.getChildOrgId(gradeParentId, "01");
            list.forEach(o -> {
                if (!childrenStruIdList.contains(o.getId())) {
                    o.getState().put("disabled", true);
                }
            });
        }
        return list;
    }

    private List<String> getInfo(Long struId, List<String> idList) {
        idList.add(String.valueOf(struId));
        SysStru sysStru = (SysStru)this.sysStruMapper.selectById(struId);
        if (ToolUtil.isNotEmpty((Object)sysStru)) {
            this.getInfo(sysStru.getParentId(), idList);
        }
        return idList;
    }
}

