/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganTypeDto;
import com.jxdinfo.hussar.authorization.organ.model.SysOrganType;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganTypeVo;
import com.jxdinfo.hussar.common.annotion.NoRepeatMethod;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49"})
@RestController
@RequestMapping(value={"/sysOrganFront"})
public class SysOrganTypeFrontController
extends HussarBaseController<SysOrganType, ISysOrganTypeService> {
    @Resource
    private ISysOrganTypeService iSysOrganTypeService;

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u5206\u9875", notes="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u5206\u9875")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysOrganType", value="\u7ec4\u7ec7\u7c7b\u578b\u5bf9\u8c61", required=true, paramType="query")})
    @GetMapping(value={"/getList"})
    @CheckPermission(value={"sysOrganFront:getList"})
    @NoRepeatMethod(timeout=50L, autoCompletion=false)
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysOrganTypeVo>> list(Page<SysOrganTypeVo> page, SysOrganType sysOrganType) {
        sysOrganType.setTypeName(ToolUtil.isNotEmpty((Object)sysOrganType.getTypeName()) ? sysOrganType.getTypeName().replace("%", "\\%").replace("_", "\\_") : "");
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrganTypeList(page, sysOrganType));
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", notes="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b")
    @GetMapping(value={"/orgTypeOption"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysOrganType>> orgTypeOption() {
        return ApiResponse.success((Object)this.iSysOrganTypeService.getOrgTypeOption());
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f", notes="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f")
    @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801", required=true, paramType="query")
    @CheckPermission(value={"sysOrganFront:selectOrg"})
    @GetMapping(value={"selectOrg"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u6839\u636eid\u83b7\u53d6\u7ec4\u7ec7\u7c7b\u578b\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganType> selectOrg(String orgCode) {
        if (ToolUtil.isEmpty((Object)orgCode)) {
            throw new BaseException("\u7ec4\u7ec7\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ApiResponse.success((Object)this.iSysOrganTypeService.getById((Serializable)((Object)orgCode)));
    }

    @ApiOperation(value="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b", notes="\u6dfb\u52a0\u7ec4\u7ec7\u7c7b\u578b")
    @ApiImplicitParam(name="sysOrganType", value="\u7ec4\u7ec7\u7c7b\u578b\u5bf9\u8c61", required=true, paramType="body")
    @PostMapping(value={"/add"})
    @CheckPermission(value={"sysOrganFront:add"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u65b0\u589e\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> add(@RequestBody SysOrganType sysOrganType) {
        this.iSysOrganTypeService.checkOrganTypeInfo((Object)sysOrganType, "add");
        return this.iSysOrganTypeService.saveSysOrganType(sysOrganType);
    }

    @ApiOperation(value="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", notes="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b")
    @ApiImplicitParam(name="sysOrganTypeDto", value="\u7ec4\u7ec7\u7c7b\u578bdto", required=true, paramType="body")
    @PostMapping(value={"/edit"})
    @CheckPermission(value={"sysOrganFront:edit"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> edit(@RequestBody SysOrganTypeDto sysOrganTypeDto) {
        this.iSysOrganTypeService.checkOrganTypeInfo((Object)sysOrganTypeDto, "edit");
        return this.iSysOrganTypeService.updateSysOrganType(sysOrganTypeDto);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b", notes="\u6279\u91cf\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b")
    @ApiImplicitParam(name="ids", value="\u5220\u9664\u7684\u7ec4\u7ec7\u7c7b\u578bid\u5b57\u7b26\u4e32", required=true, paramType="form")
    @PostMapping(value={"/delByIds"})
    @CheckPermission(value={"sysOrganFront:delByIds"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u7c7b\u578b\u5b9a\u4e49", eventDesc="\u5220\u9664\u7ec4\u7ec7\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delByIds(@RequestBody String ids) {
        ids = ids.replace("\"", "");
        return this.iSysOrganTypeService.deleteByIds(ids);
    }
}

