/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrgService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.StruSaveVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.permit.model.SysStruRole;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4"})
@RestController
@RequestMapping(value={"/orgMainFront"})
public class SysOrgManageFrontController
extends HussarBaseController<SysStru, SysOrgManageService> {
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    private ISysOrgService iSysOrgService;
    @Resource
    private ISysAuditConfigService sysAuditConfig;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgTree(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysOrgService.getOrgTreeVue(organTreeDto)));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", notes="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d(\u8fc7\u6ee4\u5c97\u4f4d\u8282\u70b9)")
    @ApiImplicitParam(name="parentId", value="\u8282\u70b9id", paramType="query")
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgDepTree"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u6811\u7684\u7ea7\u8054\u52a0\u8f7d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgDepTree(Long parentId) {
        this.orgMaintenanceService.checkOrganInfo((Object)parentId, "orgDepTree");
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysOrgService.getOrgDepTreeVue(parentId)));
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysOrganDto", value="\u7ec4\u7ec7dto", required=true, paramType="query")})
    @GetMapping(value={"/orgInfoList"})
    @CheckPermission(value={"orgMainFront:orgInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\u4e0b\u7684\u6240\u6709\u8282\u70b9\u57fa\u672c\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysOrganVo>> orgInfoList(Page page, SysOrganDto sysOrganDto) {
        sysOrganDto.setOrganName(sysOrganDto.getOrganName().replace("%", "\\%").replace("_", "\\_"));
        sysOrganDto.setOrganCode(sysOrganDto.getOrganCode().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgInfoListByParentId(page, sysOrganDto));
    }

    @ApiOperation(value="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811", notes="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"orgMainFront:getDeReTree"})
    @GetMapping(value={"/getDelegateRetrieveTree"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u56de\u6536\u4e0b\u653e\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getStruParentId(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysOrgService.getDelegateRetrieveTree(organTreeDto)));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id", notes="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id")
    @ApiImplicitParams(value={@ApiImplicitParam(name="resourceId", value="\u8d44\u6e90id", required=true, paramType="query"), @ApiImplicitParam(name="type", value="\u8d44\u6e90\u7c7b\u578b", required=true, paramType="query")})
    @CheckPermission(value={"orgMainFront:orgTree"})
    @GetMapping(value={"/orgResourceStruId"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u4e0b\u653e\u8d44\u6e90\u7684\u7ec4\u7ec7\u673a\u6784id", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> orgResourceStruId(Long resourceId, String type) {
        return ApiResponse.success((Object)this.iSysOrgService.getResourceStruId(resourceId, type));
    }

    @ApiOperation(value="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id", notes="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id")
    @ApiImplicitParams(value={@ApiImplicitParam(name="functionId", value="\u529f\u80fdid", required=true, paramType="query")})
    @GetMapping(value={"/orgFunctionStruId"})
    @ResponseBody
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u4e0b\u653e\u529f\u80fd\u7684\u7ec4\u7ec7\u673a\u6784id", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<Long>> orgFunctionStruId(Long functionId) {
        return ApiResponse.success((Object)this.iSysOrgService.getFunctionStruId(functionId));
    }

    @ApiOperation(value="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u6839\u636e\u8282\u70b9\u7ec4\u7ec7\u673a\u6784ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"orgMainFront:orgTreeById"})
    @GetMapping(value={"/orgTreeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u8282\u70b9ID\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgTreeById(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.orgMaintenanceService.getOrgTreeByIdVue(organTreeDto)));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u67e5\u770b")
    @ApiImplicitParam(name="struId", value="\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/orgInfo"})
    @CheckPermission(value={"orgMainFront:orgInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganVo> orgInfo(Long struId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgInfoById(struId));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e")
    @ApiImplicitParam(name="orgParentId", value="\u4e0a\u7ea7\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/orgInfoAdd"})
    @CheckPermission(value={"orgMainFront:orgInfoAdd"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u66f4\u65b0\u7ec4\u7ec7\u673a\u6784\u5c42\u7ea7\u7801", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<StruSaveVo> orgInfoAdd(Long orgParentId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getAddOrganInfo(orgParentId));
    }

    @ApiOperation(value="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f", notes="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f")
    @ApiImplicitParam(name="struId", value="\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/struRoleInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u770b\u7ec4\u7ec7\u673a\u6784\u89d2\u8272\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruRole>> getStruRoleInfo(Long struId) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getStruRole(struId));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgType", value="\u7ec4\u7ec7\u7c7b\u578b", paramType="query"), @ApiImplicitParam(name="isRoot", value="\u662f\u5426\u4e3a\u6839\u8282\u70b9", paramType="query")})
    @CheckPermission(value={"orgMainFront:getOrgRoleByCode"})
    @GetMapping(value={"/getOrgRoleByCode"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u83b7\u53d6\u4e0b\u5c5e\u5355\u4f4d\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruRule>> getOrgRoleByCode(String orgType, String isRoot) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getOrgRoleByCode(orgType, isRoot));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", notes="\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgType", value="\u7ec4\u7ec7\u7c7b\u578b", paramType="query"), @ApiImplicitParam(name="isRoot", value="\u662f\u5426\u4e3a\u6839\u8282\u70b9", paramType="query")})
    @GetMapping(value={"/getExitOrgRoleByCode"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b\u662f\u5426\u5b58\u5728\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784\u7c7b\u578b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> getExitOrgRoleByCode(String orgType, String isRoot) {
        return ApiResponse.success((Object)this.orgMaintenanceService.isExistChildOrgTypeByOrgType(orgType, isRoot));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58")
    @ApiImplicitParam(name="struSaveDto", value="\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto", required=true, paramType="body")
    @PostMapping(value={"/orgInfoSave"})
    @CheckPermission(value={"orgMainFront:orgInfoSave"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784->\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<JSONObject> orgInfoSave(@RequestBody StruSaveDto struSaveDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struSaveDto, "add");
        return ApiResponse.success((String)this.orgMaintenanceService.saveOrgInfoVue(struSaveDto));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f\u4fee\u6539\u4fdd\u5b58")
    @ApiImplicitParam(name="struSaveDto", value="\u7ec4\u7ec7\u673a\u6784\u4fdd\u5b58dto", required=true, paramType="body")
    @RequestMapping(value={"/orgInfoEditSave"})
    @CheckPermission(value={"orgMainFront:orgInfoEditSave"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<JSONObject> orgInfoEditSave(@RequestBody StruSaveDto struSaveDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struSaveDto, "edit");
        return ApiResponse.success((String)this.orgMaintenanceService.updateOrgInfoVue(struSaveDto));
    }

    @ApiOperation(value="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f", notes="\u4fdd\u5b58\u7ec4\u7ec7\u673a\u6784\u6811\u6392\u5e8f")
    @ApiImplicitParam(name="idList", value="\u4e0b\u7ea7\u7ec4\u7ec7\u673a\u6784id\u96c6\u5408", paramType="body")
    @PostMapping(value={"/orgTreeOrder"})
    @CheckPermission(value={"orgMainFront:orgTreeOrder"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u4fee\u6539\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Object> orgTreeOrder(@RequestBody List<Long> idList) {
        this.orgMaintenanceService.updateOrgTreeOrder(idList);
        return ApiResponse.success((Object)HttpCode.OK.value(), (String)"\u6392\u5e8f\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784", notes="\u6839\u636eID\u5220\u9664\u7ec4\u7ec7\u673a\u6784")
    @ApiImplicitParam(name="struId", value="\u7ec4\u7ec7\u673a\u6784id", required=true, paramType="form")
    @CheckPermission(value={"orgMainFront:delOrgById"})
    @PostMapping(value={"/delOrgById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u5220\u9664\u7ec4\u7ec7\u673a\u6784", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<JSONObject> delOrgById(@RequestBody Long struId) {
        return ApiResponse.success((String)this.orgMaintenanceService.deleteOrgByIdVue(struId));
    }

    @ApiOperation(value="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868", notes="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysStaffDto", value="\u4eba\u5458dto", paramType="query")})
    @CheckPermission(value={"orgMainFront:principalSelect"})
    @GetMapping(value={"principalSelect"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u83b7\u53d6\u8d1f\u8d23\u4eba\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage> principalSelect(Page page, SysStaffDto sysStaffDto) {
        return ApiResponse.success((Object)this.orgMaintenanceService.getPrincipalSelectList(page, sysStaffDto));
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", notes="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"orgMainFront:orgChangeById"})
    @GetMapping(value={"/orgChangeById"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u6839\u636eID\u83b7\u53d6\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> orgChangeById(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysOrgService.getOrgChangeTreeById(organTreeDto)));
    }

    @ApiOperation(value="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784", notes="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784")
    @ApiImplicitParam(name="struChangeDto", value="\u7ec4\u7ec7\u8f6c\u79fbdto", required=true, paramType="body")
    @PostMapping(value={"/orgTreeChange"})
    @CheckPermission(value={"orgMainFront:orgTreeChange"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u8f6c\u79fb\u7ec4\u7ec7\u673a\u6784\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> orgTreeChange(@RequestBody StruChangeDto struChangeDto) {
        this.orgMaintenanceService.checkOrganInfo((Object)struChangeDto, "orgTreeChange");
        return this.orgMaintenanceService.orgTreeChangeVue(struChangeDto);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb", notes="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7id", paramType="form"), @ApiImplicitParam(name="isUp", value="\u662f\u5426\u4e3a\u4e0a\u79fb", paramType="form")})
    @PostMapping(value={"/singleMove"})
    @CheckPermission(value={"orgMain:singleMove"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6811\u4e0a\u79fb\u4e0b\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> updateMoveNode(@RequestBody JSONObject jsonObject) {
        StruChangeDto struChangeDto = (StruChangeDto)JSONObject.parseObject((String)jsonObject.toString(), StruChangeDto.class);
        this.orgMaintenanceService.checkOrganInfo((Object)struChangeDto, "updateMoveNode");
        this.orgMaintenanceService.updateMoveNode(struChangeDto.getStruId(), struChangeDto.isUp());
        return ApiResponse.success((String)"\u79fb\u52a8\u6210\u529f");
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa", notes="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParam(name="ids", value="\u5bfc\u51fa\u7684\u7ec4\u7ec7id\u5b57\u7b26\u4e32", paramType="form")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"orgMainFront:exportData"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public void exportData(@RequestBody String ids, HttpServletResponse response) {
        this.orgMaintenanceService.exportData(ids, response);
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165", notes="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165")
    @ApiImplicitParam(name="file", value="\u5bfc\u5165\u6587\u4ef6", paramType="form")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"orgMainFront:importData"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u7ef4\u62a4", eventDesc="\u7ec4\u7ec7\u673a\u6784\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Object> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.orgMaintenanceService.importVueOrg(content));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838", notes="\u7ec4\u7ec7\u673a\u6784\u662f\u5426\u5ba1\u6838")
    @GetMapping(value={"/isAudit"})
    public ApiResponse<?> isAudit() {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isOrganAudit()) {
            return ApiResponse.success((Object)true);
        }
        return ApiResponse.success((Object)false);
    }
}

