/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.organ.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.dto.OrganTreeDto;
import com.jxdinfo.hussar.authorization.organ.dto.StaffSaveDto;
import com.jxdinfo.hussar.authorization.organ.dto.StruChangeDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysOrganDto;
import com.jxdinfo.hussar.authorization.organ.dto.SysStaffDto;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.SysOrgManageService;
import com.jxdinfo.hussar.authorization.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.authorization.organ.vo.SysStaffVO;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.ForestNodeMerger;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.mp.base.controller.HussarBaseController;
import com.jxdinfo.hussar.support.security.core.annotation.CheckPermission;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/employeeFront"})
public class SysEmployeeFrontController
extends HussarBaseController<SysStru, ISysEmployeeService> {
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private SysOrgManageService orgMaintenanceService;
    @Resource
    ISysStruAssistOrganService iSysStruAssistOrganService;

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @CheckPermission(value={"employeeFront:employeeTree"})
    @GetMapping(value={"/employeeTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeTree(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysEmployeeService.getEmployeeTreeVue(organTreeDto)));
    }

    @ApiOperation(value="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", notes="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8")
    @ApiImplicitParam(name="parentId", value="\u4eba\u5458\u90e8\u95e8id", required=true, paramType="query")
    @CheckPermission(value={"employeeFront:employeeTree"})
    @GetMapping(value={"/employeeDepTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u61d2\u52a0\u8f7d\u4eba\u5458\u90e8\u95e8\u7684\u4e0b\u7ea7\u90e8\u95e8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeDepTree(Long parentId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysEmployeeService.getEmployeeDepTreeVue(parentId)));
    }

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", notes="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5206\u9875\u4fe1\u606f", required=true, paramType="query"), @ApiImplicitParam(name="sysStaffDto", value="\u4eba\u5458dto", required=true, paramType="query")})
    @CheckPermission(value={"employeeFront:employeeInfo"})
    @GetMapping(value={"/employeeInfoList"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u5f53\u524d\u5458\u5de5\u4fe1\u606f\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<IPage<SysStaffVO>> employeeInfoList(Page page, SysStaffDto sysStaffDto) {
        sysStaffDto.setName(sysStaffDto.getName().replace("%", "\\%").replace("_", "\\_"));
        sysStaffDto.setOrganCode(sysStaffDto.getOrganCode().replace("%", "\\%").replace("_", "\\_"));
        return ApiResponse.success((Object)this.sysEmployeeService.getStaffInfoByParentStruId(page, sysStaffDto));
    }

    @ApiOperation(value="\u4eba\u5458\u65b0\u589e", notes="\u4eba\u5458\u65b0\u589e")
    @ApiImplicitParam(name="sysOrganDto", value="organ\u7ec4\u7ec7dto", required=true, paramType="body")
    @GetMapping(value={"/employeeAdd"})
    @CheckPermission(value={"employeeFront:employeeAdd"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u65b0\u589e", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> orgInfoAdd(SysOrganDto sysOrganDto) {
        return ApiResponse.success((String)this.sysEmployeeService.getCurrentCode(sysOrganDto));
    }

    @ApiOperation(value="\u67e5\u770b\u4eba\u5458\u4fe1\u606f", notes="\u67e5\u770b\u4eba\u5458\u4fe1\u606f")
    @ApiImplicitParam(name="struId", value="\u4eba\u5458\u7ec4\u7ec7id", required=true, paramType="query")
    @CheckPermission(value={"employeeFront:employeeInfo"})
    @GetMapping(value={"/employeeInfo"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u67e5\u770b\u4eba\u5458\u4fe1\u606f", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<SysOrganVo> employeeInfo(Long struId) {
        return ApiResponse.success((Object)this.sysEmployeeService.getEmployeeInfo(struId));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58")
    @ApiImplicitParam(name="staffSaveDto", value="\u4eba\u5458\u4fdd\u5b58\u4fee\u6539dto", required=true, paramType="body")
    @CheckPermission(value={"employeeFront:employeeAdd"})
    @PostMapping(value={"/emplInfoSave"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u65b0\u589e\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> emplInfoSave(@RequestBody StaffSaveDto staffSaveDto) {
        this.sysEmployeeService.checkUserInfo((Object)staffSaveDto, "add");
        return this.sysEmployeeService.saveEmployee(staffSaveDto);
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458", notes="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458")
    @ApiImplicitParam(name="struId", value="\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/judgeAddRules"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u89c4\u5219\u5224\u65ad\u8be5\u7ec4\u7ec7\u673a\u6784\u4e0b\u80fd\u5426\u65b0\u589e\u4eba\u5458", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Boolean> judgeAddRules(Long struId) {
        return ApiResponse.success((Object)this.sysEmployeeService.judgeAddRules(struId));
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58", notes="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58")
    @ApiImplicitParam(name="staffSaveDto", value="\u4eba\u5458\u4fdd\u5b58\u4fee\u6539dto", required=true, paramType="body")
    @CheckPermission(value={"employeeFront:emplInfoEditSave"})
    @PostMapping(value={"/emplInfoEditSave"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u4eba\u5458\u7ba1\u7406", eventDesc="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u4fee\u6539\u4fdd\u5b58", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> emplInfoEditSave(@RequestBody StaffSaveDto staffSaveDto) {
        this.sysEmployeeService.checkUserInfo((Object)staffSaveDto, "edit");
        return this.sysEmployeeService.updateEmployee(staffSaveDto);
    }

    @ApiOperation(value="\u4eba\u5458\u5220\u9664", notes="\u4eba\u5458\u5220\u9664")
    @ApiImplicitParam(name="orgId", value="\u4eba\u5458id", required=true, paramType="form")
    @CheckPermission(value={"employeeFront:delEmployeeById"})
    @PostMapping(value={"/delEmployeeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u5220\u9664", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Tip> delEmployeeById(@RequestBody Long orgId) {
        return this.sysEmployeeService.deleteEmployee(orgId);
    }

    @ApiOperation(value="\u4eba\u5458\u8f6c\u79fb", notes="\u4eba\u5458\u8f6c\u79fb")
    @ApiImplicitParam(name="struChangeDto", value="\u4eba\u5458\u8f6c\u79fbdto", required=true, paramType="body")
    @PostMapping(value={"/staffTransfer"})
    @CheckPermission(value={"employeeFront:staffTransfer"})
    @CacheEvict(value={"data_scope_list", "data_scope_type"}, allEntries=true)
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u8f6c\u79fb", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Tip> orgTreeChange(@RequestBody StruChangeDto struChangeDto) {
        this.sysEmployeeService.checkUserInfo((Object)struChangeDto, "transfer");
        return this.orgMaintenanceService.orgTreeChangeVue(struChangeDto);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811", notes="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811")
    @ApiImplicitParam(name="orgId", value="\u7ec4\u7ec7\u673a\u6784id", required=true, paramType="form")
    @CheckPermission(value={"employeeFront:employeeTreeById"})
    @GetMapping(value={"/employeeTreeById"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u6307\u5b9a\u7ec4\u7ec7\u673a\u6784\u4e0b\u7684\u4eba\u5458\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> employeeTreeById(String orgId) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.sysEmployeeService.getEmployeeTreeById(orgId)));
    }

    @ApiOperation(value="\u4eba\u5458\u6570\u636e\u5bfc\u51fa", notes="\u4eba\u5458\u6570\u636e\u5bfc\u51fa")
    @ApiImplicitParam(name="ids", value="\u5bfc\u51fa\u4eba\u5458id\u5b57\u7b26\u4e32", required=true, paramType="form")
    @PostMapping(value={"/exportData"})
    @CheckPermission(value={"employeeFront:exportData"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u6570\u636e\u5bfc\u51fa", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public void exportData(@RequestBody String ids, HttpServletResponse response) {
        if (ToolUtil.isEmpty((Object)ids)) {
            throw new BaseException("\u5bfc\u51fa\u4eba\u5458id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        this.sysEmployeeService.exportDataVue(idList, response);
    }

    @ApiOperation(value="\u4eba\u5458\u6570\u636e\u5bfc\u5165", notes="\u4eba\u5458\u6570\u636e\u5bfc\u5165")
    @ApiImplicitParam(name="file", value="\u4eba\u5458\u5bfc\u5165\u6587\u4ef6", required=true, paramType="form")
    @PostMapping(path={"/importData"})
    @CheckPermission(value={"employeeFront:importData"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4eba\u5458\u6570\u636e\u5bfc\u5165", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.FILE)
    public ApiResponse<Object> importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return ApiResponse.success((Object)this.sysEmployeeService.importVueStaff(content));
    }

    @ApiOperation(value="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d", notes="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="organIds", value="\u517c\u804c\u5c97\u4f4did", required=true, paramType="form"), @ApiImplicitParam(name="sysStruId", value="\u4eba\u5458\u7ec4\u7ec7id", required=true, paramType="form")})
    @PostMapping(path={"/saveOrgan"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u4fdd\u5b58\u517c\u804c\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Tip> saveOrgan(String organIds, Long sysStruId) {
        this.iSysStruAssistOrganService.saveAssistOrgan(organIds, sysStruId);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811", notes="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811")
    @ApiImplicitParam(name="organTreeDto", value="\u7ec4\u7ec7\u6811dto", required=true, paramType="query")
    @GetMapping(path={"/initOrgTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u517c\u4efb\u5c97\u4f4d\u9009\u62e9\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<?> getOrgTree(OrganTreeDto organTreeDto) {
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysStruAssistOrganService.getOrgTree(organTreeDto)));
    }

    @ApiOperation(value="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811", notes="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811")
    @ApiImplicitParam(name="assistOrganIds", value="\u517c\u4efb\u5c97\u4f4dids", required=true, paramType="query")
    @GetMapping(value={"/getAssistOrganTree"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u52a0\u8f7d\u517c\u5bb9\u5c97\u4f4d\u8be6\u60c5\u7684\u89d2\u8272\u6811", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<JSTreeModel>> getAssistOrganTree(String assistOrganIds, OrganTreeDto organTreeDto) {
        String[] ids = assistOrganIds == null ? "".split(",") : assistOrganIds.split(",");
        return ApiResponse.success((Object)ForestNodeMerger.merge((List)this.iSysStruAssistOrganService.getAssistOrganTree(ids, organTreeDto)));
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d", notes="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d")
    @ApiImplicitParam(name="struId", value="\u4eba\u5458\u7ec4\u7ec7id", required=true, paramType="query")
    @GetMapping(value={"/getAssistOrgan"})
    @AuditLog(moduleName="\u7ec4\u7ec7\u673a\u6784\u4eba\u5458\u7ba1\u7406", eventDesc="\u83b7\u53d6\u4eba\u5458\u7684\u5173\u8054\u5c97\u4f4d", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<SysStruAssistOrgan>> assistOrgan(String struId) {
        return ApiResponse.success((Object)this.iSysStruAssistOrganService.getAssistOrgan(struId));
    }
}

