/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authorization.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.dto.MenuOrderDto;
import com.jxdinfo.hussar.authorization.menu.dto.MenuTreeChangeDto;
import com.jxdinfo.hussar.authorization.menu.model.MenuInfo;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageService;
import com.jxdinfo.hussar.authorization.menu.vo.SysMenuVo;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.util.PermitMenuConstants;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.http.HttpCode;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.util.DataExportUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysMenuManageServiceImpl
extends HussarServiceImpl<SysMenuMapper, SysMenu>
implements ISysMenuManageService {
    @Value(value="${hussar-bpm.url:}")
    String url;
    @Resource
    SysMenuMapper sysMenuMapper;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysResourcesService iSysResourcesService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Value(value="${spring.profiles.active}")
    private String profiles;

    public List<MenuInfo> queryUserMenu(String type) {
        if (ToolUtil.isEmpty((Object)type)) {
            type = "";
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        List roleIdList = ConstantFactory.me().getRolesIdByShiroUser(shiroUser);
        if (shiroUser == null) {
            throw new BaseException(ResultCode.UN_AUTHORIZED.getMessage());
        }
        List<Object> menus = roleIdList != null && roleIdList.size() > 0 ? (this.hussarBaseProperties.isTenantOpen() ? this.getTenantMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, shiroUser.getConnName(), type) : this.getMenuByRoles(shiroUser.getId(), roleIdList, this.profiles, type)) : new ArrayList();
        if (!this.hussarBaseProperties.isTenantOpen()) {
            for (String menuId : PermitMenuConstants.TENANT_DISABLE_NOT_DISPLAY) {
                this.removeMenus(menus, menuId);
            }
        }
        String menuStr = JSONObject.toJSONString(menus);
        List result = JSONObject.parseArray((String)menuStr, MenuInfo.class);
        if ("0".equals(type)) {
            this.updateComponentByType(result, "/pages/console");
        } else if ("1".equals(type)) {
            this.updateComponentByType(result, "/pages/index");
        }
        return result;
    }

    public List<JSTreeModel> getAllUserMenuTree(List<String> menuId) {
        return this.sysMenuMapper.getAllUserMenuTree(menuId);
    }

    public List<JSTreeModel> getUserMenuTree(List<String> resourceIdList) {
        return this.sysMenuMapper.getUserMenuTree(resourceIdList);
    }

    public List<JSTreeModel> getMenuTree() {
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.getMenuTree();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.MENU_NODE_ID);
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    public List<JSTreeModel> getMenuStruTree() {
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.getMenuStruTree();
        JSTreeModel root = new JSTreeModel();
        root.setId(Constants.MENU_NODE_ID);
        root.setText("\u83dc\u5355\u5217\u8868");
        root.setParent(Constants.ROOT_NODE_PARENT);
        root.setIsLeaf("0");
        root.setType("isRoot");
        jsTreeModelList.add(root);
        return jsTreeModelList;
    }

    public List<JSTreeModel> getShortCutMenuTree() {
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.getShortCutMenuTree();
        jsTreeModelList.forEach(o -> {
            if (ToolUtil.isEmpty((Object)o.getPath())) {
                o.setPath("noURL");
            }
        });
        return jsTreeModelList;
    }

    public ApiResponse saveMenu(SysMenu sysMenu) {
        if (ToolUtil.isEmpty((Object)sysMenu)) {
            throw new BaseException("\u83dc\u5355\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"inside".equals(sysMenu.getOpenType())) {
            sysMenu.setOpenMode("1");
        } else {
            sysMenu.setOpenMode("0");
        }
        this.setPathFromResource(sysMenu);
        Long max = this.sysMenuMapper.getMaxOrderByParentId(sysMenu.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            BigDecimal order = BigDecimal.valueOf(max);
            sysMenu.setSeq(order.add(num));
        } else {
            sysMenu.setSeq(new BigDecimal(1));
        }
        sysMenu.setMenuType("1");
        if (!this.save(sysMenu)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f\uff01");
    }

    public ApiResponse updateMenu(SysMenu sysMenu) {
        if (ToolUtil.isEmpty((Object)sysMenu)) {
            throw new BaseException("\u83dc\u5355\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)sysMenu.getId())) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"inside".equals(sysMenu.getOpenType())) {
            sysMenu.setOpenMode("1");
        } else {
            sysMenu.setOpenMode("0");
        }
        this.setPathFromResource(sysMenu);
        if (!this.updateById(sysMenu)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    private void setPathFromResource(SysMenu sysMenu) {
        SysResources resources;
        if (ToolUtil.isEmpty((Object)sysMenu.getFunctionId())) {
            return;
        }
        SysFunctions functions = (SysFunctions)this.iSysFunctionsService.getById((Serializable)sysMenu.getFunctionId());
        if (ToolUtil.isNotEmpty((Object)functions) && ToolUtil.isNotEmpty((Object)(resources = (SysResources)this.iSysResourcesService.getById((Serializable)functions.getDefaultResourceId()))) && ToolUtil.isNotEmpty((Object)resources.getPath())) {
            sysMenu.setPath(resources.getPath());
        }
    }

    public ApiResponse deleteMenus(String menuIds) {
        if (ToolUtil.isEmpty((Object)menuIds)) {
            throw new BaseException("\u8981\u5220\u9664\u7684\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> idList = this.getAllChildMenuIds(new ArrayList<String>(Arrays.asList(menuIds.split(","))));
        if (!this.removeByIds(idList)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    private List<String> getAllChildMenuIds(List<String> menuIds) {
        if (menuIds.size() > 0) {
            this.getChildMenuIds(menuIds, menuIds);
        }
        return menuIds;
    }

    private void getChildMenuIds(List<String> menuIds, List<String> parentIds) {
        List childMenuList = this.sysMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysMenu::getParentId, parentIds));
        ArrayList<String> childIds = new ArrayList<String>();
        if (childMenuList.size() > 0) {
            childMenuList.forEach(child -> childIds.add(String.valueOf(child.getId())));
        }
        if (childIds.size() > 0) {
            menuIds.addAll(childIds);
            this.getChildMenuIds(menuIds, childIds);
        }
    }

    public SysMenuVo getMenuInfo(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.sysMenuMapper.getMenuInfo(menuId);
    }

    public JSONObject delMenuById(String menuId) {
        List<Map<String, Object>> menuResult = this.sysMenuMapper.getMenuByParentId(menuId);
        boolean isDel = true;
        if (ToolUtil.isNotEmpty(menuResult)) {
            isDel = false;
        }
        if (isDel) {
            this.sysMenuMapper.deleteById((Serializable)((Object)menuId));
        }
        JSONObject json = new JSONObject();
        json.put("success", (Object)isDel);
        return json;
    }

    public List<JSTreeModel> menuTreeById(String menuId, boolean isRoot) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.isEmpty((Object)isRoot)) {
            throw new BaseException("\u9700\u8981\u6307\u5b9a\u662f\u5426\u4e3a\u6839\u8282\u70b9");
        }
        List<JSTreeModel> jsTreeModelList = this.sysMenuMapper.menuTreeById(menuId);
        if (isRoot) {
            JSTreeModel root = new JSTreeModel();
            root.setId(Constants.MENU_NODE_ID);
            root.setText("\u83dc\u5355\u5217\u8868");
            root.setParent(Constants.ROOT_NODE_PARENT);
            root.setIsLeaf("0");
            root.setType("isRoot");
            jsTreeModelList.add(root);
        }
        return jsTreeModelList;
    }

    @Cacheable(value={"menu_info"}, key="'hussar_menus:'+#userId", condition="!'dev'.equals(#profiles)")
    public List<MenuInfo> getMenuByRoles(Long userId, List<Long> list, String profiles, String type) {
        Object path;
        String component;
        int i;
        List<MenuInfo> totalResult = this.sysMenuMapper.getAllMenu();
        List<MenuInfo> lastResult = this.sysMenuMapper.getLastMenuByRoles(list);
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent_sr();
            path = lastResult.get(i).getPath_sr();
            lastResult.get(i).setPath((String)path);
            lastResult.get(i).setComponent(component);
            if (!ToolUtil.isEmpty((Object)path)) continue;
            lastResult.remove(i);
            --i;
        }
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent();
            if (!"0".equals(type) || !ToolUtil.isNotEmpty((Object)component) || !component.contains("@/pages/index")) continue;
            lastResult.remove(i);
            --i;
        }
        for (int i2 = 0; i2 < lastResult.size(); ++i2) {
            if (!lastResult.get(i2).getPath().contains("/static/bpm/index.html")) continue;
            path = lastResult.get(i2).getPath();
            MenuInfo menuInfo1 = lastResult.get(i2);
            lastResult.remove(i2);
            String string = this.url + (String)path;
            menuInfo1.setPath(string);
            lastResult.add(i2, menuInfo1);
            break;
        }
        HashSet<MenuInfo> resultSet = new HashSet<MenuInfo>();
        for (MenuInfo menuInfo2 : lastResult) {
            this.getOwnMenus(menuInfo2, totalResult, resultSet);
        }
        ArrayList<MenuInfo> result = new ArrayList<MenuInfo>(resultSet);
        result.addAll(lastResult);
        for (MenuInfo menu : result) {
            List l = result.stream().filter(menuInfo -> menuInfo.getParentId().equals(menu.getMenuId())).collect(Collectors.toList());
            l.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
            menu.setChildMenus(l);
        }
        List<MenuInfo> list2 = result.stream().filter(menuInfo -> "1".equals(menuInfo.getParentId())).collect(Collectors.toList());
        list2.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
        return list2;
    }

    @Cacheable(value={"menu_info"}, key="'hussar_menus:'+#userId + #connName", condition="!'dev'.equals(#profiles)")
    public List<MenuInfo> getTenantMenuByRoles(Long userId, List<Long> list, String profiles, String connName, String type) {
        Object path;
        String component;
        int i;
        List<MenuInfo> totalResult = this.sysMenuMapper.getAllMenu();
        List<MenuInfo> lastResult = this.sysMenuMapper.getLastMenuByRoles(list);
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent_sr();
            path = lastResult.get(i).getPath_sr();
            lastResult.get(i).setPath((String)path);
            lastResult.get(i).setComponent(component);
            if (!ToolUtil.isEmpty((Object)path)) continue;
            lastResult.remove(i);
            --i;
        }
        for (i = 0; i < lastResult.size(); ++i) {
            component = lastResult.get(i).getComponent_sr();
            path = lastResult.get(i).getPath_sr();
            lastResult.get(i).setPath((String)path);
            lastResult.get(i).setComponent(component);
            if (!ToolUtil.isEmpty((Object)path)) continue;
            lastResult.remove(i);
            --i;
        }
        for (int i2 = 0; i2 < lastResult.size(); ++i2) {
            if (!lastResult.get(i2).getPath().contains("/static/bpm/index.html")) continue;
            path = lastResult.get(i2).getPath();
            MenuInfo menuInfo1 = lastResult.get(i2);
            lastResult.remove(i2);
            String string = this.url + (String)path;
            menuInfo1.setPath(string);
            lastResult.add(i2, menuInfo1);
            break;
        }
        HashSet<MenuInfo> resultSet = new HashSet<MenuInfo>();
        for (MenuInfo menuInfo2 : lastResult) {
            this.getOwnMenus(menuInfo2, totalResult, resultSet);
        }
        ArrayList<MenuInfo> result = new ArrayList<MenuInfo>(resultSet);
        result.addAll(lastResult);
        for (MenuInfo menu : result) {
            List l = result.stream().filter(menuInfo -> menuInfo.getParentId().equals(menu.getMenuId())).collect(Collectors.toList());
            l.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
            menu.setChildMenus(l);
        }
        List<MenuInfo> list2 = result.stream().filter(menuInfo -> "1".equals(menuInfo.getParentId())).collect(Collectors.toList());
        list2.sort((m1, m2) -> m1.getSeq().compareTo(m2.getSeq()));
        return list2;
    }

    public void getOwnMenus(MenuInfo menuInfo, List<MenuInfo> total, Set<MenuInfo> result) {
        for (MenuInfo menu : total) {
            if (!menuInfo.getParentId().equals(menu.getMenuId())) continue;
            result.add(menu);
            if ("1".equals(menu.getMenuId())) break;
            this.getOwnMenus(menu, total, result);
            break;
        }
    }

    public ApiResponse updateMenuTree(MenuTreeChangeDto menuTreeChangeDto) {
        boolean flag;
        BigDecimal order = new BigDecimal(1);
        Long max = this.sysMenuMapper.getMaxOrderByParentId(menuTreeChangeDto.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            order = BigDecimal.valueOf(max);
            order = order.add(num);
        }
        if (!(flag = this.sysMenuMapper.menuTreeChange(menuTreeChangeDto.getMenuId(), menuTreeChangeDto.getParentId(), order))) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @DSTransactional
    public ApiResponse updateMoveNode(MenuOrderDto menuOrderDto) {
        SysMenu thatMenu;
        Long menuId = menuOrderDto.getMenuId();
        boolean isUp = menuOrderDto.getIsUp();
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysMenuVo thisMenu = this.sysMenuMapper.getMenuInfo(menuId);
        List<SysMenu> thatMenuList = isUp ? this.sysMenuMapper.seletListLt(thisMenu.getParentId(), thisMenu.getSeq()) : this.sysMenuMapper.seletListGt(thisMenu.getParentId(), thisMenu.getSeq());
        if (thatMenuList.size() > 0 && (thatMenu = thatMenuList.get(0)) != null) {
            BigDecimal temp = thisMenu.getSeq();
            thisMenu.setSeq(thatMenu.getSeq());
            thatMenu.setSeq(temp);
            this.updateById(thisMenu);
            this.updateById(thatMenu);
        }
        return ApiResponse.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    public SysMenu getMenuById(String menuId) {
        return (SysMenu)this.sysMenuMapper.selectById((Serializable)((Object)menuId));
    }

    public void exportMenu(String menuIds, HttpServletResponse response) {
        if (menuIds == null) {
            throw new BaseException("\u5bfc\u51fa\u7684\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> menuIdList = Arrays.asList(menuIds.split(","));
        List menu = this.sysMenuMapper.selectBatchIds(menuIdList);
        ArrayList<Long> functionIds = new ArrayList<Long>();
        ArrayList<Long> functionModuleIds = new ArrayList<Long>();
        for (Object sysMenu : menu) {
            if (ToolUtil.isNotEmpty((Object)sysMenu.getFunctionId())) {
                functionIds.add(sysMenu.getFunctionId());
            }
            if (!ToolUtil.isNotEmpty((Object)sysMenu.getFunctionModuleId())) continue;
            functionModuleIds.add(sysMenu.getFunctionModuleId());
        }
        List functionsList = new ArrayList();
        if (ToolUtil.isNotEmpty(functionIds)) {
            functionsList = this.iSysFunctionsService.list((Wrapper)new LambdaQueryWrapper().in(SysFunctions::getId, functionIds));
            for (SysFunctions functions : functionsList) {
                if (!ToolUtil.isNotEmpty((Object)functions.getFunctionModuleId())) continue;
                functionModuleIds.add(functions.getFunctionModuleId());
            }
        }
        List<Object> functionModulesList = new ArrayList();
        if (ToolUtil.isNotEmpty(functionModuleIds)) {
            functionModulesList = this.getExportFunctionModules(functionModuleIds);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("menu", menu);
        data.put("function", functionsList);
        data.put("functionModule", functionModulesList);
        data.put("export_type", "menu");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "menu_" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile((byte[])serializeData, (String)fileName, (HttpServletResponse)response);
    }

    private List<SysFunctionModules> getExportFunctionModules(List<Long> functionModuleIds) {
        List<Object> functionModulesList = new ArrayList<SysFunctionModules>();
        if (ToolUtil.isNotEmpty(functionModuleIds)) {
            functionModulesList = this.iSysFunctionModulesService.list((Wrapper)new LambdaQueryWrapper().in(SysFunctionModules::getId, functionModuleIds));
        }
        if (functionModulesList.size() > 0) {
            ArrayList<Long> parentIdList = new ArrayList<Long>();
            for (SysFunctionModules sysFunctionModules : functionModulesList) {
                if (!ToolUtil.isNotEmpty((Object)sysFunctionModules.getParentModuleId())) continue;
                parentIdList.add(sysFunctionModules.getParentModuleId());
            }
            List<SysFunctionModules> parentList = this.getExportFunctionModules(parentIdList);
            if (parentList.size() > 0) {
                functionModulesList.addAll(parentList);
            }
        }
        return functionModulesList;
    }

    @DSTransactional
    public ApiResponse importMenu(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize((byte[])content);
        String export_type = (String)data.get("export_type");
        if (!"menu".equals(export_type)) {
            return ApiResponse.fail((int)HttpCode.INTERNAL_SERVER_ERROR.value(), (String)("\u60a8\u5bfc\u5165\u7684\u662f" + (String)Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + (String)Constants.EXPORT_MAP.get("menu")));
        }
        List menu = (List)data.get("menu");
        Map<String, Integer> count = this.insertOrUpdateList(menu, new ArrayList<SysFunctions>(), new ArrayList<SysFunctionModules>());
        return ApiResponse.success((String)("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002"));
    }

    @DSTransactional
    public JSONObject importMenuData(byte[] content) {
        Map data;
        JSONObject result = new JSONObject();
        try {
            data = (Map)SerializeUtils.deserialize((byte[])content);
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        if (ToolUtil.isEmpty((Object)data)) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e");
        }
        String export_type = (String)data.get("export_type");
        if (!"menu".equals(export_type)) {
            result.put("success", (Object)"false");
            result.put("importType", (Object)export_type);
            result.put("trueType", (Object)"menu");
            return result;
        }
        List menu = (List)data.get("menu");
        List functionsList = (List)data.get("function");
        List functionModulesList = (List)data.get("functionModule");
        Map<String, Integer> count = this.insertOrUpdateList(menu, functionsList, functionModulesList);
        result.put("success", (Object)"true");
        result.put("menuUpdate", (Object)count.get("menuUpdate"));
        result.put("menuInsert", (Object)count.get("menuInsert"));
        result.put("functionUpdate", (Object)count.get("functionUpdate"));
        result.put("functionInsert", (Object)count.get("functionInsert"));
        result.put("moduleUpdate", (Object)count.get("moduleUpdate"));
        result.put("moduleInsert", (Object)count.get("moduleInsert"));
        return result;
    }

    public Map<String, Integer> insertOrUpdateList(List<SysMenu> menuList, List<SysFunctions> functionsList, List<SysFunctionModules> functionModulesList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer menuUpdate = 0;
        Integer menuInsert = 0;
        Integer functionUpdate = 0;
        Integer functionInsert = 0;
        Integer moduleUpdate = 0;
        Integer moduleInsert = 0;
        if (CollectionUtils.isEmpty(menuList)) {
            throw new IllegalArgumentException("Error: entityList must not be empty");
        }
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            Integer n;
            Integer n2;
            int size = menuList.size();
            for (int i = 0; i < size; ++i) {
                Integer n3;
                if (super.updateById((Object)menuList.get(i))) {
                    n3 = menuUpdate;
                    n2 = menuUpdate = Integer.valueOf(menuUpdate + 1);
                } else {
                    super.save((Object)menuList.get(i));
                    n3 = menuInsert;
                    n2 = menuInsert = Integer.valueOf(menuInsert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            int functionSize = functionsList.size();
            for (int i = 0; i < functionSize; ++i) {
                if (this.iSysFunctionsService.updateById((Object)functionsList.get(i))) {
                    n2 = functionUpdate;
                    n = functionUpdate = Integer.valueOf(functionUpdate + 1);
                } else {
                    this.iSysFunctionsService.save((Object)functionsList.get(i));
                    n2 = functionInsert;
                    n = functionInsert = Integer.valueOf(functionInsert + 1);
                }
                if (i < 1 || i % functionSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            int functionModuleSize = functionModulesList.size();
            for (int i = 0; i < functionModuleSize; ++i) {
                Integer n4;
                if (this.iSysFunctionModulesService.updateById((Object)functionModulesList.get(i))) {
                    n = moduleUpdate;
                    n4 = moduleUpdate = Integer.valueOf(moduleUpdate + 1);
                } else {
                    this.iSysFunctionModulesService.save((Object)functionModulesList.get(i));
                    n = moduleInsert;
                    n4 = moduleInsert = Integer.valueOf(moduleInsert + 1);
                }
                if (i < 1 || i % functionModuleSize != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("menuUpdate", menuUpdate);
        result.put("menuInsert", menuInsert);
        result.put("functionUpdate", functionUpdate);
        result.put("functionInsert", functionInsert);
        result.put("moduleUpdate", moduleUpdate);
        result.put("moduleInsert", moduleInsert);
        return result;
    }

    public IPage<SysMenu> queryMenuInfoList(Page<SysMenu> page, Long parentNodeId) {
        if (ToolUtil.isEmpty(page) || ToolUtil.isEmpty((Object)parentNodeId)) {
            throw new BaseException("\u5206\u9875\u4fe1\u606f\u6216\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ToolUtil.equals((Object)Constants.ROOT_NODE_PARENT, (Object)parentNodeId)) {
            parentNodeId = Constants.MENU_NODE_ID;
        }
        return this.page((IPage)page, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getParentId, (Object)parentNodeId)).orderByAsc(SysMenu::getSeq));
    }

    public ApiResponse deleteCascadeMenuId(Long menuId) {
        List<Long> idList = this.findCascadeMenuId(menuId);
        if (!this.removeByIds(idList)) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public List<Long> findCascadeMenuId(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            throw new BaseException("\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashSet deleteMenuIds = Sets.newHashSet((Object[])new Long[]{menuId});
        List<JSTreeModel> menuList = this.getMenuTree();
        this.getCascadeSubMenuIds(menuId, menuList, deleteMenuIds);
        return new ArrayList<Long>(deleteMenuIds);
    }

    @DSTransactional
    public ApiResponse updateMenuOrder(List<SysMenu> sysMenus) {
        if (ToolUtil.isEmpty(sysMenus)) {
            throw new BaseException("\u6392\u5e8f\u83dc\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (int i = 0; i < sysMenus.size(); ++i) {
            SysMenu sm = sysMenus.get(i);
            String order = i + 1 + "";
            sm.setSeq(new BigDecimal(order));
        }
        if (!this.updateBatchById(sysMenus, sysMenus.size())) {
            throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    private void getCascadeSubMenuIds(Long parentNodeId, List<JSTreeModel> struMenuList, Set<Long> parentMenuIds) {
        for (JSTreeModel subMenu : struMenuList) {
            if (!parentNodeId.equals(subMenu.getParent())) continue;
            parentMenuIds.add(subMenu.getId());
            if (!CollectionUtils.isNotEmpty((Collection)subMenu.getChildrenList())) continue;
            this.getCascadeSubMenuIds(subMenu.getId(), subMenu.getChildrenList(), parentMenuIds);
        }
    }

    private void removeMenus(List<MenuInfo> menus, String menuId) {
        for (MenuInfo menuInfo : menus) {
            if (menuId.equals(menuInfo.getMenuId())) {
                menus.remove(menuInfo);
                break;
            }
            List childList = menuInfo.getChildMenus();
            if (!ToolUtil.isNotEmpty((Object)childList)) continue;
            this.removeMenus(menuInfo.getChildMenus(), menuId);
        }
    }

    private void updateComponentByType(List<MenuInfo> menus, String extra) {
        for (MenuInfo menuInfo : menus) {
            List childList;
            String component = menuInfo.getComponent();
            if (ToolUtil.isNotEmpty((Object)component) && !component.contains(extra)) {
                int index = component.indexOf("@");
                String pre = component.substring(0, index + 1);
                String suf = component.substring(index + 1);
                String newComponent = pre + extra + suf;
                menuInfo.setComponent(newComponent);
            }
            if (!ToolUtil.isNotEmpty((Object)(childList = menuInfo.getChildMenus()))) continue;
            this.updateComponentByType(menuInfo.getChildMenus(), extra);
        }
    }
}

