/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.menu.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.authorization.appmenuresource.dao.SysAppMenuResourceMapper;
import com.jxdinfo.hussar.authorization.appmenuresource.model.SysAppMenuResource;
import com.jxdinfo.hussar.authorization.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourceModulesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.authorization.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResManageService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.speedcode.MenuNode;
import com.jxdinfo.hussar.speedcode.MenuService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysCreateVueMenuServiceImpl
implements MenuService {
    private static Logger logger = LoggerFactory.getLogger(SysCreateVueMenuServiceImpl.class);
    private final ISysResManageService sysResManageService;
    @Autowired(required=false)
    private final ISysIdtableService sysIdtableService;
    private final SysUserRoleMapper sysUserRoleMapper;
    private final SysResourceModulesMapper sysResourceModulesMapper;
    private final ISysResourceMosulesService sysResourceMosulesService;
    private final ISysRoleResourceService sysRoleResourceService;
    private final ISysRoleFunctionsService sysRoleFunctionsService;
    private final SysResourcesMapper sysResourcesMapper;
    private final SysMenuMapper sysMenuMapper;
    private final SysAppMenuResourceMapper sysAppMenuResourceMapper;
    private final ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysFunctionsService iSysFunctionsService;
    @Resource
    private ISysFunctionModulesService iSysFunctionModulesService;
    private static final Long OPERATOR = 1L;
    private String RES_BTN = "res_btn";
    private String RES_MENU = "res_menu";
    private String APP_RELATION_MENU_TYPE = "1";
    private String APP_RELATION_RESOURCE_TYPE = "2";
    private String[][] res = new String[][]{{"view", "add", "delete", "update", "list", "detail"}, {"", "\u589e\u52a0", "\u5220\u9664", "\u4fee\u6539", "\u67e5\u8be2", "\u8be6\u60c5"}, {this.RES_MENU, this.RES_BTN, this.RES_BTN, this.RES_BTN, this.RES_BTN, this.RES_BTN}};
    @Value(value="${hussar-formdesign.menu-role:\u8d85\u7ea7\u7ba1\u7406\u5458}")
    private String menuRole;
    @Value(value="${hussar-formdesign.menu-role-group:}")
    private String menuRoleGroup;

    @Autowired
    public SysCreateVueMenuServiceImpl(ISysResManageService sysResManageService, ISysIdtableService sysIdtableService, SysUserRoleMapper sysUserRoleMapper, SysResourceModulesMapper sysResourceModulesMapper, ISysResourceMosulesService sysResourceMosulesService, ISysRoleResourceService sysRoleResourceService, SysResourcesMapper sysResourcesMapper, SysMenuMapper sysMenuMapper, SysAppMenuResourceMapper sysAppMenuResourceMapper, ISysFunctionResourcesService sysFunctionResourcesService, ISysRoleFunctionsService sysRoleFunctionsService) {
        this.sysResManageService = sysResManageService;
        this.sysIdtableService = sysIdtableService;
        this.sysUserRoleMapper = sysUserRoleMapper;
        this.sysResourceModulesMapper = sysResourceModulesMapper;
        this.sysResourceMosulesService = sysResourceMosulesService;
        this.sysRoleResourceService = sysRoleResourceService;
        this.sysResourcesMapper = sysResourcesMapper;
        this.sysMenuMapper = sysMenuMapper;
        this.sysAppMenuResourceMapper = sysAppMenuResourceMapper;
        this.sysFunctionResourcesService = sysFunctionResourcesService;
        this.sysRoleFunctionsService = sysRoleFunctionsService;
    }

    public void createVueMenuRes(MenuNode menuNode, String pageId, String appName) {
        this.createVueMenu(appName, pageId, menuNode, "@/rootPath", "", true, null, null);
    }

    private void createVueMenu(String appName, String pageId, MenuNode menuNode, String parentComponent, String parentPath, boolean isFirst, Long menuParentId, Long parentFunctionId) {
        String menuName = menuNode.cnName;
        String menuId = menuNode.enName;
        String currentComponent = parentComponent;
        if (menuParentId == null) {
            menuParentId = 1L;
            currentComponent = currentComponent.replace("rootPath", "pages/index");
            currentComponent = ToolUtil.isEmpty((Object)appName) ? currentComponent + "/views/" + menuId : currentComponent + "/" + menuId + "/views";
        } else {
            currentComponent = currentComponent + "/" + menuId;
        }
        String currentPath = parentPath + "/" + menuId;
        if (isFirst) {
            if (ToolUtil.isNotEmpty((Object)menuNode.child)) {
                SysMenu parentMenu = this.createMenuModule(appName, pageId, menuName, currentPath, currentComponent, menuParentId, 1L, false);
                if (parentMenu == null) {
                    return;
                }
                this.createVueMenu(appName, pageId, menuNode.child, currentComponent, currentPath, false, parentMenu.getId(), parentMenu.getFunctionModuleId());
            } else {
                this.createMenuModule(appName, pageId, menuName, currentPath, currentComponent, menuParentId, 1L, true);
            }
        } else if (ToolUtil.isNotEmpty((Object)menuNode.child)) {
            SysMenu parentMenu = this.createMenuModule(appName, pageId, menuName, currentPath, currentComponent, menuParentId, parentFunctionId, false);
            if (parentMenu == null) {
                return;
            }
            this.createVueMenu(appName, pageId, menuNode.child, currentComponent, currentPath, false, parentMenu.getId(), parentMenu.getFunctionModuleId());
        } else {
            this.createMenuModule(appName, pageId, menuName, currentPath, currentComponent, menuParentId, parentFunctionId, true);
        }
    }

    private SysMenu createMenuModule(String appName, String pageId, String menuName, String currentPath, String currentComponent, Long parentMenuId, Long parentFunctionId, boolean isLeaf) {
        List sysMenuList = this.sysMenuMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getText, (Object)menuName)).eq(SysMenu::getParentId, (Object)parentMenuId));
        if (sysMenuList.size() != 0) {
            return (SysMenu)sysMenuList.get(0);
        }
        SysMenu newMenu = new SysMenu();
        newMenu.setCreator(OPERATOR);
        newMenu.setLastEditor(OPERATOR);
        newMenu.setOpenMode("0");
        newMenu.setText(menuName);
        newMenu.setMenuAlias(menuName);
        newMenu.setMenuType("2");
        newMenu.setParentId(Long.valueOf(1L));
        newMenu.setIsLeaf(isLeaf ? "1" : "0");
        newMenu.setIcons("");
        newMenu.setOpenType(isLeaf ? "inside" : "");
        newMenu.setParentId(parentMenuId);
        newMenu.setPath(currentPath);
        newMenu.setComponent(currentComponent);
        Long max = this.sysMenuMapper.getMaxOrderByParentId(newMenu.getParentId());
        if (ToolUtil.isNotEmpty((Object)max)) {
            BigDecimal num = new BigDecimal(1);
            BigDecimal order = BigDecimal.valueOf(max);
            newMenu.setSeq(order.add(num));
        } else {
            newMenu.setSeq(new BigDecimal(1));
        }
        if (isLeaf) {
            SysFunctions sysFunction = new SysFunctions();
            String functionCode = this.sysIdtableService.getCurrentCode("FUNCTION_CODE", "SYS_FUNCTIONS");
            sysFunction.setFunctionModuleId(parentFunctionId);
            sysFunction.setFunctionCode(functionCode);
            sysFunction.setFunctionName(menuName);
            sysFunction.setSeq(newMenu.getSeq());
            this.iSysFunctionsService.save((Object)sysFunction);
            newMenu.setFunctionId(sysFunction.getId());
            this.associationRoleFunction(sysFunction);
        } else {
            String moduleCode = this.sysIdtableService.getCurrentCode("FUNCTION_MODULE_CODE", "SYS_FUNCTION_MODULES");
            SysFunctionModules sysFunctionModule = new SysFunctionModules();
            sysFunctionModule.setParentModuleId(newMenu.getParentId());
            sysFunctionModule.setFunctionModuleName(newMenu.getText());
            sysFunctionModule.setFunctionModuleCode(moduleCode);
            sysFunctionModule.setSeq(newMenu.getSeq());
            sysFunctionModule.setCreator(BaseSecurityUtil.getUser().getId());
            sysFunctionModule.setLastEditor(BaseSecurityUtil.getUser().getId());
            this.iSysFunctionModulesService.save((Object)sysFunctionModule);
            newMenu.setFunctionModuleId(sysFunctionModule.getId());
            newMenu.setId(sysFunctionModule.getId());
        }
        this.sysMenuMapper.insert(newMenu);
        SysAppMenuResource sysAppMenuResource = new SysAppMenuResource();
        sysAppMenuResource.setAppName(appName);
        sysAppMenuResource.setPageId(isLeaf ? pageId : "");
        sysAppMenuResource.setId(newMenu.getId());
        sysAppMenuResource.setRelationRefId(newMenu.getFunctionId());
        sysAppMenuResource.setRelationType(Long.valueOf(this.APP_RELATION_MENU_TYPE));
        sysAppMenuResource.setCreator(OPERATOR);
        this.sysAppMenuResourceMapper.insert(sysAppMenuResource);
        if (isLeaf) {
            List resourcesList;
            List appResourceList = this.sysAppMenuResourceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppMenuResource::getPageId, (Object)pageId)).eq(SysAppMenuResource::getRelationType, (Object)this.APP_RELATION_RESOURCE_TYPE));
            ArrayList resourceIdList = new ArrayList();
            appResourceList.parallelStream().forEach(ar -> resourceIdList.add(ar.getId()));
            if (!CollectionUtils.isEmpty(resourceIdList) && ToolUtil.isNotEmpty((Object)(resourcesList = this.sysResourcesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysResources::getId, resourceIdList))))) {
                for (SysResources resources : resourcesList) {
                    if (ToolUtil.isEmpty((Object)this.sysFunctionResourcesService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)newMenu.getFunctionId())).eq(SysFunctionResources::getResourceId, (Object)resources.getId())))) {
                        SysFunctionResources sysFunctionResources = new SysFunctionResources();
                        sysFunctionResources.setFunctionId(newMenu.getFunctionId());
                        sysFunctionResources.setResourceId(resources.getId());
                        sysFunctionResources.setCreator(OPERATOR);
                        sysFunctionResources.setLastEditor(OPERATOR);
                        this.sysFunctionResourcesService.save((Object)sysFunctionResources);
                    }
                    if (!this.RES_MENU.equals(resources.getResTypeId())) continue;
                    this.iSysFunctionsService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysFunctions::getDefaultResourceId, (Object)resources.getId())).eq(SysFunctions::getId, (Object)newMenu.getFunctionId()));
                }
            }
        }
        return newMenu;
    }

    @Deprecated
    public void deleteVueMenuRes(MenuNode menuNode) {
    }

    @Deprecated
    public void showMenuRes(MenuNode menuNode) {
    }

    @Deprecated
    public void hideMenuRes(MenuNode menuNode) {
        this.hidden("", menuNode);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void hidden(String parentPath, MenuNode menuNode) {
        String path = parentPath + "/" + menuNode.enName;
        if (!ToolUtil.isEmpty((Object)menuNode.child)) {
            this.hidden(path, menuNode.child);
            return;
        }
        SysMenu sysMenu = (SysMenu)this.sysMenuMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysMenu::getPath, (Object)path)).eq(SysMenu::getIsLeaf, (Object)"1"));
        if (ToolUtil.isEmpty((Object)sysMenu)) {
            logger.error("\u5f53\u524d\u9875\u9762\u83dc\u5355\u5c1a\u672a\u914d\u7f6e\uff01");
            return;
        }
        Long functionId = sysMenu.getFunctionId();
        this.sysMenuMapper.deleteById(sysMenu);
        this.sysAppMenuResourceMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppMenuResource::getId, (Object)sysMenu.getId())).eq(SysAppMenuResource::getRelationRefId, (Object)functionId));
        if (ToolUtil.isNotEmpty((Object)functionId)) {
            this.iSysFunctionsService.removeById((Serializable)functionId);
            return;
        }
        logger.error("\u529f\u80fd\u5220\u9664\u5931\u8d25\uff01");
    }

    public void createVueMenuRes(MenuNode menuNode, Integer strategy, boolean keepAlive, String pageId, String webName) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String appId = request.getHeader("appId");
        String type = "0";
        StringBuilder parentComponentBuilder = new StringBuilder("@/rootPath");
        StringBuilder parentPathBuilder = new StringBuilder();
        if (ToolUtil.isEmpty((Object)webName)) {
            parentComponentBuilder.append("/views");
        }
        this.create(null, pageId, parentComponentBuilder.toString(), parentPathBuilder.toString(), menuNode, true, null, null, strategy, keepAlive, type);
    }

    private void create(String appName, String pageId, String parentComponent, String parentPath, MenuNode menuNode, boolean isFirst, String moduleId, String menuParentId, Integer strategy, boolean keepAlive, String type) {
        String id = menuNode.enName + "";
        String name = menuNode.cnName;
        String component = parentComponent + "/" + id;
        if (menuParentId == null && !(component = component.replace("rootPath", "pages/index")).contains("/views")) {
            component = component + "/views";
        }
        String path = parentPath + "/" + id;
        if (isFirst && ToolUtil.isEmpty((Object)menuNode.child)) {
            SysResourceModules resourceModules = this.createResourceModule(name, null, type);
            this.createResource(appName, pageId, name, id, resourceModules, component, path, strategy, keepAlive);
        } else if (isFirst && ToolUtil.isNotEmpty((Object)menuNode.child)) {
            SysResourceModules resourceModules = this.createResourceModule(name, null, type);
            if (ToolUtil.isNotEmpty((Object)resourceModules)) {
                this.create(appName, pageId, component, path, menuNode.child, false, String.valueOf(resourceModules.getId()), String.valueOf(resourceModules.getId()), strategy, keepAlive, type);
            }
        } else if (!isFirst && ToolUtil.isEmpty((Object)menuNode.child)) {
            SysResourceModules resourceModules = this.createResourceModule(name, moduleId, type);
            this.createResource(appName, pageId, name, id, resourceModules, component, path, strategy, keepAlive);
        } else {
            SysResourceModules resourceModules = this.createResourceModule(name, moduleId, type);
            if (ToolUtil.isNotEmpty((Object)resourceModules)) {
                this.create(appName, pageId, component, path, menuNode.child, false, String.valueOf(resourceModules.getId()), String.valueOf(resourceModules.getId()), strategy, keepAlive, type);
            }
        }
    }

    private SysResourceModules createResourceModule(String name, String moduleId, String type) {
        String fail;
        String parentModuleId = null;
        parentModuleId = ToolUtil.isEmpty((Object)moduleId) ? "1" : moduleId;
        SysResourceModules sysResourceModules = new SysResourceModules();
        List resModulesList = this.sysResourceModulesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResourceModules::getModuleName, (Object)name)).eq(SysResourceModules::getParentModuleId, (Object)parentModuleId));
        if (resModulesList.size() != 0) {
            sysResourceModules = (SysResourceModules)resModulesList.get(0);
            fail = "\u6a21\u5757\u66f4\u65b0\u5931\u8d25\uff01";
        } else {
            fail = "\u65b0\u589e\u6a21\u5757\u5931\u8d25\uff01";
            String resModuleCode = this.sysIdtableService.getCurrentCode("MODULE_CODE", "SYS_RESOURCE_MODULES");
            sysResourceModules.setModuleCode(resModuleCode);
            sysResourceModules.setParentModuleId(BaseSecurityUtil.formatToLong((Object)parentModuleId));
            sysResourceModules.setCreator(OPERATOR);
        }
        sysResourceModules.setCreator(OPERATOR);
        sysResourceModules.setModuleName(name);
        if (this.sysResourceMosulesService.saveOrUpdate((Object)sysResourceModules)) {
            return sysResourceModules;
        }
        logger.error(fail);
        return null;
    }

    private SysResources createResource(String appName, String pageId, String name, String id, SysResourceModules resourceModules, String component, String path, Integer strategy, boolean keepAlive) {
        if (ToolUtil.isEmpty((Object)resourceModules)) {
            return null;
        }
        SysResources returnResources = null;
        ArrayList successResoureIds = Lists.newArrayList();
        ArrayList<SysResources> successResources = new ArrayList<SysResources>();
        for (int i = 0; i < this.res[0].length; ++i) {
            boolean associationResult;
            SysResources getResources;
            String prefix;
            String resPath = path;
            String resComponent = component;
            if ("res_menu".equals(this.res[2][i])) {
                prefix = name;
            } else {
                prefix = "";
                resPath = "";
                resComponent = "";
            }
            SysResources sysResources = new SysResources();
            List resourcesList = new ArrayList();
            resourcesList = ToolUtil.isNotEmpty((Object)resPath) ? this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)resPath)).eq(SysResources::getModuleId, (Object)resourceModules.getId())) : this.sysResourcesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysResources::getUrlNames, (Object)("/" + id + "/" + this.res[0][i]))).eq(SysResources::getModuleId, (Object)resourceModules.getId()));
            if (resourcesList.size() != 0) {
                sysResources = (SysResources)resourcesList.get(0);
            } else {
                String currentCode = this.sysIdtableService.getCurrentCode("RESOURCE_CODE", "SYS_RESOURCES");
                sysResources.setResourceCode(resourceModules.getModuleCode() + currentCode);
                if (ToolUtil.isNotEmpty((Object)resPath)) {
                    sysResources.setUrlNames(resPath);
                } else {
                    sysResources.setUrlNames("/" + id + "/" + this.res[0][i]);
                }
                sysResources.setPermissions(id + ":" + this.res[0][i]);
                sysResources.setIsAudit("0");
                sysResources.setModuleId(resourceModules.getId());
                sysResources.setResTypeId(this.res[2][i]);
                sysResources.setIsRepeatAuthenticate("0");
                sysResources.setCreator(OPERATOR);
            }
            sysResources.setCreator(OPERATOR);
            sysResources.setResourceName(prefix + this.res[1][i]);
            sysResources.setResourceAlias(prefix + this.res[1][i]);
            sysResources.setComponent(resComponent);
            sysResources.setPath(resPath);
            sysResources.setStrategy(strategy + "");
            sysResources.setKeepAlive(keepAlive ? "1" : "0");
            Long resourceResult = this.sysResManageService.resourceSave(sysResources);
            if (resourcesList.size() != 0) {
                if (ToolUtil.isEmpty((Object)resourceResult)) {
                    logger.error(this.res[0][i] + "\u8d44\u6e90\u66f4\u65b0\u5931\u8d25\uff01");
                } else {
                    getResources = this.sysResourcesMapper.getResourceByCode(sysResources.getResourceCode());
                    sysResources.setId(getResources.getId());
                    sysResources.setCreator(getResources.getCreator());
                    sysResources.setCreateTime(getResources.getCreateTime());
                    sysResources.setSeq(getResources.getSeq());
                    this.sysRoleResourceService.remove((Wrapper)new LambdaUpdateWrapper().eq(SysRoleResource::getResourceId, (Object)sysResources.getId()));
                    associationResult = this.associationRole(sysResources);
                    if (ToolUtil.isEmpty((Object)resourceResult) || !associationResult) {
                        logger.error("\u65b0\u589e'" + this.res[0][i] + "'\u8d44\u6e90\u5931\u8d25\uff01");
                    } else {
                        successResoureIds.add(String.valueOf(sysResources.getId()));
                        successResources.add(sysResources);
                    }
                }
            } else {
                getResources = this.sysResourcesMapper.getResourceByCode(sysResources.getResourceCode());
                sysResources.setId(getResources.getId());
                sysResources.setCreator(getResources.getCreator());
                sysResources.setCreateTime(getResources.getCreateTime());
                sysResources.setSeq(getResources.getSeq());
                associationResult = this.associationRole(sysResources);
                if (ToolUtil.isEmpty((Object)resourceResult) || !associationResult) {
                    logger.error("\u65b0\u589e'" + this.res[0][i] + "'\u8d44\u6e90\u5931\u8d25\uff01");
                } else {
                    successResoureIds.add(String.valueOf(sysResources.getId()));
                    successResources.add(sysResources);
                }
            }
            if (i != 0) continue;
            returnResources = sysResources;
        }
        List appMenuResourceList = this.sysAppMenuResourceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppMenuResource::getPageId, (Object)pageId)).in(SysAppMenuResource::getId, (Collection)successResoureIds));
        if (!CollectionUtils.isEmpty((Collection)appMenuResourceList)) {
            List existsResourceIds = appMenuResourceList.stream().map(SysAppMenuResource::getId).collect(Collectors.toList());
            successResoureIds.removeAll(existsResourceIds);
        }
        if (!CollectionUtils.isEmpty((Collection)successResoureIds)) {
            List appMenuRelations = this.sysAppMenuResourceMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppMenuResource::getPageId, (Object)pageId)).eq(SysAppMenuResource::getRelationType, (Object)this.APP_RELATION_MENU_TYPE));
            for (String resourceId : successResoureIds) {
                Long functionId;
                SysAppMenuResource sysAppMenuResource = new SysAppMenuResource();
                sysAppMenuResource.setAppName(appName);
                sysAppMenuResource.setPageId(pageId);
                sysAppMenuResource.setId(Long.valueOf(resourceId));
                sysAppMenuResource.setRelationType(Long.valueOf(this.APP_RELATION_RESOURCE_TYPE));
                sysAppMenuResource.setCreator(OPERATOR);
                this.sysAppMenuResourceMapper.insert(sysAppMenuResource);
                if (CollectionUtils.isEmpty((Collection)appMenuRelations) || !ToolUtil.isEmpty((Object)this.sysFunctionResourcesService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysFunctionResources::getFunctionId, (Object)(functionId = ((SysAppMenuResource)appMenuRelations.get(0)).getRelationRefId()))).eq(SysFunctionResources::getResourceId, (Object)resourceId)))) continue;
                SysFunctionResources sysFunctionResources = new SysFunctionResources();
                sysFunctionResources.setFunctionId(functionId);
                sysFunctionResources.setResourceId(Long.valueOf(resourceId));
                sysFunctionResources.setCreator(OPERATOR);
                sysFunctionResources.setLastEditor(OPERATOR);
                this.sysFunctionResourcesService.save((Object)sysFunctionResources);
            }
            for (SysResources resources : successResources) {
                if (!this.RES_MENU.equals(resources.getResTypeId()) || CollectionUtils.isEmpty((Collection)appMenuRelations)) continue;
                Long functionId = ((SysAppMenuResource)appMenuRelations.get(0)).getRelationRefId();
                this.iSysFunctionsService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysFunctions::getDefaultResourceId, (Object)resources.getId())).eq(SysFunctions::getId, (Object)functionId));
            }
        }
        return returnResources;
    }

    private Boolean associationRole(SysResources sysResources) {
        ArrayList<SysRoleResource> roleResourceList = new ArrayList<SysRoleResource>();
        List<Long> roleList = this.getRoleList();
        for (Long roleId : roleList) {
            SysRoleResource sysRoleResource = new SysRoleResource();
            sysRoleResource.setId(roleId);
            sysRoleResource.setResourceId(sysResources.getId());
            sysRoleResource.setCreator(sysResources.getCreator());
            sysRoleResource.setCreateTime(sysResources.getCreateTime());
            sysRoleResource.setLastEditor(sysResources.getCreator());
            sysRoleResource.setLastTime(sysResources.getCreateTime());
            roleResourceList.add(sysRoleResource);
        }
        return this.sysRoleResourceService.saveBatch(roleResourceList, roleResourceList.size());
    }

    private Boolean associationRoleFunction(SysFunctions sysFunctions) {
        ArrayList<SysRoleFunctions> roleFunctionsList = new ArrayList<SysRoleFunctions>();
        List<Long> roleList = this.getRoleList();
        for (Long roleId : roleList) {
            SysRoleFunctions sysRoleFunctions = new SysRoleFunctions();
            sysRoleFunctions.setRoleId(roleId);
            sysRoleFunctions.setFunctionId(sysFunctions.getId());
            sysRoleFunctions.setCreator(sysFunctions.getCreator());
            sysRoleFunctions.setCreateTime(sysFunctions.getCreateTime());
            sysRoleFunctions.setLastEditor(sysFunctions.getCreator());
            sysRoleFunctions.setLastTime(sysFunctions.getCreateTime());
            roleFunctionsList.add(sysRoleFunctions);
        }
        return this.sysRoleFunctionsService.saveBatch(roleFunctionsList, roleFunctionsList.size());
    }

    private List<Long> getRoleList() {
        String[] roleName = ToolUtil.isNotEmpty((Object)this.menuRole) ? this.menuRole.split(",") : new String[]{};
        String[] groupId = ToolUtil.isNotEmpty((Object)this.menuRoleGroup) ? this.menuRoleGroup.split(",") : new String[]{};
        List<Long> roleList = this.sysUserRoleMapper.getRoleIdByRoleName(roleName);
        if (ToolUtil.isNotEmpty((Object)groupId)) {
            List<String> groupList = this.sysUserRoleMapper.getRoleIdByGroupId(groupId);
            for (String g : groupList) {
                boolean flag = false;
                for (Long r : roleList) {
                    if (!g.equals(r)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                roleList.add(Long.valueOf(g));
            }
        }
        return roleList;
    }
}

