/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.grade.user.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.authorization.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.authorization.permit.dto.QueryUserDto;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.vo.SearchUserVo;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.grade.enums.AuthorGradeTipEnum;
import com.jxdinfo.hussar.grade.organ.manager.QueryGradeOrganManager;
import com.jxdinfo.hussar.grade.user.service.ILocalQueryGradeUserService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@HussarTokenDs
@Repository(value="com.jxdinfo.hussar.grade.user.service.impl.localQueryGradeUserServiceImpl")
public class LocalQueryGradeUserServiceImpl
implements ILocalQueryGradeUserService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalQueryGradeUserServiceImpl.class);
    @Resource
    private QueryGradeOrganManager queryGradeOrganManager;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysUsersMapper sysUsersMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    protected ISysDicRefService sysDicRefService;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;

    public Page<SearchUserVo> searchUsers(PageInfo pageInfo, QueryUserDto queryUserDto) {
        String accountStatus;
        Object[] arr;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)queryUserDto.getDepStruId())) {
            String organProperty = HussarUtils.equals((Object)Constants.ROOT_NODE_ID, (Object)queryUserDto.getDepStruId()) ? "0" : "1";
            Long parentId = this.queryGradeOrganManager.getGradeOrganType(queryUserDto.getDepStruId());
            if (HussarUtils.isEmpty((Object)parentId)) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            OrganizationTreeVo organ = this.sysStruMapper.lazyOrganizationById(parentId);
            if (HussarUtils.isNotEmpty((Object)organ) && !HussarUtils.equals((Object)organProperty, (Object)organ.getOrganProperty())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            queryUserDto.setDepStruId(parentId);
        }
        if (ArrayUtils.contains((Object[])(arr = new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode()}), (Object)(accountStatus = queryUserDto.getAccountStatus()))) {
            List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
            List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
            if (HussarUtils.isEmpty((Object)keyList) && HussarUtils.isEmpty((Object)casKeyList) && HussarUtils.equals((Object)accountStatus, (Object)UserStatus.LOCKED.getCode())) {
                page.setRecords(Collections.emptyList());
                return page;
            }
            LocalQueryGradeUserServiceImpl.handleUserLockStatusParams(queryUserDto, keyList, casKeyList, queryParams);
        }
        this.wrapQueryParams(queryUserDto, queryParams);
        List userInfoList = this.sysUsersMapper.searchUserOrganInfosNew(page, queryParams);
        this.fillOrganInfos(userInfoList);
        this.wrapUsers(userInfoList);
        this.fillUserSignInfos(userInfoList);
        page.setRecords(userInfoList);
        return page;
    }

    private static void handleUserLockStatusParams(QueryUserDto queryUserDto, List<String> keyList, List<String> casKeyList, Map<String, Object> queryParams) {
        ArrayList<Long> lockUserIds = new ArrayList<Long>();
        queryUserDto.setLockUserIds(lockUserIds);
        if (CollectionUtils.isNotEmpty(keyList)) {
            Iterator<String> iterator = keyList.iterator();
            while (iterator.hasNext()) {
                String cacheKey;
                String tmpKey = cacheKey = iterator.next();
                lockUserIds.add(Long.parseLong(tmpKey));
            }
        } else if (CollectionUtils.isNotEmpty(casKeyList)) {
            for (String cacheKey : casKeyList) {
                UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)cacheKey)), UserLockModel.class);
                if (!HussarUtils.isNotEmpty((Object)model)) continue;
                lockUserIds.add(Long.parseLong(model.getUserId()));
            }
        }
        if (HussarUtils.isNotEmpty(lockUserIds)) {
            queryParams.put("lockUserIds", lockUserIds);
        }
    }

    private void wrapQueryParams(QueryUserDto queryUserDto, Map<String, Object> queryParams) {
        String struPath;
        AtomicReference<Long> depStruId = new AtomicReference<Long>(queryUserDto.getDepStruId());
        queryParams.put("containSys", StringUtils.trimToEmpty((String)queryUserDto.getContainSys()));
        if (Objects.equals(Constants.ROOT_NODE_ID, depStruId.get())) {
            struPath = "0";
        } else if (Objects.equals(Constants.OUT_STRU_NODE_ID, depStruId.get())) {
            struPath = "1";
            queryParams.put("containSys", "0");
        } else {
            SysStru struTemp = (SysStru)this.sysStruMapper.selectById((Serializable)depStruId.get());
            AssertUtil.isNotNull((Object)struTemp, (String)TranslateUtil.getTranslateName((String)AuthorGradeTipEnum.AUTHOR_GRADE_STRU_EMPTY.getMessage()));
            struPath = struTemp.getStruFid();
            queryParams.put("containSys", "0");
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        queryParams.put("userAccount", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserAccount()));
        queryParams.put("accountStatus", StringUtils.trimToEmpty((String)queryUserDto.getAccountStatus()));
        queryParams.put("userName", SqlQueryUtil.transferSpecialChar((String)queryUserDto.getUserName()));
        queryParams.put("accountProperty", StringUtils.trimToEmpty((String)queryUserDto.getAccountProperty()));
        queryParams.put("struPath", StringUtils.trimToEmpty((String)struPath));
    }

    private void fillOrganInfos(List<SearchUserVo> userInfoList) {
        if (HussarUtils.isEmpty(userInfoList)) {
            return;
        }
        List userIdList = userInfoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List organByUserIds = this.sysStruUserMapper.getOrganByUserIds(LambdaQueryUtil.getSplitList(userIdList), null);
        Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (SearchUserVo vo : userInfoList) {
            List<UserOrganPostVo> organInfoList = userOrganMap.get(vo.getId());
            if (HussarUtils.isEmpty(organInfoList)) continue;
            String organName = organInfoList.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            vo.setDepartmentName(organName);
        }
    }

    private void wrapUsers(List<SearchUserVo> userInfoList) {
        if (HussarUtils.isEmpty(userInfoList)) {
            return;
        }
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        for (SearchUserVo vo : userInfoList) {
            Optional<String> optional;
            vo.setAccoutStatusName(mapStatus.get(vo.getAccountStatus()));
            vo.setAccountPropertyName(mapProperty.get(vo.getAccountProperty()));
            if (HussarUtils.isNotEmpty((Object)keyList)) {
                optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            } else if (HussarUtils.isNotEmpty((Object)casKeyList)) {
                optional = casKeyList.parallelStream().filter(item -> item.contains(String.valueOf(vo.getId()))).findAny();
                ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                    String tmpkey = (String)optional.get();
                    UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)tmpkey)), UserLockModel.class);
                    if (null != model && model.getLockTime() != null) {
                        vo.setAccountStatus(UserStatus.LOCKED.getCode());
                    }
                });
            }
            vo.setEndTime(Java8DateUtils.convertLocalDateTimeToString((LocalDateTime)vo.getExpiredTime()));
        }
    }

    private void fillUserSignInfos(List<SearchUserVo> searchUserVoList) {
        if (HussarUtils.isEmpty(searchUserVoList)) {
            return;
        }
        List userIdList = searchUserVoList.stream().map(SearchUserVo::getId).collect(Collectors.toList());
        List userSignVoList = this.userAttachmentService.listUserSignByUserIds(userIdList);
        if (HussarUtils.isEmpty((Object)userSignVoList)) {
            return;
        }
        Map<Long, List<SysUserAttachmentVo>> userSignMap = userSignVoList.stream().collect(Collectors.groupingBy(SysUserAttachmentVo::getUserId));
        for (SearchUserVo vo : searchUserVoList) {
            List<SysUserAttachmentVo> signInfoList = userSignMap.get(vo.getId());
            if (HussarUtils.isEmpty(signInfoList)) continue;
            if (signInfoList.size() > 1) {
                LOGGER.info("\u5f53\u524d\u7528\u6237\u5b58\u5728\u591a\u4e2a\u7b7e\u540d,\u907f\u514d\u524d\u7aef\u5f02\u5e38\uff0c\u53d6\u7b2c\u4e00\u4e2a===>{}", (Object)vo.getId());
            }
            SysUserAttachmentVo userAttachmentVo = signInfoList.get(0);
            vo.setFileType(userAttachmentVo.getFileType());
            vo.setBusiType(userAttachmentVo.getBusiType());
            vo.setUserSignImgBase64(userAttachmentVo.getImgBase64());
            vo.setUserSignFileId(userAttachmentVo.getFileId());
        }
    }
}

