/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.grade.organ.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.PermissionEnum;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruRuleMapper;
import com.jxdinfo.hussar.authorization.organ.model.SysStruRule;
import com.jxdinfo.hussar.authorization.organ.service.IHussarBaseOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganizationTreeVo;
import com.jxdinfo.hussar.common.treemodel.HussarTreePermission;
import com.jxdinfo.hussar.grade.organ.dao.SysGradeStruMapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.LinkedMultiValueMap;

public abstract class CommonQueryGradeOrganManager {
    protected static final String PARENTID = "parentId";
    protected static final String ORGANPROPERTY = "organProperty";
    protected static final String GRADEROOTID = "gradeRootId";
    @Resource
    protected SysGradeStruMapper sysGradeStruMapper;
    @Resource
    protected ISysOrganTypeService sysOrganTypeService;
    @Resource
    protected IHussarBaseOrganizationBoService hussarBaseOrganizationBoService;
    @Resource
    protected SysStruRuleMapper sysStruRuleMapper;

    protected List<OrganizationTreeVo> getGradeOrganizationTree(Long parentId, String organProperty, Long gardeRootId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put(PARENTID, parentId);
        queryParams.put(ORGANPROPERTY, organProperty);
        queryParams.put(GRADEROOTID, gardeRootId);
        return this.sysGradeStruMapper.searchOrganizationTreeWithProperty(queryParams);
    }

    protected void fillOrganizationPermissions(List<OrganizationTreeVo> result) {
        List<SysStruRule> list = this.searchWithoutStaffRuleList();
        for (OrganizationTreeVo organizationTreeVo : result) {
            this.fillSingleOrganizationPermissions(organizationTreeVo, list);
        }
    }

    protected List<SysStruRule> searchWithoutStaffRuleList() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(SysStruRule::getOrganType, (Object)"9");
        return this.sysStruRuleMapper.selectList((Wrapper)wrapper);
    }

    protected void fillSingleOrganizationPermissions(OrganizationTreeVo organizationTreeVo, List<SysStruRule> list) {
        String struType = organizationTreeVo.getStruType();
        List permissions = organizationTreeVo.getPermissions();
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        for (SysStruRule ssr : list) {
            map.add((Object)ssr.getSysOrganType(), (Object)ssr.getOrganType());
        }
        List rules = (List)map.get((Object)struType);
        organizationTreeVo.setDisabled(Boolean.valueOf(false));
        permissions.add(new HussarTreePermission(PermissionEnum.ADD.getId(), PermissionEnum.ADD.getName(), Boolean.valueOf(HussarUtils.isNotEmpty((Object)rules))));
        permissions.add(new HussarTreePermission(PermissionEnum.EDIT.getId(), PermissionEnum.EDIT.getName(), Boolean.valueOf(true)));
        permissions.add(new HussarTreePermission(PermissionEnum.DELETE.getId(), PermissionEnum.DELETE.getName(), Boolean.valueOf(true)));
        organizationTreeVo.setPermissions(permissions);
    }
}

