/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authentication.lock.SecureErr;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.extend.dao.HussarBaseUserExtendWebMapper;
import com.jxdinfo.hussar.authorization.extend.model.UserExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.ImportExcelUserExtendManager;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.vo.OrganExcelCheckResult;
import com.jxdinfo.hussar.authorization.permit.enums.AccountTypeEnum;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginFailConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.extend.service.impl.ImportExcelUserExtendManagerImpl")
public class ImportExcelUserExtendManagerImpl
implements ImportExcelUserExtendManager {
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private IHussarPwdConfigService pwdConfigService;
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysDicService sysDicService;
    @Resource
    private IHussarLoginFailConfigService hussarLoginFailConfigService;
    @Resource
    private IConvertPinyinService convertPinyinService;
    @Resource
    private HussarBaseUserExtendWebMapper hussarBaseUserExtendWebMapper;
    public static final Map<Long, String> ORGAN_PROPERTY_MAP = new HashMap<Long, String>();

    public Map<Long, String> getOrganPropertyMap() {
        return ORGAN_PROPERTY_MAP;
    }

    public void addOrganPropertyMap(Long taskId, String organProperty) {
        ORGAN_PROPERTY_MAP.put(taskId, organProperty);
    }

    @Override
    public ExcelCheckResult check(List<UserExtendExcel> datas, List<Object> otherParams) {
        ArrayList<UserExtendExcel> rootDataList = new ArrayList<UserExtendExcel>(datas);
        ArrayList<UserExtendExcel> successDataList = new ArrayList<UserExtendExcel>();
        ArrayList<ExcelImportMsg<UserExtendExcel>> newDataList = new ArrayList<ExcelImportMsg<UserExtendExcel>>();
        ArrayList<ExcelImportMsg<UserExtendExcel>> updateDataList = new ArrayList<ExcelImportMsg<UserExtendExcel>>();
        ArrayList<ExcelImportMsg<UserExtendExcel>> existDataList = new ArrayList<ExcelImportMsg<UserExtendExcel>>();
        ArrayList<ExcelImportMsg<UserExtendExcel>> errorDataList = new ArrayList<ExcelImportMsg<UserExtendExcel>>();
        OrganExcelCheckResult userExtendExcelCheckResult = new OrganExcelCheckResult();
        ArrayList<String> userAccounts = new ArrayList<String>();
        HashMap<String, Long> userAccountNumMap = new HashMap<String, Long>();
        HashMap<String, Long> userIdNumMap = new HashMap<String, Long>();
        HashMap<String, UserExtendExcel> userExtendExcelMap = new HashMap<String, UserExtendExcel>();
        this.initUserMap(datas, userAccountNumMap, userAccounts, userExtendExcelMap, userIdNumMap);
        this.checkDataInExcel(datas, errorDataList, userAccountNumMap, userIdNumMap);
        if (HussarUtils.isNotEmpty(errorDataList)) {
            userExtendExcelCheckResult.setRootNum(datas.size());
            userExtendExcelCheckResult.setErrorNum(errorDataList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)userExtendExcelCheckResult);
            return excelCheckResult;
        }
        List accounts = LambdaQueryUtil.getSplitList(userAccounts);
        List<UserExtendExcel> userExtendExcelDbList = this.hussarBaseUserExtendWebMapper.getExtendUserExcelDbList(accounts);
        HashMap<String, UserExtendExcel> userDbMap = new HashMap();
        HashMap<Long, List<UserOrganPostVo>> userOrganMap = new HashMap();
        if (HussarUtils.isNotEmpty(userExtendExcelDbList)) {
            userDbMap = userExtendExcelDbList.stream().collect(Collectors.toMap(UserExtendExcel::getUserAccount, Function.identity()));
            List userIds = userExtendExcelDbList.stream().map(u -> Long.valueOf(u.getUserId())).collect(Collectors.toList());
            List userIdList = LambdaQueryUtil.getSplitList(userIds);
            List userOrganDbList = this.sysStruUserMapper.getOrganByUserIds(userIdList, null);
            userOrganMap = userOrganDbList.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        }
        List<Long> userIdListDb = this.sysUsersService.list().stream().map(SysUsers::getId).collect(Collectors.toList());
        List organDataDbList = this.sysStruMapper.getOrganExcelByStruIds(null, null);
        Map<String, OrganExcel> fullOrganNameMap = organDataDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, o -> o));
        this.checkDataInDb(datas, successDataList, newDataList, updateDataList, existDataList, errorDataList, userDbMap, fullOrganNameMap, userOrganMap, userIdListDb);
        userExtendExcelCheckResult.setRootNum(datas.size());
        userExtendExcelCheckResult.setErrorNum(errorDataList.size());
        userExtendExcelCheckResult.setNewNum(newDataList.size());
        userExtendExcelCheckResult.setUpdateNum(updateDataList.size());
        userExtendExcelCheckResult.setExistNum(existDataList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)userExtendExcelCheckResult);
        return excelCheckResult;
    }

    @Override
    @HussarTransactional
    public void saveData(List<UserExtendExcel> datas, List<Object> otherParams) {
        ArrayList<SysUsers> sysUsers = new ArrayList<SysUsers>();
        ArrayList<SysStruUser> sysStruUsers = new ArrayList<SysStruUser>();
        ArrayList<SysUserRole> sysUserRoles = new ArrayList<SysUserRole>();
        this.initUser(datas, sysUsers, sysStruUsers, sysUserRoles);
        this.sysUsersService.saveBatch(sysUsers);
        this.sysStruUserService.saveBatch(sysStruUsers);
        this.sysUserRoleService.saveBatch(sysUserRoles);
    }

    private void initUser(List<UserExtendExcel> userExtendExcels, List<SysUsers> sysUsers, List<SysStruUser> struUsers, List<SysUserRole> sysUserRoles) {
        List organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, userExtendExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity()));
        String pass = "";
        pass = this.createUserConfigService.getCreateUserSendEmail() != false && this.createUserConfigService.getCreateUserUseDefaultPass() == false ? "123456" : this.pwdConfigService.getDefaultPassword();
        String pwd = this.credentialsMatcher.passwordEncode(String.valueOf(pass).getBytes());
        Integer maxUserOrder = this.sysUsersService.getUserMaxOrder();
        maxUserOrder = HussarUtils.isEmpty((Object)maxUserOrder) ? 1 : maxUserOrder;
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(HussarContextHolder.getConnName(), "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        int lockTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        for (UserExtendExcel entry : userExtendExcels) {
            SysUsers user = new SysUsers();
            user.setId(Long.valueOf(HussarUtils.isEmpty((Object)entry.getUserId()) ? IdWorker.getId((Object)new SysUsers()) : Long.parseLong(entry.getUserId())));
            entry.setUserId(String.valueOf(user.getId()));
            BeanUtil.copy((Object)entry, (Object)user);
            if (HussarUtils.isEmpty((Object)user.getUserOrder())) {
                maxUserOrder = maxUserOrder + 1;
                user.setUserOrder(maxUserOrder);
            }
            user.setPassword(pwd);
            user.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
            user.setSecurityLevel(Integer.valueOf(1));
            user.setMaxSessions(Integer.valueOf(Integer.parseInt(entry.getMaxSessions())));
            user.setLoginIpLimit("0");
            user.setLoginTimeLimit("0");
            user.setIsSys("0");
            user.setIsCpublic("0");
            user.seteMail(entry.getMail());
            user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(user.getUserName()));
            user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(user.getUserName()));
            if (HussarUtils.equals((Object)"0", (Object)user.getTypeProperty())) {
                user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)entry.getStartTime()));
                user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)entry.getExpiredTime()));
            }
            if (HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                user.setAccountStatus(UserStatus.OK.getCode());
                this.addLockUserCache(user, errMode, tryLoginTime, lockTime);
            }
            sysUsers.add(user);
            this.initStruUser(entry, struUsers, organDbMap);
            if (sysUserRoles == null) continue;
            SysUserRole userRole = new SysUserRole();
            userRole.setUserId(user.getId());
            userRole.setGrantedRole(SysUserAndRole.PUBLIC_ROLE.getValue());
            userRole.setAdminOption("1");
            sysUserRoles.add(userRole);
        }
    }

    private void initStruUser(UserExtendExcel userExtendExcel, List<SysStruUser> struUsers, Map<String, OrganExcel> organDbMap) {
        String[] depts;
        String deptName = userExtendExcel.getDepartment();
        for (String dept : depts = deptName.split(",")) {
            OrganExcel organExcel = organDbMap.get(dept);
            if (!HussarUtils.isNotEmpty((Object)organExcel)) continue;
            this.addRelation(userExtendExcel, organExcel, struUsers);
        }
    }

    private void addRelation(UserExtendExcel userExtendExcel, OrganExcel organExcel, List<SysStruUser> struUsers) {
        SysStruUser struUser = new SysStruUser();
        struUser.setStruId(Long.valueOf(Long.parseLong(organExcel.getStruId())));
        struUser.setUserId(Long.valueOf(userExtendExcel.getUserId()));
        struUsers.add(struUser);
    }

    @Override
    @HussarTransactional
    public void updateData(List<UserExtendExcel> datas, List<Object> otherParams) {
        ArrayList<SysStruUser> sysStruUsers = new ArrayList<SysStruUser>();
        List userAccounts = datas.stream().map(UserExtendExcel::getUserAccount).collect(Collectors.toList());
        List sysUsers = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().in(SysUsers::getUserAccount, userAccounts));
        this.initEditStruUser(datas, sysUsers, sysStruUsers);
        List userIds = sysUsers.stream().map(SysUsers::getId).collect(Collectors.toList());
        List userIdList = LambdaQueryUtil.getSplitList(userIds);
        String organProperty = HussarUtils.equals((Object)"0", (Object)datas.get(0).getOrganProperty()) ? "1" : "0";
        List organByUserIds = this.sysStruUserMapper.getOrganByUserIds(userIdList, organProperty);
        List struIds = organByUserIds.stream().map(UserOrganPostVo::getStruId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruUser::getUserId, userIds);
        if (HussarUtils.isNotEmpty(struIds)) {
            lambdaQueryWrapper.notIn(SysStruUser::getStruId, struIds);
        }
        this.sysStruUserService.remove((Wrapper)lambdaQueryWrapper);
        this.sysUsersService.updateBatchById((Collection)sysUsers);
        this.sysStruUserService.saveBatch(sysStruUsers);
    }

    private void initEditStruUser(List<UserExtendExcel> userExtendExcels, List<SysUsers> sysUsers, List<SysStruUser> struUsers) {
        List organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, userExtendExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity()));
        Map userExtendExcelMap = userExtendExcels.stream().collect(Collectors.toMap(UserExtendExcel::getUserAccount, Function.identity()));
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(HussarContextHolder.getConnName(), "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        int lockTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        for (SysUsers user : sysUsers) {
            UserExtendExcel userExtendExcel = (UserExtendExcel)userExtendExcelMap.get(user.getUserAccount());
            if (HussarUtils.isNotEmpty((Object)userExtendExcel.getUserOrder())) {
                user.setUserOrder(Integer.valueOf(Integer.parseInt(userExtendExcel.getUserOrder())));
            }
            userExtendExcel.setEmployeeId(user.getEmployeeId());
            BeanUtils.copyProperties((Object)userExtendExcel, (Object)user);
            if (HussarUtils.isNotEmpty((Object)keyList) && keyList.contains(String.valueOf(user.getId())) && !HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(user.getId()));
            }
            if (HussarUtils.equals((Object)UserStatus.LOCKED.getCode(), (Object)user.getAccountStatus())) {
                user.setAccountStatus(UserStatus.OK.getCode());
                this.addLockUserCache(user, errMode, tryLoginTime, lockTime);
            }
            user.seteMail(userExtendExcel.getMail());
            user.setMaxSessions(Integer.valueOf(Integer.parseInt(userExtendExcel.getMaxSessions())));
            user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(user.getUserName()));
            user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(user.getUserName()));
            if (HussarUtils.equals((Object)"0", (Object)user.getTypeProperty())) {
                user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)userExtendExcel.getStartTime()));
                user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)userExtendExcel.getExpiredTime()));
            }
            this.initStruUser(userExtendExcel, struUsers, organDbMap);
        }
    }

    private void initUserMap(List<UserExtendExcel> datas, Map<String, Long> userAccountNumMap, List<String> userAccounts, Map<String, UserExtendExcel> userExtendExcelMap, Map<String, Long> userIdNumMap) {
        for (UserExtendExcel userExtendExcel : datas) {
            String userAccount = userExtendExcel.getUserAccount();
            String userId = userExtendExcel.getUserId();
            Long accountNum = userAccountNumMap.get(userAccount);
            accountNum = HussarUtils.isEmpty((Object)accountNum) ? 1L : accountNum + 1L;
            userAccountNumMap.put(userAccount, accountNum);
            if (HussarUtils.isNotEmpty((Object)userId)) {
                Long userIdNum = userIdNumMap.get(userId);
                userIdNum = HussarUtils.isEmpty((Object)userIdNum) ? 1L : userIdNum + 1L;
                userIdNumMap.put(userId, userIdNum);
            }
            userAccounts.add(userAccount);
            userExtendExcelMap.put(userAccount, userExtendExcel);
        }
    }

    private void checkDataInExcel(List<UserExtendExcel> datas, List<ExcelImportMsg<UserExtendExcel>> errorDataList, Map<String, Long> userAccountNumMap, Map<String, Long> userIdNumMap) {
        for (int i = 0; i < datas.size(); ++i) {
            String userId;
            UserExtendExcel userExtendExcel = datas.get(i);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)userExtendExcel, (Integer)i);
            String userAccount = userExtendExcel.getUserAccount();
            if (userAccountNumMap.get(userAccount) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ACCOUNT_DUPLICATION.getMessage()), (Map)cellErrColMap);
            }
            if (HussarUtils.isNotEmpty((Object)(userId = userExtendExcel.getUserId())) && userIdNumMap.get(userId) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)24, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_PRIMARY_KEY_DUPLICATION.getMessage()), (Map)cellErrColMap);
            }
            this.checkExcelForParentOrgan(i, userExtendExcel.getDepartment(), cellErrColMap);
            this.checkExcelForTypeProperty(i, userExtendExcel, cellErrColMap);
            this.checkNumber(i, userExtendExcel.getMaxSessions(), 3, cellErrColMap);
            this.checkNumber(i, userExtendExcel.getUserOrder(), 15, cellErrColMap);
            if (HussarUtils.isNotBlank((CharSequence)userExtendExcel.getUserOrder()) && !this.isInIntegerRange(userExtendExcel.getUserOrder())) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)15, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_SORT_RANGE_OUT.getMessage()), (Map)cellErrColMap);
            }
            this.sysDicService.checkExcelPrimaryKey(Integer.valueOf(i), userExtendExcel.getUserId(), Integer.valueOf(24), cellErrColMap, "user");
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorDataList.add((ExcelImportMsg<UserExtendExcel>)new ExcelImportMsg((Object)userExtendExcel, cellErrColMap));
        }
    }

    private boolean isInIntegerRange(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkExcelForParentOrgan(int i, String departmentNames, Map<Integer, Map<Integer, String>> cellErrColMap) {
        List<String> deptNames = Arrays.asList(departmentNames.split(","));
        if (HussarUtils.isEmpty(deptNames)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_ORGAN_EMPTY.getMessage()), cellErrColMap);
            return;
        }
        String regex = "^(?:/[^/]+)+$";
        Pattern pattern = Pattern.compile(regex);
        for (String deptName : deptNames) {
            Matcher matcher = pattern.matcher(deptName);
            if (matcher.matches()) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_FORMAT_FALSE.getMessage()), cellErrColMap);
            break;
        }
    }

    private void checkDataInDb(List<UserExtendExcel> datas, List<UserExtendExcel> successDataList, List<ExcelImportMsg<UserExtendExcel>> newDataList, List<ExcelImportMsg<UserExtendExcel>> updateDataList, List<ExcelImportMsg<UserExtendExcel>> existDataList, List<ExcelImportMsg<UserExtendExcel>> errorDataList, Map<String, UserExtendExcel> userDbMap, Map<String, OrganExcel> fullOrganNameMap, Map<Long, List<UserOrganPostVo>> userOrganMap, List<Long> userIds) {
        List<String> userIdStrList = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        List lockUserIds = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        for (int i = 0; i < datas.size(); ++i) {
            UserExtendExcel userExtendExcel = datas.get(i);
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            this.checkOrganForExist(i, userExtendExcel, fullOrganNameMap, cellErrColMap);
            this.checkUserForExit(i, userExtendExcel, userDbMap, cellNewColMap, cellExitColMap, cellUpdateColMap, userOrganMap, cellErrColMap, userIdStrList, lockUserIds);
            if (cellErrColMap.isEmpty()) {
                successDataList.add(userExtendExcel);
            }
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<UserExtendExcel>)new ExcelImportMsg((Object)userExtendExcel, cellErrColMap));
            }
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<UserExtendExcel>)new ExcelImportMsg((Object)userExtendExcel, cellExitColMap));
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<UserExtendExcel>)new ExcelImportMsg((Object)userExtendExcel, cellUpdateColMap));
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<UserExtendExcel>)new ExcelImportMsg((Object)userExtendExcel, cellNewColMap));
        }
    }

    private void checkOrganForExist(int i, UserExtendExcel userExtendExcel, Map<String, OrganExcel> fullNameOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String[] deptNames;
        String departmentName = userExtendExcel.getDepartment();
        for (String deptName : deptNames = departmentName.split(",")) {
            if (!HussarUtils.isEmpty((Object)fullNameOrganMap.get(deptName))) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_NAME_NOT_EXSIT.getMessage()) + deptName), cellErrColMap);
            break;
        }
    }

    private void checkUserForExit(int i, UserExtendExcel userExtendExcel, Map<String, UserExtendExcel> userDbMap, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Long, List<UserOrganPostVo>> userOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap, List<String> userIdStrList, List<String> lockUserIds) {
        String userAccount = userExtendExcel.getUserAccount();
        if (!userDbMap.containsKey(userAccount)) {
            String userId = userExtendExcel.getUserId();
            if (HussarUtils.isNotEmpty((Object)userId) && userIdStrList.contains(userId)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)24, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_ADD_ORGAN_PRIMARY_KEY_EXIST.getMessage()), cellErrColMap);
            }
            HussarBaseExcelValidateHelper.addNewMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_NEW_DATA.getMessage()), cellNewColMap);
        } else {
            boolean exitFlag = true;
            UserExtendExcel userDb = userDbMap.get(userAccount);
            List<UserOrganPostVo> userOrgans = userOrganMap.get(Long.parseLong(userDb.getUserId()));
            if (HussarUtils.equals((Object)UserStatus.DELETE.getCode(), (Object)userDb.getAccountStatus())) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
            } else {
                List<String> deptNames = Arrays.asList(userExtendExcel.getDepartment().split(","));
                if (HussarUtils.isEmpty(userOrgans)) {
                    HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                    HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
                } else {
                    if (userOrgans.size() == deptNames.size()) {
                        for (UserOrganPostVo organ : userOrgans) {
                            if (deptNames.contains(organ.getOrganFname())) continue;
                            exitFlag = false;
                            break;
                        }
                    }
                    if (exitFlag) {
                        UserLockModel lockModel;
                        if (HussarUtils.isNotEmpty(lockUserIds) && lockUserIds.contains(userDb.getUserId()) && HussarUtils.isNotEmpty((Object)(lockModel = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)userDb.getUserId())).getLockTime())) {
                            userDb.setAccountStatus(UserStatus.LOCKED.getCode());
                        }
                        exitFlag = userExtendExcel.equals((Object)userDb);
                    }
                    if (exitFlag) {
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                    } else {
                        HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                        HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
                    }
                }
            }
        }
    }

    @Override
    public List<UserExtendExcel> handleDataBeforeImport(List<UserExtendExcel> list, Long taskId) {
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        String organProperty = ORGAN_PROPERTY_MAP.get(taskId);
        list.forEach(userExtendExcel -> userExtendExcel.setOrganProperty(organProperty));
        return list;
    }

    private String handleDateFormat(String dateStr) {
        if (HussarUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        return dateStr.replace("/", "-");
    }

    private void checkExcelForTypeProperty(int i, UserExtendExcel userExtendExcel, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.equals((Object)AccountTypeEnum.TEMPORARY.getValue(), (Object)userExtendExcel.getTypeProperty())) {
            String startTime = userExtendExcel.getStartTime();
            String expiredTime = userExtendExcel.getExpiredTime();
            this.checkTime(i, startTime, 13, cellErrColMap);
            this.checkTime(i, expiredTime, 14, cellErrColMap);
        }
    }

    private void checkTime(Integer i, String time, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String tip;
        String string = tip = HussarUtils.equals((Object)13, (Object)index) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_START.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_END.getMessage());
        if (HussarUtils.isBlank((CharSequence)time)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_TEMPORARY_ACCOUNT.getMessage()) + tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_DATA_REQUIRED.getMessage())), cellErrColMap);
        } else {
            try {
                Java8DateUtils.convertStringToLocalDateTime((String)time);
            }
            catch (Exception e) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_DATE_TIME_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
            }
        }
    }

    private void checkDate(Integer i, String date, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.isBlank((CharSequence)date)) {
            return;
        }
        String tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_BIRTH.getMessage());
        if (HussarUtils.equals((Object)20, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_EMPLOYMENT.getMessage());
        } else if (HussarUtils.equals((Object)21, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_GRADUATION.getMessage());
        }
        try {
            Java8DateUtils.convertStringToLocalDate((String)date);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_DATE_TIME_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
        }
    }

    private void checkNumber(Integer i, String num, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String tip;
        String string = tip = HussarUtils.equals((Object)3, (Object)index) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_MAX_SESSION.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_SORT.getMessage());
        if (HussarUtils.isBlank((CharSequence)num)) {
            if (HussarUtils.equals((Object)3, (Object)index)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_IS_REQUIRED.getMessage())), cellErrColMap);
            } else {
                return;
            }
        }
        try {
            Integer.parseInt(num);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_NUMBER_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
        }
    }

    private void addLockUserCache(SysUsers user, SecureErr errMode, String tryLoginTime, int lockTime) {
        UserLockModel lockModel = new UserLockModel();
        lockModel.setUserId(String.valueOf(user.getId()));
        lockModel.setUserName(String.valueOf(user.getUserName()));
        lockModel.getSecureErrList().add(errMode);
        lockModel.setFailNum(Integer.parseInt(tryLoginTime));
        lockModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        lockModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)lockTime));
        HussarCacheUtil.put((String)"Login_Lock", (Object)lockModel.getUserId(), (Object)lockModel, (long)((long)lockTime * 60L));
    }
}

