/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authentication.lock.SecureErr;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.extend.dao.HussarBaseStaffExtendWebMapper;
import com.jxdinfo.hussar.authorization.extend.model.StaffExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.ImportExcelStaffExtendManager;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendStaffInfoVo;
import com.jxdinfo.hussar.authorization.organ.dao.SysStaffMapper;
import com.jxdinfo.hussar.authorization.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.authorization.organ.model.OrganExcel;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.vo.OrganExcelCheckResult;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.dao.SysStruUserMapper;
import com.jxdinfo.hussar.authorization.relational.model.SysStruStaff;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruStaffService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginFailConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.excel.model.ExcelImportMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.validate.HussarBaseExcelValidateHelper;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.service.ISysDicService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authorization.extend.service.impl.ImportExcelStaffExtendManagerImpl")
public class ImportExcelStaffExtendManagerImpl
implements ImportExcelStaffExtendManager {
    @Resource
    private IHussarBaseExcelService hussarBaseExcelServiceImpl;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysStruUserMapper sysStruUserMapper;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruUserService sysStruUserService;
    @Resource
    private ISysStruStaffService sysStruStaffService;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private IHussarPwdConfigService pwdConfigService;
    @Autowired
    private AbstractCredentialsMatcher credentialsMatcher;
    @Autowired
    private AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Resource
    private ISysIdtableService sysIdtableService;
    @Resource
    private SysStaffMapper sysStaffMapper;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysDicService sysDicService;
    @Resource
    private IHussarLoginFailConfigService hussarLoginFailConfigService;
    @Resource
    private IConvertPinyinService convertPinyinService;
    @Resource
    private HussarBaseStaffExtendWebMapper hussarBaseStaffExtendWebMapper;
    public static final Map<Long, String> ORGAN_PROPERTY_MAP = new HashMap<Long, String>();

    public Map<Long, String> getOrganPropertyMap() {
        return ORGAN_PROPERTY_MAP;
    }

    public void addOrganPropertyMap(Long taskId, String organProperty) {
        ORGAN_PROPERTY_MAP.put(taskId, organProperty);
    }

    @Override
    public ExcelCheckResult check(List<StaffExtendExcel> datas, List<Object> otherParams) {
        ArrayList<StaffExtendExcel> rootDataList = new ArrayList<StaffExtendExcel>(datas);
        ArrayList<StaffExtendExcel> successDataList = new ArrayList<StaffExtendExcel>();
        ArrayList<ExcelImportMsg<StaffExtendExcel>> newDataList = new ArrayList<ExcelImportMsg<StaffExtendExcel>>();
        ArrayList<ExcelImportMsg<StaffExtendExcel>> updateDataList = new ArrayList<ExcelImportMsg<StaffExtendExcel>>();
        ArrayList<ExcelImportMsg<StaffExtendExcel>> existDataList = new ArrayList<ExcelImportMsg<StaffExtendExcel>>();
        ArrayList<ExcelImportMsg<StaffExtendExcel>> errorDataList = new ArrayList<ExcelImportMsg<StaffExtendExcel>>();
        OrganExcelCheckResult staffExtendExcelCheckResult = new OrganExcelCheckResult();
        ArrayList userAccounts = new ArrayList();
        HashMap<String, Long> staffCodeNumMap = new HashMap<String, Long>();
        HashMap<String, Long> staffIdNumMap = new HashMap<String, Long>();
        this.initUserMap(datas, staffIdNumMap, staffCodeNumMap);
        this.checkDataInExcel(datas, errorDataList, staffCodeNumMap, staffIdNumMap);
        if (HussarUtils.isNotEmpty(errorDataList)) {
            staffExtendExcelCheckResult.setRootNum(datas.size());
            staffExtendExcelCheckResult.setErrorNum(errorDataList.size());
            ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
            excelCheckResult.setCheckMsg((Object)staffExtendExcelCheckResult);
            return excelCheckResult;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysStaff::getId, (Collection)datas.stream().map(StaffExtendExcel::getStaffId).collect(Collectors.toList()));
        List staffDbList = this.sysStaffService.list((Wrapper)queryWrapper);
        HashMap<Long, List<ExtendStaffInfoVo>> staffOrganMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)staffDbList)) {
            List<Long> staffIds = staffDbList.stream().map(u -> Long.valueOf(u.getUserId())).collect(Collectors.toList());
            List<ExtendStaffInfoVo> staffOrganDbList = this.hussarBaseStaffExtendWebMapper.getStaffInfoWithOrganById(staffIds);
            staffOrganMap = staffOrganDbList.stream().collect(Collectors.groupingBy(e -> Long.parseLong(e.getStaffId())));
        }
        List organDataDbList = this.sysStruMapper.getOrganExcelByStruIds(null, null);
        Map<String, OrganExcel> fullOrganNameMap = organDataDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, o -> o));
        this.checkDataInDb(datas, successDataList, newDataList, updateDataList, existDataList, errorDataList, fullOrganNameMap, staffOrganMap);
        staffExtendExcelCheckResult.setRootNum(datas.size());
        staffExtendExcelCheckResult.setErrorNum(errorDataList.size());
        staffExtendExcelCheckResult.setNewNum(newDataList.size());
        staffExtendExcelCheckResult.setUpdateNum(updateDataList.size());
        staffExtendExcelCheckResult.setExistNum(existDataList.size());
        ExcelCheckResult excelCheckResult = new ExcelCheckResult(rootDataList, successDataList, errorDataList, newDataList, updateDataList, existDataList);
        excelCheckResult.setCheckMsg((Object)staffExtendExcelCheckResult);
        return excelCheckResult;
    }

    @Override
    @HussarTransactional
    public void saveData(List<StaffExtendExcel> datas, List<Object> otherParams) {
        ArrayList<SysStaff> sysStaffs = new ArrayList<SysStaff>();
        ArrayList<SysStruStaff> sysStruStaffs = new ArrayList<SysStruStaff>();
        this.initUserAndStaff(datas, sysStaffs, sysStruStaffs);
        this.sysStaffService.saveBatch(sysStaffs);
        this.sysStruStaffService.saveBatch(sysStruStaffs);
    }

    private void initUserAndStaff(List<StaffExtendExcel> staffExtendExcels, List<SysStaff> sysStaffs, List<SysStruStaff> struStaffs) {
        List organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, staffExtendExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity()));
        Integer maxStaffOrder = this.sysStaffMapper.getMaxOrder();
        maxStaffOrder = HussarUtils.isEmpty((Object)maxStaffOrder) ? 1 : maxStaffOrder;
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        for (StaffExtendExcel entry : staffExtendExcels) {
            SysStaff staff = new SysStaff();
            staff.setId(Long.valueOf(entry.getStaffId()));
            BeanUtil.copy((Object)entry, (Object)staff);
            if (HussarUtils.isEmpty((Object)staff.getStaffCode())) {
                staff.setStaffCode(this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF"));
            }
            maxStaffOrder = maxStaffOrder + 1;
            staff.setStaffOrder(maxStaffOrder);
            staff.setStaffPosition(HussarUtils.isEmpty((Object)dicMap.get(entry.getStaffPosition())) ? entry.getStaffPosition() : dicMap.get(entry.getStaffPosition()));
            sysStaffs.add(staff);
            this.initStruUserAndStaff(entry, struStaffs, organDbMap);
        }
    }

    private void initStruUserAndStaff(StaffExtendExcel staffExtendExcel, List<SysStruStaff> struStaffs, Map<String, OrganExcel> organDbMap) {
        String deptName = staffExtendExcel.getDepartment();
        String[] depts = deptName.split(",");
        for (int i = 0; i < depts.length; ++i) {
            OrganExcel organExcel = organDbMap.get(depts[i]);
            if (!HussarUtils.isNotEmpty((Object)organExcel)) continue;
            this.addRelation(staffExtendExcel, organExcel, struStaffs);
        }
    }

    private void addRelation(StaffExtendExcel staffExtendExcel, OrganExcel organExcel, List<SysStruStaff> struStaffs) {
        SysStruStaff struStaff = new SysStruStaff();
        struStaff.setStruId(Long.valueOf(Long.parseLong(organExcel.getStruId())));
        struStaff.setStaffId(Long.valueOf(staffExtendExcel.getStaffId()));
        struStaffs.add(struStaff);
    }

    @Override
    @HussarTransactional
    public void updateData(List<StaffExtendExcel> datas, List<Object> otherParams) {
        ArrayList sysStruUsers = new ArrayList();
        ArrayList<SysStruStaff> sysStruStaffs = new ArrayList<SysStruStaff>();
        List staffIds = datas.stream().map(StaffExtendExcel::getStaffId).map(Long::parseLong).collect(Collectors.toList());
        List sysStaffs = this.sysStaffService.list((Wrapper)new LambdaQueryWrapper().in(SysStaff::getId, staffIds));
        this.initEditStruUserAndStaff(datas, sysStaffs, sysStruStaffs);
        String organProperty = HussarUtils.equals((Object)"0", (Object)datas.get(0).getOrganProperty()) ? "1" : "0";
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysStruStaff::getStaffId, staffIds);
        List organByStaffIds = this.sysStruStaffService.list((Wrapper)queryWrapper);
        List struIds = organByStaffIds.stream().map(SysStruStaff::getStruId).distinct().collect(Collectors.toList());
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruStaff::getStaffId, staffIds);
        if (HussarUtils.isNotEmpty(struIds)) {
            lambdaQueryWrapper.notIn(SysStruStaff::getStruId, struIds);
        }
        this.sysStruStaffService.remove((Wrapper)lambdaQueryWrapper);
        this.sysStaffService.updateBatchById((Collection)sysStaffs);
        this.sysStruStaffService.saveBatch(sysStruStaffs);
    }

    private void initEditStruUserAndStaff(List<StaffExtendExcel> staffExtendExcels, List<SysStaff> sysStaffs, List<SysStruStaff> struStaffs) {
        List organExcelDbList = this.sysStruMapper.getOrganExcelByStruIds(null, staffExtendExcels.get(0).getOrganProperty());
        Map<String, OrganExcel> organDbMap = organExcelDbList.stream().collect(Collectors.toMap(OrganExcel::getOrganFName, Function.identity()));
        Map staffExtendExcelMap = staffExtendExcels.stream().collect(Collectors.toMap(StaffExtendExcel::getStaffId, Function.identity()));
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getLabel, DicVo::getValue));
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        SysBaseConfig failNumberConfig = iSysBaseConfigService.getSysBaseConfig(HussarContextHolder.getConnName(), "fail_number");
        String tryLoginTime = failNumberConfig.getConfigValue();
        int lockTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        for (SysStaff staff : sysStaffs) {
            StaffExtendExcel staffExtendExcel = (StaffExtendExcel)staffExtendExcelMap.get(staff.getId());
            staffExtendExcel.setStaffCode(staff.getStaffCode());
            BeanUtil.copy((Object)staffExtendExcel, (Object)staff);
            staff.setName(staffExtendExcel.getUserName());
            staff.setStaffPosition(HussarUtils.isEmpty((Object)dicMap.get(staff.getStaffPosition())) ? staff.getStaffPosition() : dicMap.get(staff.getStaffPosition()));
            this.initStruUserAndStaff(staffExtendExcel, struStaffs, organDbMap);
        }
    }

    private void initUserMap(List<StaffExtendExcel> datas, Map<String, Long> staffIdNumMap, Map<String, Long> staffCodeNumMap) {
        for (StaffExtendExcel staffExtendExcel : datas) {
            String staffCode;
            String staffId = staffExtendExcel.getStaffId();
            if (HussarUtils.isNotEmpty((Object)staffId)) {
                Long staffIdNum = staffIdNumMap.get(staffId);
                staffIdNum = HussarUtils.isEmpty((Object)staffIdNum) ? 1L : staffIdNum + 1L;
                staffIdNumMap.put(staffId, staffIdNum);
            }
            if (!HussarUtils.isNotEmpty((Object)(staffCode = staffExtendExcel.getStaffCode()))) continue;
            Long staffCodeNum = staffCodeNumMap.get(staffCode);
            staffCodeNum = HussarUtils.isEmpty((Object)staffCodeNum) ? 1L : staffCodeNum + 1L;
            staffCodeNumMap.put(staffCode, staffCodeNum);
        }
    }

    private void checkDataInExcel(List<StaffExtendExcel> datas, List<ExcelImportMsg<StaffExtendExcel>> errorDataList, Map<String, Long> staffCodeNumMap, Map<String, Long> staffIdNumMap) {
        for (int i = 0; i < datas.size(); ++i) {
            String staffCode;
            StaffExtendExcel staffExtendExcel = datas.get(i);
            Map cellErrColMap = HussarBaseExcelValidateHelper.validateEntity((Object)staffExtendExcel, (Integer)i);
            String staffId = staffExtendExcel.getStaffId();
            if (HussarUtils.isNotEmpty((Object)staffId) && staffIdNumMap.get(staffId) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)24, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_PRIMARY_KEY_DUPLICATION.getMessage()), (Map)cellErrColMap);
            }
            if (HussarUtils.isNotEmpty((Object)(staffCode = staffExtendExcel.getStaffCode())) && staffCodeNumMap.get(staffCode) > 1L) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)16, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_PERSONNEL_CODE_DUPLICATED.getMessage()), (Map)cellErrColMap);
            }
            this.checkExcelForParentOrgan(i, staffExtendExcel.getDepartment(), cellErrColMap);
            this.checkDate(i, staffExtendExcel.getBirthday(), 18, cellErrColMap);
            this.checkDate(i, staffExtendExcel.getWorkDate(), 20, cellErrColMap);
            this.checkDate(i, staffExtendExcel.getGraduateDate(), 21, cellErrColMap);
            this.sysDicService.checkExcelPrimaryKey(Integer.valueOf(i), staffExtendExcel.getStaffId(), Integer.valueOf(24), cellErrColMap, "user");
            if (!HussarUtils.isNotEmpty((Object)cellErrColMap)) continue;
            errorDataList.add((ExcelImportMsg<StaffExtendExcel>)new ExcelImportMsg((Object)staffExtendExcel, cellErrColMap));
        }
    }

    private boolean isInIntegerRange(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private void checkExcelForParentOrgan(int i, String departmentNames, Map<Integer, Map<Integer, String>> cellErrColMap) {
        List<String> deptNames = Arrays.asList(departmentNames.split(","));
        if (HussarUtils.isEmpty(deptNames)) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_ORGAN_EMPTY.getMessage()), cellErrColMap);
            return;
        }
        String regex = "^(?:/[^/]+)+$";
        Pattern pattern = Pattern.compile(regex);
        for (String deptName : deptNames) {
            Matcher matcher = pattern.matcher(deptName);
            if (matcher.matches()) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORGAN_NAME_FORMAT_FALSE.getMessage()), cellErrColMap);
            break;
        }
    }

    private void checkDataInDb(List<StaffExtendExcel> datas, List<StaffExtendExcel> successDataList, List<ExcelImportMsg<StaffExtendExcel>> newDataList, List<ExcelImportMsg<StaffExtendExcel>> updateDataList, List<ExcelImportMsg<StaffExtendExcel>> existDataList, List<ExcelImportMsg<StaffExtendExcel>> errorDataList, Map<String, OrganExcel> fullOrganNameMap, Map<Long, List<ExtendStaffInfoVo>> staffOrganMap) {
        List dicVos = this.sysDicRefService.getDicListByType("staff_position");
        Map<String, String> dicMap = dicVos.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        ArrayList<String> staffCodeDbList = new ArrayList();
        List staffDbList = this.sysStaffService.list();
        HashMap<String, SysStaff> staffDbMap = new HashMap();
        if (HussarUtils.isNotEmpty((Object)staffDbList)) {
            staffCodeDbList = staffDbList.stream().map(SysStaff::getStaffCode).collect(Collectors.toList());
            staffDbMap = staffDbList.stream().collect(Collectors.toMap(o -> o.getId().toString(), Function.identity()));
        }
        for (int i = 0; i < datas.size(); ++i) {
            StaffExtendExcel staffExtendExcel = datas.get(i);
            HashMap<Integer, Map<Integer, String>> cellErrColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellUpdateColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellNewColMap = new HashMap<Integer, Map<Integer, String>>();
            HashMap<Integer, Map<Integer, String>> cellExitColMap = new HashMap<Integer, Map<Integer, String>>();
            this.checkOrganForExist(i, staffExtendExcel, fullOrganNameMap, cellErrColMap);
            this.checkUserForExit(i, staffExtendExcel, staffDbMap, cellNewColMap, cellExitColMap, cellUpdateColMap, staffOrganMap, cellErrColMap, dicMap, staffCodeDbList);
            if (cellErrColMap.isEmpty()) {
                successDataList.add(staffExtendExcel);
            }
            if (HussarUtils.isNotEmpty(cellErrColMap)) {
                errorDataList.add((ExcelImportMsg<StaffExtendExcel>)new ExcelImportMsg((Object)staffExtendExcel, cellErrColMap));
            }
            if (HussarUtils.isNotEmpty(cellExitColMap)) {
                existDataList.add((ExcelImportMsg<StaffExtendExcel>)new ExcelImportMsg((Object)staffExtendExcel, cellExitColMap));
            }
            if (HussarUtils.isNotEmpty(cellUpdateColMap)) {
                updateDataList.add((ExcelImportMsg<StaffExtendExcel>)new ExcelImportMsg((Object)staffExtendExcel, cellUpdateColMap));
            }
            if (!HussarUtils.isNotEmpty(cellNewColMap)) continue;
            newDataList.add((ExcelImportMsg<StaffExtendExcel>)new ExcelImportMsg((Object)staffExtendExcel, cellNewColMap));
        }
    }

    private void checkOrganForExist(int i, StaffExtendExcel staffExtendExcel, Map<String, OrganExcel> fullNameOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String[] deptNames;
        String departmentName = staffExtendExcel.getDepartment();
        for (String deptName : deptNames = departmentName.split(",")) {
            if (!HussarUtils.isEmpty((Object)fullNameOrganMap.get(deptName))) continue;
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)2, (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ORG_NAME_NOT_EXSIT.getMessage()) + deptName), cellErrColMap);
            break;
        }
    }

    private void checkUserForExit(int i, StaffExtendExcel staffExtendExcel, Map<String, SysStaff> staffDbMap, Map<Integer, Map<Integer, String>> cellNewColMap, Map<Integer, Map<Integer, String>> cellExitColMap, Map<Integer, Map<Integer, String>> cellUpdateColMap, Map<Long, List<ExtendStaffInfoVo>> staffOrganMap, Map<Integer, Map<Integer, String>> cellErrColMap, Map<String, String> dicMap, List<String> staffCodeDbList) {
        SysStaff staffDb;
        String staffId = staffExtendExcel.getStaffId();
        boolean exitFlag = true;
        String staffPosition = dicMap.get((staffDb = staffDbMap.get(staffId)).getStaffPosition());
        staffDb.setStaffPosition(HussarUtils.isEmpty((Object)staffPosition) ? "" : staffPosition);
        List<String> deptNames = Arrays.asList(staffExtendExcel.getDepartment().split(","));
        List<ExtendStaffInfoVo> staffOrgans = staffOrganMap.get(Long.parseLong(staffId));
        if (HussarUtils.isEmpty(staffOrgans)) {
            HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
            HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
        } else {
            if (staffOrgans.size() == deptNames.size()) {
                for (ExtendStaffInfoVo organ : staffOrgans) {
                    if (deptNames.contains(organ.getOrganFname())) continue;
                    exitFlag = false;
                    break;
                }
            }
            if (exitFlag) {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
            } else {
                HussarBaseExcelValidateHelper.addExistMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_HAS_SAME_DATA_IN_PLATFORM.getMessage()), cellExitColMap);
                HussarBaseExcelValidateHelper.addUpdateMsg((int)i, (int)0, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_IS_UPDATE_DATA.getMessage()), cellUpdateColMap);
            }
        }
    }

    @Override
    public List<StaffExtendExcel> handleDataBeforeImport(List<StaffExtendExcel> list, Long taskId) {
        if (HussarUtils.isEmpty(list)) {
            return list;
        }
        list.forEach(staffExtendExcel -> {
            staffExtendExcel.setWorkDate(this.handleDateFormat(staffExtendExcel.getWorkDate()));
            staffExtendExcel.setBirthday(this.handleDateFormat(staffExtendExcel.getBirthday()));
            staffExtendExcel.setGraduateDate(this.handleDateFormat(staffExtendExcel.getGraduateDate()));
        });
        return list;
    }

    private String handleDateFormat(String dateStr) {
        if (HussarUtils.isBlank((CharSequence)dateStr)) {
            return "";
        }
        return dateStr.replace("/", "-");
    }

    private void checkDate(Integer i, String date, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        if (HussarUtils.isBlank((CharSequence)date)) {
            return;
        }
        String tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_BIRTH.getMessage());
        if (HussarUtils.equals((Object)20, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_EMPLOYMENT.getMessage());
        } else if (HussarUtils.equals((Object)21, (Object)index)) {
            tip = TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_GRADUATION.getMessage());
        }
        try {
            Java8DateUtils.convertStringToLocalDate((String)date);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_DATE_TIME_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
        }
    }

    private void checkNumber(Integer i, String num, Integer index, Map<Integer, Map<Integer, String>> cellErrColMap) {
        String tip;
        String string = tip = HussarUtils.equals((Object)3, (Object)index) ? TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_MAX_SESSION.getMessage()) : TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_USER_SORT.getMessage());
        if (HussarUtils.isBlank((CharSequence)num)) {
            if (HussarUtils.equals((Object)3, (Object)index)) {
                HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_IS_REQUIRED.getMessage())), cellErrColMap);
            } else {
                return;
            }
        }
        try {
            Integer.parseInt(num);
        }
        catch (Exception e) {
            HussarBaseExcelValidateHelper.addErrorMsg((int)i, (int)index, (String)(tip + TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXCEL_NUMBER_NOT_CONFORM_FORMAT.getMessage())), cellErrColMap);
        }
    }

    private void addLockUserCache(SysUsers user, SecureErr errMode, String tryLoginTime, int lockTime) {
        UserLockModel lockModel = new UserLockModel();
        lockModel.setUserId(String.valueOf(user.getId()));
        lockModel.setUserName(String.valueOf(user.getUserName()));
        lockModel.getSecureErrList().add(errMode);
        lockModel.setFailNum(Integer.parseInt(tryLoginTime));
        lockModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
        lockModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)lockTime));
        HussarCacheUtil.put((String)"Login_Lock", (Object)lockModel.getUserId(), (Object)lockModel, (long)((long)lockTime * 60L));
    }
}

