/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.authorization.audit.model.SysStruAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUserIpAudit;
import com.jxdinfo.hussar.authorization.audit.model.SysUsersAudit;
import com.jxdinfo.hussar.authorization.audit.service.ISysStaffAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysStruAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUserIpAuditService;
import com.jxdinfo.hussar.authorization.audit.service.ISysUsersAuditService;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.extend.dao.HussarBaseUserExtendWebMapper;
import com.jxdinfo.hussar.authorization.extend.model.UserExtendExcel;
import com.jxdinfo.hussar.authorization.extend.service.IHussarBaseUserExtendWebService;
import com.jxdinfo.hussar.authorization.extend.service.ImportExcelUserExtendManager;
import com.jxdinfo.hussar.authorization.extend.vo.ExtendUserInfoVo;
import com.jxdinfo.hussar.authorization.organ.constants.OrganConstants;
import com.jxdinfo.hussar.authorization.organ.manager.QueryOrganizationManager;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ILocalOrganizationBoService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.util.CreateUserSendMailUtil;
import com.jxdinfo.hussar.authorization.permit.dto.AddUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.EditUserDto;
import com.jxdinfo.hussar.authorization.permit.dto.UserActivateDto;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentBusiTypeEnum;
import com.jxdinfo.hussar.authorization.permit.enums.UserAttachmentFileTypeEnum;
import com.jxdinfo.hussar.authorization.permit.manager.DeleteUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.SortUserManager;
import com.jxdinfo.hussar.authorization.permit.manager.ValidateUserManager;
import com.jxdinfo.hussar.authorization.permit.model.SysUserAttachment;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserAttachmentService;
import com.jxdinfo.hussar.authorization.permit.service.ISysConfRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.service.impl.FunctionRoleUserAuthorizationChangeReporter;
import com.jxdinfo.hussar.authorization.permit.util.UserLogoutCacheUtil;
import com.jxdinfo.hussar.authorization.permit.vo.SysUserAttachmentVo;
import com.jxdinfo.hussar.authorization.permit.vo.UserOrganPostVo;
import com.jxdinfo.hussar.authorization.post.model.SysPost;
import com.jxdinfo.hussar.authorization.post.service.IHussarBasePostService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruPost;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUserAudit;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPost;
import com.jxdinfo.hussar.authorization.relational.model.SysUserPostAudit;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruPostService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostAuditService;
import com.jxdinfo.hussar.authorization.relational.service.ISysUserPostService;
import com.jxdinfo.hussar.authorization.sysuserip.model.SysUserIp;
import com.jxdinfo.hussar.authorization.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysAuditConfigService;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.enums.Whether;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.GeneratePassword;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.model.ExcelCheckResult;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.iam.data.change.notify.core.enums.DataChangeType;
import com.jxdinfo.hussar.iam.data.change.notify.server.service.impl.usermanager.UserChangeNotify;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import com.jxdinfo.hussar.pinyin.service.IConvertPinyinService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.JsonUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.utils.TranslateUtil;
import com.jxdinfo.hussar.validator.service.IHussarValidateService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorizationextend.user.impl.hussarBaseExtendServiceImpl")
@HussarTokenDs
public class HussarBaseUserExtendWebWebServiceImpl
implements IHussarBaseUserExtendWebService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseUserExtendWebWebServiceImpl.class);
    @Resource
    private DeleteUserManager deleteUserManager;
    @Resource
    private SortUserManager sortUserManager;
    @Autowired
    private ValidateUserManager validateUserManager;
    @Autowired
    protected IHussarValidateService validateService;
    @Autowired
    protected ISysConfRolesService sysConfRolesService;
    @Autowired
    protected ISysAuditConfigService sysAuditConfig;
    @Autowired
    protected ISysStruUserAuditService sysStruUserAuditService;
    @Autowired
    protected ISysUserPostAuditService sysUserPostAuditService;
    @Autowired
    protected ISysStruUserService sysStruUserService;
    @Autowired
    protected ISysUserPostService sysUserPostService;
    @Resource
    protected ISysUsersService sysUsersService;
    @Autowired
    protected ISysStaffService sysStaffService;
    @Autowired
    private IConvertPinyinService convertPinyinService;
    @Autowired
    protected IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    protected IHussarBasePostService hussarBasePostService;
    @Resource
    private ISysStruPostService sysStruPostService;
    @Autowired
    protected ISysUserIpService sysUserIpService;
    @Autowired
    protected ISysUsersAuditService sysUsersAuditService;
    @Resource
    protected AbstractOTPCredentialsMatcher abstractOtpCredentialsMatcher;
    @Autowired
    protected IHussarPwdConfigService hussarPwdConfigService;
    @Autowired
    protected ICreateUserConfigService createUserConfigService;
    @Resource
    protected AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    protected UserChangeNotify userChangeNotify;
    @Autowired
    protected ISysStruAuditService sysStruAuditService;
    @Autowired
    protected ISysUserIpAuditService sysUserIpAuditService;
    @Autowired
    private IHussarBaseUserAttachmentService userAttachmentService;
    @Resource
    private FunctionRoleUserAuthorizationChangeReporter functionRoleUserAuthorizationChangeReporter;
    @Autowired
    protected ISysStaffAuditService sysStaffAuditService;
    @Autowired
    protected ISysUserroleAuditService sysUserroleAuditService;
    @Autowired
    protected HussarBaseUserExtendWebMapper hussarBaseUserExtendWebMapper;
    @Autowired
    private ISysRolesService sysRolesService;
    @Autowired
    protected ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserIpService userIpService;
    @Autowired
    protected ISysDicRefService sysDicRefService;
    @Autowired
    private ILocalOrganizationBoService localOrganizationBoService;
    @Autowired
    private QueryOrganizationManager queryOrganizationManager;
    @Autowired
    private ImportExcelUserExtendManager importExcelUserExtendManager;
    protected static final String ADD = "1";
    protected static final String DELETE = "2";

    public ApiResponse<String> sortUser(List<Long> idList) {
        this.sortUserManager.sortUser(idList);
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_SORTING.getMessage()));
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.SORT_SUCCESS.getMessage()));
    }

    public ApiResponse<String> deleteUser(String ids) {
        List idList = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        for (Long id : idList) {
            this.deleteUserManager.deleteUser(id);
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public void saveUsersPost(EditUserDto editUserDto) {
        this.checkRelation(editUserDto);
        Long userId = editUserDto.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.saveUserPostAudit(editUserDto, userId);
        } else {
            this.saveUserPost(editUserDto, userId);
        }
    }

    public void saveUsersRole(EditUserDto editUserDto) {
        long id = editUserDto.getId();
        String roleIds = editUserDto.getRoleIds();
        ArrayList<Object> listRoles = new ArrayList<Object>();
        if (HussarUtils.isNotBlank((CharSequence)roleIds)) {
            Object[] temp = (Long[])ConvertUtils.convert((String[])roleIds.split(","), Long.class);
            if (!ArrayUtils.contains((Object[])temp, (Object)SysUserAndRole.PUBLIC_ROLE.getValue())) {
                listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
            }
            listRoles.addAll(Arrays.asList(temp));
        } else {
            listRoles.add(SysUserAndRole.PUBLIC_ROLE.getValue());
        }
        Long[] roleIdsArray = listRoles.toArray(new Long[0]);
        this.checkIncludeConfRole(roleIdsArray, "edit");
        boolean userRoleAuditFlag = this.processRoleAuditIfNecessary(id, roleIdsArray);
    }

    public void saveUsersStru(EditUserDto editUserDto) {
        Long userId = editUserDto.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.saveStruUserAudit(editUserDto, userId);
        } else {
            this.saveStruUser(editUserDto, userId);
        }
    }

    public ApiResponse<String> saveUsersStaff(EditUserDto editUserDto) {
        long id = editUserDto.getId();
        SysUsers user = this.sysUsersService.getById(Long.valueOf(id));
        Long employeeId = editUserDto.getEmployeeId();
        SysStaff sysStaff = (SysStaff)this.sysStaffService.getById((Serializable)employeeId);
        user.setUserName(sysStaff.getName());
        user.setUserNamePinyinFull(this.convertPinyinService.getNameFullPinyin(sysStaff.getName()));
        user.setUserNamePinyinInitial(this.convertPinyinService.getNameInitialsPinyin(sysStaff.getName()));
        user.setEmployeeId(employeeId);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.doProcessUserAuditEditStaff(user, null);
        } else {
            Long userId = user.getId();
            LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)lambdaUpdateWrapper.set(SysUsers::getEmployeeId, (Object)user.getEmployeeId())).set(SysUsers::getUserName, (Object)user.getUserName())).set(SysUsers::getUserNamePinyinFull, (Object)this.convertPinyinService.getNameFullPinyin(user.getUserName()))).set(SysUsers::getUserNamePinyinInitial, (Object)this.convertPinyinService.getNameInitialsPinyin(user.getUserName()))).eq(SysUsers::getId, (Object)userId);
            this.sysUsersService.update(null, (Wrapper)lambdaUpdateWrapper);
        }
        String userName = sysStaff.getName();
        return ApiResponse.success((Object)userName, (String)"");
    }

    @HussarTransactional
    public ApiResponse<Long> addUserBaseInfo(AddUserDto addUserDto) {
        String allowedIps = StringUtils.trimToEmpty((String)addUserDto.getAllowedIps());
        SysUsers user = this.initialization(addUserDto);
        this.handleRelation(user, addUserDto);
        boolean tenantFlag = this.isCanAdd(user);
        this.userAuditDataExists(user.getUserAccount());
        String secure = this.wrapUser(user);
        String result = this.processAuditIfNecessary(tenantFlag, user, allowedIps, secure);
        if (addUserDto.getUserSignFileId() != null && addUserDto.getUserSignFileId() > 0L) {
            this.saveUserSignPic(addUserDto, user.getId());
        }
        return ApiResponse.success((Object)user.getId(), (String)result);
    }

    @HussarTransactional
    public ApiResponse<Long> editUserBaseInfo(EditUserDto editUserDto) {
        String allowedIps = StringUtils.trimToEmpty((String)editUserDto.getAllowedIps());
        SysUsers user = this.initialization(editUserDto);
        String result = this.processAuditIfNecessaryEdit(user, allowedIps, editUserDto.isNeedAudit());
        this.editUserSignPic(editUserDto, user.getId());
        return ApiResponse.success((Object)user.getId(), (String)result);
    }

    @HussarTransactional
    public ApiResponse<String> dormancyUserExtend(Long id, LocalDateTime lockTime) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_DORMANCY_THIS_USER.getMessage()), (Object)id);
        SysUsers sysUsers = this.sysUsersService.getById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        sysUsers.setAccountStatus(UserStatus.DORMANCY.getCode());
        sysUsers.setLockTime(lockTime);
        this.sysUsersService.updateById((Object)sysUsers);
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        String accountStatus = UserStatus.DORMANCY.getCode();
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.DORMANCY_SUCCESS.getMessage()));
    }

    public ApiResponse<String> activateUserExtend(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_THIS_USER.getMessage()), (Object)id);
        SysUsers sysUsers = this.sysUsersService.getById(id);
        AssertUtil.isNotNull((Object)sysUsers, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        this.dealLock(sysUsers);
        boolean flag = true;
        if ("0".equals(sysUsers.getTypeProperty())) {
            LocalDateTime nowDay = LocalDateTime.now();
            LocalDateTime expiredDay = sysUsers.getExpiredTime();
            LocalDateTime startDay = sysUsers.getStartTime();
            flag = nowDay.isAfter(startDay);
            if (flag) {
                flag = expiredDay.isAfter(nowDay);
            }
        }
        if (!flag) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.TMP_ACCOUNT_CANNOT_ACTIVE.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_FAIL_EXIST_REVIEW.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("5");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        this.sysUsersService.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)id));
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ACTIVATE_SUCCESS.getMessage()));
    }

    public ApiResponse<String> activateTempUserExtend(UserActivateDto activateDto) {
        LOGGER.info("\u6fc0\u6d3b\u7528\u6237\uff1a{}", (Object)activateDto.getId());
        SysUsers sysUsers = this.sysUsersService.getById(activateDto.getId());
        AssertUtil.isNotNull((Object)sysUsers, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        AssertUtil.isNotNull((Object)activateDto.getEndTime(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        this.dealLock(sysUsers);
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(activateDto.getId())) {
            throw new BaseException("\u6fc0\u6d3b\u5931\u8d25\uff01\u5b58\u5728\u672a\u5ba1\u6838\u7684\u7533\u8bf7\uff01");
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            SysUsersAudit sysUsersAudit = new SysUsersAudit();
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUsers);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUsers.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("5");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return ApiResponse.success((String)"\u6fc0\u6d3b\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
        }
        LocalDateTime endTime = Java8DateUtils.convertStringToLocalDateTime((String)StringUtils.trimToEmpty((String)activateDto.getEndTime()));
        AssertUtil.isNotNull((Object)endTime, (String)"\u7ed3\u675f\u65f6\u95f4\u83b7\u53d6\u5f02\u5e38");
        this.sysUsersService.update(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(SysUsers::getAccountStatus, (Object)UserStatus.OK.getCode())).set(SysUsers::getLastLoginTime, (Object)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()))).set(SysUsers::getExpiredTime, (Object)Date.from(endTime.atZone(ZoneId.systemDefault()).toInstant()))).eq(SysUsers::getId, (Object)activateDto.getId()));
        sysUsers.setAccountStatus(UserStatus.OK.getCode());
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUsers});
        return ApiResponse.success((String)"\u6fc0\u6d3b\u6210\u529f\uff01");
    }

    public ApiResponse<List<ExtendUserInfoVo>> getUserInfo(String struId) {
        List<ExtendUserInfoVo> userInfoVoList;
        ArrayList result = new ArrayList();
        Long parentId = null;
        if (HussarUtils.isNotEmpty((Object)struId)) {
            parentId = Long.parseLong(struId);
        }
        if (HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, parentId) || HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
            if (HussarUtils.isEmpty((Object)EngineUtil.getUser())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"personalCenter.loginAgain"));
            }
            SecurityUser securityUser = BaseSecurityUtil.getUser((String)EngineUtil.getUser().getAccessToken());
            if (HussarUtils.isEmpty((Object)(parentId = this.queryOrganizationManager.getGradeOrganType(parentId, securityUser)))) {
                return ApiResponse.success(result);
            }
            if (!HussarUtils.equals((Object)OrganConstants.ROOT_ORGAN_ID, (Object)parentId) && !HussarUtils.equals((Object)Constants.OUT_STRU_NODE_ID, (Object)parentId)) {
                struId = parentId.toString();
            }
        }
        if ("11".equals(struId)) {
            userInfoVoList = this.validateOrganFname(this.hussarBaseUserExtendWebMapper.getUserInfo(null, "0"));
            return ApiResponse.success(userInfoVoList);
        }
        if ("12".equals(struId)) {
            userInfoVoList = this.validateOrganFname(this.hussarBaseUserExtendWebMapper.getUserInfo(null, ADD));
            return ApiResponse.success(userInfoVoList);
        }
        String struFid = "";
        if (HussarUtils.isNotEmpty((Object)struId)) {
            struFid = "%/" + struId + "/%";
        }
        List<ExtendUserInfoVo> userInfoVoList2 = this.validateOrganFname(this.hussarBaseUserExtendWebMapper.getUserInfo(struFid, null));
        return ApiResponse.success(userInfoVoList2);
    }

    private List<ExtendUserInfoVo> validateOrganFname(List<ExtendUserInfoVo> extendUserInfoVoList) {
        if (HussarUtils.isNotEmpty(extendUserInfoVoList)) {
            ArrayList<ExtendUserInfoVo> resultVoList = new ArrayList<ExtendUserInfoVo>();
            Map<String, List<ExtendUserInfoVo>> userInfoMap = extendUserInfoVoList.stream().collect(Collectors.groupingBy(ExtendUserInfoVo::getUserId));
            for (String key : userInfoMap.keySet()) {
                List<ExtendUserInfoVo> userInfoVoList = userInfoMap.get(key);
                StringBuilder organFname = new StringBuilder(userInfoVoList.get(0).getOrganFname());
                for (int i = 1; i < userInfoVoList.size(); ++i) {
                    organFname.append(",");
                    organFname.append(userInfoVoList.get(i).getOrganFname());
                }
                userInfoVoList.get(0).setOrganFname(organFname.toString());
                ExtendUserInfoVo extendUserInfoVo = new ExtendUserInfoVo();
                BeanUtils.copyProperties((Object)userInfoVoList.get(0), (Object)extendUserInfoVo);
                resultVoList.add(extendUserInfoVo);
            }
            return resultVoList;
        }
        return extendUserInfoVoList;
    }

    public ApiResponse<List<SysUserIp>> selectUserIpByUserIds(List<Long> userIdList) {
        return ApiResponse.success((Object)this.userIpService.selectUserIpByUserIds(userIdList));
    }

    public ApiResponse<String> cancelUserExtend(Long id) {
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_THIS_USER.getMessage()), (Object)id);
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        SysUsers sysUser = this.sysUsersService.getUser(id);
        AssertUtil.isNotNull((Object)sysUser, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_NOT_FIND_USER_INFO.getMessage()));
        if (Whether.YES.getValue().equals(sysUser.getIsSys())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ADMIN.getMessage()));
        }
        if (shiroUser.getId().equals(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CANCEL_FAIL_ACTIVE_USER.getMessage()));
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(id)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_FAIL_EXIST_REVIEW.getMessage()));
        }
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            CopyPropertieUtils.copyProperties((Object)sysUsersAudit, (Object)sysUser);
            sysUsersAudit.setId(null);
            sysUsersAudit.setUserId(sysUser.getId());
            sysUsersAudit.setIsAudit("0");
            sysUsersAudit.setCurrentStatus("4");
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS_WAIT_REVIEW.getMessage()));
        }
        HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUser.getId()));
        sysUser.setAccountStatus(UserStatus.CANCEL.getCode());
        this.sysUserroleAuditService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)sysUser.getId()));
        this.sysUsersService.updateById((Object)sysUser);
        UserLogoutCacheUtil.kickOutUser((Long)id);
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{sysUser});
        return ApiResponse.success((String)TranslateUtil.getTranslateName((String)TipConstantsEnum.CANCEL_SUCCESS.getMessage()));
    }

    public ApiResponse<String> fillOrganInfos(String jsonStr) {
        List userInfoList = (List)JsonUtil.parse((String)jsonStr, List.class);
        ArrayList userIdList = new ArrayList();
        userInfoList.forEach(o -> userIdList.add(Long.valueOf(o.get("RECORD_ID").toString())));
        List organByUserIds = this.localOrganizationBoService.getOrganByUserIds(userIdList);
        Map<Long, List<UserOrganPostVo>> userOrganMap = organByUserIds.stream().collect(Collectors.groupingBy(UserOrganPostVo::getUserId));
        for (Map vo : userInfoList) {
            List<UserOrganPostVo> organInfoList = userOrganMap.get(Long.valueOf(vo.get("RECORD_ID").toString()));
            if (HussarUtils.isEmpty(organInfoList)) continue;
            String organName = organInfoList.stream().map(UserOrganPostVo::getOrganFname).collect(Collectors.joining(","));
            vo.put("departmentName", organName);
        }
        return ApiResponse.success((Object)JsonUtil.toJson((Object)userInfoList), (String)"");
    }

    public ApiResponse<String> wrapUsers(String jsonStr) {
        boolean flag;
        List userInfoList = (List)JsonUtil.parse((String)jsonStr, List.class);
        List keyList = HussarCacheUtil.getKeysLike((String)"Login_Lock", (String)"?");
        List casKeyList = HussarCacheUtil.getKeysLike((String)"hussar_cas_login_lock", (String)"?");
        List list1 = this.sysDicRefService.getDicListByType("account_state");
        Map<String, String> mapStatus = list1.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        List list2 = this.sysDicRefService.getDicListByType("account_property");
        Map<String, String> mapProperty = list2.stream().collect(Collectors.toMap(DicVo::getValue, DicVo::getLabel));
        boolean bl = flag = HussarUtils.isNotEmpty((Object)keyList) || HussarUtils.isNotEmpty((Object)casKeyList);
        if (HussarUtils.isNotEmpty((Object)userInfoList)) {
            for (Map vo : userInfoList) {
                vo.put("accoutStatusLabel", mapStatus.get(vo.get("ACCOUNT_STATUS").toString()));
                vo.put("accountPropertyName", mapProperty.get(vo.get("TYPE_PROPERTY").toString()));
                if (flag) {
                    Optional<String> optional;
                    if (HussarUtils.isNotEmpty((Object)keyList)) {
                        optional = keyList.parallelStream().filter(item -> item.equalsIgnoreCase(String.valueOf(vo.get("RECORD_ID")))).findAny();
                        ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                            String tmpkey = (String)optional.get();
                            UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)"Login_Lock", (Object)tmpkey);
                            if (null != model && model.getLockTime() != null) {
                                vo.put("ACCOUNT_STATUS", UserStatus.LOCKED.getCode());
                            }
                        });
                    } else if (HussarUtils.isNotEmpty((Object)casKeyList)) {
                        optional = casKeyList.parallelStream().filter(item -> item.contains(String.valueOf(vo.get("RECORD_ID")))).findAny();
                        ConditionUtils.isTrue((boolean)optional.isPresent()).handle(() -> {
                            String tmpkey = (String)optional.get();
                            UserLockModel model = (UserLockModel)JSON.parseObject((String)((String)HussarCacheUtil.get((String)"hussar_cas_login_lock", (Object)tmpkey)), UserLockModel.class);
                            if (null != model && model.getLockTime() != null) {
                                vo.put("ACCOUNT_STATUS", UserStatus.LOCKED.getCode());
                            }
                        });
                    }
                }
                if (!HussarUtils.isNotEmpty(vo.get("EXPIRED_TIME"))) continue;
                vo.put("endTime", Java8DateUtils.convertStringToLocalDateTime((String)vo.get("EXPIRED_TIME").toString()).toLocalDate().toString());
            }
        }
        return ApiResponse.success((Object)JsonUtil.toJson((Object)userInfoList), (String)"");
    }

    public ApiResponse<String> fillUserSignInfos(String jsonStr) {
        List userInfoList = (List)JsonUtil.parse((String)jsonStr, List.class);
        ArrayList userIdList = new ArrayList();
        userInfoList.forEach(o -> userIdList.add(Long.valueOf(o.get("RECORD_ID").toString())));
        List userSignVoList = this.userAttachmentService.listUserSignByUserIds(userIdList);
        Map<Long, List<SysUserAttachmentVo>> userSignMap = userSignVoList.stream().collect(Collectors.groupingBy(SysUserAttachmentVo::getUserId));
        for (Map vo : userInfoList) {
            List<SysUserAttachmentVo> signInfoList = userSignMap.get(Long.valueOf(vo.get("RECORD_ID").toString()));
            if (HussarUtils.isEmpty(signInfoList)) continue;
            if (signInfoList.size() > 1) {
                LOGGER.info("\u5f53\u524d\u7528\u6237\u5b58\u5728\u591a\u4e2a\u7b7e\u540d,\u907f\u514d\u524d\u7aef\u5f02\u5e38\uff0c\u53d6\u7b2c\u4e00\u4e2a===>{}", (Object)Long.valueOf(vo.get("RECORD_ID").toString()));
            }
            SysUserAttachmentVo userAttachmentVo = signInfoList.get(0);
            vo.put("FileType", userAttachmentVo.getFileType());
            vo.put("BusiType", userAttachmentVo.getBusiType());
            vo.put("UserSignImgBase64", userAttachmentVo.getImgBase64());
            vo.put("UserSignFileId", userAttachmentVo.getFileId());
        }
        return ApiResponse.success((Object)JsonUtil.toJson((Object)userInfoList), (String)"");
    }

    public ApiResponse<ExcelCheckResult> saveUserBatch(List<UserExtendExcel> userExtendList) {
        ExcelCheckResult result = this.importExcelUserExtendManager.check(userExtendList, new ArrayList<Object>());
        List errDataList = result.getErrDatas();
        List newDataList = result.getNewDatas();
        List updateDataList = result.getUpdateDatas();
        Object customExcelCheckResult = result.getCheckMsg();
        if (HussarUtils.isNotEmpty((Object)errDataList)) {
            throw new BaseException();
        }
        this.saveOrUpdateImport(newDataList, updateDataList);
        return ApiResponse.success((Object)result);
    }

    public void saveOrUpdateImport(List<UserExtendExcel> newDataList, List<UserExtendExcel> updateDataList) {
        if (newDataList.size() != 0) {
            this.importExcelUserExtendManager.saveData(newDataList, new ArrayList<Object>());
        }
        if (updateDataList.size() != 0) {
            this.importExcelUserExtendManager.updateData(updateDataList, new ArrayList<Object>());
        }
    }

    private void dealLock(SysUsers sysUsers) {
        if (sysUsers != null) {
            HussarCacheUtil.evictKeysLike((String)"Login_Lock", (String)String.valueOf(sysUsers.getId()));
            HussarCacheUtil.evictKeysLike((String)"hussar_cas_login_lock", (String)String.valueOf(sysUsers.getId()));
        }
    }

    protected void checkIncludeConfRole(Long[] idLs, String type) {
        if (HussarUtils.isNotEmpty((Object[])idLs)) {
            boolean flag = this.sysConfRolesService.isIncludeConfRole(idLs);
            if (HussarUtils.equals((Object)"add", (Object)type)) {
                AssertUtil.isFalse((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
            }
            if (HussarUtils.equals((Object)"edit", (Object)type)) {
                AssertUtil.isFalse((boolean)flag, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_THE_ROLE_NO_ALLOW_EXCEED_ROLE_SETS.getMessage()));
            }
        }
    }

    private void checkRelation(EditUserDto editUserDto) {
        Long[] struIdArray = (Long[])ConvertUtils.convert((String[])editUserDto.getStruIds().split(","), Long.class);
        List<Long> struIds = Arrays.asList(struIdArray);
        ArrayList<Long> postIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)editUserDto.getPartPostIds())) {
            Long[] postIdArray = (Long[])ConvertUtils.convert((String[])editUserDto.getPartPostIds().split(","), Long.class);
            postIds.addAll(Arrays.asList(postIdArray));
        }
        postIds.add(editUserDto.getPostId());
        List posts = this.hussarBasePostService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysPost::getId, postIds)).isNotNull(SysPost::getOrganTypeCode)).ne(SysPost::getOrganTypeCode, (Object)""));
        if (HussarUtils.isNotEmpty((Object)posts)) {
            List postIdList = posts.stream().map(SysPost::getId).collect(Collectors.toList());
            List struPosts = this.sysStruPostService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysStruPost::getStruId, struIds)).in(SysStruPost::getPostId, postIdList));
            Map<Long, List<SysStruPost>> postMap = struPosts.stream().collect(Collectors.groupingBy(SysStruPost::getPostId));
            if (!HussarUtils.equals((Object)posts.size(), (Object)postMap.size())) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.EDIT_FAIL_EXIST_RELATE_USER_ORGAN_POST.getMessage()));
            }
        }
    }

    private void handleRelation(SysUsers user, AddUserDto addUserDto) {
        Long userId = user.getId();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.saveStruUserAudit(addUserDto, userId);
        } else {
            this.saveStruUser(addUserDto, userId);
        }
    }

    private void saveUserPostAudit(AddUserDto addUserDto, Long userId) {
        ArrayList<SysUserPostAudit> userPostAudits = new ArrayList<SysUserPostAudit>();
        Long postId = addUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPostAudit userPostAudit = new SysUserPostAudit();
            userPostAudit.setPostId(postId);
            userPostAudit.setUserId(userId);
            userPostAudit.setRelateType("0");
            userPostAudit.setOperateType(ADD);
            userPostAudit.setAuditStatus("0");
            userPostAudits.add(userPostAudit);
        }
        String partPostIds = StringUtils.trimToEmpty((String)addUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPostAudit userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(partPostId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType(ADD);
                userPostAudit.setOperateType(ADD);
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(userPostAudits)) {
            this.sysUserPostAuditService.saveBatch(userPostAudits, userPostAudits.size());
        }
    }

    private void saveStruUserAudit(AddUserDto addUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        ArrayList<SysStruUserAudit> sysStruUserAudits = new ArrayList<SysStruUserAudit>();
        if (HussarUtils.isNotEmpty(struIdList)) {
            for (Long struId : struIdList) {
                SysStruUserAudit sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType(ADD);
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(sysStruUserAudits)) {
            this.sysStruUserAuditService.saveBatch(sysStruUserAudits, sysStruUserAudits.size());
        }
    }

    private void saveStruUser(AddUserDto addUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        LocalDateTime now = LocalDateTime.now();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        for (Long struId : struIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUser.setCreateTime(now);
            struUser.setLastTime(now);
            struUser.setCreator(securityUser.getId());
            struUser.setLastEditor(securityUser.getId());
            struUsers.add(struUser);
        }
        if (HussarUtils.isNotEmpty(struUsers)) {
            this.sysStruUserService.saveBatch(struUsers, struUsers.size());
        }
    }

    private void saveUserPost(AddUserDto addUserDto, Long userId) {
        ArrayList<SysUserPost> userPosts = new ArrayList<SysUserPost>();
        Long postId = addUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPost userPost = new SysUserPost();
            userPost.setPostId(postId);
            userPost.setUserId(userId);
            userPost.setRelateType("0");
            userPosts.add(userPost);
        }
        String partPostIds = StringUtils.trimToEmpty((String)addUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPost userPost = new SysUserPost();
                userPost.setPostId(partPostId);
                userPost.setUserId(userId);
                userPost.setRelateType(ADD);
                userPosts.add(userPost);
            }
        }
        if (HussarUtils.isNotEmpty(userPosts)) {
            this.sysUserPostService.saveBatch(userPosts, userPosts.size());
        }
    }

    private void saveUserPostAudit(EditUserDto editUserDto, Long userId) {
        SysUserPostAudit userPostAudit;
        ArrayList<SysUserPostAudit> userPostAudits = new ArrayList<SysUserPostAudit>();
        List userPostList = this.sysUserPostService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        List oldMainPostIds = userPostList.stream().filter(item -> "0".equals(item.getRelateType())).map(SysUserPost::getPostId).collect(Collectors.toList());
        if (!oldMainPostIds.contains(editUserDto.getPostId())) {
            if (HussarUtils.isNotEmpty(oldMainPostIds)) {
                for (Long postId : oldMainPostIds) {
                    SysUserPostAudit userPostAudit2 = new SysUserPostAudit();
                    userPostAudit2.setPostId(postId);
                    userPostAudit2.setUserId(userId);
                    userPostAudit2.setRelateType("0");
                    userPostAudit2.setOperateType(DELETE);
                    userPostAudit2.setAuditStatus("0");
                    userPostAudits.add(userPostAudit2);
                }
            }
            if (HussarUtils.isNotEmpty((Object)editUserDto.getPostId())) {
                SysUserPostAudit userPostAudit3 = new SysUserPostAudit();
                userPostAudit3.setPostId(editUserDto.getPostId());
                userPostAudit3.setUserId(userId);
                userPostAudit3.setRelateType("0");
                userPostAudit3.setOperateType(ADD);
                userPostAudit3.setAuditStatus("0");
                userPostAudits.add(userPostAudit3);
            }
        }
        String partPostIds = StringUtils.trimToEmpty((String)editUserDto.getPartPostIds());
        ArrayList<Long> newPartPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            newPartPostIdList.addAll(Arrays.asList(temp));
        }
        List oldPartPostIds = userPostList.stream().filter(item -> ADD.equals(item.getRelateType())).map(SysUserPost::getPostId).collect(Collectors.toList());
        List<Object> addPartPostIds = new ArrayList();
        List<Object> delPartPostIds = new ArrayList();
        if (HussarUtils.isEmpty(oldPartPostIds) && HussarUtils.isNotEmpty(newPartPostIdList)) {
            addPartPostIds = newPartPostIdList;
        }
        if (HussarUtils.isEmpty(newPartPostIdList) && HussarUtils.isNotEmpty(oldPartPostIds)) {
            delPartPostIds = oldPartPostIds;
        }
        if (HussarUtils.isNotEmpty(newPartPostIdList) && HussarUtils.isNotEmpty(oldPartPostIds)) {
            addPartPostIds = newPartPostIdList.stream().filter(item -> !oldPartPostIds.contains(item)).collect(Collectors.toList());
            delPartPostIds = oldPartPostIds.stream().filter(item -> !newPartPostIdList.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addPartPostIds)) {
            for (Long postId : addPartPostIds) {
                userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(postId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType(ADD);
                userPostAudit.setOperateType(ADD);
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delPartPostIds)) {
            for (Long postId : delPartPostIds) {
                userPostAudit = new SysUserPostAudit();
                userPostAudit.setPostId(postId);
                userPostAudit.setUserId(userId);
                userPostAudit.setRelateType(ADD);
                userPostAudit.setOperateType(DELETE);
                userPostAudit.setAuditStatus("0");
                userPostAudits.add(userPostAudit);
            }
        }
        if (HussarUtils.isNotEmpty(userPostAudits)) {
            List audits = this.sysUserPostAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserPostAudit::getAuditStatus, (Object)"0")).eq(SysUserPostAudit::getUserId, (Object)userId)).isNotNull(SysUserPostAudit::getPostId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_POST.getMessage()));
            this.sysUserPostAuditService.saveBatch(userPostAudits, userPostAudits.size());
        }
    }

    private void saveStruUserAudit(EditUserDto editUserDto, Long userId) {
        SysStruUserAudit sysStruUserAudit;
        ArrayList<SysStruUserAudit> sysStruUserAudits = new ArrayList<SysStruUserAudit>();
        String struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds());
        ArrayList<Long> newStruIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            newStruIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(newStruIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        List struUserList = this.sysStruUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
        List oldStruIds = struUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList());
        List<Object> addStruIds = new ArrayList();
        List<Object> delStruIds = new ArrayList();
        if (HussarUtils.isEmpty(oldStruIds) && HussarUtils.isNotEmpty(newStruIdList)) {
            addStruIds = newStruIdList;
        }
        if (HussarUtils.isEmpty(newStruIdList) && HussarUtils.isNotEmpty(oldStruIds)) {
            delStruIds = oldStruIds;
        }
        if (HussarUtils.isNotEmpty(newStruIdList) && HussarUtils.isNotEmpty(oldStruIds)) {
            addStruIds = newStruIdList.stream().filter(item -> !oldStruIds.contains(item)).collect(Collectors.toList());
            delStruIds = oldStruIds.stream().filter(item -> !newStruIdList.contains(item)).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(addStruIds) || HussarUtils.isNotEmpty(delStruIds)) {
            List audits = this.sysStruUserAuditService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStruUserAudit::getAuditStatus, (Object)"0")).eq(SysStruUserAudit::getUserId, (Object)userId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
            AssertUtil.isTrue((boolean)HussarUtils.isEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ORGAN.getMessage()));
        }
        if (HussarUtils.isNotEmpty(addStruIds)) {
            for (Long struId : addStruIds) {
                sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType(ADD);
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(delStruIds)) {
            for (Long struId : delStruIds) {
                sysStruUserAudit = new SysStruUserAudit();
                sysStruUserAudit.setStruId(struId);
                sysStruUserAudit.setUserId(userId);
                sysStruUserAudit.setOperateType(DELETE);
                sysStruUserAudit.setAuditStatus("0");
                sysStruUserAudits.add(sysStruUserAudit);
            }
        }
        if (HussarUtils.isNotEmpty(sysStruUserAudits)) {
            this.sysStruUserAuditService.saveBatch(sysStruUserAudits, sysStruUserAudits.size());
        }
    }

    private void saveStruUser(EditUserDto editUserDto, Long userId) {
        String struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds());
        ArrayList<Long> struIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)struIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            struIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isEmpty(struIdList)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_RELATE_ORGAN_NO_EXIST.getMessage()));
        }
        this.sysStruUserService.remove((Wrapper)new LambdaQueryWrapper().eq(SysStruUser::getUserId, (Object)userId));
        ArrayList<SysStruUser> struUsers = new ArrayList<SysStruUser>();
        LocalDateTime now = LocalDateTime.now();
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        for (Long struId : struIdList) {
            SysStruUser struUser = new SysStruUser();
            struUser.setStruId(struId);
            struUser.setUserId(userId);
            struUser.setCreateTime(now);
            struUser.setLastTime(now);
            struUser.setCreator(securityUser.getId());
            struUser.setLastEditor(securityUser.getId());
            struUsers.add(struUser);
        }
        this.sysStruUserService.saveBatch(struUsers, struUsers.size());
    }

    private void saveUserPost(EditUserDto editUserDto, Long userId) {
        this.sysUserPostService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserPost::getUserId, (Object)userId));
        ArrayList<SysUserPost> userPosts = new ArrayList<SysUserPost>();
        Long postId = editUserDto.getPostId();
        if (HussarUtils.isNotEmpty((Object)postId)) {
            SysUserPost userPost = new SysUserPost();
            userPost.setPostId(postId);
            userPost.setUserId(userId);
            userPost.setRelateType("0");
            userPosts.add(userPost);
        }
        String partPostIds = StringUtils.trimToEmpty((String)editUserDto.getPartPostIds());
        ArrayList<Long> partPostIdList = new ArrayList<Long>();
        if (HussarUtils.isNotBlank((CharSequence)partPostIds)) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])partPostIds.split(","), Long.class);
            partPostIdList.addAll(Arrays.asList(temp));
        }
        if (HussarUtils.isNotEmpty(partPostIdList)) {
            for (Long partPostId : partPostIdList) {
                SysUserPost userPost = new SysUserPost();
                userPost.setPostId(partPostId);
                userPost.setUserId(userId);
                userPost.setRelateType(ADD);
                userPosts.add(userPost);
            }
        }
        if (HussarUtils.isNotEmpty(userPosts)) {
            this.sysUserPostService.saveBatch(userPosts, userPosts.size());
        }
    }

    private SysUsers initialization(EditUserDto editUserDto) {
        String struIds;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EDIT_USER_DTO_INITIALIZE_PARAM.getMessage()), (Object)JSON.toJSONString((Object)editUserDto));
        long id = editUserDto.getId();
        SysUsers user = this.sysUsersService.getById(Long.valueOf(id));
        AssertUtil.isNotNull((Object)user, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_NO_EXIST_USER.getMessage()));
        String mail = StringUtils.trimToEmpty((String)editUserDto.getMail());
        Integer maxSessions = editUserDto.getMaxSessions();
        String weChat = StringUtils.trimToEmpty((String)editUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)editUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)editUserDto.getTelephone());
        String accountProperty = StringUtils.trimToEmpty((String)editUserDto.getAccountProperty());
        boolean isLoginTimeLimit = editUserDto.getLoginTimeLimit() != null && editUserDto.getLoginTimeLimit() != false;
        String accessLoginStartTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)editUserDto.getAccessLoginEndTime());
        String startTime = StringUtils.trimToEmpty((String)editUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)editUserDto.getEndTime());
        boolean isLoginIpLimit = editUserDto.getLoginIpLimit() != null && editUserDto.getLoginIpLimit() != false;
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.seteMail(mail);
        user.setTypeProperty(accountProperty);
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setLoginTimeLimit(isLoginTimeLimit ? ADD : "0");
        user.setLoginIpLimit(isLoginIpLimit ? ADD : "0");
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        if (HussarUtils.isNotBlank((CharSequence)(struIds = StringUtils.trimToEmpty((String)editUserDto.getStruIds())))) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            user.setCorporationId(temp[0]);
            user.setDepartmentId(temp[0]);
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            user.setUserAccount(user.getUserAccount().toUpperCase());
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(startTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    user.setAccountStatus(UserStatus.DORMANCY.getCode());
                    user.setLockTime(Java8DateUtils.currentLocalDateTime());
                }
            }
            catch (ParseException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_DATE_FORMAT_ERROR.getMessage()));
            }
        }
        return user;
    }

    private SysUsers initialization(AddUserDto addUserDto) {
        String struIds;
        LOGGER.info(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_DTO_INITIALIZE_PARAM.getMessage()), (Object)JSON.toJSONString((Object)addUserDto));
        SysUsers user = new SysUsers();
        long id = IdWorker.getId((Object)user);
        user.setId(Long.valueOf(id));
        String userAccount = StringUtils.trimToEmpty((String)addUserDto.getUserAccount());
        String mail = StringUtils.trimToEmpty((String)addUserDto.getMail());
        Integer maxSessions = addUserDto.getMaxSessions();
        String weChat = StringUtils.trimToEmpty((String)addUserDto.getWeChat());
        String mobile = StringUtils.trimToEmpty((String)addUserDto.getMobile());
        String telephone = StringUtils.trimToEmpty((String)addUserDto.getTelephone());
        String accountStatus = StringUtils.trimToEmpty((String)addUserDto.getAccountStatus());
        String accountProperty = StringUtils.trimToEmpty((String)addUserDto.getAccountProperty());
        boolean isLoginTimeLimit = addUserDto.getLoginTimeLimit();
        String accessLoginStartTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginStartTime());
        String accessLoginEndTime = StringUtils.trimToEmpty((String)addUserDto.getAccessLoginEndTime());
        String startTime = StringUtils.trimToEmpty((String)addUserDto.getStartTime());
        String endTime = StringUtils.trimToEmpty((String)addUserDto.getEndTime());
        boolean isLoginIpLimit = addUserDto.getLoginIpLimit();
        user.setUserAccount(userAccount);
        user.seteMail(mail);
        user.setAccountStatus(accountStatus);
        user.setTypeProperty(accountProperty);
        user.setSecurityLevel(Integer.valueOf(1));
        user.setIsSys("0");
        user.setIsCpublic("0");
        user.setStartTime(Java8DateUtils.convertStringToLocalDateTime((String)startTime));
        user.setExpiredTime(Java8DateUtils.convertStringToLocalDateTime((String)endTime));
        user.setTelephone(telephone);
        user.setMobile(mobile);
        user.setWeChat(weChat);
        user.setMaxSessions(maxSessions);
        user.setLoginTimeLimit(isLoginTimeLimit ? ADD : "0");
        user.setLoginIpLimit(isLoginIpLimit ? ADD : "0");
        Integer userOrder = this.sysUsersService.getUserMaxOrder();
        userOrder = HussarUtils.isEmpty((Object)userOrder) ? Integer.valueOf(1) : Integer.valueOf(userOrder + 1);
        user.setUserOrder(userOrder);
        if (isLoginTimeLimit) {
            user.setAccessLoginStartTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginStartTime));
            user.setAccessLoginEndTime(Java8DateUtils.convertStringToLocalTime((String)accessLoginEndTime));
        }
        if (HussarUtils.isNotBlank((CharSequence)(struIds = StringUtils.trimToEmpty((String)addUserDto.getStruIds())))) {
            Long[] temp = (Long[])ConvertUtils.convert((String[])struIds.split(","), Long.class);
            user.setCorporationId(temp[0]);
            user.setDepartmentId(temp[0]);
        }
        return user;
    }

    private boolean isCanAdd(SysUsers sysUsers) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ADD_VERIFY.getMessage()));
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue()) {
            sysUsers.setUserAccount(sysUsers.getUserAccount().toUpperCase());
        }
        if (this.isExistAccount(sysUsers.getUserAccount())) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST.getMessage()));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysStruAudit::getRealStruId, (Object)sysUsers.getEmployeeId())).eq(SysStruAudit::getState, (Object)"0");
        Long count = this.sysStruAuditService.count((Wrapper)wrapper);
        if (count > 0L) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_THIS_PERSON_PROHIBIT_UPDATE.getMessage()));
        }
        return true;
    }

    private boolean isExistAccount(String userAccount) {
        return this.sysUsersService.isExistAccount(userAccount);
    }

    private void userAuditDataExists(String userAccount) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_USER_VERIFY_AUDIT.getMessage()));
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(SysUsersAudit::getUserAccount, (Object)userAccount)).eq(SysUsersAudit::getIsAudit, (Object)"0");
        boolean userAccountInAudit = this.sysUsersAuditService.count((Wrapper)wrapper) > 0L;
        AssertUtil.isFalse((boolean)userAccountInAudit, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_FAIL_USER_EXIST_AUDIT.getMessage()));
    }

    private String wrapUser(SysUsers sysUsers) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_FILL_IN_USER_INFO.getMessage()));
        sysUsers.setCorporationId(sysUsers.getDepartmentId());
        sysUsers.setTotpKey(this.abstractOtpCredentialsMatcher.getRandomSecretBase32());
        String secure = "";
        String encodeSecure = "";
        secure = this.hussarPwdConfigService.getDefaultPassword();
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue()) {
            AssertUtil.isNotEmpty((String)sysUsers.geteMail(), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_CREATE_USER_MAST_SEND_EMAIL.getMessage()));
            if (!this.createUserConfigService.getCreateUserUseDefaultPass().booleanValue()) {
                secure = GeneratePassword.generate((String)this.hussarPwdConfigService.getPwdRule());
            }
        }
        if (!this.sysAuditConfig.isCriticalOperationsAudit() || !this.sysAuditConfig.isUserAudit()) {
            encodeSecure = this.credentialsMatcher.passwordEncode(String.valueOf(secure).getBytes());
            sysUsers.setPassword(encodeSecure);
        } else {
            sysUsers.setPassword(secure);
        }
        return secure;
    }

    private String processAuditIfNecessary(boolean tenantFlag, SysUsers sysUsers, String allowedIps, String secure) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_AUDIT_CONSTANT_2.getMessage()));
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.doProcessUserAudit(sysUsers, allowedIps);
        } else {
            this.doProcessUser(tenantFlag, sysUsers, allowedIps, secure);
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.ADD_SUCCESS_WAIT_REVIEW.getMessage()));
        } else {
            stringBuilder.append(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_SUCCESS.getMessage()));
        }
        return stringBuilder.toString();
    }

    private void doProcessUser(boolean tenantFlag, SysUsers sysUsers, String allowedIps, String secure) {
        this.sysUsersService.save((Object)sysUsers);
        this.saveUserIP(sysUsers.getId(), allowedIps);
        if (this.createUserConfigService.getCreateUserSendEmail().booleanValue() && StringUtils.isNotBlank((CharSequence)sysUsers.geteMail())) {
            CreateUserSendMailUtil.sendMail((SysUsers)sysUsers, (String)secure);
        }
        this.userChangeNotify.notify(DataChangeType.INSERT, new Object[]{sysUsers});
    }

    private void doProcessUserAudit(SysUsers sysUsers, String allowedIps) {
        boolean canOperate = this.sysStruAuditService.checkCanOperate(sysUsers.getDepartmentId());
        AssertUtil.isTrue((boolean)canOperate, (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_USER_ORGAN_EXIST_UNAPPROVED_DATA.getMessage()));
        long userId = sysUsers.getId();
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        BeanUtils.copyProperties((Object)sysUsers, (Object)sysUsersAudit);
        sysUsersAudit.setId(null);
        sysUsersAudit.setUserId(Long.valueOf(userId));
        sysUsersAudit.setPassword(sysUsers.getPassword());
        sysUsersAudit.setCurrentStatus("0");
        sysUsersAudit.setIsAudit("0");
        LocalDateTime now = LocalDateTime.now();
        sysUsersAudit.setCreateTime(now);
        sysUsersAudit.setCreateTime(now);
        this.sysUsersAuditService.save((Object)sysUsersAudit);
        this.saveUserAuditIP(userId, allowedIps, "0");
    }

    protected void saveUserIP(Long userId, String accessLoginIp) {
        boolean flag = false;
        ArrayList<SysUserIp> sysUserIps = new ArrayList<SysUserIp>();
        if (StringUtils.isNotBlank((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String string : list) {
                SysUserIp sysUserIp = new SysUserIp();
                sysUserIp.setUserId(userId);
                sysUserIp.setUserIp(string);
                sysUserIps.add(sysUserIp);
            }
        }
        if (HussarUtils.isNotEmpty(sysUserIps)) {
            ArrayList<String> newsysUserIps = new ArrayList<String>();
            for (SysUserIp sysUserIp : sysUserIps) {
                AssertUtil.isFalse((boolean)newsysUserIps.contains(sysUserIp.getUserIp()), (String)(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_EXIST_DUPLICATE_IP.getMessage()) + sysUserIp.getUserIp()));
                newsysUserIps.add(sysUserIp.getUserIp());
            }
            flag = this.sysUserIpService.saveBatch(sysUserIps);
        }
    }

    protected void saveUserAuditIP(Long userId, String accessLoginIp, String currentStatus) {
        boolean flag = false;
        ArrayList<SysUserIpAudit> listAudit = new ArrayList<SysUserIpAudit>();
        if (StringUtils.isNotEmpty((CharSequence)accessLoginIp)) {
            List<String> list = Arrays.asList(accessLoginIp.split(","));
            for (String ip : list) {
                SysUserIpAudit sysUserIpAudit = new SysUserIpAudit();
                sysUserIpAudit.setUserId(userId);
                sysUserIpAudit.setUserIp(ip);
                sysUserIpAudit.setIsAudit("0");
                sysUserIpAudit.setCurrentStatus(currentStatus);
                listAudit.add(sysUserIpAudit);
            }
        }
        if (HussarUtils.isNotEmpty(listAudit)) {
            flag = this.sysUserIpAuditService.saveBatch(listAudit);
        }
    }

    private void saveUserSignPic(AddUserDto addUserDto, Long userId) {
        SysUserAttachment sysUserAttachment = new SysUserAttachment();
        sysUserAttachment.setFileType(Integer.valueOf(UserAttachmentFileTypeEnum.ATTACHMENT_FILE.getValue()));
        sysUserAttachment.setBusiType(Integer.valueOf(UserAttachmentBusiTypeEnum.USER_SIGN.getValue()));
        sysUserAttachment.setFileId(addUserDto.getUserSignFileId());
        sysUserAttachment.setUserId(userId);
        this.userAttachmentService.saveUserAttachmentInfo(sysUserAttachment);
    }

    private String processAuditIfNecessaryEdit(SysUsers user, String allowedIps, boolean needAudit) {
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit()) {
            this.doProcessUserAuditEdit(user, allowedIps);
        } else {
            this.doProcessUserEdit(user, allowedIps);
        }
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && needAudit) {
            return TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_SUCCESS_WAIT_REVIEW.getMessage());
        }
        return TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_SUCCESS.getMessage());
    }

    private void doProcessUserAuditEdit(SysUsers user, String allowedIps) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        SysUsers oldUser = this.sysUsersService.getUser(user.getId());
        boolean flag = this.compareUser(user, oldUser, allowedIps);
        if (!flag) {
            this.userAuditDataExistsEdit(user.getId());
            BeanUtils.copyProperties((Object)user, (Object)sysUsersAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
            sysUsersAudit.setUserId(user.getId());
            sysUsersAudit.setCurrentStatus(ADD);
            sysUsersAudit.setIsAudit("0");
            LocalDateTime now = LocalDateTime.now();
            sysUsersAudit.setCreateTime(now);
            sysUsersAudit.setCreateTime(now);
            this.sysUsersAuditService.save((Object)sysUsersAudit);
            this.saveUserAuditIP(user.getId(), allowedIps, ADD);
        }
    }

    private void doProcessUserAuditEditStaff(SysUsers user, String allowedIps) {
        SysUsersAudit sysUsersAudit = new SysUsersAudit();
        SysUsers oldUser = this.sysUsersService.getById(user.getId());
        boolean flag = this.compareUser(user, oldUser, allowedIps);
        if (!flag) {
            this.userAuditDataExistsEdit(user.getId());
            Long oldEmployeeId = oldUser.getEmployeeId();
            Long newEmployeeId = user.getEmployeeId();
            AssertUtil.isTrue((boolean)this.sysStaffAuditService.checkStaffCanOperate(oldEmployeeId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
            if (!oldEmployeeId.equals(newEmployeeId)) {
                AssertUtil.isTrue((boolean)this.sysStaffAuditService.checkStaffCanOperate(newEmployeeId), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
            }
            BeanUtils.copyProperties((Object)user, (Object)sysUsersAudit, (String[])new String[]{"id", "delFlag", "createTime", "lastTime", "creator", "lastEditor"});
            sysUsersAudit.setUserId(user.getId());
            sysUsersAudit.setCurrentStatus(ADD);
            sysUsersAudit.setIsAudit("0");
            LocalDateTime now = LocalDateTime.now();
            sysUsersAudit.setCreateTime(now);
            sysUsersAudit.setCreateTime(now);
            this.sysUsersAuditService.save((Object)sysUsersAudit);
        }
    }

    private void editUserSignPic(EditUserDto editUserDto, Long userId) {
        SysUserAttachment sysUserAttachment = new SysUserAttachment();
        Integer fileType = null;
        if (ToolUtil.isNotEmpty((Object)editUserDto.getUserSignImgBase64())) {
            fileType = UserAttachmentFileTypeEnum.ATTACHMENT_BASE64.getValue();
        }
        if (ToolUtil.isNotEmpty((Object)editUserDto.getUserSignFileId())) {
            fileType = UserAttachmentFileTypeEnum.ATTACHMENT_FILE.getValue();
        }
        sysUserAttachment.setFileType(fileType);
        sysUserAttachment.setBusiType(Integer.valueOf(UserAttachmentBusiTypeEnum.USER_SIGN.getValue()));
        sysUserAttachment.setImgBase64(editUserDto.getUserSignImgBase64());
        sysUserAttachment.setFileId(editUserDto.getUserSignFileId());
        sysUserAttachment.setUserId(userId);
        this.userAttachmentService.updateUserSignInfo(sysUserAttachment);
    }

    private void doProcessUserEdit(SysUsers user, String allowedIps) {
        boolean flag;
        Long userId = user.getId();
        SysUsers old = this.sysUsersService.getById(userId);
        if (!ADD.equals(old.getAccountStatus()) && ADD.equals(user.getAccountStatus())) {
            user.setLastLoginTime(LocalDateTime.now());
            LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
            loginLock.removeUserCache(String.valueOf(userId));
        }
        if (!(flag = this.compareUser(user, old, allowedIps))) {
            this.sysUsersService.updateById((Object)user);
            this.sysUserIpService.remove((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)userId));
            this.saveUserIP(userId, allowedIps);
        }
        this.userChangeNotify.notify(DataChangeType.UPDATE, new Object[]{user});
        this.functionRoleUserAuthorizationChangeReporter.report(new Object[]{"user", Collections.singletonList(userId)});
    }

    private boolean compareUser(SysUsers newUser, SysUsers oldUser, String allowedIps) {
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getUserAccount()), (Object)StringUtils.trimToEmpty((String)oldUser.getUserAccount()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getMaxSessions(), (Object)oldUser.getMaxSessions())) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getSecurityLevel(), (Object)oldUser.getSecurityLevel())) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.geteMail()), (Object)StringUtils.trimToEmpty((String)oldUser.geteMail()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getWeChat()), (Object)StringUtils.trimToEmpty((String)oldUser.getWeChat()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getMobile()), (Object)StringUtils.trimToEmpty((String)oldUser.getMobile()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getTelephone()), (Object)StringUtils.trimToEmpty((String)oldUser.getTelephone()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getTypeProperty()), (Object)StringUtils.trimToEmpty((String)oldUser.getTypeProperty()))) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getStartTime(), (Object)oldUser.getStartTime())) {
            return false;
        }
        if (!HussarUtils.equals((Object)newUser.getExpiredTime(), (Object)oldUser.getExpiredTime())) {
            return false;
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getLoginTimeLimit()), (Object)StringUtils.trimToEmpty((String)oldUser.getLoginTimeLimit()))) {
            return false;
        }
        if (ADD.equals(newUser.getLoginTimeLimit())) {
            if (!HussarUtils.equals((Object)newUser.getAccessLoginStartTime(), (Object)oldUser.getAccessLoginStartTime())) {
                return false;
            }
            if (!HussarUtils.equals((Object)newUser.getAccessLoginEndTime(), (Object)oldUser.getAccessLoginEndTime())) {
                return false;
            }
        }
        if (!HussarUtils.equals((Object)StringUtils.trimToEmpty((String)newUser.getLoginIpLimit()), (Object)StringUtils.trimToEmpty((String)oldUser.getLoginIpLimit()))) {
            return false;
        }
        if (ADD.equals(newUser.getLoginIpLimit())) {
            List list = this.sysUserIpService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserIp::getUserId, (Object)newUser.getId()));
            List oldIpList = list.stream().map(SysUserIp::getUserIp).collect(Collectors.toList());
            List<String> ipList = Arrays.asList(allowedIps.split(","));
            if (!HussarUtils.equals((Object)oldIpList.size(), (Object)ipList.size())) {
                return false;
            }
            List delIps = oldIpList.stream().filter(item -> !ipList.contains(item)).collect(Collectors.toList());
            return !HussarUtils.isNotEmpty(delIps);
        }
        return oldUser.getEmployeeId().equals(newUser.getEmployeeId());
    }

    private void userAuditDataExistsEdit(Long userId) {
        LOGGER.debug(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_VERIFY_ON_AUDIT.getMessage()));
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isUserAudit() && this.sysUsersAuditService.adjustEdit(userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.UPDATE_FAIL_EXIST_REVIEW.getMessage()));
        }
    }

    private boolean processRoleAuditIfNecessary(Long id, Long[] roleIds) {
        boolean userRoleAuditFlag = false;
        if (this.sysAuditConfig.isCriticalOperationsAudit() && this.sysAuditConfig.isRoleAudit()) {
            List auditList = this.sysUserroleAuditService.getHasReviewList(id);
            List connList = this.sysUserRoleService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id)).eq(SysUserRole::getAdminOption, (Object)Whether.YES.getValue()));
            ArrayList<Long> adds = new ArrayList<Long>();
            ArrayList<Long> dels = new ArrayList<Long>();
            if (HussarUtils.isNotEmpty((Object)connList)) {
                for (SysUserRole sysUserRole : connList) {
                    boolean isSame = false;
                    if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                        for (Long roleId : roleIds) {
                            if (ToolUtil.isEmpty((Object)roleId) || !roleId.equals(sysUserRole.getGrantedRole())) continue;
                            isSame = true;
                            break;
                        }
                    }
                    if (isSame) continue;
                    dels.add(sysUserRole.getGrantedRole());
                }
            }
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    boolean isSame = false;
                    for (SysUserRole sysUserRole : connList) {
                        if (!roleId.equals(sysUserRole.getGrantedRole())) continue;
                        isSame = true;
                        break;
                    }
                    if (isSame || SysUserAndRole.PUBLIC_ROLE.getValue().equals(roleId)) continue;
                    adds.add(roleId);
                }
            }
            if (HussarUtils.isNotEmpty(adds) || HussarUtils.isNotEmpty(dels)) {
                List audits = this.sysUserroleAuditService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserroleAudit::getUserId, (Object)id)).eq(SysUserroleAudit::getStatus, (Object)UserRoleStatus.LOCKED.getCode()));
                AssertUtil.isFalse((boolean)HussarUtils.isNotEmpty((Object)audits), (String)TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_UPDATE_FAIL_EXIST_REVIEW_ROLE.getMessage()));
                userRoleAuditFlag = true;
            }
            if (HussarUtils.isNotEmpty(adds)) {
                this.insertAndUpdateUserRoleAudit(adds, auditList, id, ADD);
            }
            if (HussarUtils.isNotEmpty(dels)) {
                this.insertAndUpdateUserRoleAudit(dels, auditList, id, DELETE);
            }
        } else {
            this.sysRolesService.delAuthCacheInfo(id);
            if (BaseSecurityUtil.getUser().isGradeadmin()) {
                List roleList = this.sysUserRoleService.delOrganRoleIdByUserId(id);
                if (HussarUtils.isNotEmpty((Object)roleList)) {
                    List cdidList = LambdaQueryUtil.getSplitList((List)roleList);
                    this.sysUserRoleService.delUserRoleByRoleId(id, cdidList);
                }
            } else {
                List sysUserRoles = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id));
                List roleList = sysUserRoles.stream().map(SysUserRole::getGrantedRole).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(roleList)) {
                    List cdids = roleList.stream().distinct().collect(Collectors.toList());
                    List cdidList = LambdaQueryUtil.getSplitList(cdids);
                    this.sysUserRoleService.delSysRolesByUserId(id, cdidList);
                }
            }
            ArrayList<SysUserRole> userRoleList = new ArrayList<SysUserRole>();
            if (HussarUtils.isNotEmpty((Object[])roleIds)) {
                for (Long roleId : roleIds) {
                    if (Long.valueOf(SysUserAndRole.PUBLIC_ROLE.getValue().toString()).equals(roleId) && BaseSecurityUtil.getUser().isGradeadmin()) continue;
                    SysUserRole sysUserRole = new SysUserRole();
                    sysUserRole.setUserId(id);
                    sysUserRole.setGrantedRole(roleId);
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    userRoleList.add(sysUserRole);
                }
                this.fillCommonFields(userRoleList);
            }
            this.sysUserRoleService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)id)).eq(SysUserRole::getGrantedRole, (Object)SysUserAndRole.GRADEADMIN_ROLE.getValue()));
            if (HussarUtils.isNotEmpty(userRoleList)) {
                this.sysUserRoleService.saveBatch(userRoleList, userRoleList.size());
            }
        }
        return userRoleAuditFlag;
    }

    private void insertAndUpdateUserRoleAudit(List<Long> roleIds, List<SysUserroleAudit> auditList, Long userId, String operationType) {
        Long account;
        ArrayList<SysUserroleAudit> updateAuditList = new ArrayList<SysUserroleAudit>();
        HashMap<String, Object> updateMap = new HashMap<String, Object>();
        ArrayList<SysUserroleAudit> addAuditList = new ArrayList<SysUserroleAudit>();
        Date currentDate = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        Long l = account = ToolUtil.isNotEmpty((Object)BaseSecurityUtil.getUser()) ? BaseSecurityUtil.getUser().getId() : null;
        if (HussarUtils.isNotEmpty(roleIds)) {
            for (Long roleId : roleIds) {
                if (ToolUtil.isEmpty((Object)roleId) || Objects.equals(roleId, SysUserAndRole.PUBLIC_ROLE.getValue())) continue;
                boolean isExist = false;
                for (SysUserroleAudit sysUserroleAudit : auditList) {
                    if (!roleId.equals(sysUserroleAudit.getRoleId())) continue;
                    isExist = true;
                    updateAuditList.add(sysUserroleAudit);
                    break;
                }
                if (isExist) continue;
                SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
                sysUserroleAudit.setUserId(userId);
                sysUserroleAudit.setRoleId(roleId);
                sysUserroleAudit.setStatus(UserRoleStatus.LOCKED.getCode());
                sysUserroleAudit.setOperationType(operationType);
                addAuditList.add(sysUserroleAudit);
            }
        }
        if (HussarUtils.isNotEmpty(updateAuditList)) {
            updateMap.put("userId", userId);
            updateMap.put("operationType", operationType);
            updateMap.put("status", UserRoleStatus.LOCKED.getCode());
            updateMap.put("lastTime", currentDate);
            updateMap.put("lastEditor", account);
            updateMap.put("updateAuditList", updateAuditList);
            this.sysUserroleAuditService.updateAuditBatch(updateMap);
        }
        if (HussarUtils.isNotEmpty(addAuditList)) {
            this.sysUserroleAuditService.saveBatch(addAuditList);
        }
    }

    protected void fillCommonFields(List<SysUserRole> sysUserRoles) {
        if (HussarUtils.isEmpty(sysUserRoles)) {
            return;
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        for (SysUserRole userRole : sysUserRoles) {
            userRole.setCreateTime(now);
            userRole.setLastTime(now);
            userRole.setCreator(securityUser.getId());
            userRole.setLastEditor(securityUser.getId());
        }
    }
}

