/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.extend.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.organ.model.SysStaff;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.general.idtable.service.ISysIdtableService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.authorization.extend.utils.authorizationExtendUtils")
public class AuthorizationExtendUtils {
    private static Logger logger = LoggerFactory.getLogger(AuthorizationExtendUtils.class);
    @Autowired
    protected ISysIdtableService sysIdtableService;
    @Resource
    protected ISysStruService sysStruService;
    @Resource
    protected ISysStaffService sysStaffService;
    @Resource
    protected ISysOrganService sysOrganService;

    public String getCode(String code) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        long currentCount = 1L;
        if (HussarUtils.isBlank((CharSequence)code)) {
            while (currentCount != 0L) {
                lambdaQueryWrapper.clear();
                code = this.sysIdtableService.getCurrentCode("STAFF_CODE", "SYS_STAFF");
                lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
                currentCount = this.sysStaffService.count((Wrapper)lambdaQueryWrapper);
            }
        } else {
            lambdaQueryWrapper.eq(SysStaff::getStaffCode, (Object)code);
            currentCount = this.sysStaffService.count((Wrapper)lambdaQueryWrapper);
            if (currentCount > 0L) {
                throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_ADD_FAIL_EXIST_STAFF_CODE.getMessage()));
            }
        }
        return code;
    }

    public List<Long> convertStringToLongList(String ids) {
        if (HussarUtils.isEmpty((Object)ids)) {
            return Collections.emptyList();
        }
        return Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
    }
}

