/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authorization.permit.factory;

import com.jxdinfo.hussar.authorization.enums.TipConstantsEnum;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserRoleExpandService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class UserRoleExpandFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarBaseUserRoleExpandService> USER_ROLE_MAP = new HashMap<String, IHussarBaseUserRoleExpandService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarBaseUserRoleExpandService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarBaseUserRoleExpandService> beanMap) {
        for (IHussarBaseUserRoleExpandService hussarBaseUserRoleExpandService : beanMap.values()) {
            USER_ROLE_MAP.put(hussarBaseUserRoleExpandService.getRelateType(), hussarBaseUserRoleExpandService);
        }
    }

    public static List<Long> getRolesByExpand(Long userId) {
        if (HussarUtils.isEmpty((Object)userId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)TipConstantsEnum.AUTHOR_USER_ID_NOT_FIND.getMessage()));
        }
        List<Long> roleIds = new ArrayList<Long>();
        for (IHussarBaseUserRoleExpandService hussarBaseUserRoleExpandService : USER_ROLE_MAP.values()) {
            List<Long> expandRoleIds = hussarBaseUserRoleExpandService.getExpandRolesByUserId(userId);
            if (!HussarUtils.isNotEmpty(expandRoleIds)) continue;
            roleIds.addAll(expandRoleIds);
        }
        if (HussarUtils.isNotEmpty(roleIds)) {
            roleIds = roleIds.stream().distinct().collect(Collectors.toList());
        }
        return roleIds;
    }

    public static List<Long> getRolesByBusiness(Map<String, List<Long>> businessMap) {
        List<Long> roleIds = new ArrayList<Long>();
        for (IHussarBaseUserRoleExpandService hussarBaseUserRoleExpandService : USER_ROLE_MAP.values()) {
            List<Long> expandRoleIds;
            List<Long> bussinessIds;
            String type = hussarBaseUserRoleExpandService.getRelateType();
            if (HussarUtils.isEmpty((Object)type) || HussarUtils.isEmpty(bussinessIds = businessMap.get(type)) || !HussarUtils.isNotEmpty(expandRoleIds = hussarBaseUserRoleExpandService.getRolesByBusinessId(bussinessIds))) continue;
            roleIds.addAll(expandRoleIds);
        }
        if (HussarUtils.isNotEmpty(roleIds)) {
            roleIds = roleIds.stream().distinct().collect(Collectors.toList());
        }
        return roleIds;
    }
}

