/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.base.cloud.model.client.SysAuthClientModel;
import com.jxdinfo.hussar.base.cloud.service.SysAuthClientDetailsService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityClientModelDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.ClientModelDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.utils.TranslateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AuthSecurityClientModelDetailServiceImpl
implements AuthSecurityClientModelDetailService {
    @Autowired
    private SysAuthClientDetailsService sysAuthClientDetailsService;
    @Autowired
    private HussarTenantProperties tenantProperties;

    public ClientModelDetails loadClientModelByClientId(String clientId, String clientPassword, String tenantCode) {
        if (HussarUtils.isEmpty((Object)clientId)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_FAIL_OBTAIN.getValue()));
        }
        SysAuthClientModel sysAuthClientModel = new SysAuthClientModel();
        sysAuthClientModel.setClientId(clientId);
        sysAuthClientModel.setClientSecret(clientPassword);
        String connName = "master";
        if (this.tenantProperties.isEnabled()) {
            connName = HussarUtils.isNotEmpty((Object)this.tenantProperties.getClientIdWhiteList()) && this.tenantProperties.getClientIdWhiteList().contains(clientId) ? "master" : HussarContextHolder.getConnName();
        }
        return this.sysAuthClientDetailsService.doLoginByClientId(connName, sysAuthClientModel);
    }
}

