/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.lock.LoginLock;
import com.jxdinfo.hussar.authentication.lock.SecureErr;
import com.jxdinfo.hussar.authentication.lock.UserLockModel;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginFailConfigService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.authentication.service.impl.loginLockServiceImpl")
public class LoginLockServiceImpl
implements LoginLock {
    private static final String LOINLOCK = "Login_Lock";
    @Resource
    private IHussarLoginFailConfigService hussarLoginFailConfigService;

    public boolean userIsLock(String userId) {
        return this.userLockState(userId);
    }

    public boolean userIsLock(String userId, String connName) {
        String key = userId + "-" + connName;
        return this.userLockState(key);
    }

    public int userLockNum(String userId) {
        int num = 0;
        UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)LOINLOCK, (Object)userId);
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    public int userLockNum(String userId, String connName) {
        int num = 0;
        UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)LOINLOCK, (Object)(userId + "-" + connName));
        if (ToolUtil.isNotEmpty((Object)model)) {
            num = model.getFailNum();
        }
        return num;
    }

    public void removeUserCache(String userId) {
        HussarCacheUtil.evict((String)LOINLOCK, (Object)userId);
    }

    public void removeUserCache(String userId, String connName) {
        HussarCacheUtil.evict((String)LOINLOCK, (Object)(userId + "-" + connName));
    }

    public void addUserCache(String userId, String userName, int tryLogin) {
        this.addNewUserCache(userId, userId, userName, tryLogin);
    }

    public void addUserCache(String userId, String userName, String connName, int tryLogin) {
        String key = userId + "-" + connName;
        this.addNewUserCache(key, userId, userName, tryLogin);
    }

    private boolean userLockState(String key) {
        boolean flag = false;
        UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)LOINLOCK, (Object)key);
        if (ToolUtil.isNotEmpty((Object)model) && ToolUtil.isNotEmpty((Object)model.getExpireTime()) && DateUtil.compareDate((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (Date)model.getExpireTime()) == -1) {
            flag = true;
        }
        return flag;
    }

    private void addNewUserCache(String key, String userId, String userName, int tryLogin) {
        UserLockModel model = (UserLockModel)HussarCacheUtil.get((String)LOINLOCK, (Object)key);
        int failTime = this.hussarLoginFailConfigService.getLockTime();
        int minutes = this.hussarLoginFailConfigService.getFailTime();
        int seconds = minutes * 60;
        SecureErr errMode = new SecureErr();
        errMode.setInputTime(new Date());
        errMode.setExpireTime(DateUtils.addMinutes((Date)errMode.getInputTime(), (int)minutes));
        List historyPwdErr = null;
        if (ToolUtil.isNotEmpty((Object)model)) {
            historyPwdErr = model.getSecureErrList();
            for (SecureErr err : historyPwdErr) {
                if (!err.getExpireTime().before(new Date())) continue;
                historyPwdErr.remove(err);
            }
            historyPwdErr.add(errMode);
            model.setFailNum(historyPwdErr.size());
            model.setSecureErrList(historyPwdErr);
        } else {
            model = new UserLockModel();
            model.setUserId(userId);
            model.setUserName(userName);
            model.getSecureErrList().add(errMode);
            model.setFailNum(1);
        }
        this.lockOrContinue(model, tryLogin, failTime, seconds);
    }

    private void lockOrContinue(UserLockModel lockModel, int tryLogin, int failTime, int seconds) {
        if (lockModel.getFailNum() >= tryLogin) {
            lockModel.setLockTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()));
            lockModel.setExpireTime(DateUtil.addMinute((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (int)failTime));
            HussarCacheUtil.put((String)LOINLOCK, (Object)lockModel.getUserId(), (Object)lockModel, (long)((long)failTime * 60L));
        } else {
            HussarCacheUtil.put((String)LOINLOCK, (Object)lockModel.getUserId(), (Object)lockModel, (long)seconds);
        }
    }
}

