/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.dto.SysUsersDto;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authentication.factory.HussarLoginFactory;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.authentication.service.IExtendUserDetailService;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.authorization.relational.service.ISysStruUserService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IProtectionStatusConfigBoService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.base.config.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.ConditionUtils;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.theme.service.IThemeService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.support.dto.AuditLogModel;
import com.jxdinfo.hussar.support.audit.core.util.AuditLogUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.properties.HussarDynamicProperties;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantMultUser;
import com.jxdinfo.hussar.tenant.groupingmodel.model.SysTenantStru;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantMultUserService;
import com.jxdinfo.hussar.tenant.groupingmodel.service.ISysTenantStruService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@HussarTokenDs
@Service
public class HussarLoginBaseServiceImpl
implements HussarLoginService {
    private static Logger LOGGER = LoggerFactory.getLogger(HussarLoginBaseServiceImpl.class);
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysUserRoleService iSysUserRoleService;
    @Resource
    private ISysStruService iSysStruService;
    @Resource
    private ISysStruRoleService iSysStruRoleService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private IThemeService themeService;
    @Resource
    private ISysWelcomeService sysWelcomeService;
    @Resource
    private IHussarBaseUserIdentityService userIdentityService;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IExtendUserDetailService extendUserDetailService;
    @Resource
    private IProtectionStatusConfigBoService protectionStatusConfigBoService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};
    private static final Long[] ADMINS = new Long[]{716665713812840448L, 1450757642371981314L, 716671816189616128L, 1450757642371981314L, 1450757481235202050L, 1450757642371981324L};
    private static final String IS_ONLY_TENANT_ZERO = "1";
    private static final String IS_ONLY_TENANT_ZERO_KEY = "hussar.isOnlyTenantZero.enable";
    private static final String SYSTEM_TENANT_CODE = "0";
    private static final Long[] THREE_SENIOR_ADMINS = new Long[]{1450757481235202050L, 1450757642371981314L, 1450757642371981324L};
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Resource
    private HussarDynamicProperties hussarDynamicProperties;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Resource
    private ISysBaseConfigService baseConfigService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantMultUserService tenantMultUserService;
    @Lazy
    @Autowired(required=false)
    private ISysTenantStruService sysTenantStruService;
    @Resource
    private ISysStruUserService sysStruUserService;

    public UserDetails login(AuthcDto authcDto) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = Optional.ofNullable(requestAttributes).map(ServletRequestAttributes::getRequest).orElse(null);
        String loginType = authcDto.getLoginType();
        String loginCode = authcDto.getLoginCode();
        boolean tenantOpen = TenantCacheUtil.openTenant();
        DefaultTenant hussarTenantDefinition = new DefaultTenant();
        if (request != null) {
            if (HussarUtils.isEmpty((Object)loginType) || HussarUtils.isEmpty((Object)loginCode)) {
                loginType = request.getHeader("loginType");
                loginCode = request.getHeader("loginCode");
            }
            if (tenantOpen) {
                hussarTenantDefinition = this.tenantCommonService.parse();
                Optional.ofNullable(hussarTenantDefinition).ifPresent(e -> {
                    this.checkTeant((HussarTenantDefinition)e);
                    authcDto.setTenantCode(e.getTenantCode());
                    authcDto.setDsName(e.getConnName());
                });
            } else {
                authcDto.setTenantCode(SYSTEM_TENANT_CODE);
                authcDto.setDsName("master");
            }
        }
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").beforeSelectUser(request, loginCode, authcDto);
        } else {
            String username = HussarLoginFactory.getLoginValidateService(loginType).beforeSelectUser(request, loginCode, authcDto);
            ConditionUtils.isTrue((boolean)ToolUtil.isNotEmpty((Object)username)).handle(() -> authcDto.setUsername(username));
        }
        SysUsers sysUsers = this.getSysUsers(authcDto);
        if (tenantOpen && "groupingmodel".equals(this.hussarTenantProperties.getType())) {
            Long userId = sysUsers.getId();
            List<SysTenant> switchTenantList = this.getSwitchTenantList(userId);
            if (ArrayUtils.contains((Object[])ADMINS, (Object)sysUsers.getId())) {
                authcDto.setTenantCode(SYSTEM_TENANT_CODE);
                authcDto.setDsName("master");
                hussarTenantDefinition = this.tenantCommonService.search(SYSTEM_TENANT_CODE);
            } else {
                SysTenant sysTenant = switchTenantList.get(0);
                authcDto.setTenantCode(sysTenant.getTenantCode());
                authcDto.setDsName(sysTenant.getConnName());
                hussarTenantDefinition = this.tenantCommonService.search(sysTenant.getTenantCode());
            }
        }
        SysUsersDto sysUsersDto = new SysUsersDto();
        CopyPropertieUtils.copyProperties((Object)sysUsersDto, (Object)sysUsers);
        if (ToolUtil.isEmpty((Object)loginType) || "default".equals(loginType)) {
            HussarLoginFactory.getLoginValidateService("default").validateUser(authcDto, sysUsersDto);
        } else {
            HussarLoginFactory.getLoginValidateService(loginType).validateUser(authcDto, sysUsersDto);
        }
        UserDetails userDetails = this.getLoginSecurityUser(tenantOpen, (HussarTenantDefinition)hussarTenantDefinition, sysUsers);
        if (ToolUtil.isNotEmpty((Object)userDetails)) {
            sysUsers.setLastLoginTime(Java8DateUtils.currentLocalDateTime());
            sysUsers.setLastEditor(userDetails.getUserId());
            sysUsers.setLastTime(LocalDateTime.now());
            this.asyncUpdateLastLoginTime(sysUsers, authcDto.getDsName(), authcDto.getTenantCode());
        }
        return userDetails;
    }

    @NotNull
    private SysUsers getSysUsers(AuthcDto authcDto) {
        SysUsers sysUsers;
        String account = authcDto.getUsername();
        if (!this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)authcDto.getUsername())) {
            account = authcDto.getUsername().toUpperCase();
        }
        if (ToolUtil.isEmpty((Object)(sysUsers = this.iSysUsersService.getUserByAccountAndStatus(authcDto.getDsName(), account, (List)Lists.newArrayList((Object[])new String[]{UserStatus.LOCKED.getCode(), UserStatus.OK.getCode(), UserStatus.DORMANCY.getCode()}))))) {
            sysUsers = new SysUsers();
            sysUsers.setUserName(authcDto.getUsername());
            this.throwExceptionPersionally(authcDto, sysUsers, TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_USERNAME_OR_PASSWORD_ERROR.getValue()));
        } else if (this.hussarLoginConfigService.getLoginUpperOpen(authcDto.getDsName()).booleanValue() && !authcDto.getUsername().equals(sysUsers.getUserAccount())) {
            this.throwExceptionPersionally(authcDto, sysUsers, TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_USERNAME_OR_PASSWORD_ERROR.getValue()));
        }
        return sysUsers;
    }

    private void asyncUpdateLastLoginTime(SysUsers sysUsers, String connName, String tenantCode) {
        Executor loginSuccessExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        if (null != loginSuccessExecutor) {
            loginSuccessExecutor.execute(() -> {
                try {
                    HussarContextHolder.setTenant((String)connName, (String)tenantCode);
                    this.iSysUsersService.updateById(connName, (Object)sysUsers);
                }
                catch (Exception e) {
                    LOGGER.error("\u5f02\u6b65\u66f4\u65b0\u7528\u6237\u6700\u540e\u767b\u5f55\u65f6\u95f4\u5931\u8d25userId = {}", (Object)sysUsers.getId(), (Object)e);
                }
            });
        }
    }

    private void checkTeant(HussarTenantDefinition tenantInfo) {
        if (StringUtils.isNotBlank((CharSequence)tenantInfo.getTenantCode()) && !tenantInfo.getConnName().equals("master")) {
            Boolean timeLimit = tenantInfo.getTimeLimit();
            LocalDateTime startTime = tenantInfo.getStartTime();
            LocalDateTime endTime = tenantInfo.getEndTime();
            String tenantStatus = tenantInfo.getTenantStatus();
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase(SYSTEM_TENANT_CODE), (String)"\u79df\u6237\u5df2\u5220\u9664");
            AssertUtil.isFalse((boolean)tenantStatus.equalsIgnoreCase("2"), (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((tenantStatus.equalsIgnoreCase("3") || tenantStatus.equalsIgnoreCase("4") ? 1 : 0) != 0, (String)"\u79df\u6237\u4e0d\u53ef\u7528");
            AssertUtil.isFalse((timeLimit != false && endTime.isBefore(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u5df2\u5931\u6548");
            AssertUtil.isFalse((timeLimit != false && startTime.isAfter(Java8DateUtils.currentLocalDateTime()) ? 1 : 0) != 0, (String)"\u79df\u6237\u672a\u751f\u6548");
        }
    }

    private void throwExceptionPersionally(AuthcDto authcDto, SysUsers sysUsers, String message) {
        HussarTenantDefinition hussarTenantDefinition;
        BaseException e = new BaseException(message);
        AuditLogModel auditLogModel = new AuditLogModel();
        auditLogModel.setModuleName(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_LOGIN.getValue()));
        auditLogModel.setExceptionInfo((Throwable)e);
        auditLogModel.setEventGrade(AuditEventGrade.SYSTEM_LOG_TYPE);
        auditLogModel.setEventType(AuditEventType.LOGIEXCEPTION);
        auditLogModel.setEventDesc(message);
        UserDetails userDetails = new UserDetails();
        if (sysUsers.getId() != null) {
            userDetails.setUserId(sysUsers.getId());
        }
        if (HussarUtils.isNotBlank((CharSequence)authcDto.getDsName()) && !authcDto.getDsName().equals("master") && HussarUtils.isNotEmpty((Object)(hussarTenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)authcDto.getTenantCode())))) {
            userDetails.setTenantId(hussarTenantDefinition.getTenantId());
            userDetails.setTenantCode(hussarTenantDefinition.getTenantCode());
        }
        userDetails.setUserName(sysUsers.getUserName());
        auditLogModel.setUserDetails(userDetails);
        AuditLogUtils.addAuditLog((AuditLogModel)auditLogModel);
        throw e;
    }

    private UserDetails getLoginSecurityUser(boolean tenantOpen, HussarTenantDefinition tenantInfo, SysUsers sysUsers) {
        UserDetails userDetails = (UserDetails)HussarCacheUtil.get((String)"hussar_user_cache", (Object)("user_id_" + sysUsers.getId()));
        Boolean useUserCache = HussarUtils.isNotEmpty((Object)userDetails);
        if (!useUserCache.booleanValue()) {
            userDetails = new UserDetails();
        }
        userDetails.setUserId(sysUsers.getId());
        if (tenantOpen && HussarUtils.isNotEmpty((Object)tenantInfo)) {
            userDetails.addExtendUserMap(this.hussarDynamicProperties.getDatasourceKeyByHeader(), (Object)tenantInfo.getConnName());
            userDetails.setTenantId(tenantInfo.getTenantId());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("tenantName", (Object)tenantInfo.getTenantName());
            userDetails.addExtendUserMap("tcode", (Object)tenantInfo.getTenantCode());
            userDetails.addExtendUserMap("connName", (Object)tenantInfo.getConnName());
            userDetails.addExtendUserMap("gitUrl", (Object)tenantInfo.getGitUrl());
            userDetails.addExtendUserMap("gitToken", (Object)tenantInfo.getGitToken());
            userDetails.setTenantCode(tenantInfo.getTenantCode());
        }
        userDetails.addExtendUserMap("account", (Object)sysUsers.getUserAccount());
        userDetails.setUserName(sysUsers.getUserName());
        if (this.protectionStatusConfigBoService.isFenBaoEnable().booleanValue()) {
            userDetails.addExtendUserMap("securityLevel", (Object)sysUsers.getSecurityLevel());
        }
        userDetails.addExtendUserMap("accountStatus", (Object)sysUsers.getAccountStatus());
        userDetails.setMaxSameCount(sysUsers.getMaxSessions());
        if (!useUserCache.booleanValue() && HussarUtils.isNotEmpty((Object)(userDetails = this.userIdentityService.handleUserIdentity(userDetails, Long.valueOf(1L))))) {
            HussarCacheUtil.put((String)"hussar_user_cache", (Object)("user_id_" + sysUsers.getId()), (Object)userDetails);
        }
        List roleIds = (List)userDetails.getExtendUserMap("rolesList");
        userDetails.addExtendUserMap("theme", (Object)"default");
        ArrayList<Long> roleList = new ArrayList<Long>(roleIds);
        roleList.add(userDetails.getUserId());
        userDetails.addExtendUserMap("welcomeUrl", (Object)"/default/index");
        Map customExtendMap = this.extendUserDetailService.generateExtendMap(userDetails.getUserId());
        if (HussarUtils.isNotEmpty((Object)customExtendMap)) {
            for (Map.Entry entry : customExtendMap.entrySet()) {
                userDetails.addExtendUserMap((String)entry.getKey(), entry.getValue());
            }
        }
        return userDetails;
    }

    private List<SysTenant> getSwitchTenantList(Long userId) {
        String isOnlyTenantZero;
        boolean protectFlag;
        LambdaQueryWrapper sysTenantQy = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)sysTenantQy.eq(SysTenant::getTenantStatus, (Object)IS_ONLY_TENANT_ZERO)).orderByAsc(SysTenant::getTenantSeq)).orderByDesc(HussarBaseEntity::getCreateTime);
        List resultList = this.sysTenantService.list((Wrapper)sysTenantQy);
        if (!ArrayUtils.contains((Object[])ADMINS, (Object)userId)) {
            LambdaQueryWrapper sysTenantMultUserQy = new LambdaQueryWrapper();
            sysTenantMultUserQy.eq(SysTenantMultUser::getUserId, (Object)userId);
            SysTenantMultUser tenantMultUser = this.tenantMultUserService.getOne("master", sysTenantMultUserQy);
            List tenantUerIds = resultList.stream().map(SysTenant::getTenantAdminId).collect(Collectors.toList());
            if (tenantMultUser != null) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getById((Serializable)tenantMultUser.getTenantId());
                resultList.clear();
                resultList.add(sysTenant);
            } else if (tenantUerIds.contains(userId)) {
                SysTenant sysTenant = (SysTenant)this.sysTenantService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysTenant::getTenantAdminId, (Object)userId));
                resultList.clear();
                resultList.add(sysTenant);
            } else {
                List struByStruIds;
                HashSet struCollection = Sets.newHashSet();
                List sysStruUserList = this.sysStruUserService.list("master", (Wrapper)Wrappers.lambdaQuery().eq(SysStruUser::getUserId, (Object)userId));
                if (CollectionUtils.isNotEmpty((Collection)sysStruUserList) && (struByStruIds = this.iSysStruService.getStruByStruIds("master", sysStruUserList.stream().map(SysStruUser::getStruId).collect(Collectors.toList()))) != null) {
                    for (SysStru sysStru : struByStruIds) {
                        Set collect = Arrays.stream(sysStru.getStruFid().split("/")).filter(HussarUtils::isNotBlank).map(Long::parseLong).collect(Collectors.toSet());
                        struCollection.addAll(collect);
                    }
                }
                List tenantStrus = this.sysTenantStruService.list("master");
                List tenantIdList = tenantStrus.stream().filter(t -> struCollection.contains(t.getStruId())).map(SysTenantStru::getTenantId).collect(Collectors.toList());
                resultList = resultList.stream().filter(r -> tenantIdList.contains(r.getId()) || SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
            }
        }
        if ((protectFlag = this.protectionStatusConfigBoService.isFenBaoEnable("master").booleanValue()) && ArrayUtils.contains((Object[])THREE_SENIOR_ADMINS, (Object)userId) && (HussarUtils.isEmpty((Object)(isOnlyTenantZero = String.valueOf(((Environment)SpringContextHolder.getBean(Environment.class)).getProperty(IS_ONLY_TENANT_ZERO_KEY)))) || IS_ONLY_TENANT_ZERO.equals(isOnlyTenantZero))) {
            resultList = resultList.stream().filter(r -> SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty((Object)resultList) && protectFlag && !ArrayUtils.contains((Object[])THREE_SENIOR_ADMINS, (Object)userId)) {
            if (resultList.size() == 1 && SYSTEM_TENANT_CODE.equals(((SysTenant)resultList.get(0)).getTenantCode())) {
                LOGGER.info("\u5f53\u524d\u7528\u6237\u53ea\u5728\u5e73\u53f0\u7ea7\u79df\u6237\u4e0b\u6709\u6570\u636e\uff0c\u4e0d\u9700\u8981\u53bb\u6389\u5e73\u53f0\u7ea7\uff0c\u5f53\u524d\u7528\u6237ID\uff1a{}", (Object)userId);
            } else {
                resultList = resultList.stream().filter(r -> !SYSTEM_TENANT_CODE.equals(r.getTenantCode())).collect(Collectors.toList());
            }
        }
        return resultList;
    }
}

