/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.support.security.plugin.oauth2.logic.SecurityOAuth2Util;
import com.jxdinfo.hussar.support.security.plugin.oauth2.model.ClientTokenModel;
import com.jxdinfo.hussar.unify.authentication.client.service.ClientModelPermissionService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar.unify.authentication", name={"enable"}, havingValue="true", matchIfMissing=false)
public class BaseClientModelPermissionServiceImpl
implements ClientModelPermissionService {
    private static Logger logger = LoggerFactory.getLogger(BaseClientModelPermissionServiceImpl.class);

    public List<String> getPermissionService(String clientId, String tenantCode) {
        try {
            ClientTokenModel clientTokenModel = SecurityOAuth2Util.securityOAuth2Template.getClientTokenModel(clientId, tenantCode);
            return clientTokenModel == null ? new ArrayList() : clientTokenModel.permissions;
        }
        catch (Exception e) {
            logger.error("\u901a\u8fc7\u5ba2\u6237\u7aefid\u83b7\u53d6\u5ba2\u6237\u7aef\u6743\u9650\u5217\u8868\u5931\u8d25\uff0cclientId = {}", (Object)clientId, (Object)e);
            return new ArrayList<String>();
        }
    }
}

