/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserIdentityService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.properties.HussarBaseProperties;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.security.core.stp.SecurityInterface;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SecurityInterfaceBaseImpl
implements SecurityInterface {
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruRoleService sysStruRoleService;
    @Resource
    private HussarBaseProperties hussarBaseProperties;
    @Resource
    private IHussarBaseUserIdentityService hussarBaseUserIdentityService;

    public List<String> getPermissionList(Object loginId, String loginType) {
        return this.getResourcePermission();
    }

    public Set<String> getPermissionList(UserDetails userDetails, String loginType) {
        if (HussarUtils.isEmpty((Object)userDetails)) {
            return new HashSet<String>();
        }
        return this.hussarBaseUserIdentityService.getPermissionByUserId(userDetails.getUserId());
    }

    public List<String> getRoleList(Object loginId, String loginType) {
        return this.getRolePermission(Long.valueOf(String.valueOf(loginId)));
    }

    private List<Long> getRoleIdList(Long userId) {
        SysUsers sysUsers = this.sysUsersService.getUser(userId);
        if (HussarUtils.isEmpty((Object)sysUsers)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        List userRoleList = this.sysUserRoleService.list((Wrapper)new LambdaQueryWrapper().eq(SysUserRole::getUserId, (Object)userId));
        userRoleList.forEach(userRole -> roleIdList.add(userRole.getGrantedRole()));
        if (ToolUtil.isNotEmpty((Object)sysUsers.getEmployeeId()) && ToolUtil.isNotEmpty((Object)sysUsers.getDepartmentId())) {
            List roleList = this.sysStruRoleService.getRolesByStruId(sysUsers.getDepartmentId());
            roleIdList.addAll(roleList);
        }
        return roleIdList;
    }

    private List<String> getResourcePermission() {
        return HussarSecurityUtils.getPermissions();
    }

    private List<String> getRolePermission(Long userId) {
        List<Long> roleIdList = this.getRoleIdList(userId);
        ArrayList<String> rolePermissionList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(roleIdList)) {
            List rolesList = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().in(SysRoles::getId, roleIdList));
            rolesList.forEach(role -> rolePermissionList.add(role.getRolePermission()));
        }
        return rolePermissionList;
    }

    @HussarDs(value="#connName")
    private List<String> getResourcePermissionByDs(String connName, Long userId) {
        return this.getResourcePermission();
    }

    @HussarDs(value="#connName")
    private List<String> getRolePermissionByDs(String connName, Long userId) {
        return this.getRolePermission(userId);
    }
}

