/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.jxdinfo.hussar.authentication.model.SysAuthClientScope;
import com.jxdinfo.hussar.authentication.service.SysAuthClientScopeService;
import com.jxdinfo.hussar.authentication.service.SysAuthScopePermissionService;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientPermissionService;
import com.jxdinfo.hussar.iam.client.vo.ClientPermissionVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.apimanager.core.support.model.ScopePermissionModel;
import com.jxdinfo.hussar.support.apimanager.core.support.service.ScopePermissionService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@ConditionalOnProperty(prefix="hussar.base", name={"scope-permission-type"}, havingValue="Base", matchIfMissing=false)
@HussarTokenDs
@Service
public class ScopePermissionServiceImpl
implements ScopePermissionService {
    @Autowired
    private SysAuthClientScopeService sysAuthClientScopeService;
    @Autowired
    private SysAuthScopePermissionService sysAuthScopePermissionService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Resource
    private IHussarIamClientPermissionService hussarIamClientPermissionService;

    public List<String> getPermissionList(ScopePermissionModel scopePermissionModel) {
        String scope = scopePermissionModel.getScope();
        String tenantCode = scopePermissionModel.getTenantCode();
        String clientId = scopePermissionModel.getClientId();
        List<String> permissions = this.getPermissionList(scope, tenantCode);
        ArrayList<String> permissionList = new ArrayList<String>(permissions);
        ApiResponse response = this.hussarIamClientPermissionService.listClientPermissions(clientId);
        List clientPermissionVoList = (List)response.getData();
        List urls = clientPermissionVoList.stream().map(ClientPermissionVo::getUrl).collect(Collectors.toList());
        permissionList.addAll(urls);
        return permissionList.stream().distinct().collect(Collectors.toList());
    }

    public List<String> getPermissionList(String scope, String tenantCode) {
        HussarTenantDefinition definition;
        if (HussarUtils.isEmpty((Object)scope)) {
            return new ArrayList<String>();
        }
        String connName = "master";
        if (this.hussarTenantProperties.isEnabled() && HussarUtils.isNotEmpty((Object)(definition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode)))) {
            connName = definition.getConnName();
        }
        Object[] scopes = scope.split(",");
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.in(SysAuthClientScope::getScope, scopes);
        List sysAuthClientScopes = this.sysAuthClientScopeService.list(connName, (Wrapper)queryWrapper);
        ArrayList<String> allNameList = new ArrayList<String>();
        for (SysAuthClientScope sysAuthClientScope : sysAuthClientScopes) {
            List urlNameList = this.sysAuthScopePermissionService.getUrlNameList(connName, sysAuthClientScope.getId());
            urlNameList = urlNameList.stream().distinct().collect(Collectors.toList());
            allNameList.addAll(urlNameList);
        }
        return allNameList;
    }
}

