/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.enums.AuthenticationEnum;
import com.jxdinfo.hussar.authorization.enums.UserStatus;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.cloud.service.SysAuthUserDetailsService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.support.service.AuthSecurityUserDetailService;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.utils.TranslateUtil;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AuthSecurityUserDetailServiceImpl
implements AuthSecurityUserDetailService {
    @Autowired
    private SysAuthUserDetailsService sysAuthUserDetailsService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private ISysUsersService iSysUsersService;

    public UserDetails loadUserByUsername(LoginUser loginUser) {
        return this.sysAuthUserDetailsService.getLoginUserByAccount(loginUser);
    }

    public UserDetails loadUserBySocial(String code) {
        return null;
    }

    public Boolean checkUserPassword(String password) {
        if (ToolUtil.isEmpty((Object)password)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SECONDARY_PASSWORD_EMPTY.getValue()));
        }
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)securityUser)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_SECONDARY_FAIL_OBTAIN_USER_INFO.getValue()));
        }
        SysUsers sysUsers = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)securityUser.getAccount())).ne(SysUsers::getAccountStatus, (Object)UserStatus.DELETE.getCode())).ne(SysUsers::getAccountStatus, (Object)UserStatus.CANCEL.getCode()), false);
        if (ToolUtil.isEmpty((Object)sysUsers)) {
            throw new BaseException(securityUser.getAccount() + TranslateUtil.getTranslateName((String)AuthenticationEnum.AUTHEN_ID_BELONGS_USER_NOT_EXIST.getValue()));
        }
        String encPwd = this.credentialsMatcher.passwordEncode(password.getBytes());
        return encPwd.equalsIgnoreCase(sysUsers.getPassword());
    }
}

