/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.dto.AuthcDto;
import com.jxdinfo.hussar.authentication.service.HussarLoginService;
import com.jxdinfo.hussar.base.cloud.service.SysAuthUserDetailsService;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.platform.core.support.service.dto.LoginUser;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SysAuthUserDetailsServiceImpl
implements SysAuthUserDetailsService {
    private static Logger logger = LoggerFactory.getLogger(SysAuthUserDetailsServiceImpl.class);
    @Resource
    private HussarLoginService hussarLoginService;
    @Resource
    private IDynamicDataSourceService dynamicDataSourceService;

    public UserDetails getLoginUserByAccount(LoginUser loginUser) {
        AuthcDto authcDto = new AuthcDto();
        authcDto.setUsername(loginUser.getUserName());
        authcDto.setCipher(loginUser.getPassword());
        authcDto.setIsIndex(loginUser.getExtendMap("isIndex"));
        authcDto.setKaptcha(loginUser.getExtendMap("kaptcha"));
        authcDto.setTotp(loginUser.getExtendMap("totp"));
        authcDto.setKaptchasuffix(loginUser.getExtendMap("kaptchasuffix"));
        if (HussarUtils.isEmpty((Object)authcDto)) {
            return null;
        }
        UserDetails securityUser = this.getUserInfo(authcDto);
        return securityUser;
    }

    private UserDetails getUserInfo(AuthcDto authcDto) {
        UserDetails userInfo = this.hussarLoginService.login(authcDto);
        if (HussarUtils.isNotEmpty((Object)userInfo)) {
            userInfo.addExtendUserMap("baseConnName", (Object)this.dynamicDataSourceService.currentDsName());
            return userInfo;
        }
        return null;
    }

    @HussarDs(value="#connName")
    private UserDetails getUserInfoByChangDs(String connName, AuthcDto authcDto) {
        authcDto.setDsName(connName);
        return this.getUserInfo(authcDto);
    }
}

