/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.job;

import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.model.DefaultTenant;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UnlockJob
implements BasicProcessor {
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysUsersService sysUsersService;

    public ProcessResult process(TaskContext context) throws Exception {
        String tenantCode = context.getTenantCode();
        if (StringUtils.isBlank((CharSequence)tenantCode) || "0".equals(tenantCode)) {
            boolean tenantOpen = TenantCacheUtil.openTenant();
            HashSet<String> connNameList = new HashSet<String>();
            Map normalTenants = new HashMap<String, DefaultTenant>();
            if (tenantOpen) {
                Set tenantConnNameList = this.sysTenantService.getConnNameList();
                if (HussarUtils.isNotEmpty((Object)tenantConnNameList)) {
                    connNameList.addAll(tenantConnNameList);
                }
                normalTenants = this.sysTenantService.getNormalTenants();
            } else {
                connNameList.add("master");
                normalTenants.put("master", new DefaultTenant());
            }
            for (String connName : connNameList) {
                HussarTenantDefinition hussarTenantDefinition = (HussarTenantDefinition)normalTenants.get(connName);
                if (hussarTenantDefinition == null) {
                    throw new BaseException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6e90\u540d\u79f0\u4e3a" + connName + "\u7684\u79df\u6237");
                }
                HussarContextHolder.setTenant((HussarTenantDefinition)hussarTenantDefinition);
                this.sysUsersService.unLock(connName);
                HussarContextHolder.remove();
            }
        }
        return new ProcessResult(true, "success");
    }
}

