/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.controller;

import com.jxdinfo.hussar.authentication.util.JitGatewayUtil;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/gateway"})
public class CAHandlerBS
extends BaseController {
    private static final String propertiesURL = "jitgwmessage.properties";
    @Resource
    private ISysUsersService sysUsersService;

    @RequestMapping(value={"/getPropertiesData"})
    @ResponseBody
    public ApiResponse<?> getPropertiesData() throws IOException {
        System.out.println("\u751f\u6210\u539f\u6587\u521d\u59cb\u5316\u5f00\u59cb");
        boolean configItemRightFlag = JitGatewayUtil.initConfigBean(propertiesURL);
        System.out.println("\u751f\u6210\u539f\u6587\u521d\u59cb\u5316\u7ed3\u675f");
        if (!configItemRightFlag) {
            String errorInfo = "\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e";
            System.out.println(errorInfo);
            return ApiResponse.fail((String)errorInfo);
        }
        String appid = (String)JitGatewayUtil.configMap.get("appId");
        String gwUrl = (String)JitGatewayUtil.configMap.get("authURL");
        URL url = new URL(gwUrl);
        gwUrl = url.getHost();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appId", appid);
        map.put("gwUrl", gwUrl);
        return ApiResponse.success(map);
    }

    @RequestMapping(value={"/jitGWTokenAndAuthen"})
    @ResponseBody
    public ApiResponse<?> jitGWTokenAndAuthen(HttpServletRequest req, @RequestBody Map<String, String> body) throws IOException {
        System.out.println("T+A\u8ba4\u8bc1\u5f00\u59cb\uff01\n");
        String message = "error";
        String errorInfo = "";
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        HttpServletRequest request = req;
        jitGatewayUtil.jitGatewayUtilBean.setToken(body.get("token"));
        jitGatewayUtil.tokenSend();
        HttpSession session = request.getSession(true);
        session.setAttribute("isSuccess", (Object)jitGatewayUtil.authResult.isSuccess());
        if (!jitGatewayUtil.authResult.isSuccess()) {
            errorInfo = "T+A\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jitGatewayUtil.authResult.getErrDesc();
            System.out.println(errorInfo);
        } else {
            message = "success";
            session.setAttribute("certAttributeNodeMap", (Object)jitGatewayUtil.authResult.getCertAttributeNodeMap());
            session.setAttribute("umsAttributeNodeMap", (Object)jitGatewayUtil.authResult.getUmsAttributeNodeMap());
            session.setAttribute("pmsAttributeNodeMap", (Object)jitGatewayUtil.authResult.getPmsAttributeNodeMap());
            session.setAttribute("customAttributeNodeMap", (Object)jitGatewayUtil.authResult.getCustomAttributeNodeMap());
            System.out.println("T+A\u8eab\u4efd\u8ba4\u8bc1\u6210\u529f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6b63\u5e38\u8fd4\u56de\uff01\n");
        }
        System.out.println("T+A\u8eab\u4efd\u8ba4\u8bc1\u7ed3\u675f\uff01\n");
        if ("success".equals(message)) {
            HashMap map = new HashMap();
            return ApiResponse.success(map);
        }
        return ApiResponse.fail((String)errorInfo);
    }

    @RequestMapping(value={"/login"})
    @ResponseBody
    public ApiResponse<?> login(HttpServletRequest req) throws IOException, ServletException {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpServletRequest request = req;
        HttpSession session = request.getSession(false);
        boolean isSuccess = false;
        if (ToolUtil.isNotEmpty((Object)session)) {
            isSuccess = (Boolean)session.getAttribute("isSuccess");
        }
        System.out.println("\u8ba4\u8bc1\u6210\u529f\u6807\u8bb0:" + isSuccess);
        String errorInfo = "";
        if (isSuccess) {
            Map certAttributeNodeMap = (Map)session.getAttribute("certAttributeNodeMap");
            Map umsAttributeNodeMap = (Map)session.getAttribute("umsAttributeNodeMap");
            Map pmsAttributeNodeMap = (Map)session.getAttribute("pmsAttributeNodeMap");
            String customAttributeNodeMap = session.getAttribute("customAttributeNodeMap") == null ? null : session.getAttribute("customAttributeNodeMap").toString();
            String DN = "";
            if (certAttributeNodeMap != null && certAttributeNodeMap.size() > 0) {
                for (Map.Entry entry : certAttributeNodeMap.entrySet()) {
                    Object key = entry.getKey();
                    String[] keys = null;
                    if (key == null || key.equals("")) continue;
                    keys = (String[])key;
                    Object val = entry.getValue();
                    if (val == null) continue;
                    DN = val.toString();
                }
            }
            System.out.println("dnname:" + DN + ":");
            String userKeyID = "";
            String cardID = "";
            String isNew = "true";
            if (DN != null && !DN.equals("")) {
                String[] strKeys = DN.split(",");
                for (int i = 0; i < strKeys.length; ++i) {
                    String[] strValues = strKeys[i].split("=");
                    if (strValues[0].trim().equals("CN")) {
                        userKeyID = strValues[1];
                        continue;
                    }
                    if (strValues[0].trim().equals("T")) {
                        cardID = strValues[1];
                        continue;
                    }
                    if (!strValues[0].trim().equals("E")) continue;
                    cardID = strValues[1];
                    isNew = "false";
                }
            }
            String clientIp = "";
            String clientip = "";
            String ip = "";
            try {
                try {
                    clientIp = request.getHeader("clientIp");
                    if (clientIp == null) {
                        clientIp = "";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    clientip = request.getHeader("clientip");
                    if (clientip == null) {
                        clientip = "";
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ip = clientIp.length() > 0 && clientip.length() > 0 && clientIp.equals(clientip) ? clientIp : (clientIp.length() > 0 ? clientIp : (clientip.length() > 0 ? clientip : ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Date d = new Date();
            System.out.println(":CAKeyID:" + userKeyID + ":cardID:" + cardID + ":ip:" + ip + ":#############\u767b\u5f55\u65f6\u95f4:" + d.toLocaleString());
            if (!"".equals(cardID)) {
                cardID = cardID.toUpperCase();
            }
            SysUsers sysUsers = this.sysUsersService.getUsersByIdCard(cardID);
            result.put("userAccount", sysUsers.getUserAccount());
            result.put("cardID", cardID);
            result.put("userIp", ip);
        } else {
            if (null != session.getAttribute("errCode")) {
                String errCode = session.getAttribute("errCode").toString();
                String codeMsg = "\u9519\u8bef\u7f16\u7801:" + errCode;
                errorInfo = errorInfo + codeMsg;
                System.out.println(codeMsg);
            }
            if (null != session.getAttribute("errDesc")) {
                String errDesc = session.getAttribute("errDesc").toString();
                String errMsg = "\u9519\u8bef\u63cf\u8ff0:" + errDesc;
                errorInfo = errorInfo + errMsg;
                System.out.println("\u9519\u8bef\u63cf\u8ff0:" + errDesc);
            }
        }
        if (ToolUtil.isNotEmpty(result)) {
            return ApiResponse.success(result);
        }
        return ApiResponse.fail((String)errorInfo);
    }

    @RequestMapping(value={"/jitGWRandom"})
    @ResponseBody
    public ApiResponse<?> jitGWRandom(HttpServletRequest req) throws IOException {
        System.out.println("\u751f\u6210\u539f\u6587\u521d\u59cb\u5316\u5f00\u59cb");
        boolean configItemRightFlag = JitGatewayUtil.initConfigBean(propertiesURL);
        System.out.println("\u751f\u6210\u539f\u6587\u521d\u59cb\u5316\u7ed3\u675f");
        if (!configItemRightFlag) {
            String errorInfo = "\u914d\u7f6e\u6587\u4ef6\u4e0d\u6b63\u786e";
            System.out.println(errorInfo);
            return ApiResponse.fail((String)errorInfo);
        }
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        HttpServletRequest request = req;
        Object qrCodeAuthObj = JitGatewayUtil.configMap.get("QRCodeAuth");
        String qrCodeAuthStr = String.valueOf(qrCodeAuthObj);
        String randNum = null;
        String pinCode = "false";
        if ("false".equals(qrCodeAuthStr)) {
            System.out.println("\u751f\u6210\u539f\u6587\u5f00\u59cb");
            randNum = jitGatewayUtil.generateRandomNum();
            if (!jitGatewayUtil.isNotNull(randNum)) {
                String errorInfo = "\u751f\u6210\u539f\u6587\u4e3a\u7a7a";
                System.out.println(errorInfo);
                return ApiResponse.fail((String)errorInfo);
            }
            pinCode = (String)JitGatewayUtil.configMap.get("pinCode");
            request.getSession().setAttribute("original_data", (Object)randNum);
            System.out.println("\u751f\u6210\u539f\u6587\u7ed3\u675f\uff0c\u6210\u529f\u751f\u6210\u539f\u6587\uff1a" + randNum);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("original_data", randNum);
        map.put("QRCodeAuth", qrCodeAuthStr);
        map.put("original", randNum);
        map.put("pinCode", pinCode);
        return ApiResponse.success(map);
    }

    @RequestMapping(value={"/jitGWAuth"})
    @ResponseBody
    public ApiResponse<?> jitGWAuth(HttpServletRequest req, @RequestBody Map<String, String> body) throws IOException {
        Cookie[] cookies;
        System.out.println("\u8eab\u4efd\u8ba4\u8bc1\u5f00\u59cb\uff01\n");
        JitGatewayUtil jitGatewayUtil = new JitGatewayUtil();
        HttpServletRequest request = req;
        jitGatewayUtil.jitGatewayUtilBean.setAuthMode(body.get("authMode"));
        jitGatewayUtil.jitGatewayUtilBean.setToken(body.get("token"));
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_data(this.getProperties(request.getSession(), "original_data"));
        jitGatewayUtil.jitGatewayUtilBean.setOriginal_jsp(body.get("original"));
        jitGatewayUtil.jitGatewayUtilBean.setSigned_data(body.get("signed_data"));
        jitGatewayUtil.jitGatewayUtilBean.setRemoteAddr(request.getRemoteAddr());
        jitGatewayUtil.jitGatewayUtilBean.setPinCode(body.get("key_pin"));
        jitGatewayUtil.jitGatewayUtilBean.setQctoken(body.get("qctoken"));
        String qrcode = null;
        for (Cookie cookie : cookies = request.getCookies()) {
            if (!"jit_qrcode".equalsIgnoreCase(cookie.getName())) continue;
            qrcode = cookie.getValue();
        }
        jitGatewayUtil.jitGatewayUtilBean.setQrcode(qrcode);
        jitGatewayUtil.auth();
        HttpSession session = request.getSession(true);
        session.setAttribute("isSuccess", (Object)jitGatewayUtil.authResult.isSuccess());
        String message = "error";
        String errorInfo = "";
        if (!jitGatewayUtil.authResult.isSuccess()) {
            if (jitGatewayUtil.isNotNull(jitGatewayUtil.authResult.getErrCode())) {
                session.setAttribute("errCode", (Object)jitGatewayUtil.authResult.getErrCode());
            }
            if (jitGatewayUtil.isNotNull(jitGatewayUtil.authResult.getErrDesc())) {
                session.setAttribute("errDesc", (Object)jitGatewayUtil.authResult.getErrDesc());
            }
            errorInfo = "\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + jitGatewayUtil.authResult.getErrDesc();
            System.out.println(errorInfo);
        } else {
            message = "success";
            session.setAttribute("certAttributeNodeMap", (Object)jitGatewayUtil.authResult.getCertAttributeNodeMap());
            session.setAttribute("umsAttributeNodeMap", (Object)jitGatewayUtil.authResult.getUmsAttributeNodeMap());
            session.setAttribute("pmsAttributeNodeMap", (Object)jitGatewayUtil.authResult.getPmsAttributeNodeMap());
            session.setAttribute("customAttributeNodeMap", (Object)jitGatewayUtil.authResult.getCustomAttributeNodeMap());
            session.setAttribute("keyPin", jitGatewayUtil.authResult.getKeyPinList());
            System.out.println("\u8eab\u4efd\u8ba4\u8bc1\u6210\u529f\uff0c\u8ba4\u8bc1\u4fe1\u606f\u6b63\u5e38\u8fd4\u56de\uff01\n");
        }
        System.out.println("\u8eab\u4efd\u8ba4\u8bc1\u7ed3\u675f\uff01\n");
        if ("success".equals(message)) {
            HashMap map = new HashMap();
            return ApiResponse.success(map);
        }
        return ApiResponse.fail((String)errorInfo);
    }

    private String getProperties(HttpSession httpSession, String key) {
        return httpSession.getAttribute(key) == null ? null : httpSession.getAttribute(key).toString();
    }
}

