/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.exception;

import com.jxdinfo.hussar.common.exception.BaseExceptionEnum;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.constants.enums.ExceptionCodeEnum;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLoginException;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLoginParamException;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientLogoutException;
import com.jxdinfo.hussar.unify.authentication.client.exception.ClientUnLoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
public class BaseAuthenticationExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(BaseAuthenticationExceptionHandler.class);

    @ExceptionHandler(value={ClientLoginException.class})
    public ApiResponse<?> handlerException(ClientLoginException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)BaseExceptionEnum.BUSSINESS_EXCEPTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ClientLoginParamException.class})
    public ApiResponse<?> handlerException(ClientLoginParamException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)BaseExceptionEnum.BUSSINESS_EXCEPTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ClientLogoutException.class})
    public ApiResponse<?> handlerException(ClientLogoutException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)BaseExceptionEnum.BUSSINESS_EXCEPTION.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ClientUnLoginException.class})
    public ApiResponse<?> handlerException(ClientUnLoginException e) {
        logger.error("\u5f02\u5e38\u4fe1\u606f\uff1a", (Throwable)e);
        return ApiResponse.fail((int)ExceptionCodeEnum.NOTLOGIN_CODE.getCode(), (String)e.getMessage());
    }
}

