/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.jxdinfo.hussar.authentication.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.support.security.core.session.SecuritySession;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="hussar.cache", name={"cacheType"}, havingValue="ehcache", matchIfMissing=false)
public class MapSessionLimit
implements SessionLimit {
    private static Map<String, Deque<Serializable>> USERSESSION = new HashMap<String, Deque<Serializable>>();

    public Deque<Serializable> getUserSession(String userId) {
        Deque<Serializable> deque = USERSESSION.get(userId);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
        }
        return deque;
    }

    public Deque<Serializable> getUserSession(String userId, String connName) {
        Deque<Serializable> deque = USERSESSION.get(userId + connName);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
        }
        return deque;
    }

    public void addUserSession(String userId, Deque<Serializable> deque) {
        USERSESSION.put(userId, deque);
    }

    public void addUserSession(String userId, String connName, Deque<Serializable> deque) {
        USERSESSION.put(userId + connName, deque);
    }

    public void removeBySession(SecuritySession session) {
        Deque<Serializable> deque;
        SecurityUser shiroUser = (SecurityUser)session.get("baseUserInfo");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty(deque = USERSESSION.get(shiroUser.getId()))) {
            deque.remove(session.getId());
            USERSESSION.put(String.valueOf(shiroUser.getId()), deque);
        }
    }

    public void removeBySession(SecuritySession session, String connName) {
        String key;
        Deque<Serializable> deque;
        SecurityUser shiroUser = (SecurityUser)session.get("baseUserInfo");
        if (ToolUtil.isNotEmpty((Object)shiroUser) && ToolUtil.isNotEmpty(deque = USERSESSION.get(key = shiroUser.getId() + connName))) {
            deque.remove(session.getId());
            USERSESSION.put(key, deque);
        }
    }
}

