/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.authentication.dto.GetBackPasswordDto;
import com.jxdinfo.hussar.authentication.service.GetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.model.SysGetBackPassword;
import com.jxdinfo.hussar.authorization.permit.model.SysPasswordHist;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysGetBackPasswordService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarLoginConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.IHussarPwdConfigService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.crypto.credential.AbstractCredentialsMatcher;
import com.jxdinfo.hussar.platform.core.crypto.properties.HussarEncryptProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.security.service.PasswordEncryptService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GetBackPasswordServiceImpl
implements GetBackPasswordService {
    private static Long EXPIRE_TIME = 600L;
    @Resource
    private ISysUsersService iSysUsersService;
    @Resource
    private ISysGetBackPasswordService iSysGetBackPasswordService;
    @Resource
    private AbstractCredentialsMatcher credentialsMatcher;
    @Resource
    private IHussarLoginConfigService hussarLoginConfigService;
    @Resource
    private IHussarPwdConfigService hussarPwdConfigService;
    @Resource
    private HussarEncryptProperties hussarEncryptProperties;
    @Resource
    private PasswordEncryptService passwordEncryptService;
    private static final String[] EXCLUDE_USER = new String[]{"superadmin", "businessadmin", "auditadmin", "reviewadmin", "systemadmin", "hussar"};

    public ApiResponse<GetBackPasswordDto> queryUserQues(String userAccount) {
        return this.queryUserQues(userAccount, "-1", null);
    }

    public ApiResponse<GetBackPasswordDto> queryUserQues(String userAccount, String kaptcha, String kaptchasuffix) {
        if (HussarUtils.isBlank((CharSequence)kaptcha)) {
            throw new BaseException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String code = (String)HussarCacheUtil.get((String)"KAPTCHA_CODE", (Object)kaptchasuffix, String.class);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BaseException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        if (ToolUtil.isEmpty((Object)kaptcha) || !kaptcha.equalsIgnoreCase(code)) {
            throw new BaseException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        HussarCacheUtil.evict((String)"KAPTCHA_CODE", (Object)kaptchasuffix);
        if (ToolUtil.isEmpty((Object)userAccount)) {
            throw new BaseException("\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)userAccount)) {
            userAccount = userAccount.toUpperCase();
        }
        if (!this.iSysUsersService.isExistAccount(userAccount)) {
            throw new BaseException("\u7528\u6237\u672a\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u5bc6\u7801\uff01");
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isEmpty((Object)sysGetBackPassword)) {
            throw new BaseException("\u7528\u6237\u672a\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u5bc6\u7801\uff01");
        }
        GetBackPasswordDto getBackPasswordVo = new GetBackPasswordDto();
        getBackPasswordVo.setQuestion(sysGetBackPassword.getpQues());
        getBackPasswordVo.setUserAccount(userAccount);
        return ApiResponse.success((Object)getBackPasswordVo);
    }

    public ApiResponse queryValidateKey(GetBackPasswordDto getBackPasswordDto) {
        String pKey;
        String pQues;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, pQues = getBackPasswordDto.getQuestion(), pKey = getBackPasswordDto.getAnswer()})) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HussarCacheUtil.evict((String)"answer_info", (Object)userAccount);
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        SysGetBackPassword sysGetBackPassword = (SysGetBackPassword)this.iSysGetBackPasswordService.getById((Serializable)user.getId());
        if (ToolUtil.isNotEmpty((Object)sysGetBackPassword)) {
            if (pQues.equals(sysGetBackPassword.getpQues()) && pKey.equals(sysGetBackPassword.getpKey())) {
                HussarCacheUtil.put((String)"answer_info", (Object)userAccount, (Object)ResultCode.SUCCESS.getCode(), (long)EXPIRE_TIME);
                return ApiResponse.success((String)"\u9a8c\u8bc1\u901a\u8fc7\uff0c\u8bf7\u8bbe\u7f6e\u60a8\u7684\u65b0\u5bc6\u7801\uff01");
            }
            throw new BaseException("\u60a8\u8f93\u5165\u7684\u7b54\u6848\u4e0d\u6b63\u786e\uff01");
        }
        throw new BaseException("\u7528\u6237\u672a\u8bbe\u7f6e\u5bc6\u4fdd\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u627e\u56de\u5bc6\u7801\uff01");
    }

    public ApiResponse saveNewPwd(GetBackPasswordDto getBackPasswordDto) {
        Object checkAnswer;
        String cPwd;
        String newPwd;
        String userAccount = getBackPasswordDto.getUserAccount();
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userAccount, newPwd = getBackPasswordDto.getNewPwd(), cPwd = getBackPasswordDto.getCheckPwd()})) {
            throw new BaseException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.hussarLoginConfigService.getLoginUpperOpen().booleanValue() && !ArrayUtils.contains((Object[])EXCLUDE_USER, (Object)userAccount)) {
            userAccount = userAccount.toUpperCase();
        }
        if ((checkAnswer = HussarCacheUtil.get((String)"answer_info", (Object)userAccount)) == null) {
            return ApiResponse.fail((String)"\u5bc6\u4fdd\u95ee\u9898\u672a\u9a8c\u8bc1\u901a\u8fc7");
        }
        if (this.hussarEncryptProperties.isEnablePwEncryption()) {
            newPwd = this.passwordEncryptService.decrypt(newPwd);
            cPwd = this.passwordEncryptService.decrypt(cPwd);
        }
        SysUsers user = (SysUsers)this.iSysUsersService.getOne((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysUsers::getUserAccount, (Object)userAccount)).ne(SysUsers::getAccountStatus, (Object)"2"), false);
        Long userId = user.getId();
        String regular = this.hussarPwdConfigService.getPwdComplexityRegular().replaceAll("/", "");
        String hint = this.hussarPwdConfigService.getUnmatchedHintMark();
        String unmatchedHint = this.hussarPwdConfigService.getUnmatchedHint();
        String pwdRule = this.hussarPwdConfigService.getPwdRule();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!newPwd.matches(regular)) {
            result.put("success", false);
            result.put("error", "unmatchedHintMark");
            result.put("pwdRule", pwdRule);
            result.put("hintMark", hint);
            result.put("msg", unmatchedHint);
            return ApiResponse.success(result);
        }
        if (newPwd.toLowerCase().contains(userAccount.toLowerCase())) {
            result.put("success", false);
            result.put("error", "updateFailPwdNotUser");
            return ApiResponse.success(result);
        }
        if (!newPwd.equals(cPwd)) {
            result.put("success", false);
            result.put("error", "pwdNotSame");
            return ApiResponse.success(result);
        }
        String nPwd = this.credentialsMatcher.passwordEncode(newPwd.getBytes());
        List list = this.iSysUsersService.getPwdHist(userId);
        for (SysPasswordHist sysPasswordHist : list) {
            if (!nPwd.equals(sysPasswordHist.getPassword())) continue;
            result.put("success", false);
            result.put("error", "resetFail");
            result.put("repeatTime", this.hussarPwdConfigService.getPwdRepeatTime());
            return ApiResponse.success(result);
        }
        user.setPassword(nPwd);
        this.iSysUsersService.updatePwd(user);
        result.put("success", true);
        HussarCacheUtil.evict((String)"answer_info", (Object)userAccount);
        return ApiResponse.success(result);
    }
}

