/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.authentication.bo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.hussar.authentication.enums.ObjectMapperInstance;
import java.util.Arrays;
import java.util.Map;

public class HttpRequestBO {
    private final String url;
    private final Map<String, Object> params;
    private final Map<String, Object> headers;
    private final Object requestBody;
    private final Class<?> responseObj;
    private final TypeReference<?> typeReference;
    private final JavaType javaType;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperInstance.INSTANCE.getObjectMapper();

    private HttpRequestBO(HttpRequestBOBuilder builder) {
        this.url = builder.url;
        this.params = builder.params;
        this.headers = builder.headers;
        this.requestBody = builder.requestBody;
        this.responseObj = builder.responseObj;
        this.typeReference = builder.typeReference;
        this.javaType = builder.javaType;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Object getRequestBody() {
        return this.requestBody;
    }

    public Class<?> getResponseObj() {
        return this.responseObj;
    }

    public TypeReference<?> getTypeReference() {
        return this.typeReference;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public static class HttpRequestBOBuilder {
        private String url;
        private Map<String, Object> params;
        private Map<String, Object> headers;
        private Object requestBody;
        private Class<?> responseObj;
        private TypeReference<?> typeReference;
        private JavaType javaType;

        public HttpRequestBOBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpRequestBOBuilder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public HttpRequestBOBuilder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public HttpRequestBOBuilder requestBody(Object requestBody) {
            this.requestBody = requestBody;
            return this;
        }

        public HttpRequestBOBuilder responseObj(Class<?> responseObj) {
            this.responseObj = responseObj;
            return this;
        }

        public HttpRequestBOBuilder responseObj(TypeReference<?> typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        public HttpRequestBOBuilder responseObj(JavaType javaType) {
            this.javaType = javaType;
            return this;
        }

        public HttpRequestBOBuilder responseObj(Class<?> ... clazzes) {
            JavaType result = clazzes.length > 1 ? OBJECT_MAPPER.getTypeFactory().constructParametricType(clazzes[0], (Class[])Arrays.copyOfRange(clazzes, 1, clazzes.length)) : OBJECT_MAPPER.getTypeFactory().constructType(clazzes[0]);
            this.javaType = result;
            return this;
        }

        public HttpRequestBO request() {
            return new HttpRequestBO(this);
        }
    }
}

