/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.audit.service.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.audit.constant.AuthorizationConstant;
import com.jxdinfo.hussar.audit.constant.SqlQueryConstant;
import com.jxdinfo.hussar.audit.dao.SysSupportAuditLogMapper;
import com.jxdinfo.hussar.audit.dto.AccessAuditLogDTO;
import com.jxdinfo.hussar.audit.dto.AuditLogExportExcelDto;
import com.jxdinfo.hussar.audit.model.AuditLogExportExcel;
import com.jxdinfo.hussar.audit.model.AuditLogExportExcelDesc;
import com.jxdinfo.hussar.audit.properties.AuditExportProperties;
import com.jxdinfo.hussar.audit.service.IAccessAuditLog;
import com.jxdinfo.hussar.audit.service.IBaseAuditLogService;
import com.jxdinfo.hussar.audit.vo.AccessAuditLogVo;
import com.jxdinfo.hussar.audit.vo.AuditLogChartColumnVo;
import com.jxdinfo.hussar.audit.vo.AuditLogChartVo;
import com.jxdinfo.hussar.audit.vo.AuditLogEntityVo;
import com.jxdinfo.hussar.audit.vo.AuditLogSpaceUsageVo;
import com.jxdinfo.hussar.audit.vo.AuditLogVo;
import com.jxdinfo.hussar.audit.vo.AuditTypeVo;
import com.jxdinfo.hussar.audit.vo.SeverityLevelVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.config.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.base.config.baseconfig.service.ICreateUserConfigService;
import com.jxdinfo.hussar.base.config.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.Java8DateUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.excel.builder.ConcreteExcelBuilder;
import com.jxdinfo.hussar.excel.builder.ExcelProduct;
import com.jxdinfo.hussar.excel.model.ClassSheetMsg;
import com.jxdinfo.hussar.excel.service.IHussarBaseExcelService;
import com.jxdinfo.hussar.excel.service.ISysExcelTaskService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogCURDService;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.enums.AuditSeverityLevel;
import com.jxdinfo.hussar.support.audit.core.enums.RequestResult;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service
public class BaseAuditLogServiceImpl
extends HussarBaseServiceImpl<SysSupportAuditLogMapper, AuditLogEntity>
implements IBaseAuditLogService {
    private static final String[] ORDERS = new String[]{"ASC", "DESC"};
    private static final String DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    @Resource
    private AuditLogCURDService auditLogCURDService;
    @Resource
    private ISysUsersService usersService;
    @Autowired
    private ICreateUserConfigService createUserConfigService;
    @Autowired
    private ISysBaseConfigService sysBaseConfigService;
    @Autowired
    private DynamicDatasourceService dynamicDatasourceService;
    @Autowired
    private IDynamicDataSourceService iDynamicDataSourceService;
    @Autowired
    private SysSupportAuditLogMapper sysSupportAuditLogMapper;
    @Autowired
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired
    private IHussarBaseExcelService hussarBaseExcelService;
    @Autowired
    private ISysExcelTaskService sysExcelTaskServiceImpl;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private IAccessAuditLog accessAuditLog;
    @Autowired
    private AuditExportProperties auditExportProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAuditLogServiceImpl.class);
    private static final List<DateTimeFormatter> FORMATTERS = Arrays.asList(DateTimeFormatter.ISO_DATE_TIME, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"), DateTimeFormatter.ofPattern("yyyy-MM-dd"));

    public IPage<AuditLogEntityVo> getAuditLogList(Page<AuditLogEntity> page, AuditLogEntity auditLogEntity, HttpServletRequest request) {
        String tokenId = request.getParameter("token_eq");
        String isSessionTracking = request.getParameter("isSessionTracking");
        if ("1".equals(isSessionTracking) && StringUtils.isBlank((CharSequence)tokenId)) {
            ArrayList<AuditLogEntityVo> resultList = new ArrayList<AuditLogEntityVo>();
            page.getRecords().forEach(item -> {
                AuditLogEntityVo auditLogEntityVo = new AuditLogEntityVo();
                CopyPropertieUtils.copyProperties((Object)auditLogEntityVo, (Object)item);
                resultList.add(auditLogEntityVo);
            });
            return this.replacePageType((IPage<?>)page, (List<AuditLogEntityVo>)resultList);
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            throw new BaseException("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u67e5\u8be2\u6761\u4ef6\u6709\u8bef");
        }
        IPage list = this.auditLogCURDService.listPage(auditLogEntity, page, request);
        AssertUtil.isNotNull((Object)list, (String)"\u5ba1\u8ba1\u65e5\u5fd7\u672a\u5f00\u542f");
        ArrayList<AuditLogEntityVo> result = new ArrayList<AuditLogEntityVo>();
        if (HussarUtils.isNotEmpty((Object)list.getRecords())) {
            List userIdList = list.getRecords().stream().map(AuditLogEntity::getUserId).collect(Collectors.toList());
            List usersList = this.usersService.listByIds(userIdList);
            HashMap<Long, SysUsers> longUserMap = new HashMap<Long, SysUsers>();
            for (SysUsers item2 : usersList) {
                longUserMap.put(item2.getId(), item2);
            }
            list.getRecords().forEach(o -> {
                SysUsers user;
                AuditLogEntityVo auditLogEntityVo = new AuditLogEntityVo();
                CopyPropertieUtils.copyProperties((Object)auditLogEntityVo, (Object)o);
                if (ToolUtil.isNotEmpty((Object)o.getEventGrade())) {
                    if (AuditEventGrade.SERVICE_LOG_TYPE.getType() == o.getEventGrade().intValue()) {
                        auditLogEntityVo.setEventGradeName(AuditEventGrade.SERVICE_LOG_TYPE.getDesc());
                    }
                    if (AuditEventGrade.SYSTEM_LOG_TYPE.getType() == o.getEventGrade().intValue()) {
                        auditLogEntityVo.setEventGradeName(AuditEventGrade.SYSTEM_LOG_TYPE.getDesc());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)o.getEventType())) {
                    auditLogEntityVo.setEventTypeName(this.getEvenTypeName(o.getEventType()));
                }
                if (ToolUtil.isNotEmpty((Object)o.getSeverityLevel())) {
                    auditLogEntityVo.setSeverityLevelName(AuditSeverityLevel.of((int)o.getSeverityLevel()).getDesc());
                }
                if (ToolUtil.isNotEmpty((Object)o.getRequesetResult())) {
                    if (RequestResult.success.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.success.getDesc());
                    }
                    if (RequestResult.failed.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.failed.getDesc());
                    }
                    if (RequestResult.progressing.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.progressing.getDesc());
                    }
                }
                if (HussarUtils.isNotEmpty((Object)(user = (SysUsers)longUserMap.get(o.getUserId())))) {
                    auditLogEntityVo.setUserAccount(user.getUserAccount());
                }
                auditLogEntityVo.setLogContent("\u7c7b\u540d:" + o.getPackageName() + "." + o.getClassName() + ";\u65b9\u6cd5\u540d:" + o.getMethodName() + ";\u64cd\u4f5c\u63cf\u8ff0:" + o.getEventDesc());
                result.add(auditLogEntityVo);
            });
        }
        return this.replacePageType((IPage<?>)page, (List<AuditLogEntityVo>)result);
    }

    public AuditLogChartVo getAuditLogChart(AuditLogEntity auditLogEntity, HttpServletRequest request) {
        AuditLogChartColumnVo auditLogChartColumnVo;
        Long totalLong;
        String newKey;
        HashMap<String, String[]> typeMap = new HashMap<String, String[]>();
        typeMap.put("field_groupby", new String[]{"eventType"});
        HashMap<String, String[]> gradeMap = new HashMap<String, String[]>();
        gradeMap.put("field_groupby", new String[]{"eventGrade"});
        typeMap.putAll(request.getParameterMap());
        gradeMap.putAll(request.getParameterMap());
        typeMap.remove("orderRule");
        gradeMap.remove("orderRule");
        List typeMaps = this.auditLogCURDService.listGroupCountList(auditLogEntity, typeMap);
        List gradeMaps = this.auditLogCURDService.listGroupCountList(auditLogEntity, gradeMap);
        ArrayList<AuditLogChartColumnVo> eventGradeChart = new ArrayList<AuditLogChartColumnVo>();
        ArrayList<AuditLogChartColumnVo> eventTypeChart = new ArrayList<AuditLogChartColumnVo>();
        for (AuditEventGrade auditEventGrade : AuditEventGrade.values()) {
            AuditLogChartColumnVo auditLogChartColumnVo2 = new AuditLogChartColumnVo();
            if (auditEventGrade.getType() == -1) continue;
            auditLogChartColumnVo2.setNum(Long.valueOf(0L));
            auditLogChartColumnVo2.setSubscript(auditEventGrade.getDesc());
            auditLogChartColumnVo2.setType(Integer.valueOf(auditEventGrade.getType()));
            eventGradeChart.add(auditLogChartColumnVo2);
        }
        if (HussarUtils.isNotEmpty((Object)gradeMaps)) {
            for (Map item : gradeMaps) {
                HashMap temp = new HashMap();
                for (Object key : item.keySet()) {
                    newKey = key.toString().toLowerCase();
                    temp.put(newKey, item.get(key));
                }
                Object v = temp.get("totalcount");
                totalLong = 0L;
                totalLong = v instanceof Integer ? Long.valueOf(((Integer)v).longValue()) : (v instanceof Long ? (Long)v : Long.valueOf(Long.parseLong(v.toString())));
                Integer typeInt = null;
                Object type = temp.get("eventgrade");
                if (type instanceof Integer) {
                    typeInt = (Integer)type;
                } else if (type instanceof BigDecimal) {
                    typeInt = ((BigDecimal)type).intValue();
                }
                auditLogChartColumnVo = this.getAuditChartTypeByType(typeInt, eventGradeChart);
                auditLogChartColumnVo.setNum(totalLong);
            }
        }
        for (AuditEventType auditEventType : AuditEventType.values()) {
            AuditLogChartColumnVo auditLogChartColumnVo2 = new AuditLogChartColumnVo();
            if (auditEventType.getCode() == -1) continue;
            auditLogChartColumnVo2.setNum(Long.valueOf(0L));
            auditLogChartColumnVo2.setSubscript(auditEventType.getDesc());
            auditLogChartColumnVo2.setType(Integer.valueOf(auditEventType.getCode()));
            eventTypeChart.add(auditLogChartColumnVo2);
        }
        if (HussarUtils.isNotEmpty((Object)typeMaps)) {
            for (Map item : typeMaps) {
                HashMap temp = new HashMap();
                for (Object key : item.keySet()) {
                    newKey = key.toString().toLowerCase();
                    temp.put(newKey, item.get(key));
                }
                Object v = temp.get("totalcount");
                totalLong = 0L;
                totalLong = v instanceof Integer ? Long.valueOf(((Integer)v).longValue()) : (v instanceof Long ? (Long)v : Long.valueOf(Long.parseLong(v.toString())));
                Integer codeInt = null;
                Object code = temp.get("eventtype");
                if (code instanceof Integer) {
                    codeInt = (Integer)code;
                } else if (code instanceof BigDecimal) {
                    codeInt = ((BigDecimal)code).intValue();
                }
                auditLogChartColumnVo = this.getAuditChartTypeByType(codeInt, eventTypeChart);
                auditLogChartColumnVo.setNum(totalLong);
            }
        }
        AuditLogChartVo auditLogChartVo = new AuditLogChartVo();
        auditLogChartVo.setEventTypeChart(eventTypeChart);
        auditLogChartVo.setEventGradeChart(eventGradeChart);
        return auditLogChartVo;
    }

    public AuditLogVo getAuditLogInfo(Page<AuditLogEntity> page, AuditLogEntity auditLogEntity, HttpServletRequest request) {
        AuditTypeVo auditTypeVo;
        AuditLogVo auditLogVo = new AuditLogVo();
        auditLogVo.setAuditLogListInfo(this.getAuditLogList(page, auditLogEntity, request));
        auditLogVo.setAuditLogChartInfo(this.getAuditLogChart(auditLogEntity, request));
        ArrayList<AuditTypeVo> auditTypeVoList = new ArrayList<AuditTypeVo>();
        String eventTypeIn = request.getParameter("eventType_in");
        String eventTypeNotIn = request.getParameter("eventType_notIn");
        if (HussarUtils.isNotEmpty((Object)eventTypeIn)) {
            for (AuditEventType item : AuditEventType.values()) {
                if (item.getCode() == -1 || item.getCode() != 5 && item.getCode() != 6 && item.getCode() != 7) continue;
                auditTypeVo = new AuditTypeVo();
                auditTypeVo.setId(item.getCode());
                auditTypeVo.setResTypeName(item.getDesc());
                auditTypeVoList.add(auditTypeVo);
            }
        } else if (HussarUtils.isNotEmpty((Object)eventTypeNotIn)) {
            for (AuditEventType item : AuditEventType.values()) {
                if (item.getCode() == -1 || item.getCode() == 5 || item.getCode() == 6 || item.getCode() == 7) continue;
                auditTypeVo = new AuditTypeVo();
                auditTypeVo.setId(item.getCode());
                auditTypeVo.setResTypeName(item.getDesc());
                auditTypeVoList.add(auditTypeVo);
            }
        } else {
            for (AuditEventType item : AuditEventType.values()) {
                if (item.getCode() == -1) continue;
                auditTypeVo = new AuditTypeVo();
                auditTypeVo.setId(item.getCode());
                auditTypeVo.setResTypeName(item.getDesc());
                auditTypeVoList.add(auditTypeVo);
            }
        }
        auditLogVo.setLogTypeOption(auditTypeVoList);
        ArrayList<SeverityLevelVo> severityLevelVoList = new ArrayList<SeverityLevelVo>();
        for (AuditSeverityLevel item : AuditSeverityLevel.values()) {
            if (item.getCode() == -1) continue;
            SeverityLevelVo severityLevelVo = new SeverityLevelVo();
            severityLevelVo.setId(item.getCode());
            severityLevelVo.setResTypeName(item.getDesc());
            severityLevelVoList.add(severityLevelVo);
        }
        auditLogVo.setSeverityLevelOption(severityLevelVoList);
        return auditLogVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuditLogSpaceUsageVo getAuditLogSpaceUsageInfo() {
        AuditLogSpaceUsageVo auditLogSpaceUsageVo = new AuditLogSpaceUsageVo();
        boolean openAuditLogSpaceUsageSwitch = this.createUserConfigService.isOpenAuditLogSpaceUsageSwitch();
        auditLogSpaceUsageVo.setOpenConfig(openAuditLogSpaceUsageSwitch);
        if (!openAuditLogSpaceUsageSwitch) {
            return auditLogSpaceUsageVo;
        }
        String logAll = this.sysBaseConfigService.getSysBaseConfigDto("audit_log_max_space").getConfigValue();
        auditLogSpaceUsageVo.setLogAll(logAll);
        String thresholdPer = this.sysBaseConfigService.getSysBaseConfigDto("audit_log_threshold").getConfigValue();
        double threshold = Double.parseDouble(logAll) * (Double.parseDouble(HussarUtils.isNotEmpty((Object)thresholdPer) ? thresholdPer : "100") / 100.0);
        ItemDataSource currentDatasource = this.dynamicDatasourceService.getCurrentDatasource();
        if (HussarUtils.isEmpty((Object)currentDatasource)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6570\u636e\u6e90");
        }
        Connection connection = null;
        try {
            connection = this.iDynamicDataSourceService.getConnection(currentDatasource.getUrl(), currentDatasource.getUsername(), currentDatasource.getPassword());
            String schemaName = currentDatasource.getSchemaName();
            String schema = connection.getSchema();
            String currSchemaName = HussarUtils.isNotEmpty((Object)schemaName) ? schemaName : schema;
            DbType dbType = currentDatasource.getDbType();
            this.handleDbTypeSql(connection, dbType, currSchemaName, auditLogSpaceUsageVo, threshold);
        }
        catch (SQLException e) {
            LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            auditLogSpaceUsageVo.setOpenConfig(Boolean.FALSE.booleanValue());
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error("errorMessage:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        return auditLogSpaceUsageVo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDbTypeSql(Connection connection, DbType dbType, String currSchemaName, AuditLogSpaceUsageVo auditLogSpaceUsageVo, double threshold) throws SQLException {
        try (Statement stmt = null;){
            if (DbType.MYSQL.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.MYSQL_QUERY);
                stmt.setString(1, connection.getCatalog());
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.DM.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.DM_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.ORACLE.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.ORACLE_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.POSTGRE_SQL.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.PG_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.SQL_SERVER2005.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.SQLSERVER_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.GAUSS.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.GAUSS_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.KINGBASE_ES.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.KING_BASE_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.HIGH_GO.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.HIGH_GO_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            } else if (DbType.OSCAR.equals((Object)dbType)) {
                stmt = connection.prepareStatement(SqlQueryConstant.OSCAR_QUERY);
                stmt.setString(1, currSchemaName);
                BaseAuditLogServiceImpl.handleResult((PreparedStatement)stmt, auditLogSpaceUsageVo, threshold);
            }
        }
    }

    public void exportAuditLogExcel(AuditLogExportExcelDto auditLogExportExcelDto, Long taskId) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        auditLogExportExcelDto.setUserName(SqlQueryUtil.transferSpecialChar((String)auditLogExportExcelDto.getUserName()));
        auditLogExportExcelDto.setTenantId(HussarContextHolder.getHussarTenant().getTenantId());
        Integer exportLimit = this.auditExportProperties.getExportLimit();
        List<AuditLogExportExcel> auditLogExportExcelList = new ArrayList();
        if (exportLimit != 0) {
            List<AuditLogEntity> auditLogEntities = this.sysSupportAuditLogMapper.getAuditLogExportExcelList(auditLogExportExcelDto, exportLimit);
            SysBaseConfig sysBaseConfig = this.sysBaseConfigService.getSysBaseConfig("protection_status");
            List rolesList = securityUser.getRolesList();
            List<Object> threeAuditLogEntities = new ArrayList<AuditLogEntity>(auditLogEntities);
            if (HussarUtils.isNotEmpty((Object)rolesList) && HussarUtils.isNotEmpty((Object)sysBaseConfig) && "3".equals(sysBaseConfig.getConfigValue())) {
                ArrayList<Long> securityAndSystemAdminRoles = new ArrayList<Long>(Arrays.asList(AuthorizationConstant.SECURITY_ADMIN_ROLE, AuthorizationConstant.TENANT_SECURITY_ADMIN_ROLE, AuthorizationConstant.SYSTEM_ADMIN_ROLE, AuthorizationConstant.TENANT_SYSTEM_ADMIN_ROLE));
                List sysUserRoles = this.sysUserRoleService.list(securityUser.getConnName(), (Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, securityAndSystemAdminRoles));
                Set userIds = sysUserRoles.stream().map(SysUserRole::getUserId).collect(Collectors.toSet());
                if (rolesList.contains(AuthorizationConstant.SECURITY_ADMIN_ROLE) || rolesList.contains(AuthorizationConstant.TENANT_SECURITY_ADMIN_ROLE)) {
                    threeAuditLogEntities = auditLogEntities.stream().filter(item -> !userIds.contains(item.getUserId())).collect(Collectors.toList());
                } else if (rolesList.contains(AuthorizationConstant.SECAUDIT_ADMIN_ROLE) || rolesList.contains(AuthorizationConstant.TENANT_SECAUDIT_ADMIN_ROLE)) {
                    threeAuditLogEntities = auditLogEntities.stream().filter(item -> userIds.contains(item.getUserId())).collect(Collectors.toList());
                }
            }
            List<Object> auditLogEntitiesType = new ArrayList();
            List accessAuditLogVos = new ArrayList();
            String actionsPage = auditLogExportExcelDto.getActionsPage();
            ArrayList<Integer> loginType = new ArrayList<Integer>(Arrays.asList(5, 6, 7));
            if ("login".equals(actionsPage)) {
                auditLogEntitiesType = threeAuditLogEntities.stream().filter(item -> loginType.contains(item.getEventType())).collect(Collectors.toList());
            } else if ("operate".equals(actionsPage)) {
                auditLogEntitiesType = threeAuditLogEntities.stream().filter(item -> !loginType.contains(item.getEventType())).collect(Collectors.toList());
            } else if ("visit".equals(actionsPage)) {
                AccessAuditLogDTO accessAuditLogDTO = new AccessAuditLogDTO();
                accessAuditLogDTO.setUserAccount(auditLogExportExcelDto.getUserName());
                accessAuditLogDTO.setStartTime(auditLogExportExcelDto.getStartTime());
                accessAuditLogDTO.setEndTime(auditLogExportExcelDto.getEndTime());
                accessAuditLogDTO.setUserId(securityUser.getUserId());
                accessAuditLogDTO.setOrder("access_time,desc");
                Page page = new Page(1L, Integer.MAX_VALUE);
                accessAuditLogVos = this.accessAuditLog.getAccessAuditLogInfo(page, accessAuditLogDTO).getRecords();
            } else if (HussarUtils.isEmpty((Object)actionsPage)) {
                auditLogEntitiesType = threeAuditLogEntities;
            } else {
                throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u9875\u9762\u7c7b\u578b");
            }
            if ("login".equals(actionsPage) || "operate".equals(actionsPage) || HussarUtils.isEmpty((Object)actionsPage)) {
                auditLogExportExcelList = HussarUtils.copy(auditLogEntitiesType, AuditLogExportExcel.class);
                DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern(DATE_TIME_FORMAT_PATTERN);
                AtomicInteger atomicInteger = new AtomicInteger(1);
                auditLogExportExcelList.forEach(item -> {
                    item.setOrdinal(String.valueOf(atomicInteger.getAndIncrement()));
                    item.setEventType(BaseAuditLogServiceImpl.getAuditEventTypeName(Integer.parseInt(item.getEventType())));
                    item.setEventGrade(BaseAuditLogServiceImpl.getAuditEventGradeName(Integer.parseInt(item.getEventGrade())));
                    item.setRequesetResult(BaseAuditLogServiceImpl.getRequestResultName(Integer.parseInt(item.getRequesetResult())));
                    item.setSeverityLevel(BaseAuditLogServiceImpl.getAuditSeverityLevelName(Integer.parseInt(item.getSeverityLevel())));
                    LocalDateTime dateTime = BaseAuditLogServiceImpl.parseToLocalDateTime(item.getCreateTime());
                    item.setCreateTime(dateTime.format(outputFormatter));
                });
            } else {
                auditLogExportExcelList = new ArrayList();
                AtomicInteger atomicInteger = new AtomicInteger(1);
                for (AccessAuditLogVo accessAuditLogVo : accessAuditLogVos) {
                    AuditLogExportExcel auditLogExportExcel = new AuditLogExportExcel();
                    auditLogExportExcel.setOrdinal(String.valueOf(atomicInteger.getAndIncrement()));
                    auditLogExportExcel.setUserName(accessAuditLogVo.getUserName());
                    auditLogExportExcel.setClientAddr(accessAuditLogVo.getClientIp());
                    auditLogExportExcel.setCreateTime(accessAuditLogVo.getAccessTime().format(DateTimeFormatter.ofPattern(DATE_TIME_FORMAT_PATTERN)));
                    auditLogExportExcel.setEventDesc(accessAuditLogVo.getEventDesc());
                    auditLogExportExcel.setEventType(accessAuditLogVo.getMenuName());
                    auditLogExportExcelList.add(auditLogExportExcel);
                }
            }
        }
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        ArrayList finalAuditLogExportExcelList = auditLogExportExcelList;
        hussarBaseExcelExecutor.execute(() -> {
            ClassSheetMsg classSheetMsg1 = new ClassSheetMsg(AuditLogExportExcel.class, finalAuditLogExportExcelList, "\u5ba1\u8ba1\u65e5\u5fd7\u5bfc\u51fa\u4fe1\u606f", 0);
            AuditLogExportExcelDesc auditLogExportExcelDesc = new AuditLogExportExcelDesc();
            auditLogExportExcelDesc.setExportOperator(securityUser.getUserName());
            String exportTime = Java8DateUtils.getCurrentDateDTimeStr();
            auditLogExportExcelDesc.setExportTime(Java8DateUtils.getCurrentDateTimeStr());
            ArrayList<AuditLogExportExcelDesc> auditLogExportExcelDescList = new ArrayList<AuditLogExportExcelDesc>();
            auditLogExportExcelDescList.add(auditLogExportExcelDesc);
            ClassSheetMsg classSheetMsg2 = new ClassSheetMsg(AuditLogExportExcelDesc.class, auditLogExportExcelDescList, "\u5bfc\u51fa\u63cf\u8ff0", 1);
            try {
                ExcelProduct excelProduct = new ConcreteExcelBuilder("\u5ba1\u8ba1\u65e5\u5fd7\u5bfc\u51fa\u4fe1\u606f" + exportTime + ".xlsx", taskId, this.hussarBaseExcelService).makeClassSheet(classSheetMsg1).makeClassSheet(classSheetMsg2).buildExcelProduct();
                this.sysExcelTaskServiceImpl.updateById((Object)excelProduct.getTask());
            }
            catch (IOException e) {
                LOGGER.error("\u5ba1\u8ba1\u65e5\u5fd7 Excel \u5bfc\u51fa\u5931\u8d25\uff0c\u4efb\u52a1ID: {}, \u5bfc\u51fa\u65f6\u95f4: {}", new Object[]{taskId, exportTime, e});
                throw new BaseException("\u5ba1\u8ba1\u65e5\u5fd7 Excel \u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public String getUserId() {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List rolesList = securityUser.getRolesList();
        if (HussarUtils.isNotEmpty((Object)rolesList)) {
            ArrayList<Long> securityAndSystemAdminRoles = new ArrayList<Long>(Arrays.asList(AuthorizationConstant.SECURITY_ADMIN_ROLE, AuthorizationConstant.TENANT_SECURITY_ADMIN_ROLE, AuthorizationConstant.SYSTEM_ADMIN_ROLE, AuthorizationConstant.TENANT_SYSTEM_ADMIN_ROLE));
            List sysUserRoles = this.sysUserRoleService.list(securityUser.getConnName(), (Wrapper)new LambdaQueryWrapper().in(SysUserRole::getGrantedRole, securityAndSystemAdminRoles));
            return sysUserRoles.stream().map(SysUserRole::getUserId).collect(Collectors.toSet()).stream().map(String::valueOf).collect(Collectors.joining(","));
        }
        return "";
    }

    private static String getAuditEventTypeName(int code) {
        for (AuditEventType auditEventType : AuditEventType.values()) {
            if (auditEventType.getCode() != code) continue;
            return auditEventType.getDesc();
        }
        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u65e5\u5fd7\u7c7b\u578b" + code);
    }

    private static String getAuditEventGradeName(int type) {
        for (AuditEventGrade auditEventGrade : AuditEventGrade.values()) {
            if (auditEventGrade.getType() != type) continue;
            return auditEventGrade.getDesc();
        }
        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u4e8b\u4ef6\u7c7b\u578b" + type);
    }

    private static String getRequestResultName(int code) {
        for (RequestResult requestResult : RequestResult.values()) {
            if (requestResult.getCode() != code) continue;
            return requestResult.getDesc();
        }
        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u6267\u884c\u72b6\u6001" + code);
    }

    private static String getAuditSeverityLevelName(int code) {
        for (AuditSeverityLevel auditSeverityLevel : AuditSeverityLevel.values()) {
            if (auditSeverityLevel.getCode() != code) continue;
            return auditSeverityLevel.getDesc();
        }
        throw new BaseException("\u672a\u627e\u5230\u5bf9\u5e94\u4e25\u91cd\u7a0b\u5ea6" + code);
    }

    private static void handleResult(PreparedStatement stmt, AuditLogSpaceUsageVo auditLogSpaceUsageVo, double threshold) throws SQLException {
        try (ResultSet resultSet = stmt.executeQuery();){
            if (resultSet.next()) {
                double logUsed = resultSet.getDouble("size_mb");
                auditLogSpaceUsageVo.setLogUsed(String.valueOf(logUsed));
                if (threshold <= logUsed) {
                    auditLogSpaceUsageVo.setAlert(Boolean.TRUE.booleanValue());
                }
            }
        }
    }

    public static LocalDateTime parseToLocalDateTime(String dateString) {
        for (DateTimeFormatter formatter : FORMATTERS) {
            try {
                return LocalDateTime.parse(dateString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new BaseException("\u5f53\u524d\u65f6\u95f4\u683c\u5f0f\u4e0d\u652f\u6301");
    }

    private IPage<AuditLogEntityVo> replacePageType(IPage<?> page, List<AuditLogEntityVo> list) {
        Page result = new Page();
        result.setCurrent(page.getCurrent());
        result.setPages(page.getPages());
        result.setSize(page.getSize());
        result.setTotal(page.getTotal());
        result.setRecords(list);
        return result;
    }

    private AuditLogChartColumnVo getAuditChartTypeByType(Integer type, List<AuditLogChartColumnVo> list) {
        for (AuditLogChartColumnVo item : list) {
            if (!Objects.equals(item.getType(), type)) continue;
            return item;
        }
        return new AuditLogChartColumnVo();
    }

    private String getEvenTypeName(Integer code) {
        for (AuditEventType item : AuditEventType.values()) {
            if (item.getCode() != code.intValue()) continue;
            return item.getDesc();
        }
        return null;
    }

    public AuditLogVo getLogOptionInfo() {
        AuditLogVo auditLogVo = new AuditLogVo();
        ArrayList<AuditTypeVo> auditTypeVoList = new ArrayList<AuditTypeVo>();
        for (AuditEventType item : AuditEventType.values()) {
            if (item.getCode() == -1) continue;
            AuditTypeVo auditTypeVo = new AuditTypeVo();
            auditTypeVo.setId(item.getCode());
            auditTypeVo.setResTypeName(item.getDesc());
            auditTypeVoList.add(auditTypeVo);
        }
        auditLogVo.setLogTypeOption(auditTypeVoList);
        ArrayList<SeverityLevelVo> severityLevelVoList = new ArrayList<SeverityLevelVo>();
        for (AuditSeverityLevel item : AuditSeverityLevel.values()) {
            if (item.getCode() == -1) continue;
            SeverityLevelVo severityLevelVo = new SeverityLevelVo();
            severityLevelVo.setId(item.getCode());
            severityLevelVo.setResTypeName(item.getDesc());
            severityLevelVoList.add(severityLevelVo);
        }
        auditLogVo.setSeverityLevelOption(severityLevelVoList);
        return auditLogVo;
    }
}

