/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.audit.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.audit.constant.AuthorizationConstant;
import com.jxdinfo.hussar.audit.dao.AccessAuditLogMapper;
import com.jxdinfo.hussar.audit.dto.AccessAuditLogDTO;
import com.jxdinfo.hussar.audit.model.AccessAuditLog;
import com.jxdinfo.hussar.audit.service.IAccessAuditLog;
import com.jxdinfo.hussar.audit.vo.AccessAuditLogVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.config.AuditLogProperties;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AccessAuditLogServiceImpl
extends HussarServiceImpl<AccessAuditLogMapper, AccessAuditLog>
implements IAccessAuditLog {
    @Autowired
    private IAccessAuditLog auditLogService;
    @Autowired
    private AccessAuditLogMapper auditLogMapper;
    @Autowired
    private AuditLogProperties auditLogProperties;

    public IPage<AccessAuditLogVo> getAccessAuditLogInfo(Page<AccessAuditLogVo> page, AccessAuditLogDTO accessAuditLogDTO) {
        AssertUtil.isTrue((boolean)this.auditLogProperties.getEnable(), (String)"\u5ba1\u8ba1\u65e5\u5fd7\u672a\u5f00\u542f");
        HashMap<String, Object> searchMap = new HashMap<String, Object>();
        accessAuditLogDTO.setUserAccount("%" + SqlQueryUtil.transferSpecialChar((String)accessAuditLogDTO.getUserAccount()) + "%");
        accessAuditLogDTO.setTenantId(HussarSecurityUtils.getLoginUserDetails().getTenantId());
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        List rolesList = securityUser.getRolesList();
        if (HussarUtils.isEmpty((Object)rolesList)) {
            throw new BaseException("\u5f53\u524d\u7528\u6237\u672a\u5173\u8054\u89d2\u8272");
        }
        if (rolesList.contains(AuthorizationConstant.SECAUDIT_ADMIN_ROLE) || rolesList.contains(AuthorizationConstant.TENANT_SECAUDIT_ADMIN_ROLE)) {
            searchMap.put("type", "1");
        } else if (rolesList.contains(AuthorizationConstant.SECURITY_ADMIN_ROLE) || rolesList.contains(AuthorizationConstant.TENANT_SECURITY_ADMIN_ROLE)) {
            searchMap.put("type", "2");
        } else {
            searchMap.put("type", "5");
        }
        if (HussarUtils.isNotEmpty((Object)accessAuditLogDTO.getOrder())) {
            String[] order = accessAuditLogDTO.getOrder().split(",");
            searchMap.put("order", order);
        }
        return this.auditLogMapper.queryPage(page, accessAuditLogDTO, searchMap);
    }

    public void addAccessAuditLog(AccessAuditLog accessAuditLog, HttpServletRequest request) {
        if (this.auditLogProperties.getEnable()) {
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            accessAuditLog.setUserId(securityUser.getId());
            accessAuditLog.setAccountName(securityUser.getAccount());
            accessAuditLog.setClientIp("0:0:0:0:0:0:0:1".equals(request.getRemoteAddr()) ? "127.0.0.1" : request.getRemoteAddr());
            accessAuditLog.setClientPort(request.getRemotePort() + "");
            accessAuditLog.setPath(request.getRequestURL().toString());
            accessAuditLog.setRequestMethod(request.getMethod());
            accessAuditLog.setUrl(request.getRequestURI());
            accessAuditLog.setServerName(request.getHeader("client-id"));
            accessAuditLog.setTenantId(securityUser.getTenantId());
            String description = accessAuditLog.getStatus();
            String time = accessAuditLog.getAccessTime().toString().replace("T", " ");
            description = "0".equals(description) ? accessAuditLog.getUserName() + "(" + securityUser.getAccount() + ")\u4e8e" + time + "\u8bbf\u95ee\"" + accessAuditLog.getMenuName() + "\",\u65e0\u5f02\u5e38" : ("1".equals(description) ? accessAuditLog.getUserName() + "(" + securityUser.getAccount() + ")\u4e8e" + time + "\u8bbf\u95ee\"" + accessAuditLog.getMenuName() + "\",\u8bbf\u95ee\u5f02\u5e38" : accessAuditLog.getUserName() + "(" + securityUser.getAccount() + ")\u4e8e" + time + "\u8bbf\u95ee\"" + accessAuditLog.getMenuName() + "\"");
            accessAuditLog.setEventDesc(description);
            this.auditLogService.save((Object)accessAuditLog);
        }
    }
}

