/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.audit.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.audit.dao.SysSupportAuditLogMapper;
import com.jxdinfo.hussar.audit.service.IBaseAuditLogService;
import com.jxdinfo.hussar.audit.vo.AuditLogChartColumnVo;
import com.jxdinfo.hussar.audit.vo.AuditLogChartVo;
import com.jxdinfo.hussar.audit.vo.AuditLogEntityVo;
import com.jxdinfo.hussar.audit.vo.AuditLogVo;
import com.jxdinfo.hussar.audit.vo.AuditTypeVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.audit.core.auditlog.entity.AuditLogEntity;
import com.jxdinfo.hussar.support.audit.core.auditlog.service.AuditLogCURDService;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import com.jxdinfo.hussar.support.audit.core.enums.RequestResult;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@HussarDs(value="master")
@Service
public class BaseAuditLogServiceImpl
extends HussarBaseServiceImpl<SysSupportAuditLogMapper, AuditLogEntity>
implements IBaseAuditLogService {
    private static final String[] ORDERS = new String[]{"ASC", "DESC"};
    @Resource
    private AuditLogCURDService auditLogCURDService;
    @Resource
    private ISysUsersService usersService;

    public IPage<AuditLogEntityVo> getAuditLogList(Page<AuditLogEntity> page, AuditLogEntity auditLogEntity, HttpServletRequest request) {
        String tokenId = request.getParameter("token_eq");
        String isSessionTracking = request.getParameter("isSessionTracking");
        if ("1".equals(isSessionTracking) && StringUtils.isBlank((CharSequence)tokenId)) {
            ArrayList<AuditLogEntityVo> resultList = new ArrayList<AuditLogEntityVo>();
            page.getRecords().forEach(item -> {
                AuditLogEntityVo auditLogEntityVo = new AuditLogEntityVo();
                CopyPropertieUtils.copyProperties((Object)auditLogEntityVo, (Object)item);
                resultList.add(auditLogEntityVo);
            });
            return this.replacePageType((IPage<?>)page, (List<AuditLogEntityVo>)resultList);
        }
        SecurityUser shiroUser = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)shiroUser)) {
            throw new BaseException("\u7528\u6237\u672a\u767b\u5f55");
        }
        if (ToolUtil.isEmpty(page)) {
            throw new BaseException("\u67e5\u8be2\u6761\u4ef6\u6709\u8bef");
        }
        IPage list = this.auditLogCURDService.listPage(auditLogEntity, page, request);
        AssertUtil.isNotNull((Object)list, (String)"\u5ba1\u8ba1\u65e5\u5fd7\u672a\u5f00\u542f");
        ArrayList<AuditLogEntityVo> result = new ArrayList<AuditLogEntityVo>();
        if (HussarUtils.isNotEmpty((Object)list.getRecords())) {
            List userIdList = list.getRecords().stream().map(AuditLogEntity::getUserId).collect(Collectors.toList());
            List usersList = this.usersService.listByIds(userIdList);
            HashMap<Long, SysUsers> longUserMap = new HashMap<Long, SysUsers>();
            for (SysUsers item2 : usersList) {
                longUserMap.put(item2.getId(), item2);
            }
            list.getRecords().forEach(o -> {
                SysUsers user;
                AuditLogEntityVo auditLogEntityVo = new AuditLogEntityVo();
                CopyPropertieUtils.copyProperties((Object)auditLogEntityVo, (Object)o);
                if (ToolUtil.isNotEmpty((Object)o.getEventGrade())) {
                    if (AuditEventGrade.SERVICE_LOG_TYPE.getType() == o.getEventGrade().intValue()) {
                        auditLogEntityVo.setEventGradeName(AuditEventGrade.SERVICE_LOG_TYPE.getDesc());
                    }
                    if (AuditEventGrade.SYSTEM_LOG_TYPE.getType() == o.getEventGrade().intValue()) {
                        auditLogEntityVo.setEventGradeName(AuditEventGrade.SYSTEM_LOG_TYPE.getDesc());
                    }
                }
                if (ToolUtil.isNotEmpty((Object)o.getEventType())) {
                    auditLogEntityVo.setEventTypeName(this.getEvenTypeName(o.getEventType()));
                }
                if (ToolUtil.isNotEmpty((Object)o.getRequesetResult())) {
                    if (RequestResult.success.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.success.getDesc());
                    }
                    if (RequestResult.failed.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.failed.getDesc());
                    }
                    if (RequestResult.progressing.getCode().equals(o.getRequesetResult())) {
                        auditLogEntityVo.setState(RequestResult.progressing.getDesc());
                    }
                }
                if (HussarUtils.isNotEmpty((Object)(user = (SysUsers)longUserMap.get(o.getUserId())))) {
                    auditLogEntityVo.setUserAccount(user.getUserAccount());
                }
                auditLogEntityVo.setLogContent("\u7c7b\u540d:" + o.getPackageName() + "." + o.getClassName() + ";\u65b9\u6cd5\u540d:" + o.getMethodName() + ";\u64cd\u4f5c\u63cf\u8ff0:" + o.getEventDesc());
                result.add(auditLogEntityVo);
            });
        }
        return this.replacePageType((IPage<?>)page, (List<AuditLogEntityVo>)result);
    }

    public AuditLogChartVo getAuditLogChart(AuditLogEntity auditLogEntity, HttpServletRequest request) {
        AuditLogChartColumnVo auditLogChartColumnVo;
        Long totalLong;
        String newKey;
        HashMap<String, String[]> typeMap = new HashMap<String, String[]>();
        typeMap.put("field_groupby", new String[]{"eventType"});
        HashMap<String, String[]> gradeMap = new HashMap<String, String[]>();
        gradeMap.put("field_groupby", new String[]{"eventGrade"});
        typeMap.putAll(request.getParameterMap());
        gradeMap.putAll(request.getParameterMap());
        typeMap.remove("orderRule");
        gradeMap.remove("orderRule");
        List typeMaps = this.auditLogCURDService.listGroupCountList(auditLogEntity, typeMap);
        List gradeMaps = this.auditLogCURDService.listGroupCountList(auditLogEntity, gradeMap);
        ArrayList<AuditLogChartColumnVo> eventGradeChart = new ArrayList<AuditLogChartColumnVo>();
        ArrayList<AuditLogChartColumnVo> eventTypeChart = new ArrayList<AuditLogChartColumnVo>();
        for (AuditEventGrade auditEventGrade : AuditEventGrade.values()) {
            AuditLogChartColumnVo auditLogChartColumnVo2 = new AuditLogChartColumnVo();
            if (auditEventGrade.getType() == -1) continue;
            auditLogChartColumnVo2.setNum(Long.valueOf(0L));
            auditLogChartColumnVo2.setSubscript(auditEventGrade.getDesc());
            auditLogChartColumnVo2.setType(Integer.valueOf(auditEventGrade.getType()));
            eventGradeChart.add(auditLogChartColumnVo2);
        }
        if (HussarUtils.isNotEmpty((Object)gradeMaps)) {
            for (Map item : gradeMaps) {
                HashMap temp = new HashMap();
                for (Object key : item.keySet()) {
                    newKey = key.toString().toLowerCase();
                    temp.put(newKey, item.get(key));
                }
                Object v = temp.get("totalcount");
                totalLong = 0L;
                totalLong = v instanceof Integer ? Long.valueOf(((Integer)v).longValue()) : (v instanceof Long ? (Long)v : Long.valueOf(Long.parseLong(v.toString())));
                Integer typeInt = null;
                Object type = temp.get("eventgrade");
                if (type instanceof Integer) {
                    typeInt = (Integer)type;
                } else if (type instanceof BigDecimal) {
                    typeInt = ((BigDecimal)type).intValue();
                }
                auditLogChartColumnVo = this.getAuditChartTypeByType(typeInt, eventGradeChart);
                auditLogChartColumnVo.setNum(totalLong);
            }
        }
        for (AuditEventType auditEventType : AuditEventType.values()) {
            AuditLogChartColumnVo auditLogChartColumnVo2 = new AuditLogChartColumnVo();
            if (auditEventType.getCode() == -1) continue;
            auditLogChartColumnVo2.setNum(Long.valueOf(0L));
            auditLogChartColumnVo2.setSubscript(auditEventType.getDesc());
            auditLogChartColumnVo2.setType(Integer.valueOf(auditEventType.getCode()));
            eventTypeChart.add(auditLogChartColumnVo2);
        }
        if (HussarUtils.isNotEmpty((Object)typeMaps)) {
            for (Map item : typeMaps) {
                HashMap temp = new HashMap();
                for (Object key : item.keySet()) {
                    newKey = key.toString().toLowerCase();
                    temp.put(newKey, item.get(key));
                }
                Object v = temp.get("totalcount");
                totalLong = 0L;
                totalLong = v instanceof Integer ? Long.valueOf(((Integer)v).longValue()) : (v instanceof Long ? (Long)v : Long.valueOf(Long.parseLong(v.toString())));
                Integer codeInt = null;
                Object code = temp.get("eventtype");
                if (code instanceof Integer) {
                    codeInt = (Integer)code;
                } else if (code instanceof BigDecimal) {
                    codeInt = ((BigDecimal)code).intValue();
                }
                auditLogChartColumnVo = this.getAuditChartTypeByType(codeInt, eventTypeChart);
                auditLogChartColumnVo.setNum(totalLong);
            }
        }
        AuditLogChartVo auditLogChartVo = new AuditLogChartVo();
        auditLogChartVo.setEventTypeChart(eventTypeChart);
        auditLogChartVo.setEventGradeChart(eventGradeChart);
        return auditLogChartVo;
    }

    public AuditLogVo getAuditLogInfo(Page<AuditLogEntity> page, AuditLogEntity auditLogEntity, HttpServletRequest request) {
        AuditLogVo auditLogVo = new AuditLogVo();
        auditLogVo.setAuditLogListInfo(this.getAuditLogList(page, auditLogEntity, request));
        auditLogVo.setAuditLogChartInfo(this.getAuditLogChart(auditLogEntity, request));
        ArrayList<AuditTypeVo> auditTypeVoList = new ArrayList<AuditTypeVo>();
        for (AuditEventType item : AuditEventType.values()) {
            if (item.getCode() == -1) continue;
            AuditTypeVo auditTypeVo = new AuditTypeVo();
            auditTypeVo.setId(item.getCode());
            auditTypeVo.setResTypeName(item.getDesc());
            auditTypeVoList.add(auditTypeVo);
        }
        auditLogVo.setLogTypeOption(auditTypeVoList);
        return auditLogVo;
    }

    private IPage<AuditLogEntityVo> replacePageType(IPage<?> page, List<AuditLogEntityVo> list) {
        Page result = new Page();
        result.setCurrent(page.getCurrent());
        result.setPages(page.getPages());
        result.setSize(page.getSize());
        result.setTotal(page.getTotal());
        result.setRecords(list);
        return result;
    }

    private AuditLogChartColumnVo getAuditChartTypeByType(Integer type, List<AuditLogChartColumnVo> list) {
        for (AuditLogChartColumnVo item : list) {
            if (!Objects.equals(item.getType(), type)) continue;
            return item;
        }
        return new AuditLogChartColumnVo();
    }

    private String getEvenTypeName(Integer code) {
        for (AuditEventType item : AuditEventType.values()) {
            if (item.getCode() != code.intValue()) continue;
            return item.getDesc();
        }
        return null;
    }
}

