/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.audit.cloud.transdict.factory;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransAbleMapping;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class TransAbleMappingFactory
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransAbleMappingFactory.class);
    private static final List<TransAbleMapping> mappingList = new ArrayList<TransAbleMapping>();
    private static final String NAMESPACE = "namespace";
    private static final String ID = "id";

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(TransAbleMapping.class);
        this.setBeansToList(beanMap);
    }

    private void setBeansToList(Map<String, TransAbleMapping> beanMap) {
        if (HussarUtils.isNotEmpty(beanMap)) {
            for (TransAbleMapping transAbleMapping : beanMap.values()) {
                mappingList.add(transAbleMapping);
            }
        }
    }

    public static TransAbleMapping getTransMapping(String namespace) {
        for (TransAbleMapping transAbleMapping : mappingList) {
            if (!transAbleMapping.match(namespace, null)) continue;
            return transAbleMapping;
        }
        return null;
    }

    public static Object getById(Map<String, Object> map) {
        String namespace = (String)map.get(NAMESPACE);
        Long id = HussarUtils.toLong((Object)map.get(ID));
        TransAbleMapping transAbleMapping = TransAbleMappingFactory.getTransMapping(namespace);
        if (ToolUtil.isEmpty((Object)transAbleMapping)) {
            LOGGER.info("getById\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
            return null;
        }
        return transAbleMapping.getById((Object)id, null);
    }

    public static <T> List<T> listByMap(Map<String, Object> map) {
        String namespace = (String)map.get(NAMESPACE);
        TransAbleMapping transAbleMapping = TransAbleMappingFactory.getTransMapping(namespace);
        if (ToolUtil.isEmpty((Object)transAbleMapping)) {
            LOGGER.info("listByMap\u672a\u627e\u5230\u547d\u540d\u7a7a\u95f4\uff0c{}", (Object)namespace);
            return null;
        }
        return transAbleMapping.listByMap(map, null);
    }
}

