/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysOrgan;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysEmployeeService;
import com.jxdinfo.hussar.authorization.organ.service.ISysOrganService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStaffService;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysStruAssistOrgan;
import com.jxdinfo.hussar.authorization.permit.model.SysUserRole;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysStruAssistOrganService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUserRoleService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppGroupMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordLogMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppRecordMapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysApplicationMapper;
import com.jxdinfo.hussar.base.portal.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.base.portal.application.model.SysAppAuthUser;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDeploy;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDevops;
import com.jxdinfo.hussar.base.portal.application.model.SysAppDomain;
import com.jxdinfo.hussar.base.portal.application.model.SysAppGroup;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecord;
import com.jxdinfo.hussar.base.portal.application.model.SysAppRecordLog;
import com.jxdinfo.hussar.base.portal.application.model.SysAppResource;
import com.jxdinfo.hussar.base.portal.application.model.SysAppTemplate;
import com.jxdinfo.hussar.base.portal.application.model.SysAppVersion;
import com.jxdinfo.hussar.base.portal.application.model.SysApplication;
import com.jxdinfo.hussar.base.portal.application.pojo.AppRecordLogTypeEnum;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppAuthUserService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDevopsService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppDomainService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordLogService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppRecordService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppResourceService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppTemplateService;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppVersionService;
import com.jxdinfo.hussar.base.portal.application.service.ISysApplicationService;
import com.jxdinfo.hussar.base.portal.application.service.ISysDeployService;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysAppInfoVo;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationDeploy;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationGroup;
import com.jxdinfo.hussar.base.portal.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.base.portal.constant.AppConstants;
import com.jxdinfo.hussar.base.portal.gitlabServer.dto.GitServerDto;
import com.jxdinfo.hussar.base.portal.gitlabServer.service.IGitlabService;
import com.jxdinfo.hussar.base.portal.properties.GitlabConfigProperty;
import com.jxdinfo.hussar.base.portal.utils.AppTypeUtil;
import com.jxdinfo.hussar.base.portal.yamlServer.service.IYamlService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.ExcelUtil;
import com.jxdinfo.hussar.common.utils.IdempotentJsonUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.platform.core.utils.file.ZipFile;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysApplicationServiceImpl")
public class SysApplicationServiceImpl
extends HussarServiceImpl<SysApplicationMapper, SysApplication>
implements ISysApplicationService {
    private static final Logger logger = LoggerFactory.getLogger(SysApplicationServiceImpl.class);
    @Resource
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysApplicationMapper sysApplicationMapper;
    @Resource
    private SysAppGroupMapper sysAppGroupMapper;
    @Resource
    private ISysAppDomainService iSysAppDomainService;
    @Resource
    private ISysAppResourceService sysAppResourceService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysDeployService sysDeployService;
    @Resource
    private ISysOrganService sysOrganService;
    @Resource
    private ISysStaffService sysStaffService;
    @Resource
    private ISysStruAssistOrganService sysStruAssistOrganService;
    @Resource
    private ISysEmployeeService sysEmployeeService;
    @Resource
    private IYamlService yamlService;
    @Resource
    private IGitlabService gitlabService;
    @Resource
    GitlabConfigProperty gitlabConfigProperty;
    @Resource
    private ISysUserRoleService sysUserRoleService;
    @Resource
    private ISysAppVersionService sysAppVersionService;
    @Resource
    private ISysAppDomainService sysAppDomainService;
    @Resource
    private ISysAppDevopsService sysAppDevopsService;
    @Autowired
    private SysAppRecordMapper sysAppRecordMapper;
    @Autowired
    private SysAppRecordLogMapper sysAppRecordLogMapper;
    @Autowired
    private ISysAppAuthUserService sysAppAuthUserService;
    @Autowired
    private ISysAppTemplateService sysAppTemplateService;
    @Autowired
    private ISysAppRecordService sysAppRecordService;
    @Autowired
    private ISysAppRecordLogService sysAppRecordLogService;

    public List<SysAppGroupVo> getManageAppList(Long appGroupId, String appName, String appStatus, String releaseStatus, String resourceStatus) {
        List<Long> appIdList;
        List<SysAppGroupVo> sysAppGroupVos;
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Object> appList = new ArrayList();
        List<SysAppGroup> sysAppGroups = new ArrayList<SysAppGroup>();
        Boolean isSuper = user.isSuperAdmin();
        Character escapeSymbol = SqlQueryUtil.ESCAPE_SYMBOL;
        appList = this.sysApplicationMapper.getAppListNew(user.getId(), appGroupId, SqlQueryUtil.transferSpecialChar((String)appName), appStatus, releaseStatus, resourceStatus, escapeSymbol, isSuper);
        ArrayList<Long> groupIds = new ArrayList<Long>();
        if (HussarUtils.isEmpty((Object)appGroupId) && HussarUtils.isEmpty((Object)appName) && HussarUtils.isEmpty((Object)appStatus) && HussarUtils.isEmpty((Object)releaseStatus) && HussarUtils.isEmpty((Object)resourceStatus)) {
            groupIds.add(AppConstants.DEFAULT_GROUP_ID);
        }
        appList.stream().forEach(app -> {
            app.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + app.getAppCode() + ".git");
            groupIds.add(app.getAppGroupId());
        });
        if (groupIds.size() > 0) {
            sysAppGroups = this.sysAppGroupMapper.getAppGroup(user.getUserId(), groupIds);
        }
        if ((sysAppGroupVos = this.combinedData(appList, sysAppGroups)) != null && HussarUtils.isNotEmpty(appIdList = sysAppGroupVos.stream().filter(vo -> vo != null && vo.getSysApplicationList() != null).flatMap(vo -> vo.getSysApplicationList().stream()).filter(app -> app != null && app.getId() != null).map(SysApplicationDeploy::getId).collect(Collectors.toList()))) {
            List<SysAppInfoVo> appStatusNameList = this.getAppStatusName(appIdList, "1");
            Map<Long, String> appStageNameInfo = appStatusNameList.stream().collect(Collectors.toMap(SysApplication::getId, SysAppInfoVo::getAppStageStatus));
            sysAppGroupVos.stream().forEach(sysAppGroupVo -> {
                List sysApplicationList = sysAppGroupVo.getSysApplicationList();
                if (HussarUtils.isNotEmpty((Object)sysApplicationList)) {
                    sysApplicationList.stream().forEach(appInfo -> appInfo.setAppStageStatus((String)appStageNameInfo.get(appInfo.getId())));
                }
            });
        }
        return sysAppGroupVos;
    }

    public Boolean getAppProStatus(Long time) {
        File file = new File(this.gitlabConfigProperty.getTempPath() + File.separator + time);
        logger.info("\u5224\u65ad\u4e34\u65f6\u6587\u4ef6\u52a0\u662f\u5426\u5b58\u5728\uff1a{},----!file.exists():==={}", (Object)(this.gitlabConfigProperty.getTempPath() + File.separator + time), (Object)(!file.exists() ? 1 : 0));
        return !file.exists();
    }

    public List<String> getBuilddefs(String projectId) {
        ArrayList<String> list = new ArrayList<String>();
        CloseableHttpClient httpclients = null;
        try {
            httpclients = HttpClients.createDefault();
            HttpGet httpGet = new HttpGet("http://60.204.136.32:8787/api/ci/builddefs?projectId=" + projectId);
            CloseableHttpResponse response = httpclients.execute((HttpUriRequest)httpGet);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
            JSONArray jsonArray = JSONArray.parseArray((String)result);
            if (jsonArray.size() == 0) {
                List<String> list2 = null;
                return list2;
            }
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        finally {
            if (httpclients != null) {
                try {
                    httpclients.close();
                }
                catch (IOException e) {
                    throw new BaseException((Throwable)e);
                }
            }
        }
        return list;
    }

    public Long updateApp(SysApplicationDto sysApplicationDto) {
        Long templateTime = System.currentTimeMillis();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setPipelineType("\u5e94\u7528\u7f16\u8f91");
        sysAppRecord.setStatus("1");
        sysAppRecord.setRecordType("3");
        if ("1".equals(sysApplicationDto.getFlag())) {
            sysApplication.setResourceStatus("");
            sysAppRecord.setPipelineType("\u5e94\u7528\u91cd\u90e8\u7f72");
            sysAppRecord.setRecordType("4");
        }
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysApplication oldApp = (SysApplication)this.getById(sysApplication.getId());
        SysUsers oldLeader = this.sysUsersService.getUser(oldApp.getProjectLeader());
        SysUsers newLeader = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        SysAppRecordLog saveAppLog = new SysAppRecordLog();
        this.insertOrUpdate(sysAppRecord, saveAppLog, AppRecordLogTypeEnum.SAVE_APP_INFO_SUCCESS);
        AppRecordLogTypeEnum editAppFailed = AppRecordLogTypeEnum.RECORD_LOG_STEP_ANME_FAILED;
        SysAppRecordLog failLog = new SysAppRecordLog();
        SysApplicationServiceImpl that = this;
        Long gitTime = System.currentTimeMillis();
        Thread pushAppThread = new Thread(() -> {
            try {
                logger.info("\u5411\u65b0\u5e94\u7528\u63a8\u9001\u5e94\u7528\u4fe1\u606f:===================");
                Wrapper wrapper = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysApplication.getId())).eq((Object)"DEL_FLAG", (Object)"0");
                List sysAppDeployList = this.sysDeployService.list(wrapper);
                if (sysAppDeployList.size() > 0) {
                    for (SysAppDeploy sysAppDeploy : sysAppDeployList) {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("sysApplication", sysApplication);
                        String uri = "";
                        uri = "3".equals(sysAppDeploy.getDeployType()) || "4".equals(sysAppDeploy.getDeployType()) || "5".equals(sysAppDeploy.getDeployType()) ? "http://" + sysAppDeploy.getThreeLevelDomainFront() : "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain();
                        String url = uri + "/hussarApi/hussarBase/newapp/saveOrUpdateNewApplication";
                        this.post(url, map);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Thread pushUserThread = new Thread(() -> {
            try {
                logger.info("\u5411\u65b0\u5e94\u7528\u63a8\u9001\u8d1f\u8d23\u4eba\u4fe1\u606f:===================");
                that.syncDevloper(String.valueOf(sysApplication.getProjectLeader()), String.valueOf(sysApplication.getId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Boolean addH5Flag = sysApplication.getAppType().contains("2") && !oldApp.getAppType().contains("2");
        Boolean addXcxFlag = sysApplication.getAppType().contains("3") && !oldApp.getAppType().contains("3");
        Boolean addAppFlag = sysApplication.getAppType().contains("4") && !oldApp.getAppType().contains("4");
        Thread addAppTypeThread = new Thread(() -> {
            SysAppRecordLog failLog1 = new SysAppRecordLog();
            String gitMsg = "";
            try {
                logger.info("\u4e0b\u8f7dgit\u9879\u76ee:===================");
                SysAppRecordLog downGitLog = new SysAppRecordLog();
                this.insertOrUpdate(sysAppRecord, downGitLog, AppRecordLogTypeEnum.DOWN_GIT_RPOJECT_DURING);
                editAppFailed.setName(AppRecordLogTypeEnum.DOWN_GIT_RPOJECT_DURING.getName());
                failLog1 = downGitLog;
                String accessToken = user.getChar1();
                String gitTempPath = this.gitlabConfigProperty.getTempPath() + File.separator + gitTime + File.separator;
                this.gitlabService.pullToLocalByBranch(sysApplication.getAppCode(), gitTempPath, "dev", accessToken);
                this.insertOrUpdate(sysAppRecord, downGitLog, AppRecordLogTypeEnum.DOWN_GIT_RPOJECT_SUCCESS);
                logger.info("\u9a8c\u8bc1git\u4e2d\u4ee3\u7801\u6587\u4ef6\u7ed3\u6784:===================");
                SysAppRecordLog matchGitAppTypeLog = new SysAppRecordLog();
                this.insertOrUpdate(sysAppRecord, matchGitAppTypeLog, AppRecordLogTypeEnum.MATCH_GIT_APP_TYPE_DURING);
                editAppFailed.setName(AppRecordLogTypeEnum.MATCH_GIT_APP_TYPE_DURING.getName());
                failLog1 = matchGitAppTypeLog;
                Thread.sleep(1000L);
                Boolean copyH5ToGitFlag = false;
                Boolean copyXcxToGitFlag = false;
                Boolean copyAppToGitFlag = false;
                if (addH5Flag.booleanValue()) {
                    copyH5ToGitFlag = this.checkGitAppType(gitTempPath, "hussar-mobile", AppRecordLogTypeEnum.GIT_EXIST_APP_TYPE_H5_SUCCESS, editAppFailed, failLog1, sysAppRecord);
                }
                if (addXcxFlag.booleanValue()) {
                    copyXcxToGitFlag = this.checkGitAppType(gitTempPath, "hussar-mobile-uni", AppRecordLogTypeEnum.GIT_EXIST_APP_TYPE_XCX_SUCCESS, editAppFailed, failLog1, sysAppRecord);
                }
                if (addAppFlag.booleanValue()) {
                    copyAppToGitFlag = this.checkGitAppType(gitTempPath, "hussar-mobile-uni", AppRecordLogTypeEnum.GIT_EXIST_APP_TYPE_APP_SUCCESS, editAppFailed, failLog1, sysAppRecord);
                }
                this.insertOrUpdate(sysAppRecord, matchGitAppTypeLog, AppRecordLogTypeEnum.MATCH_GIT_APP_TYPE_SUCCESS);
                if (!(copyH5ToGitFlag.booleanValue() || copyXcxToGitFlag.booleanValue() || copyAppToGitFlag.booleanValue())) {
                    sysAppRecord.setStatus("2");
                    this.sysAppRecordMapper.updateById(sysAppRecord);
                } else {
                    logger.info("\u5224\u65ad\u6a21\u677f\u662f\u5426\u5b58\u5728:===================");
                    SysAppRecordLog checkTemplateExistLog = new SysAppRecordLog();
                    this.insertOrUpdate(sysAppRecord, checkTemplateExistLog, AppRecordLogTypeEnum.CHECK_TEMPLATE_EXIST_DURING);
                    editAppFailed.setName(AppRecordLogTypeEnum.CHECK_TEMPLATE_EXIST_DURING.getName());
                    failLog1 = checkTemplateExistLog;
                    Long templateId = oldApp.getTemplateId();
                    SysAppTemplate template = (SysAppTemplate)this.sysAppTemplateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppTemplate::getId, (Object)templateId)).eq(SysAppTemplate::getDelFlag, (Object)"0"));
                    if (null == template) {
                        logger.info("\u6a21\u677f\u4e0d\u5b58\u5728:===================");
                        this.insertOrUpdate(sysAppRecord, checkTemplateExistLog, AppRecordLogTypeEnum.CHECK_TEMPLATE_EXIST_FAILED);
                        sysApplication.setAppType(oldApp.getAppType());
                        this.updateById((BaseEntity)sysApplication);
                        return;
                    }
                    this.insertOrUpdate(sysAppRecord, checkTemplateExistLog, AppRecordLogTypeEnum.CHECK_TEMPLATE_EXIST_SUCCESS);
                    logger.info("\u4e0b\u8f7d\u5e76\u89e3\u538b\u6a21\u677f\u6e90\u7801:===================");
                    SysAppRecordLog downTemplateLog = new SysAppRecordLog();
                    this.insertOrUpdate(sysAppRecord, downTemplateLog, AppRecordLogTypeEnum.DOWN_UNZIP_CODE_DURING);
                    editAppFailed.setName(AppRecordLogTypeEnum.DOWN_UNZIP_CODE_DURING.getName());
                    failLog1 = downTemplateLog;
                    String templateTempPath = this.gitlabConfigProperty.getTempPath() + File.separator + templateTime + File.separator;
                    ZipFile.unzip((String)template.getTemplatePath(), (String)templateTempPath, (Charset)Charset.forName("GBK"));
                    this.insertOrUpdate(sysAppRecord, downTemplateLog, AppRecordLogTypeEnum.DOWN_UNZIP_CODE_SUCCESS);
                    logger.info("\u5224\u65ad\u6a21\u677f\u662f\u5426\u5b58\u5728\u548c\u662f\u5426\u7b26\u5408\u65b0\u7c7b\u578b\u8981\u6c42:===================");
                    SysAppRecordLog matchAppTypeTemplateLog = new SysAppRecordLog();
                    this.insertOrUpdate(sysAppRecord, matchAppTypeTemplateLog, AppRecordLogTypeEnum.MATCH_APP_TYPE_TEMPLATE_DURING);
                    editAppFailed.setName(AppRecordLogTypeEnum.MATCH_APP_TYPE_TEMPLATE_DURING.getName());
                    failLog1 = matchAppTypeTemplateLog;
                    Boolean matchTemplateAppType_web = true;
                    Boolean matchTemplateAppType_xcx = true;
                    Boolean matchTemplateAppType_app = true;
                    if (copyH5ToGitFlag.booleanValue()) {
                        matchTemplateAppType_web = this.matchTemplateAppType(templateTempPath, "hussar-mobile", failLog1, sysAppRecord, editAppFailed, AppRecordLogTypeEnum.TEMPLATE_NO_APP_TYPE_H5_FAILD);
                        gitMsg = gitMsg + "\u589e\u52a0H5\u6e90\u7801";
                    }
                    if (copyXcxToGitFlag.booleanValue()) {
                        matchTemplateAppType_xcx = this.matchTemplateAppType(templateTempPath, "hussar-mobile-uni", failLog1, sysAppRecord, editAppFailed, AppRecordLogTypeEnum.TEMPLATE_NO_APP_TYPE_XCX_FAILD);
                        gitMsg = gitMsg + "\u589e\u52a0\u5c0f\u7a0b\u5e8f\u6e90\u7801";
                    }
                    if (copyAppToGitFlag.booleanValue()) {
                        matchTemplateAppType_app = this.matchTemplateAppType(templateTempPath, "hussar-mobile-uni", failLog1, sysAppRecord, editAppFailed, AppRecordLogTypeEnum.TEMPLATE_NO_APP_TYPE_APP_FAILD);
                        gitMsg = gitMsg + "\u589e\u52a0APP\u6e90\u7801";
                    }
                    this.insertOrUpdate(sysAppRecord, matchAppTypeTemplateLog, AppRecordLogTypeEnum.MATCH_APP_TYPE_TEMPLATE_SUCCESS);
                    if (!(matchTemplateAppType_web.booleanValue() && matchTemplateAppType_xcx.booleanValue() && matchTemplateAppType_app.booleanValue())) {
                        sysApplication.setAppType(oldApp.getAppType());
                        this.updateById((BaseEntity)sysApplication);
                    } else {
                        logger.info("\u5c06\u6a21\u677f\u6587\u4ef6\u4e2d\u6240\u9700\u5e94\u7528\u7c7b\u578b\u6587\u4ef6copy\u5230\u4ecegit\u4e0adown\u4ee3\u7801\u7684\u4e34\u65f6\u6587\u4ef6:===================");
                        SysAppRecordLog copyTemplateToGit = new SysAppRecordLog();
                        this.insertOrUpdate(sysAppRecord, copyTemplateToGit, AppRecordLogTypeEnum.COPY_TEMPLATE_TO_GIT_TEMP_DURING);
                        editAppFailed.setName(AppRecordLogTypeEnum.COPY_TEMPLATE_TO_GIT_TEMP_DURING.getName());
                        failLog1 = copyTemplateToGit;
                        String destinationFolderPath = gitTempPath + File.separator;
                        File destinationFolder = new File(destinationFolderPath);
                        if (!destinationFolder.exists()) {
                            destinationFolder.mkdirs();
                        }
                        if (copyH5ToGitFlag.booleanValue()) {
                            SysApplicationServiceImpl.copyFolder(new File(templateTempPath + File.separator + "hussar-mobile"), destinationFolder);
                        }
                        if (copyXcxToGitFlag.booleanValue() || copyAppToGitFlag.booleanValue()) {
                            SysApplicationServiceImpl.copyFolder(new File(templateTempPath + File.separator + "hussar-mobile-uni"), destinationFolder);
                        }
                        this.insertOrUpdate(sysAppRecord, copyTemplateToGit, AppRecordLogTypeEnum.COPY_TEMPLATE_TO_GIT_TEMP_SUCCESS);
                        logger.info("\u63d0\u4ea4git\u4ee3\u7801\u5230\u670d\u52a1\u5668:===================");
                        SysAppRecordLog pushToGitLog = new SysAppRecordLog();
                        this.insertOrUpdate(sysAppRecord, pushToGitLog, AppRecordLogTypeEnum.PUSH_TO_GIT_DURING);
                        editAppFailed.setName(AppRecordLogTypeEnum.PUSH_TO_GIT_DURING.getName());
                        failLog1 = pushToGitLog;
                        this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + gitTime + File.separator, sysApplication.getAppCode(), gitMsg, "dev", accessToken);
                        this.insertOrUpdate(sysAppRecord, pushToGitLog, AppRecordLogTypeEnum.PUSH_TO_GIT_SUCCESS);
                        sysAppRecord.setStatus("2");
                        this.sysAppRecordMapper.updateById(sysAppRecord);
                    }
                }
            }
            catch (Exception e) {
                this.insertOrUpdate(sysAppRecord, failLog1, AppRecordLogTypeEnum.RECORD_LOG_STEP_ANME_FAILED);
                sysApplication.setAppType(oldApp.getAppType());
                this.updateById((BaseEntity)sysApplication);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + templateTime));
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + gitTime));
            }
        });
        try {
            if (!sysApplication.getAppDescribe().equals(oldApp.getAppDescribe())) {
                logger.info("\u4fee\u6539gitlab\u9879\u76ee\u63cf\u8ff0:===================");
                SysAppRecordLog editAppDescribeLog = new SysAppRecordLog();
                this.insertOrUpdate(sysAppRecord, editAppDescribeLog, AppRecordLogTypeEnum.EDIT_APP_DESCRIBE_DURING);
                editAppFailed.setName(AppRecordLogTypeEnum.EDIT_APP_DESCRIBE_DURING.getName());
                failLog = editAppDescribeLog;
                this.gitlabService.editProjectDescribe(sysApplication.getAppDescribe(), user.getChar1(), sysApplication.getAppCode());
                this.insertOrUpdate(sysAppRecord, editAppDescribeLog, AppRecordLogTypeEnum.EDIT_APP_DESCRIBE_SUCCESS);
            }
            if ("1".equals(sysApplicationDto.getFlag())) {
                this.gitlabService.inviteUserJoinGroupOrProject(newLeader.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
            }
            if (!"1".equals(sysApplicationDto.getFlag()) && oldApp.getProjectLeader() != null && !oldApp.getProjectLeader().equals(sysApplication.getProjectLeader())) {
                SysAppRecordLog editLeaderLog = new SysAppRecordLog();
                this.insertOrUpdate(sysAppRecord, editLeaderLog, AppRecordLogTypeEnum.EDIT_APP_LEADER_DURING);
                editAppFailed.setName(AppRecordLogTypeEnum.EDIT_APP_LEADER_DURING.getName());
                failLog = editLeaderLog;
                List devList = this.sysAppAuthUserService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthUser::getAppId, (Object)oldApp.getId())).eq(SysAppAuthUser::getAuthType, (Object)"1")).eq(SysAppAuthUser::getDelFlag, (Object)"0")).eq(SysAppAuthUser::getOnlineAuth, (Object)"1")).stream().map(SysAppAuthUser::getUserId).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(devList) && devList.contains(oldApp.getProjectLeader())) {
                    this.gitlabService.editMemberLevelFProject(user.getChar1(), oldApp.getAppCode(), oldLeader.getUserAccount(), "30");
                } else {
                    logger.info("gitlab\u9879\u76ee\u4e2d\u79fb\u9664\u539f\u9879\u76ee\u8d1f\u8d23\u4eba:===================" + oldLeader.getUserAccount());
                    this.gitlabService.deleteUserFGroupOrProject(oldLeader.getUserAccount(), user.getChar1(), "projects", oldApp.getAppCode());
                }
                if (HussarUtils.isNotEmpty(devList) && devList.contains(sysApplication.getProjectLeader())) {
                    this.gitlabService.editMemberLevelFProject(user.getChar1(), oldApp.getAppCode(), newLeader.getUserAccount(), "40");
                } else {
                    logger.info("gitlab\u9879\u76ee\u4e2d\u6dfb\u52a0\u65b0\u9879\u76ee\u8d1f\u8d23\u4eba:===================" + newLeader.getUserAccount());
                    this.gitlabService.inviteUserJoinGroupOrProject(newLeader.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
                }
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(newLeader.getId());
                sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
                sysUserRole.setAdminOption("1");
                if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                this.insertOrUpdate(sysAppRecord, editLeaderLog, AppRecordLogTypeEnum.EDIT_APP_LEADER_SUCCESS);
                SysAppDeploy devDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)sysApplication.getId())).eq(SysAppDeploy::getDeployType, (Object)"1"));
                if (null != devDeploy && "1".equals(devDeploy.getIsPublish())) {
                    pushAppThread.start();
                    if ("0".equals(devDeploy.getIsAbutmentIam())) {
                        pushUserThread.start();
                    }
                }
            }
            if ("1".equals(oldApp.getIsOnline()) && "0".equals(sysApplication.getIsOnline())) {
                logger.info("\u7ebf\u4e0a\u5e94\u7528\u4fee\u6539\u4e3a\u7ebf\u4e0b\u5e94\u7528 \u91ca\u653e\u5e94\u7528\u6240\u6709\u5f00\u53d1\u73af\u5883\u8d44\u6e90:===================");
                SysAppRecordLog releaseResourceLog = new SysAppRecordLog();
                this.insertOrUpdate(sysAppRecord, releaseResourceLog, AppRecordLogTypeEnum.RELEASE_RESOURCE_DURING);
                editAppFailed.setName(AppRecordLogTypeEnum.RELEASE_RESOURCE_DURING.getName());
                failLog = releaseResourceLog;
                this.releaseAppALLDevResource(sysApplication);
                sysApplication.setResourceStatus("");
                this.insertOrUpdate(sysAppRecord, releaseResourceLog, AppRecordLogTypeEnum.RELEASE_RESOURCE_SUCCESS);
                if (!"1".equals(oldApp.getPersonalBrance())) {
                    this.gitlabService.setProtectBranch(oldApp.getAppCode(), user.getChar1());
                }
            }
            if (addH5Flag.booleanValue() || addXcxFlag.booleanValue()) {
                addAppTypeThread.start();
            } else {
                sysAppRecord.setStatus("2");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            this.updateById((BaseEntity)sysApplication);
        }
        catch (Exception e) {
            logger.info("\u5e94\u7528\u7f16\u8f91\uff1a\u66f4\u6362\u8d1f\u8d23\u4eba\u5f02\u5e38========={}", (Object[])e.getStackTrace());
            this.insertOrUpdate(sysAppRecord, failLog, AppRecordLogTypeEnum.RECORD_LOG_STEP_ANME_FAILED);
        }
        return sysApplication.getId();
    }

    private Boolean matchTemplateAppType(String templateTempPath, String fileString, SysAppRecordLog failLog1, SysAppRecord sysAppRecord, AppRecordLogTypeEnum editAppFailed, AppRecordLogTypeEnum appRecordLogMsg) {
        if (!new File(templateTempPath + File.separator + fileString).exists()) {
            logger.info("\u6a21\u677f\u4e0d\u7b26\u5408\u5e94\u7528\u7c7b\u578b:===================");
            SysAppRecordLog templateNoAppTypeLog = new SysAppRecordLog();
            editAppFailed.setName(AppRecordLogTypeEnum.TEMPLATE_NO_APP_TYPE_FAILD.getName());
            failLog1 = templateNoAppTypeLog;
            this.insertOrUpdate(sysAppRecord, templateNoAppTypeLog, appRecordLogMsg);
            return false;
        }
        return true;
    }

    private Boolean checkGitAppType(String gitTempPath, String fileName, AppRecordLogTypeEnum gitExistAppTypeSuccess, AppRecordLogTypeEnum editAppFailed, SysAppRecordLog failLog1, SysAppRecord sysAppRecord) {
        if (new File(gitTempPath + File.separator + fileName).exists()) {
            logger.info("git\u670d\u52a1\u5668\u4e0a\u5df2\u7ecf\u5b58\u5728\u5e94\u7528\u7c7b\u578b\u6587\u4ef6\u5939: addH5Flag:===={}");
            SysAppRecordLog gitExistAppTypeLog = new SysAppRecordLog();
            editAppFailed.setName(gitExistAppTypeSuccess.getName());
            failLog1 = gitExistAppTypeLog;
            gitExistAppTypeLog.setEndTime(LocalDateTime.now());
            this.insertOrUpdate(sysAppRecord, gitExistAppTypeLog, gitExistAppTypeSuccess);
            return false;
        }
        return true;
    }

    private void insertOrUpdate(SysAppRecord sysAppRecord, SysAppRecordLog sysAppRecordLog, AppRecordLogTypeEnum appRecordLogTypeEnum) {
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo(appRecordLogTypeEnum.getName());
        sysAppRecordLog.setStatus(appRecordLogTypeEnum.getStatus());
        if (null == sysAppRecordLog.getId()) {
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            if (AppRecordLogTypeEnum.SAVE_APP_INFO_SUCCESS.getName().equals(appRecordLogTypeEnum.getName()) || appRecordLogTypeEnum.getStatus().equals("1")) {
                sysAppRecordLog.setEndTime(LocalDateTime.now());
            }
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        } else {
            sysAppRecordLog.setEndTime(LocalDateTime.now());
            sysAppRecordLog.setErrInfo(appRecordLogTypeEnum.getMsg());
            this.sysAppRecordLogMapper.updateById(sysAppRecordLog);
        }
        if ("1".equals(appRecordLogTypeEnum.getStatus())) {
            sysAppRecordLog.setEndTime(LocalDateTime.now());
            sysAppRecordLog.setErrInfo(appRecordLogTypeEnum.getMsg());
            this.sysAppRecordLogMapper.updateById(sysAppRecordLog);
            sysAppRecord.setStatus("3");
            this.sysAppRecordMapper.updateById(sysAppRecord);
        }
    }

    private static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        if (sourceFolder.isDirectory()) {
            File[] files;
            Path destinationFolderPath = destinationFolder.toPath().resolve(sourceFolder.getName());
            if (!Files.exists(destinationFolderPath, new LinkOption[0])) {
                Files.createDirectory(destinationFolderPath, new FileAttribute[0]);
            }
            if ((files = sourceFolder.listFiles()) != null) {
                for (File file : files) {
                    SysApplicationServiceImpl.copyFolder(file, destinationFolderPath.toFile());
                }
            }
        } else {
            Path destinationFilePath = destinationFolder.toPath().resolve(sourceFolder.getName());
            Files.copy(sourceFolder.toPath(), destinationFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public SysAppDeploy getSysDeployInfo(Long appId, String deployType, Long userId) {
        return this.sysDeployService.getSysDeployInfo(appId, deployType, userId);
    }

    public int getFrontCount(String threeDomainFront, String twoDomain, Long deployId) {
        return this.sysDeployService.getFrontCount(threeDomainFront, twoDomain, deployId);
    }

    public int getMobileCount(String threeDomainMobile, String twoDomain, Long deployId) {
        return this.sysDeployService.getMobileCount(threeDomainMobile, twoDomain, deployId);
    }

    public void editPublishInfo(SysAppDeploy sysAppDeploy) {
        if (null != sysAppDeploy.getAppDeployId() && ("0".equals(sysAppDeploy.getIsAbutmentIam()) || "n".equals(sysAppDeploy.getAutoTest()))) {
            SysAppDeploy oldInfo = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            if ("0".equals(sysAppDeploy.getIsAbutmentIam())) {
                sysAppDeploy.setIamAuthAddress(oldInfo.getIamAuthAddress());
                sysAppDeploy.setIamAuthClientId(oldInfo.getIamAuthClientId());
                sysAppDeploy.setIamAuthClientSecret(oldInfo.getIamAuthClientSecret());
                sysAppDeploy.setIamGrantAddress(oldInfo.getIamGrantAddress());
                sysAppDeploy.setIamGrantUserName(oldInfo.getIamGrantUserName());
                sysAppDeploy.setIamGrantUserId(oldInfo.getIamGrantUserId());
                sysAppDeploy.setIamGrantAppCode(oldInfo.getIamGrantAppKey());
                sysAppDeploy.setIamGrantAppKey(oldInfo.getIamGrantAppKey());
                sysAppDeploy.setIamDataSyncKey(oldInfo.getIamDataSyncKey());
                sysAppDeploy.setIamBimRemotePwd(oldInfo.getIamBimRemotePwd());
                sysAppDeploy.setIamBimRemoteUser(oldInfo.getIamBimRemoteUser());
                sysAppDeploy.setAdataObjectCode(oldInfo.getAdataObjectCode());
                sysAppDeploy.setDataObjectCode(oldInfo.getDataObjectCode());
                sysAppDeploy.setBtnObjectCode(oldInfo.getBtnObjectCode());
                sysAppDeploy.setIamRequestWay(oldInfo.getIamRequestWay());
            }
            if ("n".equals(sysAppDeploy.getAutoTest())) {
                sysAppDeploy.setWorkspaceName(oldInfo.getWorkspaceName());
                sysAppDeploy.setProjectMsName(oldInfo.getProjectMsName());
                sysAppDeploy.setMethod(oldInfo.getMethod());
                sysAppDeploy.setTestPlanName(oldInfo.getTestPlanName());
                sysAppDeploy.setTestCaseName(oldInfo.getTestCaseName());
                sysAppDeploy.setMode(oldInfo.getMode());
                sysAppDeploy.setMsResultUrl(oldInfo.getMsResultUrl());
            }
        }
    }

    public Long publish(SysApplicationDto sysApplicationDto) {
        logger.info("\u5e94\u7528\u53d1\u5e03\u540e\u53f0\u63a5\u6536\u53c2\u6570\uff1asysApplicationDto ================================>{}", (Object)sysApplicationDto.toString());
        Long time = System.currentTimeMillis();
        SysApplication appInfo = sysApplicationDto.getSysApplication();
        SysApplication sysApplication = (SysApplication)this.getById(appInfo.getId());
        String oldPersonalBrance = sysApplication.getPersonalBrance();
        sysApplication.setPersonalBrance(appInfo.getPersonalBrance());
        sysApplication.setResourceStatus("0");
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("1");
        sysAppDeploy.setDelFlag("0");
        sysAppDeploy.setIsPublish("2");
        sysAppDeploy.setDevopsStatus("0");
        sysAppDeploy.setAppId(sysApplication.getId());
        this.editPublishInfo(sysAppDeploy);
        this.sysDeployService.saveOrUpdate((Object)sysAppDeploy);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u4fdd\u5b58\u5e94\u7528\u4fe1\u606fsysApplication: --------------------->{}", (Object)sysApplication.toString());
        this.saveOrUpdate((BaseEntity)sysApplication);
        SysAppDevops sysAppDevopsDev = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("2");
        sysAppRecord.setDefinitionId(null == sysAppDevopsDev ? null : sysAppDevopsDev.getTestDefinitionId());
        sysAppRecord.setPipelineType("\u5e94\u7528\u53d1\u5e03");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        if (null == sysAppDevopsDev) {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        } else {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        }
        Thread thread = new Thread(() -> {
            try {
                logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730===================");
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "dev");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "DEV", "dev");
                this.gitlabService.pushToDev(null, "1", sysApplication.getAppCode(), "\u5e94\u7528\u53d1\u5e03\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                if (!"1".equals(sysApplication.getPersonalBrance())) {
                    logger.info("\u5171\u540c\u5206\u652f\u6a21\u5f0f\uff1a\u53d6\u6d88dev\u4fdd\u62a4\u5206\u652f===================");
                    this.gitlabService.unProtectBranch(sysApplication.getAppCode(), accessToken);
                }
                logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u5bf9\u63a5devops\u5f00\u59cb===================");
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId()));
                if (null == sysAppDevops || "0".equals(sysAppDevops.getRecoverFlag())) {
                    this.sysAppResourceService.countApplicationNum(sysApplication.getDevelopResourceId());
                }
                SysAppRecordLog sysAppRecordLog1 = sysAppRecordLog;
                if (sysAppDevops == null) {
                    SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
                    JSONObject sysAppDevopsJson = this.sysAppDevopsService.createProject(sysApplication, projectLeaderUser.getUserAccount());
                    sysAppDevops = new SysAppDevops();
                    sysAppDevops.setAppId(sysApplication.getId());
                    sysAppDevops.setProjectId(String.valueOf(sysAppDevopsJson.get((Object)"projectId")));
                }
                if (HussarUtils.isEmpty((Object)sysAppDevops.getDevDefinitionId())) {
                    logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u521b\u5efa\u6570\u636e\u5e93\u5f00\u59cb\uff1a===============================");
                    JSONObject json = this.sysAppDevopsService.createPipeline(sysApplication, sysAppDeploy, "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master", sysAppDevops.getProjectId(), sysAppRecord, sysAppRecordLog1);
                    if ("200".equals(json.getString("statusCode"))) {
                        sysAppDevops.setDevDefinitionId(json.getString("devDefinitionId"));
                        sysAppDevops.setTestDefinitionId(json.getString("testDefinitionId"));
                        sysAppDevops.setProdDefinitionId(json.getString("prodDefinitionId"));
                        sysAppDevops.setPreDefinitionId(json.getString("preDefinitionId"));
                        sysAppDevops.setBranch("1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master");
                        sysAppDevops.setRecoverFlag("1");
                        sysAppDevops.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                        sysAppDevops.setEnv("DEV");
                        sysAppDevops.setReleas(json.get((Object)"releas").toString());
                        logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u4fdd\u5b58devops\u6784\u5efa\u4fe1\u606fsysAppDevops: --------------------->{}", (Object)sysAppDevops);
                        this.sysAppDevopsService.saveOrUpdate((Object)sysAppDevops);
                        sysAppRecordLog1 = new SysAppRecordLog();
                        sysAppRecordLog1.setRecordId(sysAppRecord.getId());
                        sysAppRecordLog1.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
                        sysAppRecordLog1.setStartTime(LocalDateTime.now());
                        sysAppRecordLog1.setStatus("2");
                        sysAppRecordLog1.setType("1");
                    } else {
                        logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a===============================");
                        return;
                    }
                }
                String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
                logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u5f00\u59cb\u6267\u884c\u6d41\u6c34\u7ebf-----------------");
                this.sysAppDevopsService.executePipeline(sysAppDevops.getDevDefinitionId(), "v" + sysAppDevops.getVersion(), frontType, sysAppDeploy.getInitDatabase(), "DEV", "dev", sysAppDeploy, sysAppRecord, sysAppRecordLog1);
                if ("0".equals(appInfo.getPersonalBrance()) && "1".equals(oldPersonalBrance)) {
                    logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u72ec\u7acb\u6a21\u5f0f\u66f4\u6539\u4e3a\u5171\u540c\u6a21\u5f0f \u91ca\u653e\u6240\u6709\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u8d44\u6e90===================");
                    this.releasePersonDevResource(sysApplication);
                    this.gitlabService.unProtectBranch(sysApplication.getAppCode(), accessToken);
                }
                if ("1".equals(appInfo.getPersonalBrance()) && "0".equals(oldPersonalBrance)) {
                    this.gitlabService.setProtectBranch(sysApplication.getAppCode(), accessToken);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                logger.info("\u5e94\u7528\u53d1\u5e03\uff1a\u5220\u9664\u672c\u5730\u4e34\u65f6\u6587\u4ef6-----------------");
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        });
        if (null == sysAppDeploy.getAppDeployId()) {
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            thread.start();
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
            if (!oldSysAppDeploy.equals(sysAppDeploy)) {
                thread.start();
            }
        }
        return time;
    }

    public Long publishToTestEnvironment(SysApplicationDto sysApplicationDto) {
        logger.info("\u53d1\u5e03\u5230\u6d4b\u8bd5\u540e\u53f0\u63a5\u6536\u53c2\u6570\uff1asysApplicationDto ================================>{}", (Object)sysApplicationDto.toString());
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("3");
        sysAppDeploy.setDelFlag("0");
        sysAppDeploy.setDeployStatus("1");
        sysAppDeploy.setIsPublish("2");
        sysAppDeploy.setDevopsStatus("0");
        sysAppDeploy.setAppId(sysApplication.getId());
        this.editPublishInfo(sysAppDeploy);
        this.sysDeployService.saveOrUpdate((Object)sysAppDeploy);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        String branchName = "";
        branchName = "0".equals(sysApplication.getIsOnline()) || "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master";
        SysAppDevops sysAppDevopsDev = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("2");
        sysAppRecord.setDefinitionId(null == sysAppDevopsDev ? null : sysAppDevopsDev.getTestDefinitionId());
        sysAppRecord.setPipelineType("\u6d4b\u8bd5\u73af\u5883\u53d1\u5e03");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        if (null == sysAppDevopsDev) {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        } else {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        }
        String finalBranchName = branchName;
        new Thread(() -> {
            try {
                logger.info("\u53d1\u5e03\u5230\u6d4b\u8bd5\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730============================");
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, finalBranchName);
                logger.info("\u53d1\u5e03\u5230\u6d4b\u8bd5\uff1a\u751f\u6210\u6a21\u677f\u6587\u4ef6============================");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "TEST", finalBranchName);
                logger.info("\u53d1\u5e03\u5230\u6d4b\u8bd5\uff1a\u63d0\u4ea4\u4ee3\u7801============================");
                this.gitlabService.pushToDev(finalBranchName, sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u53d1\u5e03\u6d4b\u8bd5\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplicationDto.getSysApplication().getId(), "D");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "B");
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_B_T" + (count + 1);
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("B");
                sysAppVersion.setBranchName(finalBranchName);
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
                logger.info("\u53d1\u5e03\u5230\u6d4b\u8bd5\uff1a\u5bf9\u63a5devops\u5f00\u59cb============================");
                String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId()));
                SysAppRecordLog sysAppRecordLog1 = sysAppRecordLog;
                if (sysAppDevops == null) {
                    SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
                    JSONObject sysAppDevopsJson = this.sysAppDevopsService.createProject(sysApplication, projectLeaderUser.getUserAccount());
                    sysAppDevops = new SysAppDevops();
                    sysAppDevops.setAppId(sysApplication.getId());
                    sysAppDevops.setProjectId(String.valueOf(sysAppDevopsJson.get((Object)"projectId")));
                }
                if (HussarUtils.isEmpty((Object)sysAppDevops.getTestDefinitionId())) {
                    logger.info("\u53d1\u5e03\u6d4b\u8bd5\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u521b\u5efa\u6570\u636e\u5e93\u5f00\u59cb\uff1a===============================");
                    JSONObject json = this.sysAppDevopsService.createPipeline(sysApplication, sysAppDeploy, finalBranchName, sysAppDevops.getProjectId(), sysAppRecord, sysAppRecordLog1);
                    if ("200".equals(json.getString("statusCode"))) {
                        sysAppDevops.setDevDefinitionId(json.getString("devDefinitionId"));
                        sysAppDevops.setTestDefinitionId(json.getString("testDefinitionId"));
                        sysAppDevops.setProdDefinitionId(json.getString("prodDefinitionId"));
                        sysAppDevops.setPreDefinitionId(json.getString("preDefinitionId"));
                        sysAppDevops.setBranch(finalBranchName);
                        sysAppDevops.setRecoverFlag("1");
                        sysAppDevops.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                        sysAppDevops.setEnv("DEV");
                        sysAppDevops.setReleas(json.get((Object)"releas").toString());
                        logger.info("\u53d1\u5e03\u6d4b\u8bd5\uff1a\u4fdd\u5b58devops\u6784\u5efa\u4fe1\u606fsysAppDevops: --------------------->{}", (Object)sysAppDevops.toString());
                        this.sysAppDevopsService.saveOrUpdate((Object)sysAppDevops);
                        sysAppRecordLog1 = new SysAppRecordLog();
                        sysAppRecordLog.setRecordId(sysAppRecord.getId());
                        sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
                        sysAppRecordLog.setStartTime(LocalDateTime.now());
                        sysAppRecordLog.setStatus("2");
                        sysAppRecordLog.setType("1");
                    } else {
                        logger.info("\u53d1\u5e03\u6d4b\u8bd5\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a===============================");
                        return;
                    }
                }
                logger.info("\u53d1\u5e03\u6d4b\u8bd5\uff1a\u6267\u884c\u6d41\u6c34\u7ebf\u5f00\u59cb============================");
                this.sysAppDevopsService.executePipeline(sysAppDevops.getTestDefinitionId(), versionName, frontType, sysAppDeploy.getInitDatabase(), "TEST", finalBranchName, sysAppDeploy, sysAppRecord, sysAppRecordLog1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                logger.info("\u53d1\u5e03\u6d4b\u8bd5\uff1a\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939============================");
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public Long publishToFormalEnvironment(SysApplicationDto sysApplicationDto) {
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        if (sysApplication != null) {
            sysApplication.setReleaseStatus("0");
            sysApplication.setPublishFormalTime(LocalDateTime.now());
            this.updateById((BaseEntity)sysApplication);
        }
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("4");
        sysAppDeploy.setDelFlag("0");
        sysAppDeploy.setDeployStatus("1");
        sysAppDeploy.setIsPublish("2");
        sysAppDeploy.setDevopsStatus("0");
        sysAppDeploy.setAppId(sysApplication.getId());
        this.editPublishInfo(sysAppDeploy);
        this.sysDeployService.saveOrUpdate((Object)sysAppDeploy);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        String branchName = "";
        branchName = "0".equals(sysApplication.getIsOnline()) || "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master";
        String finalBranchName = branchName;
        SysAppDevops sysAppDevopsDev = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("2");
        sysAppRecord.setDefinitionId(null == sysAppDevopsDev ? null : sysAppDevopsDev.getProdDefinitionId());
        sysAppRecord.setPipelineType("\u6b63\u5f0f\u73af\u5883\u53d1\u5e03");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        if (null == sysAppDevopsDev) {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        } else {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        }
        new Thread(() -> {
            try {
                logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730============================");
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, finalBranchName);
                logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u751f\u6210\u6a21\u677f\u6587\u4ef6============================");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "PROD", finalBranchName);
                logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u63d0\u4ea4\u4ee3\u7801============================");
                this.gitlabService.pushToDev(finalBranchName, sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u53d1\u5e03\u6b63\u5f0f\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplication.getId(), "B");
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "R");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                if (count > 0) {
                    int num = 0;
                    String[] numArray = versionNum.split("\\.");
                    num = Integer.parseInt(numArray[2]) + 1;
                    versionNum = numArray[0] + "." + numArray[1] + "." + num;
                }
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_R";
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("R");
                sysAppVersion.setBranchName(finalBranchName);
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
                String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId()));
                SysAppRecordLog sysAppRecordLog1 = sysAppRecordLog;
                if (sysAppDevops == null) {
                    SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
                    JSONObject sysAppDevopsJson = this.sysAppDevopsService.createProject(sysApplication, projectLeaderUser.getUserAccount());
                    sysAppDevops = new SysAppDevops();
                    sysAppDevops.setAppId(sysApplication.getId());
                    sysAppDevops.setProjectId(String.valueOf(sysAppDevopsJson.get((Object)"projectId")));
                }
                if (HussarUtils.isEmpty((Object)sysAppDevops.getProdDefinitionId())) {
                    logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u521b\u5efa\u6570\u636e\u5e93\u5f00\u59cb\uff1a===============================");
                    JSONObject json = this.sysAppDevopsService.createPipeline(sysApplication, sysAppDeploy, finalBranchName, sysAppDevops.getProjectId(), sysAppRecord, sysAppRecordLog1);
                    if ("200".equals(json.getString("statusCode"))) {
                        sysAppDevops.setDevDefinitionId(json.getString("devDefinitionId"));
                        sysAppDevops.setTestDefinitionId(json.getString("testDefinitionId"));
                        sysAppDevops.setProdDefinitionId(json.getString("prodDefinitionId"));
                        sysAppDevops.setPreDefinitionId(json.getString("preDefinitionId"));
                        sysAppDevops.setBranch(finalBranchName);
                        sysAppDevops.setRecoverFlag("1");
                        sysAppDevops.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                        sysAppDevops.setEnv("DEV");
                        sysAppDevops.setReleas(json.get((Object)"releas").toString());
                        logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u4fdd\u5b58devops\u6784\u5efa\u4fe1\u606fsysAppDevops: --------------------->{}", (Object)sysAppDevops);
                        this.sysAppDevopsService.saveOrUpdate((Object)sysAppDevops);
                        sysAppRecordLog1 = new SysAppRecordLog();
                        sysAppRecordLog1.setRecordId(sysAppRecord.getId());
                        sysAppRecordLog1.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
                        sysAppRecordLog1.setStartTime(LocalDateTime.now());
                        sysAppRecordLog1.setStatus("2");
                        sysAppRecordLog1.setType("1");
                    } else {
                        logger.info("\u53d1\u5e03\u6b63\u5f0f\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a===============================");
                        return;
                    }
                }
                logger.info("\u53d1\u5e03\u5230\u6b63\u5f0f\uff1a\u6267\u884c\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a===============================");
                this.sysAppDevopsService.executePipeline(sysAppDevops.getProdDefinitionId(), versionName, frontType, "n", "PROD", finalBranchName, sysAppDeploy, sysAppRecord, sysAppRecordLog1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public SysApplication getApplicationInfo() {
        return this.sysApplicationMapper.getApplicationInfo();
    }

    @HussarTransactional
    public Boolean deleteApp(Long appId) {
        SysApplication appInfo = (SysApplication)this.getById(appId);
        if ("1".equals(appInfo.getAppStatus())) {
            return false;
        }
        appInfo.setDelFlag("1");
        appInfo.setResourceStatus("1");
        new Thread(() -> {
            if ("1".equals(appInfo.getIsOnline())) {
                this.releaseAppALLDevResource(appInfo);
            }
            this.gitlabService.removeAllUserFProject(this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId()).getChar1(), appInfo.getAppCode());
            List list = this.sysAppAuthUserService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthUser::getAppId, (Object)appId)).eq(SysAppAuthUser::getDelFlag, (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                for (SysAppAuthUser authUser : list) {
                    authUser.setDelFlag("1");
                    this.sysAppAuthUserService.update((Object)authUser, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppAuthUser::getAppId, (Object)appId)).eq(SysAppAuthUser::getUserId, (Object)authUser.getUserId()));
                }
            }
        }).start();
        return this.updateById((BaseEntity)appInfo);
    }

    public void releaseAppALLDevResource(SysApplication appInfo) {
        int count = this.sysDeployService.getCount(appInfo.getId());
        SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)appInfo.getDevelopResourceId());
        sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + count));
        sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - count));
        this.sysAppResourceService.updateById((Object)sysAppResource);
        this.sysDeployService.updateIsPublish(appInfo.getId());
        appInfo.setResourceStatus("1");
        this.updateById((BaseEntity)appInfo);
        List list = this.sysAppDevopsService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)appInfo.getId())).eq((Object)"RECOVER_FLAG", (Object)"1"));
        if (HussarUtils.isNotEmpty((Object)list)) {
            List releasList = list.stream().map(SysAppDevops::getReleas).collect(Collectors.toList());
            String releasStr = String.join((CharSequence)",", releasList);
            logger.info("\u5220\u9664\u5e94\u7528\uff1a\u5bf9\u63a5devops\u91ca\u653e\u6240\u6709\u5f00\u53d1\u73af\u5883\u8d44\u6e90releasStr\uff1a=========================>{}", (Object)releasStr);
            this.sysAppDevopsService.releaseResource(releasStr);
        }
    }

    public Long publishToPreEnvironment(SysApplicationDto sysApplicationDto) {
        logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u540e\u53f0\u63a5\u6536\u53c2\u6570\uff1asysApplicationDto ================================>{}", (Object)sysApplicationDto.toString());
        Long time = System.currentTimeMillis();
        SysApplication sysApplication = (SysApplication)this.getById(sysApplicationDto.getSysApplication().getId());
        SysAppDeploy sysAppDeploy = sysApplicationDto.getSysAppDeploy();
        sysAppDeploy.setDeployType("5");
        sysAppDeploy.setDelFlag("0");
        sysAppDeploy.setDeployStatus("1");
        sysAppDeploy.setIsPublish("2");
        sysAppDeploy.setDevopsStatus("0");
        sysAppDeploy.setAppId(sysApplication.getId());
        this.editPublishInfo(sysAppDeploy);
        this.sysDeployService.saveOrUpdate((Object)sysAppDeploy);
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        String branchName = "";
        branchName = "0".equals(sysApplication.getIsOnline()) || "1".equals(sysApplication.getPersonalBrance()) ? "dev" : "master";
        SysAppDevops sysAppDevopsDev = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("2");
        sysAppRecord.setDefinitionId(null == sysAppDevopsDev ? null : sysAppDevopsDev.getPreDefinitionId());
        sysAppRecord.setPipelineType("\u9884\u53d1\u5e03\u73af\u5883\u53d1\u5e03");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        if (null == sysAppDevopsDev) {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u9879\u76ee\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        } else {
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
            sysAppRecordLog.setStatus("2");
            sysAppRecordLog.setType("1");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        }
        String finalBranchName = branchName;
        new Thread(() -> {
            try {
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730============================");
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, finalBranchName);
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u751f\u6210\u6a21\u677f\u6587\u4ef6============================");
                this.yamlService.createValues(sysAppDeploy, sysApplication.getAppType(), sysApplication.getAppCode(), time, "PRE", finalBranchName);
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u63d0\u4ea4\u4ee3\u7801============================");
                this.gitlabService.pushToDev(finalBranchName, sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u53d1\u5e03\u9884\u53d1\u5e03\u73af\u5883\u63d0\u4ea4\u90e8\u7f72\u4fe1\u606f", accessToken, time);
                SysAppVersion sysAppVersion = new SysAppVersion();
                String versionNum = "";
                List versionNumList = this.sysAppVersionService.getVersionNum(sysApplicationDto.getSysApplication().getId(), "B");
                versionNum = versionNumList.size() > 0 ? (String)versionNumList.get(0) : "V1.0.0";
                int count = this.sysAppVersionService.getCount(sysApplication.getId(), "P");
                if (count > 0) {
                    int num = 0;
                    String[] numArray = versionNum.split("\\.");
                    num = Integer.parseInt(numArray[2]) + 1;
                    versionNum = numArray[0] + "." + numArray[1] + "." + num;
                }
                String versionName = sysApplication.getAppCode() + "_" + versionNum + "_" + new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_P";
                sysAppVersion.setVersionNum(versionNum);
                sysAppVersion.setVersionDesc(versionNum);
                sysAppVersion.setVersionName(versionName);
                sysAppVersion.setAppId(sysApplication.getId());
                sysAppVersion.setVersionType("B");
                sysAppVersion.setBranchName(finalBranchName);
                this.sysAppVersionService.saveVersion(sysAppVersion, user);
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u5bf9\u63a5devops\u5f00\u59cb============================");
                String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
                SysAppDevops sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId()));
                SysAppRecordLog sysAppRecordLog1 = sysAppRecordLog;
                if (sysAppDevops == null) {
                    SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
                    JSONObject sysAppDevopsJson = this.sysAppDevopsService.createProject(sysApplication, projectLeaderUser.getUserAccount());
                    sysAppDevops = new SysAppDevops();
                    sysAppDevops.setAppId(sysApplication.getId());
                    sysAppDevops.setProjectId(String.valueOf(sysAppDevopsJson.get((Object)"projectId")));
                }
                if (HussarUtils.isEmpty((Object)sysAppDevops.getPreDefinitionId())) {
                    logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u5f00\u59cb\uff1a===============================");
                    JSONObject json = this.sysAppDevopsService.createPipeline(sysApplication, sysAppDeploy, finalBranchName, sysAppDevops.getProjectId(), sysAppRecord, sysAppRecordLog1);
                    if ("200".equals(json.getString("statusCode"))) {
                        sysAppDevops.setDevDefinitionId(json.getString("devDefinitionId"));
                        sysAppDevops.setTestDefinitionId(json.getString("testDefinitionId"));
                        sysAppDevops.setProdDefinitionId(json.getString("prodDefinitionId"));
                        sysAppDevops.setPreDefinitionId(json.getString("preDefinitionId"));
                        sysAppDevops.setBranch(finalBranchName);
                        sysAppDevops.setRecoverFlag("1");
                        sysAppDevops.setVersion(Integer.valueOf(Integer.parseInt(json.get((Object)"version").toString())));
                        sysAppDevops.setEnv("DEV");
                        sysAppDevops.setReleas(json.get((Object)"releas").toString());
                        logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u4fdd\u5b58devops\u6784\u5efa\u4fe1\u606fsysAppDevops: --------------------->{}", (Object)sysAppDevops);
                        this.sysAppDevopsService.saveOrUpdate((Object)sysAppDevops);
                        sysAppRecordLog1 = new SysAppRecordLog();
                        sysAppRecordLog.setRecordId(sysAppRecord.getId());
                        sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
                        sysAppRecordLog.setStartTime(LocalDateTime.now());
                        sysAppRecordLog.setStatus("2");
                        sysAppRecordLog.setType("1");
                    } else {
                        logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u5bf9\u63a5devops\u6784\u5efa\u6d41\u6c34\u7ebf\u5931\u8d25\uff1a===============================");
                        return;
                    }
                }
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u6267\u884c\u6d41\u6c34\u7ebf\u5f00\u59cb============================");
                this.sysAppDevopsService.executePipeline(sysAppDevops.getPreDefinitionId(), versionName, frontType, sysAppDeploy.getInitDatabase(), "PRE", finalBranchName, sysAppDeploy, sysAppRecord, sysAppRecordLog1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                logger.info("\u53d1\u5e03\u5230\u9884\u53d1\u5e03\u73af\u5883\uff1a\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5939============================");
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        if (null == sysAppDeploy.getAppDeployId()) {
            if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        } else {
            SysAppDeploy oldSysAppDeploy = (SysAppDeploy)this.sysDeployService.getById((Serializable)sysAppDeploy.getAppDeployId());
            this.sysDeployService.updateDeploy(sysAppDeploy);
            if (!HussarUtils.isEmpty((Object)oldSysAppDeploy.getDomainId())) {
                if (!oldSysAppDeploy.getDomainId().equals(sysAppDeploy.getDomainId())) {
                    SysAppDomain sysAppDomain = new SysAppDomain();
                    sysAppDomain.setId(oldSysAppDeploy.getDomainId());
                    sysAppDomain.setDomainStatus("0");
                    this.iSysAppDomainService.updateStatus(sysAppDomain);
                    if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                        SysAppDomain sysAppDomain2 = new SysAppDomain();
                        sysAppDomain2.setId(sysAppDeploy.getDomainId());
                        sysAppDomain2.setDomainStatus("1");
                        this.iSysAppDomainService.updateStatus(sysAppDomain2);
                    }
                }
            } else if (!HussarUtils.isEmpty((Object)sysAppDeploy.getDomainId())) {
                SysAppDomain sysAppDomain2 = new SysAppDomain();
                sysAppDomain2.setId(sysAppDeploy.getDomainId());
                sysAppDomain2.setDomainStatus("1");
                this.iSysAppDomainService.updateStatus(sysAppDomain2);
            }
        }
        return time;
    }

    public List<SysAppDeploy> getAppLeaderBranchInfo(Long appId) {
        Long userId = BaseSecurityUtil.getUser().getId();
        return this.sysApplicationMapper.getAppLeaderBranchInfo(appId, userId);
    }

    public Map<String, Object> getAppDevelopStatus(Long appId, String deployType, Long userId) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("appStatus", "3");
        SysAppDeploy deployInfo = null;
        deployInfo = HussarUtils.isEmpty((Object)userId) ? (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)appId)).eq(SysAppDeploy::getDeployType, (Object)deployType)).eq(SysAppDeploy::getDelFlag, (Object)"0")) : (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDeploy::getAppId, (Object)appId)).eq(SysAppDeploy::getDeployType, (Object)deployType)).eq(SysAppDeploy::getUserId, (Object)userId)).eq(SysAppDeploy::getDelFlag, (Object)"0"));
        if (HussarUtils.isEmpty((Object)deployInfo)) {
            res.put("appStatus", "0");
            return res;
        }
        SysAppDevops sysAppDevops = null;
        sysAppDevops = "2".equals(deployType) ? (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)appId)).eq(SysAppDevops::getBranch, (Object)deployInfo.getBranchName())) : (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)appId)).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
        if (HussarUtils.isEmpty((Object)sysAppDevops)) {
            res.put("appStatus", "3");
            return res;
        }
        String definitionId = null;
        if ("2".equals(deployType)) {
            definitionId = sysAppDevops.getDevDefinitionId();
        } else if ("1".equals(deployType)) {
            definitionId = sysAppDevops.getDevDefinitionId();
        } else if ("3".equals(deployType)) {
            definitionId = sysAppDevops.getTestDefinitionId();
        } else if ("4".equals(deployType)) {
            definitionId = sysAppDevops.getProdDefinitionId();
        } else if ("5".equals(deployType)) {
            definitionId = sysAppDevops.getPreDefinitionId();
        }
        List recordList = this.sysAppRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppRecord::getAppId, (Object)appId)).eq(SysAppRecord::getDefinitionId, (Object)definitionId)).orderByDesc(HussarBaseEntity::getCreateTime));
        if (HussarUtils.isEmpty((Object)recordList)) {
            res.put("appStatus", "3");
            return res;
        }
        String pipelineStatus = ((SysAppRecord)recordList.get(0)).getPipelineStatus();
        String deployStatus = ((SysAppRecord)recordList.get(0)).getStatus();
        if ("1".equals(pipelineStatus) && "1".equals(deployStatus)) {
            res.put("appStatus", "1");
        } else if ("4".equals(pipelineStatus)) {
            res.put("appStatus", "4");
        } else if ("3".equals(pipelineStatus)) {
            res.put("appStatus", "3");
        } else if ("1".equals(deployStatus) && "2".equals(pipelineStatus)) {
            res.put("appStatus", "2");
        } else {
            res.put("appStatus", "3");
        }
        return res;
    }

    public IPage<SysAppInfoVo> queryAppListPage(Page<SysAppInfoVo> pages, SysAppInfoVo sysAppInfoVo) {
        sysAppInfoVo.setAppName(SqlQueryUtil.transferSpecialChar((String)sysAppInfoVo.getAppName()));
        sysAppInfoVo.setApplyUserName(SqlQueryUtil.transferSpecialChar((String)sysAppInfoVo.getApplyUserName()));
        sysAppInfoVo.setAppManageName(SqlQueryUtil.transferSpecialChar((String)sysAppInfoVo.getAppManageName()));
        sysAppInfoVo.setEscapeSymbol(SqlQueryUtil.ESCAPE_SYMBOL);
        if (HussarUtils.isNotEmpty((Object)sysAppInfoVo.getApplyDeptIdStr())) {
            sysAppInfoVo.setApplyDeptList(Arrays.stream(sysAppInfoVo.getApplyDeptIdStr().split(",")).map(Long::parseLong).collect(Collectors.toList()));
        }
        sysAppInfoVo.setSuperAdmin(Boolean.valueOf(BaseSecurityUtil.getUser().isSuperAdmin()));
        sysAppInfoVo.setUserId(BaseSecurityUtil.getUser().getId());
        List<SysAppInfoVo> sysAppList = this.sysApplicationMapper.queryAppList(pages, sysAppInfoVo);
        this.getAppStatus(sysAppList, "2");
        return pages.setRecords(sysAppList);
    }

    private void getAppStatus(List<SysAppInfoVo> sysAppList, String type) {
        sysAppList.stream().forEach(item -> {
            String stageName = "";
            stageName = null != item.getProdDeployType() && "1".equals(item.getProdIspublish()) ? stageName + "\u5df2\u4e0a\u7ebf," : (null != item.getTestDeployType() && "1".equals(item.getTestIspublish()) ? stageName + "\u5df2\u6d4b\u8bd5," : stageName + "\u5f00\u53d1\u4e2d,");
            if ("2".equals(type) && "1".equals(item.getResourceStatus())) {
                stageName = stageName + "\u5df2\u56de\u6536\u8d44\u6e90,";
            }
            stageName = stageName.substring(0, stageName.length() - 1);
            item.setAppStageStatus(stageName);
        });
    }

    public Map<String, Object> queryAppCount() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        int dev = 0;
        int test = 0;
        int prod = 0;
        int release = 0;
        SysAppInfoVo sysAppInfoVo = new SysAppInfoVo();
        sysAppInfoVo.setSuperAdmin(Boolean.valueOf(BaseSecurityUtil.getUser().isSuperAdmin()));
        sysAppInfoVo.setUserId(BaseSecurityUtil.getUser().getId());
        List<SysAppInfoVo> sysAppInfoVos = this.sysApplicationMapper.queryAppCount(sysAppInfoVo);
        for (SysAppInfoVo item : sysAppInfoVos) {
            if (null != item.getProdDeployType() && "1".equals(item.getProdIspublish())) {
                ++prod;
            } else if (null != item.getTestDeployType() && "1".equals(item.getTestIspublish())) {
                ++test;
            } else {
                ++dev;
            }
            if (!"1".equals(item.getResourceStatus())) continue;
            ++release;
        }
        res.put("total", HussarUtils.isNotEmpty(sysAppInfoVos) ? sysAppInfoVos.size() : 0);
        res.put("dev", dev);
        res.put("test", test);
        res.put("prod", prod);
        res.put("release", release);
        return res;
    }

    void releasePersonDevResource(SysApplication sysApplication) {
        List list;
        List sysAppDeployList = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysApplication.getId())).eq((Object)"DEPLOY_TYPE", (Object)"2")).eq((Object)"IS_PUBLISH", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
        if (HussarUtils.isNotEmpty((Object)sysAppDeployList)) {
            SysAppResource sysAppResource = (SysAppResource)this.sysAppResourceService.getById((Serializable)sysApplication.getDevelopResourceId());
            sysAppResource.setResidueNum(Integer.valueOf(sysAppResource.getResidueNum() + sysAppDeployList.size()));
            sysAppResource.setAssignedNum(Integer.valueOf(sysAppResource.getAssignedNum() - sysAppDeployList.size()));
            this.sysAppResourceService.updateById((Object)sysAppResource);
        }
        if (HussarUtils.isNotEmpty((Object)(list = this.sysAppDevopsService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)sysApplication.getId())).eq((Object)"RECOVER_FLAG", (Object)"1")).eq((Object)"TEST_DEFINITION_ID", (Object)""))))) {
            List releasList = list.stream().map(SysAppDevops::getReleas).collect(Collectors.toList());
            String releasStr = String.join((CharSequence)",", releasList);
            logger.info("\u5220\u9664\u5e94\u7528\uff1a\u5bf9\u63a5devops\u91ca\u653e\u6240\u6709\u4e2a\u4eba\u5f00\u53d1\u73af\u5883\u8d44\u6e90releasStr\uff1a=========================>{}", (Object)releasStr);
            this.sysAppDevopsService.releaseResource(releasStr);
            this.sysDeployService.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"APP_ID", (Object)sysApplication.getId())).eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"DEPLOY_TYPE", (Object)"2")).set((Object)"IS_PUBLISH", (Object)"0"));
        }
    }

    public ApiResponse<SysApplicationVo> getAppDetail(Long appId) {
        SysApplicationVo sysApplicationVo = this.sysApplicationMapper.getAppDetail(appId);
        return ApiResponse.success((Object)sysApplicationVo);
    }

    public Long copyApplication(SysApplicationDto sysApplicationDto) {
        LocalDateTime log1StartTime = LocalDateTime.now();
        Long time = System.currentTimeMillis();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        String accessToken = user.getChar1();
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysApplication application = (SysApplication)this.getById(sysApplication.getId());
        Long appId = IdWorker.getId((Object)new SysApplication());
        sysApplication.setId(appId);
        sysApplication.setReleaseStatus("0");
        sysApplication.setAppStatus("2");
        sysApplication.setDelFlag("0");
        sysApplication.setCreateFlag("0");
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + File.separator + ".git");
        this.save((BaseEntity)sysApplication);
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("1");
        sysAppRecord.setPipelineType("\u5e94\u7528\u521b\u5efa");
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        SysAppRecordLog recordLog1 = new SysAppRecordLog();
        try {
            recordLog1.setRecordId(sysAppRecord.getId());
            recordLog1.setLogInfo(AppRecordLogTypeEnum.SAVE_APP_INFO_SUCCESS.getName());
            recordLog1.setStartTime(log1StartTime);
            Thread.sleep(1000L);
            recordLog1.setEndTime(LocalDateTime.now());
            recordLog1.setStatus(AppRecordLogTypeEnum.SAVE_APP_INFO_SUCCESS.getStatus());
            this.sysAppRecordLogMapper.insert(recordLog1);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u5e94\u7528\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
        SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
        new Thread(() -> {
            LocalDateTime failStartTime = recordLog1.getEndTime();
            String logInfo = "\u590d\u5236\u539f\u9879\u76ee\u6e90\u7801";
            String status = "";
            Long id = 0L;
            try {
                SysAppRecordLog recordLog2 = new SysAppRecordLog();
                recordLog2.setRecordId(sysAppRecord.getId());
                recordLog2.setLogInfo(logInfo);
                recordLog2.setStartTime(recordLog1.getEndTime());
                recordLog2.setStatus("2");
                this.sysAppRecordLogMapper.insert(recordLog2);
                id = recordLog2.getId();
                status = "2";
                this.gitlabService.pullToLocal(application.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, "dev");
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode() + File.separator + ".git"));
                recordLog2.setEndTime(LocalDateTime.now());
                recordLog2.setStatus("0");
                this.sysAppRecordLogMapper.updateById(recordLog2);
                status = "0";
                logInfo = AppRecordLogTypeEnum.GET_UPDATE_GIT_DURING.getName();
                SysAppRecordLog recordLog3 = new SysAppRecordLog();
                recordLog3.setRecordId(sysAppRecord.getId());
                recordLog3.setLogInfo(logInfo);
                recordLog3.setStartTime(recordLog2.getEndTime());
                recordLog3.setStatus(AppRecordLogTypeEnum.GET_UPDATE_GIT_DURING.getStatus());
                this.sysAppRecordLogMapper.insert(recordLog3);
                id = recordLog3.getId();
                status = AppRecordLogTypeEnum.GET_UPDATE_GIT_DURING.getStatus();
                failStartTime = recordLog2.getEndTime();
                this.gitlabService.createProject(sysApplication.getAppCode(), sysApplication.getAppDescribe(), "\u521b\u5efa\u526f\u672c\u5e94\u7528", accessToken, time);
                recordLog3.setStatus(AppRecordLogTypeEnum.GET_UPDATE_GIT_SUCCESS.getStatus());
                recordLog3.setEndTime(LocalDateTime.now());
                this.sysAppRecordLogMapper.updateById(recordLog3);
                status = AppRecordLogTypeEnum.GET_UPDATE_GIT_SUCCESS.getStatus();
                logInfo = AppRecordLogTypeEnum.GIT_PERSION_DURING.getName();
                SysAppRecordLog recordLog4 = new SysAppRecordLog();
                recordLog4.setRecordId(sysAppRecord.getId());
                recordLog4.setLogInfo(logInfo);
                recordLog4.setStartTime(recordLog3.getEndTime());
                recordLog4.setStatus(AppRecordLogTypeEnum.GIT_PERSION_DURING.getStatus());
                this.sysAppRecordLogMapper.insert(recordLog4);
                id = recordLog4.getId();
                status = AppRecordLogTypeEnum.GIT_PERSION_DURING.getStatus();
                failStartTime = recordLog3.getEndTime();
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
                recordLog4.setStatus(AppRecordLogTypeEnum.GIT_PERSION_SUCCESS.getStatus());
                recordLog4.setEndTime(LocalDateTime.now());
                this.sysAppRecordLogMapper.updateById(recordLog4);
                status = AppRecordLogTypeEnum.GIT_PERSION_SUCCESS.getStatus();
                logInfo = AppRecordLogTypeEnum.CREATE_APP_SUCCESS.getName();
                failStartTime = recordLog4.getEndTime();
                SysAppRecordLog recordLog5 = new SysAppRecordLog();
                recordLog5.setRecordId(sysAppRecord.getId());
                recordLog5.setLogInfo(logInfo);
                recordLog5.setStartTime(recordLog4.getEndTime());
                recordLog5.setEndTime(LocalDateTime.now());
                recordLog5.setStatus("0");
                this.sysAppRecordLogMapper.insert(recordLog5);
                sysAppRecord.setStatus("2");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            catch (Exception e) {
                e.printStackTrace();
                SysAppRecordLog recordLogFail = new SysAppRecordLog();
                recordLogFail.setRecordId(sysAppRecord.getId());
                recordLogFail.setLogInfo(logInfo);
                recordLogFail.setErrInfo(e.getMessage());
                recordLogFail.setEndTime(LocalDateTime.now());
                if ("0".equals(status)) {
                    recordLogFail.setStartTime(failStartTime);
                    recordLogFail.setStatus(AppRecordLogTypeEnum.CREATE_APP_FAILED.getStatus());
                    this.sysAppRecordLogMapper.insert(recordLogFail);
                }
                if ("2".equals(status)) {
                    recordLogFail.setId(id);
                    recordLogFail.setStatus(AppRecordLogTypeEnum.CREATE_APP_FAILED.getStatus());
                    this.sysAppRecordLogMapper.updateById(recordLogFail);
                }
                sysApplication.setCreateFlag("1");
                this.sysApplicationMapper.updateById(sysApplication);
                sysAppRecord.setStatus("3");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            finally {
                this.deleteFile(new File(this.gitlabConfigProperty.getTempPath() + File.separator + time));
            }
        }).start();
        SysUserRole sysUserRole = new SysUserRole();
        sysUserRole.setUserId(projectLeaderUser.getId());
        sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
        sysUserRole.setAdminOption("1");
        if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
            this.sysUserRoleService.save((Object)sysUserRole);
        }
        return sysApplication.getId();
    }

    public Boolean updateAppStatus(Long appId, String appStatus) {
        SysApplication sysApplication = (SysApplication)this.getById(appId);
        if ("0".equals(appStatus) && "0".equals(sysApplication.getReleaseStatus())) {
            return false;
        }
        sysApplication.setAppStatus(appStatus);
        try {
            SysAppDeploy sysAppDeploy = this.sysDeployService.getDeployByDeployType(appId);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysApplication", sysApplication);
            String uri = "";
            uri = "3".equals(sysAppDeploy.getDeployType()) || "4".equals(sysAppDeploy.getDeployType()) || "5".equals(sysAppDeploy.getDeployType()) ? "http://" + sysAppDeploy.getThreeLevelDomainFront() : "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain();
            String url = uri + "/hussarApi/hussarBase/newapp/saveOrUpdateNewApplication";
            this.post(url, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.updateById((BaseEntity)sysApplication);
    }

    public ApiResponse<SysApplicationDto> getAppDetailAndDeploy(Long appId) {
        SysApplicationDto sysApplicationDto = new SysApplicationDto();
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        SecurityUser user = BaseSecurityUtil.getUser();
        Boolean superAdmin = user.isSuperAdmin();
        Boolean projectLeader = user.getRolesList().contains(AppConstants.PROJECT_LEADER_ID);
        Boolean applicationLeader = user.getRolesList().contains(AppConstants.APP_ADMIN_ID);
        SysApplication sysApplication = this.sysApplicationMapper.getAppDetailContainUserName(appId);
        sysAppDeploy = superAdmin != false || projectLeader != false || applicationLeader != false ? this.sysDeployService.getAppDeploy(appId, null, "1") : ("1".equals(sysApplication.getPersonalBrance()) ? this.sysDeployService.getAppDeploy(appId, user.getId(), "2") : this.sysDeployService.getAppDeploy(appId, null, "1"));
        sysApplicationDto.setSysAppDeploy(sysAppDeploy);
        sysApplication.setAppGitUrl(this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + sysApplication.getAppCode() + ".git");
        sysApplicationDto.setSysApplication(sysApplication);
        return ApiResponse.success((Object)sysApplicationDto);
    }

    public Boolean updateSecretKey(Long appId) {
        SysApplication sysApplication = new SysApplication();
        sysApplication.setId(appId);
        sysApplication.setSecretKey(IdUtil.randomUUID().replace("-", ""));
        return this.updateById((BaseEntity)sysApplication);
    }

    private List<SysAppGroupVo> combinedData(List<SysApplicationVo> appList, List<SysAppGroup> sysAppGroups) {
        Map resultCollect = JSON.parseArray((String)JSON.toJSONString(sysAppGroups), SysAppGroupVo.class).stream().collect(Collectors.toMap(SysAppGroup::getId, sysAppGroupVo -> sysAppGroupVo, (k1, k2) -> k1, LinkedHashMap::new));
        appList.stream().forEach(sysApplication -> {
            SysAppGroupVo sysAppGroupVo = (SysAppGroupVo)resultCollect.get(sysApplication.getAppGroupId());
            if (HussarUtils.isNotEmpty((Object)sysAppGroupVo)) {
                if (HussarUtils.isNotEmpty((Object)sysAppGroupVo.getSysApplicationList())) {
                    sysAppGroupVo.getSysApplicationList().add(sysApplication);
                }
                if (HussarUtils.isEmpty((Object)sysAppGroupVo.getSysApplicationList())) {
                    ArrayList<SysApplicationVo> sysApplicationList = new ArrayList<SysApplicationVo>();
                    sysApplicationList.add((SysApplicationVo)sysApplication);
                    sysAppGroupVo.setSysApplicationList(sysApplicationList);
                }
            }
        });
        ArrayList<SysAppGroupVo> res = new ArrayList<SysAppGroupVo>(resultCollect.values());
        Collections.sort(res, (o1, o2) -> o1.getCreateTime().compareTo(o2.getCreateTime()));
        return res;
    }

    public Boolean checkUser(String userAccount) {
        SysUsers user = this.sysUsersService.getUserByUserAccount(userAccount);
        return HussarUtils.isNotEmpty((Object)user);
    }

    @HussarTransactional
    public String syncDevloper(String ids, String appId) {
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aids====={}\uff0cappId===={}", (Object)ids, (Object)appId);
        SysAppDeploy sysAppDeploy = (SysAppDeploy)this.sysDeployService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEL_FLAG", (Object)"0")).eq((Object)"APP_ID", (Object)appId)).eq((Object)"DEPLOY_TYPE", (Object)"1"));
        String containerPath = sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain();
        if (containerPath == null || "".equals(containerPath)) {
            throw new BaseException("\u5e94\u7528\u5730\u5740\u9519\u8bef\uff0c\u540c\u6b65\u7528\u6237\u5230\u5e94\u7528\u5931\u8d25\uff01");
        }
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (int i = 0; i < idArray.length; ++i) {
            idList.add(Long.parseLong(idArray[i]));
        }
        List users = this.sysUsersService.listByIds(idList);
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1ausers====={}", (Object)users);
        ArrayList<Long> empIdList = new ArrayList<Long>();
        for (int i = 0; i < users.size(); ++i) {
            empIdList.add(((SysUsers)users.get(i)).getEmployeeId());
        }
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aempIdList=========={}", empIdList);
        List strus = this.sysStruService.listByIds(empIdList);
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1astrus=========={}", (Object)strus);
        String empIdsStr = empIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aempIdsStr=========={}", (Object)empIdsStr);
        List staffs = this.sysStaffService.getSysStaffListByEmpIds(empIdsStr);
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1astaffs=========={}", (Object)staffs);
        ArrayList<Long> orgIdList = new ArrayList<Long>();
        for (int i = 0; i < strus.size(); ++i) {
            orgIdList.add(((SysStru)strus.get(i)).getOrganId());
        }
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aorgIdList=========={}", orgIdList);
        List organs = this.sysOrganService.listByIds(orgIdList);
        List sysStruAssistOrgan = this.sysStruAssistOrganService.getStruAssistOrganByStruIds(empIdList);
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1asysStruAssistOrgan=========={}", (Object)sysStruAssistOrgan);
        ArrayList<String> organFcode = new ArrayList<String>();
        for (int i = 0; i < organs.size(); ++i) {
            List organFcodeList = Arrays.stream(((SysOrgan)organs.get(i)).getOrganFcode().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            organFcode.addAll(organFcodeList);
        }
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aorganFcode=========={}", organFcode);
        List<Object> organList = new ArrayList();
        List<Object> struList = new ArrayList();
        if (HussarUtils.isNotEmpty(organFcode)) {
            String organFcodeStr = String.join((CharSequence)",", organFcode);
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aorganFcodeStr=========={}", (Object)organFcodeStr);
            organList = this.sysApplicationMapper.getFOrganListByOrganFcode(organFcode);
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1aorganList=========={}", organList);
            List organIdList = organList.stream().map(o -> o.getId()).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty((Object)organIdList)) {
                struList = this.sysApplicationMapper.getStruByOrganIds(organIdList);
            }
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\uff1astruList=========={}", struList);
        }
        if (HussarUtils.isNotEmpty((Object)sysStruAssistOrgan)) {
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1a=================================");
            ArrayList<Long> assistStruIdList = new ArrayList<Long>();
            for (SysStruAssistOrgan item : sysStruAssistOrgan) {
                assistStruIdList.add(item.getAssistParentId());
            }
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistStruIdList============{}", assistStruIdList);
            List assistStruInfoList = this.sysStruService.listByIds(assistStruIdList);
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistStruInfoList============{}", (Object)assistStruInfoList);
            List assistOrgIdList = assistStruInfoList.stream().map(o -> o.getOrganId()).collect(Collectors.toList());
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistOrgIdList============{}", assistOrgIdList);
            List assistOrgInfoList = this.sysOrganService.listByIds(assistOrgIdList);
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistOrgInfoList============{}", (Object)assistOrgInfoList);
            ArrayList assistOrgFCode = new ArrayList();
            for (int i = 0; i < assistOrgInfoList.size(); ++i) {
                assistOrgFCode.addAll(Arrays.stream(((SysOrgan)assistOrgInfoList.get(i)).getOrganFcode().split("/")).filter(s -> !s.isEmpty()).collect(Collectors.toList()));
            }
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistOrgInfoList============{}", (Object)assistOrgInfoList);
            if (HussarUtils.isNotEmpty(assistOrgFCode)) {
                String assistOrgFCodeStr = String.join((CharSequence)",", assistOrgFCode);
                logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\u67e5\u8be2\uff1aassistOrgFCodeStr============{}", (Object)assistOrgFCodeStr);
                List<SysOrgan> assistOrgAParentInfoList = this.sysApplicationMapper.getFOrganListByOrganFcode(organFcode);
                List<Long> assistOrganIdList = assistOrgAParentInfoList.stream().map(o -> o.getId()).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty(assistOrganIdList)) {
                    List<SysStru> assistStruAParentInfoList = this.sysApplicationMapper.getStruByOrganIds(assistOrganIdList);
                    struList.addAll(assistStruAParentInfoList);
                }
                organList.addAll(assistOrgAParentInfoList);
            }
        }
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\uff1aorganList=========={}", organList);
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u63a8\u9001\u4eba\u5458\u5408\u5e76\u517c\u5c97\u4fe1\u606f\uff1astruList=========={}", struList);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("strus", struList);
        data.put("organs", organList);
        data.put("staffs", staffs);
        data.put("users", users);
        data.put("sysStruAssistOrgan", sysStruAssistOrgan);
        String url = containerPath + "/hussarApi/hussarBase/newapp/importData";
        this.post(url, data);
        return "success";
    }

    public ApiResponse importExcelApplication(MultipartFile file) {
        try {
            List list;
            JSONObject json = ExcelUtil.getJsonFromXlsWithNullValue((byte[])file.getBytes(), (int)1, null);
            String code = json.getString("code");
            Map data = (Map)json.get((Object)"data");
            String appGroup = (String)data.get("appGroup");
            String WEB = (String)data.get("WEB");
            String H5 = (String)data.get("H5");
            String procedure = (String)data.get("procedure");
            String APP = (String)data.get("APP");
            String isOnline = (String)data.get("isOnline");
            String onlineSourceName = (String)data.get("onlineSourceName");
            String terminalType = (String)data.get("terminalType");
            data.put("appGroupId", "");
            data.put("developResourceId", "");
            data.put("mobileType", "");
            if (HussarUtils.isNotEmpty((Object)appGroup) && HussarUtils.isNotEmpty((Object)(list = this.sysAppGroupService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GROUP_NAME", (Object)appGroup)).eq((Object)"DEL_FLAG", (Object)"0"))))) {
                data.put("appGroupId", ((SysAppGroup)list.get(0)).getId());
            }
            if (HussarUtils.isNotEmpty((Object)WEB)) {
                if ("\u662f".equals(WEB)) {
                    data.put("WEB", "1");
                } else {
                    data.put("WEB", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)H5)) {
                if ("\u662f".equals(H5)) {
                    data.put("H5", "2");
                    data.put("mobileType", "\u4f01\u4e1a\u5fae\u4fe1".equals(terminalType) ? "1" : null);
                } else {
                    data.put("H5", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)procedure)) {
                if ("\u662f".equals(procedure)) {
                    data.put("procedure", "3");
                } else {
                    data.put("procedure", null);
                }
            }
            if (HussarUtils.isNotEmpty((Object)APP)) {
                if ("\u662f".equals(APP)) {
                    data.put("APP", "4");
                } else {
                    data.put("uniApp", null);
                }
            }
            if ("\u662f".equals(isOnline)) {
                data.put("isOnline", "1");
                SysAppResource one = (SysAppResource)this.sysAppResourceService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppResource::getDevelopResourceName, (Object)onlineSourceName)).eq(SysAppResource::getDelFlag, (Object)"0"));
                data.put("developResourceId", null == one ? "" : one.getDevelopResourceId());
            } else if ("\u5426".equals(isOnline)) {
                data.put("isOnline", "0");
            }
            data.remove("terminalType");
            data.remove("onlineSourceName");
            data.remove("appGroup");
            data.remove("appGroup");
            if ("200".equals(code) && HussarUtils.isNotEmpty((Object)data)) {
                return ApiResponse.success((Object)data);
            }
            if (data.size() == 0) {
                return ApiResponse.fail((String)json.getString("\u8bf7\u5728\u6a21\u677f\u4e2d\u8fdb\u884c\u586b\u5199\u5e94\u7528\u90e8\u7f72\u4fe1\u606f"));
            }
            return ApiResponse.fail((String)json.getString("\u5bfc\u5165\u5931\u8d25"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ApiResponse.fail((String)"\u5bfc\u5165\u5931\u8d25\uff01");
        }
    }

    public void downloadTemplate(HttpServletResponse response, Map map) throws IOException {
        String filePath = (String)map.get("filePath");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        org.springframework.core.io.Resource resource = resolver.getResource("classpath:file\\application\\" + filePath);
        File file = File.createTempFile("tmp", filePath.substring(filePath.indexOf(".") + 1));
        FileUtils.copyInputStreamToFile((InputStream)resource.getInputStream(), (File)file);
        SysApplicationServiceImpl.download(file, response);
    }

    public static void download(File file, HttpServletResponse response) {
        try {
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[((InputStream)fis).available()];
            ((InputStream)fis).read(buffer);
            ((InputStream)fis).close();
            response.reset();
            response.addHeader("Content-Length", "" + file.length());
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/" + file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf(".") + 1) + ";charset=utf-8");
            BufferedOutputStream toClient = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ((OutputStream)toClient).write(buffer);
            ((OutputStream)toClient).flush();
            ((OutputStream)toClient).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void post(String url, Map<String, Object> map) {
        try (HttpResponse res = null;){
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0post\u8bf7\u6c42\uff1aurl\uff1a----->{},map:----------->{}", (Object)url, map);
            res = ((HttpRequest)((HttpRequest)HttpRequest.post((String)url).timeout(90000).contentType("application/json", "UTF-8")).bodyText(IdempotentJsonUtils.toString(map), "application/json", "utf-8")).send();
            res.charset("utf-8");
            logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0post\u8fd4\u56de\u53c2\u6570\uff1ares.bodyText()\uff1a----->{}", (Object)res.bodyText());
            if (res.bodyText().equals("fail")) {
                this.log.error(res.bodyText());
                logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0post\u8bf7\u6c42\u5931\u8d25\uff1ares.bodyText()\uff1a----->{}", (Object)res.bodyText());
                throw new BaseException("\u64cd\u4f5c\u5931\u8d25");
            }
        }
    }

    private void deleteFile(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return;
        }
        for (File f : files = file.listFiles()) {
            if (f.isDirectory()) {
                this.deleteFile(f);
                continue;
            }
            f.delete();
        }
        file.delete();
    }

    public Boolean obtainChanges(GitServerDto gitServerDto) {
        List list;
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u5e94\u7528id{}\uff1a\u83b7\u53d6\u53d8\u66f4\u5f00\u59cb===========================", (Object)gitServerDto.getAppId());
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getUserId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader && ("dev".equals(gitServerDto.getBranch()) || null == gitServerDto.getBranch())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else if ("1".equals(sysApplication.getPersonalBrance())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            sysAppDeploy.setBranchName("dev");
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        String frontType = AppTypeUtil.getAppTypeLabel(sysApplication.getAppType());
        SysAppDevops sysAppDevops = new SysAppDevops();
        String branchName = "";
        String recordType = "";
        if ("1".equals(sysApplication.getPersonalBrance())) {
            if (superAdmin || projectLeader) {
                sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
                branchName = "dev";
                recordType = "\u83b7\u53d6\u53d8\u66f4";
            } else {
                sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).eq(SysAppDevops::getBranch, (Object)sysAppDeploy.getBranchName()));
                branchName = sysAppDeploy.getBranchName();
                recordType = "\u83b7\u53d6\u53d8\u66f4-" + gitServerDto.getBranch();
            }
        } else {
            sysAppDevops = (SysAppDevops)this.sysAppDevopsService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppDevops::getAppId, (Object)sysApplication.getId())).ne(SysAppDevops::getTestDefinitionId, (Object)"")).isNotNull(SysAppDevops::getTestDefinitionId));
            branchName = "dev";
            recordType = "\u83b7\u53d6\u53d8\u66f4";
        }
        SysAppRecord sysAppRecord = new SysAppRecord();
        sysAppRecord.setAppId(sysApplication.getId());
        sysAppRecord.setRecordType("2");
        sysAppRecord.setDefinitionId(sysAppDevops.getDevDefinitionId());
        sysAppRecord.setPipelineType(recordType);
        sysAppRecord.setStatus("1");
        this.sysAppRecordMapper.insert(sysAppRecord);
        if (HussarUtils.isBlank((CharSequence)accessToken)) {
            SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
            sysAppRecordLog.setRecordId(sysAppRecord.getId());
            sysAppRecordLog.setLogInfo("\u6821\u9a8c\u7528\u6237\u4ee4\u724c\u4fe1\u606f");
            sysAppRecordLog.setStartTime(LocalDateTime.now());
            sysAppRecordLog.setEndTime(LocalDateTime.now());
            sysAppRecordLog.setStatus("1");
            sysAppRecordLog.setType("1");
            this.sysAppRecordLogMapper.insert(sysAppRecordLog);
            sysAppRecord.setStatus("3");
            this.sysAppRecordMapper.updateById(sysAppRecord);
            return false;
        }
        SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
        sysAppRecordLog.setRecordId(sysAppRecord.getId());
        sysAppRecordLog.setLogInfo("\u6d41\u6c34\u7ebf\u6784\u5efa");
        sysAppRecordLog.setStartTime(LocalDateTime.now());
        sysAppRecordLog.setStatus("2");
        sysAppRecordLog.setType("1");
        this.sysAppRecordLogMapper.insert(sysAppRecordLog);
        SysAppDeploy finalSysAppDeploy = sysAppDeploy;
        SysAppDevops finalSysAppDevops = sysAppDevops;
        String finalFrontType = frontType;
        String finalBranchName = branchName;
        SysAppDeploy finalSysAppDeploy1 = sysAppDeploy;
        new Thread(() -> {
            try {
                Long time = System.currentTimeMillis();
                logger.info("\u83b7\u53d6\u53d8\u66f4\uff1a\u66f4\u65b0\u4ee3\u7801\u5230\u672c\u5730============================");
                this.gitlabService.pullToLocal(sysApplication.getAppCode(), this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), accessToken, finalBranchName);
                logger.info("\u83b7\u53d6\u53d8\u66f4\uff1a\u751f\u6210\u6a21\u677f\u6587\u4ef6============================");
                this.yamlService.createValuesForObtainChange(finalSysAppDeploy1, sysApplication.getAppCode(), time, "DEV");
                logger.info("\u83b7\u53d6\u53d8\u66f4\uff1a\u63d0\u4ea4\u4ee3\u7801============================");
                if (finalBranchName.equals("dev")) {
                    this.gitlabService.pushToDevForObtainChanges(finalBranchName, sysApplication.getPersonalBrance(), sysApplication.getAppCode(), "\u83b7\u53d6\u53d8\u66f4\u4fee\u6539values\u6587\u4ef6\u503c", accessToken, time);
                } else {
                    this.gitlabService.pushToGit(this.gitlabConfigProperty.getTempPath() + File.separator + time + File.separator + sysApplication.getAppCode(), sysApplication.getAppCode(), "\u83b7\u53d6\u53d8\u66f4\u4fee\u6539values\u6587\u4ef6\u503c", finalBranchName, accessToken);
                }
                this.sysAppDevopsService.executePipeline(finalSysAppDevops.getDevDefinitionId(), "v" + finalSysAppDevops.getVersion(), finalFrontType, "n", "DEV", finalBranchName, finalSysAppDeploy, sysAppRecord, sysAppRecordLog);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        return true;
    }

    public Boolean commitChanges(GitServerDto gitServerDto) {
        List list;
        logger.info("\u5e94\u7528\u7ba1\u7406\u5e73\u53f0\u5e94\u7528id{}\uff1a\u63d0\u4ea4\u53d8\u66f4\u5f00\u59cb===========================", (Object)gitServerDto.getAppId());
        SysApplication sysApplication = (SysApplication)this.getById(gitServerDto.getAppId());
        SecurityUser user = BaseSecurityUtil.getUser();
        boolean superAdmin = user.isSuperAdmin();
        boolean projectLeader = user.getId().equals(sysApplication.getProjectLeader());
        SysAppDeploy sysAppDeploy = new SysAppDeploy();
        if (superAdmin || projectLeader && ("dev".equals(gitServerDto.getBranch()) || null == gitServerDto.getBranch())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
                sysAppDeploy.setBranchName("dev");
            }
        } else if ("1".equals(sysApplication.getPersonalBrance())) {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"2")).eq((Object)"USER_ID", (Object)user.getUserId())).eq((Object)"DEL_FLAG", (Object)"0"));
            if (HussarUtils.isNotEmpty((Object)list)) {
                sysAppDeploy = (SysAppDeploy)list.get(0);
            }
        } else {
            list = this.sysDeployService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"APP_ID", (Object)gitServerDto.getAppId())).eq((Object)"DEPLOY_TYPE", (Object)"1")).eq((Object)"DEL_FLAG", (Object)"0"));
            sysAppDeploy = (SysAppDeploy)list.get(0);
            sysAppDeploy.setBranchName("dev");
        }
        if (sysAppDeploy.getAppIp() == null || sysAppDeploy.getAppFrontPort() == null) {
            return false;
        }
        String accessToken = this.sysUsersService.getUser(user.getId()).getChar1();
        if (HussarUtils.isNotEmpty((Object)accessToken)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sysAppDeploy", sysAppDeploy);
            data.put("sysApplication", sysApplication);
            data.put("accessToken", accessToken);
            data.put("type", "2");
            String uri = "";
            uri = "3".equals(sysAppDeploy.getDeployType()) || "4".equals(sysAppDeploy.getDeployType()) || "5".equals(sysAppDeploy.getDeployType()) ? "http://" + sysAppDeploy.getThreeLevelDomainFront() : "http://" + sysAppDeploy.getThreeLevelDomainFront() + "." + sysAppDeploy.getTwoLevelDomain();
            String url = uri + "/hussarApi/hussarBase/newapp/abutmentGitlab";
            this.post(url, data);
        }
        return true;
    }

    public Boolean restoreDelApplication(Long appId) {
        return this.sysApplicationMapper.restoreDelApplication(appId);
    }

    public Boolean completelyDelApplication(Long appId) {
        return this.sysApplicationMapper.completelyDelApplication(appId);
    }

    public Page<SysApplicationGroup> pageList(Page page, SysApplication sysApplication) {
        sysApplication.setAppName(SqlQueryUtil.transferSpecialChar((String)sysApplication.getAppName()));
        sysApplication.setEscapeSymbol(SqlQueryUtil.ESCAPE_SYMBOL);
        return ((SysApplicationMapper)this.getBaseMapper()).pageList((Page<SysApplicationGroup>)page, sysApplication);
    }

    public Map queryAppAllInfo(Long appId) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        List<SysAppInfoVo> appStatusNameList = this.getAppStatusName(Arrays.asList(appId), "2");
        res.put("apppStatus", null == appStatusNameList ? null : appStatusNameList.get(0).getAppStageStatus());
        Map baseInfo = this.sysApplicationMapper.queryAppBaseInfo(appId);
        baseInfo.put("appGitUrl", this.gitlabConfigProperty.getGitUri() + this.gitlabConfigProperty.getGitGroup() + baseInfo.get("appCode") + ".git");
        String appType = (String)baseInfo.get("appType");
        List<Map<String, Object>> publishInfo = this.sysApplicationMapper.queryDatabaseInfo(appId);
        if (HussarUtils.isNotEmpty(publishInfo)) {
            for (Map<String, Object> item : publishInfo) {
                if ("1".equals((String)item.get("deployType")) || "2".equals((String)item.get("deployType"))) {
                    item.put("namespace", (String)item.get("devNamespace"));
                    item.put("webDomain", item.get("threeLevelDomainFront") + "." + item.get("AppResourceTwoLevelDomain"));
                    if (appType.contains("2")) {
                        item.put("H5Domain", item.get("threeLevelDomainMobile") + "." + item.get("AppResourceTwoLevelDomain"));
                    } else {
                        item.put("H5Domain", "");
                    }
                    if (appType.contains("4")) {
                        item.put("appDomain", item.get("threeLevelDomainUniapp") + "." + item.get("AppResourceTwoLevelDomain"));
                    } else {
                        item.put("appDomain", "");
                    }
                    if ("1".equals(item.get("deployType"))) {
                        item.put("envType", "\u5f00\u53d1\u73af\u5883");
                    }
                    if ("1".equals((String)item.get("personalBrance")) && "2".equals((String)item.get("deployType"))) {
                        item.put("envType", "\u5f00\u53d1\u73af\u5883-" + item.get("branchName"));
                    }
                } else {
                    item.put("webDomain", item.get("threeLevelDomainFront"));
                    if (appType.contains("2")) {
                        item.put("H5Domain", item.get("threeLevelDomainMobile"));
                    } else {
                        item.put("H5Domain", "");
                    }
                    if (appType.contains("4")) {
                        item.put("appDomain", item.get("threeLevelDomainUniapp"));
                    } else {
                        item.put("appDomain", "");
                    }
                    if ("3".equals((String)item.get("deployType"))) {
                        item.put("envType", "\u6d4b\u8bd5\u73af\u5883");
                    }
                    if ("4".equals((String)item.get("deployType"))) {
                        item.put("envType", "\u6b63\u5f0f\u73af\u5883");
                    }
                    if ("5".equals((String)item.get("deployType"))) {
                        item.put("envType", "\u9884\u53d1\u5e03\u73af\u5883");
                    }
                }
                item.put("databasetType", this.databaseType((String)item.get("databasetType")));
            }
        }
        res.put("baseInfo", baseInfo);
        res.put("publishInfo", publishInfo);
        return res;
    }

    private List<SysAppInfoVo> getAppStatusName(List<Long> idList, String type) {
        List<SysAppInfoVo> res = this.sysApplicationMapper.getAppDeployInfo(idList);
        if (HussarUtils.isNotEmpty(res)) {
            this.getAppStatus(res, type);
            return res;
        }
        return null;
    }

    private String databaseType(String databasetType) {
        String name = "";
        if (HussarUtils.isNotEmpty((Object)databasetType)) {
            switch (databasetType) {
                case "1": {
                    name = "oracle";
                    break;
                }
                case "8": {
                    name = "mysql";
                    break;
                }
                case "9": {
                    name = "mysql8";
                    break;
                }
                case "3": {
                    name = "dameng";
                    break;
                }
                default: {
                    name = "db2";
                }
            }
        }
        return name;
    }

    public List<Map<String, Object>> queryAppAnalysis() {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        int dev = 0;
        int test = 0;
        int prod = 0;
        int release = 0;
        SysAppInfoVo sysAppInfoVo = new SysAppInfoVo();
        sysAppInfoVo.setSuperAdmin(Boolean.valueOf(BaseSecurityUtil.getUser().isSuperAdmin()));
        sysAppInfoVo.setUserId(BaseSecurityUtil.getUser().getId());
        List<SysAppInfoVo> sysAppInfoVos = this.sysApplicationMapper.queryAppCount(sysAppInfoVo);
        for (SysAppInfoVo item : sysAppInfoVos) {
            if (null != item.getProdDeployType() && "1".equals(item.getProdIspublish())) {
                ++prod;
            } else if (null != item.getTestDeployType() && "1".equals(item.getTestIspublish())) {
                ++test;
            } else {
                ++dev;
            }
            if (!"1".equals(item.getResourceStatus())) continue;
            ++release;
        }
        HashMap<String, Object> totalMap = new HashMap<String, Object>();
        totalMap.put("name", "\u603b\u5e94\u7528");
        totalMap.put("value", HussarUtils.isNotEmpty(sysAppInfoVos) ? sysAppInfoVos.size() : 0);
        res.add(totalMap);
        HashMap<String, Object> devMap = new HashMap<String, Object>();
        devMap.put("name", "\u5f00\u53d1\u4e2d\u5e94\u7528");
        devMap.put("value", dev);
        res.add(devMap);
        HashMap<String, Object> testMap = new HashMap<String, Object>();
        testMap.put("name", "\u5df2\u6d4b\u8bd5\u5e94\u7528");
        testMap.put("value", test);
        res.add(testMap);
        HashMap<String, Object> prodMap = new HashMap<String, Object>();
        prodMap.put("name", "\u5df2\u4e0a\u7ebf\u5e94\u7528");
        prodMap.put("value", prod);
        res.add(prodMap);
        HashMap<String, Object> releaseMap = new HashMap<String, Object>();
        releaseMap.put("name", "\u5df2\u56de\u6536\u8d44\u6e90\u5e94\u7528");
        releaseMap.put("value", release);
        res.add(releaseMap);
        return res;
    }

    public List<Map<String, Object>> queryAppAnalysisByOrgan() {
        ArrayList<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
        SysAppInfoVo sysAppInfoVo = new SysAppInfoVo();
        sysAppInfoVo.setSuperAdmin(Boolean.valueOf(BaseSecurityUtil.getUser().isSuperAdmin()));
        sysAppInfoVo.setUserId(BaseSecurityUtil.getUser().getId());
        List<SysAppInfoVo> sysAppInfoVos = this.sysApplicationMapper.queryAppCount(sysAppInfoVo);
        int total = 0;
        int dev = 0;
        int test = 0;
        int prod = 0;
        int release = 0;
        HashMap<String, Object> oneData = new HashMap<String, Object>();
        for (int i = 0; i < sysAppInfoVos.size(); ++i) {
            SysAppInfoVo item = sysAppInfoVos.get(i);
            if (i != 0 && null != sysAppInfoVos.get(i - 1).getApplyDeptId() && !sysAppInfoVos.get(i - 1).getApplyDeptId().equals(item.getApplyDeptId())) {
                oneData.put("name", null == sysAppInfoVos.get(i - 1).getApplyDeptName() ? "--" : sysAppInfoVos.get(i - 1).getApplyDeptName());
                oneData.put("value", Arrays.asList(total, dev, test, prod, release));
                res.add(oneData);
                oneData = new HashMap();
                total = 0;
                dev = 0;
                test = 0;
                prod = 0;
                release = 0;
            }
            if (null != item.getProdDeployType() && "1".equals(item.getProdIspublish())) {
                ++prod;
            } else if (null != item.getTestDeployType() && "1".equals(item.getTestIspublish())) {
                ++test;
            } else {
                ++dev;
            }
            if ("1".equals(item.getResourceStatus())) {
                ++release;
            }
            ++total;
            if (i != sysAppInfoVos.size() - 1 || null == item.getApplyDeptId()) continue;
            oneData.put("name", null == item.getApplyDeptName() ? "--" : item.getApplyDeptName());
            oneData.put("value", Arrays.asList(total, dev, test, prod, release));
            res.add(oneData);
        }
        return res;
    }

    public Long reCreate(SysApplicationDto sysApplicationDto) {
        SysApplication sysApplication = sysApplicationDto.getSysApplication();
        SysApplication databaseAppInfo = (SysApplication)this.sysApplicationMapper.selectById(sysApplication.getId());
        Long appId = sysApplication.getId();
        LocalDateTime log1StartTime = LocalDateTime.now();
        Long currentTime = System.currentTimeMillis();
        SysUsers user = this.sysUsersService.getUser(BaseSecurityUtil.getUser().getId());
        SysAppRecord sysAppRecord = this.sysAppRecordService.saveRecord("9", "\u91cd\u65b0\u521b\u5efa", "1", appId);
        new Thread(() -> {
            SysAppRecordLog failRecordLog = new SysAppRecordLog();
            try {
                SysAppRecordLog gitPersonAppLeaderLog;
                SysAppRecordLog creatGitAppUploadLog;
                SysAppRecordLog downUzipTemplateLog;
                SysAppRecordLog deleteAppLog;
                SysAppRecordLog updateAppInfoLog;
                SysAppRecordLog sysAppRecordLog = new SysAppRecordLog();
                if (HussarUtils.isEmpty((Object)user.getChar1())) {
                    sysAppRecordLog.setRecordId(sysAppRecord.getId());
                    sysAppRecordLog.setLogInfo("\u6821\u9a8c\u7528\u6237gitlab\u6743\u9650");
                    sysAppRecordLog.setStartTime(log1StartTime);
                    sysAppRecordLog.setEndTime(LocalDateTime.now());
                    sysAppRecordLog.setStatus("1");
                    sysAppRecordLog.setType("1");
                    this.sysAppRecordLogService.save((Object)sysAppRecordLog);
                    this.sysAppRecordService.updateRecord(sysAppRecord, "3");
                    return;
                }
                failRecordLog = updateAppInfoLog = this.sysAppRecordLogService.saveRecordLog("\u66f4\u65b0\u5e94\u7528\u4fe1\u606f", sysAppRecord.getId(), "2", "1", null);
                SysUsers projectLeaderUser = this.sysUsersService.getUser(sysApplication.getProjectLeader());
                SysUserRole sysUserRole = new SysUserRole();
                sysUserRole.setUserId(projectLeaderUser.getId());
                sysUserRole.setGrantedRole(AppConstants.PROJECT_LEADER_ID);
                sysUserRole.setAdminOption("1");
                if (this.sysUserRoleService.getUserRole(sysUserRole.getUserId(), sysUserRole.getGrantedRole()) < 1) {
                    this.sysUserRoleService.save((Object)sysUserRole);
                }
                sysApplication.setCreateFlag("0");
                this.sysApplicationMapper.updateById(sysApplication);
                this.sysAppRecordLogService.updateRecordLog(updateAppInfoLog, "0");
                failRecordLog = deleteAppLog = this.sysAppRecordLogService.saveRecordLog("\u5220\u9664gitlab\u4ee3\u7801\u4ed3\u5e93\u539f\u9879\u76ee", sysAppRecord.getId(), "2", "1", null);
                this.gitlabService.deleteGitProject(sysApplication.getAppCode(), user.getChar1());
                this.sysAppRecordLogService.updateRecordLog(deleteAppLog, "0");
                failRecordLog = downUzipTemplateLog = this.sysAppRecordLogService.saveRecordLog("\u4e0b\u8f7d\u5e76\u89e3\u538b\u6e90\u7801", sysAppRecord.getId(), "2", "1", null);
                this.gitlabService.createDir(sysApplication.getAppCode(), currentTime);
                SysAppTemplate sysAppTemplate = (SysAppTemplate)this.sysAppTemplateService.getById((Serializable)databaseAppInfo.getTemplateId());
                String filePath = this.gitlabConfigProperty.getTemplatePath() + File.separator + sysAppTemplate.getTemplateName() + ".zip";
                String tempPath = this.gitlabConfigProperty.getTempPath() + File.separator + currentTime + File.separator + sysApplication.getAppCode();
                ZipFile.unzip((String)filePath, (String)tempPath, (Charset)Charset.forName("GBK"));
                Boolean h5Flag = false;
                if (!new File(tempPath + File.separator + "hussar-mobile").exists() && sysApplication.getAppType().contains("2")) {
                    SysAppRecordLog noH5Log = new SysAppRecordLog();
                    noH5Log.setRecordId(sysAppRecord.getId());
                    noH5Log.setLogInfo("\u6a21\u677f\u4e2d\u4e0d\u5305\u542b\u5e94\u7528\u7c7b\u578b\u4e3aH5\u7684\u6e90\u7801\u6587\u4ef6");
                    noH5Log.setStartTime(LocalDateTime.now());
                    noH5Log.setEndTime(LocalDateTime.now());
                    noH5Log.setStatus("0");
                    this.sysAppRecordLogService.save((Object)noH5Log);
                    h5Flag = true;
                }
                if (!sysApplication.getAppType().contains("2") && new File(tempPath + File.separator + "hussar-mobile").exists()) {
                    this.deleteFile(new File(tempPath + File.separator + "hussar-mobile"));
                }
                Boolean uniappFlag = false;
                if (!new File(tempPath + File.separator + "hussar-mobile-uni").exists() && (sysApplication.getAppType().contains("3") || sysApplication.getAppType().contains("4"))) {
                    SysAppRecordLog noUniappLog = new SysAppRecordLog();
                    noUniappLog.setRecordId(sysAppRecord.getId());
                    noUniappLog.setLogInfo("\u6a21\u677f\u4e2d\u4e0d\u5305\u542b\u5e94\u7528\u7c7b\u578b\u5c0f\u7a0b\u5e8f\u6216UNIAPP\u7684\u6e90\u7801\u6587\u4ef6");
                    noUniappLog.setStartTime(LocalDateTime.now());
                    noUniappLog.setEndTime(LocalDateTime.now());
                    noUniappLog.setStatus("0");
                    this.sysAppRecordLogService.save((Object)noUniappLog);
                    uniappFlag = true;
                }
                if (new File(tempPath + File.separator + "hussar-mobile-uni").exists() && !sysApplication.getAppType().contains("3") && !sysApplication.getAppType().contains("4")) {
                    this.deleteFile(new File(tempPath + File.separator + "hussar-mobile-uni"));
                }
                if (h5Flag.booleanValue() || uniappFlag.booleanValue()) {
                    LocalDateTime startTime = LocalDateTime.now();
                    String appType = sysApplication.getAppType();
                    String[] split = appType.split(",");
                    ArrayList<String> appTypeList = new ArrayList<String>(Arrays.asList(split));
                    if (h5Flag.booleanValue()) {
                        appTypeList.remove("2");
                    }
                    if (uniappFlag.booleanValue()) {
                        appTypeList.remove("3");
                        appTypeList.remove("4");
                    }
                    String newAppType = String.join((CharSequence)",", appTypeList);
                    sysApplication.setAppType(newAppType);
                    this.sysApplicationMapper.updateById(sysApplication);
                    SysAppRecordLog editAppLog = new SysAppRecordLog();
                    editAppLog.setRecordId(sysAppRecord.getId());
                    editAppLog.setLogInfo("\u4fee\u6539\u5e94\u7528\u7c7b\u578b");
                    editAppLog.setStartTime(startTime);
                    editAppLog.setEndTime(LocalDateTime.now());
                    editAppLog.setStatus("0");
                    this.sysAppRecordLogService.save((Object)editAppLog);
                }
                this.sysAppRecordLogService.updateRecordLog(downUzipTemplateLog, "0");
                failRecordLog = creatGitAppUploadLog = this.sysAppRecordLogService.saveRecordLog("\u521b\u5efagit\u9879\u76ee\u5e76\u4e0a\u4f20\u6e90\u7801", sysAppRecord.getId(), "2", "1", null);
                String accessToken = user.getChar1();
                this.gitlabService.createProject(sysApplication.getAppCode(), sysApplication.getAppDescribe(), "\u521b\u5efa\u5e94\u7528", accessToken, currentTime);
                this.sysAppRecordLogService.updateRecordLog(creatGitAppUploadLog, "0");
                failRecordLog = gitPersonAppLeaderLog = this.sysAppRecordLogService.saveRecordLog("git\u9879\u76ee\u6388\u6743\u5e94\u7528\u8d1f\u8d23\u4eba", sysAppRecord.getId(), "2", "1", null);
                this.gitlabService.inviteUserJoinGroupOrProject(projectLeaderUser.getUserAccount(), user.getChar1(), "projects", sysApplication.getAppCode(), true);
                this.sysAppRecordLogService.updateRecordLog(gitPersonAppLeaderLog, "0");
                SysAppRecordLog reCreateAppSuccessLog = new SysAppRecordLog();
                reCreateAppSuccessLog.setRecordId(sysAppRecord.getId());
                reCreateAppSuccessLog.setLogInfo("\u5e94\u7528\u91cd\u521b\u5efa\u6210\u529f");
                reCreateAppSuccessLog.setStartTime(gitPersonAppLeaderLog.getEndTime());
                reCreateAppSuccessLog.setEndTime(LocalDateTime.now());
                reCreateAppSuccessLog.setStatus("0");
                this.sysAppRecordLogMapper.insert(reCreateAppSuccessLog);
                sysAppRecord.setStatus("2");
                this.sysAppRecordMapper.updateById(sysAppRecord);
            }
            catch (Exception e) {
                sysApplication.setCreateFlag("1");
                this.sysApplicationMapper.updateById(sysApplication);
                this.sysAppRecordLogService.updateRecordLog(failRecordLog, "1");
                this.sysAppRecordService.updateRecord(sysAppRecord, "3");
                e.printStackTrace();
                logger.info("\u91cd\u521b\u5efa\u5e94\u7528\uff1a{}", (Object)e.getMessage());
            }
        }).start();
        return sysApplication.getId();
    }

    public Boolean isAppWebSocketFlag() {
        Map<String, Object> appWebSocketFlag = this.sysApplicationMapper.isAppWebSocketFlag();
        return HussarUtils.isNotEmpty(appWebSocketFlag) ? "0".equals(appWebSocketFlag.get("CONFIG_VALUE").toString()) : false;
    }
}

