/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.base.portal.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.base.portal.application.dao.SysAppIpRecordMapper;
import com.jxdinfo.hussar.base.portal.application.model.SysAppIpRecord;
import com.jxdinfo.hussar.base.portal.application.service.ISysAppIpRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.base.portal.application.service.impl.SysAppIpRecordImpl")
public class SysAppIpRecordImpl
extends HussarServiceImpl<SysAppIpRecordMapper, SysAppIpRecord>
implements ISysAppIpRecordService {
    @Autowired
    private SysAppIpRecordMapper sysAppIpRecordMapper;

    public String saveOrUpdateIpRecord(SysAppIpRecord sysAppIpRecord) {
        if (this.isInIpRecord(sysAppIpRecord).booleanValue()) {
            return "exist";
        }
        if (HussarUtils.isNotEmpty((Object)sysAppIpRecord.getId())) {
            this.sysAppIpRecordMapper.updateById(sysAppIpRecord);
        } else {
            sysAppIpRecord.setDelFlag("0");
            this.sysAppIpRecordMapper.insert(sysAppIpRecord);
        }
        return "success";
    }

    private Boolean isInIpRecord(SysAppIpRecord sysAppIpRecord) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)sysAppIpRecord.getId())) {
            queryWrapper.ne(SysAppIpRecord::getId, (Object)sysAppIpRecord.getId());
        }
        List sysAppIpRecords = this.sysAppIpRecordMapper.selectList((Wrapper)queryWrapper.eq(SysAppIpRecord::getDelFlag, (Object)"0"));
        Boolean falg = false;
        if (HussarUtils.isNotEmpty((Object)sysAppIpRecords)) {
            long checkStartOutIp = this.ipToLong(sysAppIpRecord.getStartOutIp());
            long checkEndOutIp = this.ipToLong(sysAppIpRecord.getEndOutIp());
            for (SysAppIpRecord item : sysAppIpRecords) {
                long startIp = this.ipToLong(item.getStartOutIp());
                long endIp = this.ipToLong(item.getEndOutIp());
                if (checkStartOutIp < startIp || checkStartOutIp > endIp || checkEndOutIp < startIp || checkEndOutIp > endIp) continue;
                falg = true;
                break;
            }
        }
        return falg;
    }

    public long ipToLong(String ip) {
        String[] split = ip.split("\\.");
        long resut = 0L;
        for (int i = 0; i < split.length; ++i) {
            resut += Long.parseLong(split[i]) << 24 - 8 * i;
        }
        return resut;
    }
}

