/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.springframework.util.DigestUtils;
import org.springframework.util.ResourceUtils;

public class ZipUtil {
    private static int BUFFERSIZE = 1024;

    public static void zip(String sourceFileName, String zipFileName) throws Exception {
        System.out.println("\u5f00\u59cb\u538b\u7f29...");
        ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(Paths.get(zipFileName, new String[0]), new OpenOption[0]));
        File sourceFile = new File(sourceFileName);
        ZipUtil.compress(out, sourceFile, "");
        out.close();
        System.out.println("\u538b\u7f29\u5b8c\u6210\uff01");
    }

    public static void compress(ZipOutputStream out, File sourceFile, String base) throws Exception {
        if (sourceFile.isDirectory()) {
            File[] flist = sourceFile.listFiles();
            if (flist != null) {
                if (flist.length == 0) {
                    System.out.println(base + "/");
                    out.putNextEntry(new ZipEntry(base + "/"));
                } else {
                    for (File file : flist) {
                        ZipUtil.compress(out, file, base + "/" + file.getName());
                    }
                }
            }
        } else {
            out.putNextEntry(new ZipEntry(base));
            FileInputStream fos = new FileInputStream(sourceFile);
            try (BufferedInputStream bis = new BufferedInputStream(fos);){
                int len;
                byte[] buf = new byte[1024];
                System.out.println(base);
                while ((len = bis.read(buf, 0, 1024)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            fos.close();
        }
    }

    public static String getMd5(String path) {
        String md5 = null;
        try (FileInputStream inputStream = new FileInputStream(ResourceUtils.getFile((String)path));){
            md5 = DigestUtils.md5DigestAsHex((InputStream)inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5;
    }

    public static List<String> unzip(String fileName, String path) {
        ArrayList<String> filePaths = new ArrayList<String>();
        try (ZipFile zf = new ZipFile(new File(fileName));){
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry zn = en.nextElement();
                if (zn.isDirectory()) continue;
                Path targetPath = Paths.get(path, zn.getName()).normalize();
                File file = targetPath.toFile();
                file.getParentFile().mkdirs();
                InputStream is = zf.getInputStream(zn);
                Throwable throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file);
                    Throwable throwable2 = null;
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) != -1) {
                            fos.write(buffer, 0, len);
                        }
                        filePaths.add(targetPath.toString());
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePaths;
    }
}

