/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.applicationmix.dao.SysAppDataSourceMapper;
import com.jxdinfo.hussar.applicationmix.model.SysAppDataSource;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceBoService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppDataSourceService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.datasource.dto.SysDataSourceDto;
import com.jxdinfo.hussar.datasource.manager.api.service.DatasourceService;
import com.jxdinfo.hussar.datasource.model.SysDataSource;
import com.jxdinfo.hussar.platform.core.tenant.properties.HussarTenantProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarTenantCommonService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class SysAppDataSourceBoServiceImpl
implements ISysAppDataSourceBoService {
    @Autowired
    private ISysAppDataSourceService appDataSourceService;
    @Resource
    private HussarTenantProperties hussarTenantProperties;
    @Autowired(required=false)
    private IHussarTenantCommonService tenantCommonService;
    @Autowired
    private DatasourceService datasourceService;
    @Resource
    private SysAppDataSourceMapper sysAppDataSourceMapper;

    public List<SysDataSource> getDatasourceByAppId(Long id) {
        ServletRequestAttributes servletRequestAttributes;
        String tenantCode;
        ArrayList result = Lists.newArrayList();
        boolean tenantOpen = this.hussarTenantProperties.isEnabled() && this.tenantCommonService != null;
        String connName = "master";
        if (tenantOpen && HussarUtils.isNotEmpty((Object)(tenantCode = (servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest().getHeader("tcode")))) {
            HussarTenantDefinition tenantDefinition = this.tenantCommonService.search(tenantCode);
            connName = tenantDefinition.getConnName();
        }
        SysDataSourceDto mainDataSource = this.datasourceService.getDataSourceByConnName(connName);
        result.add(mainDataSource);
        List appDataSources = this.appDataSourceService.list(connName, (Wrapper)new LambdaQueryWrapper().eq(SysAppDataSource::getAppId, (Object)id));
        if (HussarUtils.isNotEmpty((Object)appDataSources)) {
            List dbId = appDataSources.stream().map(SysAppDataSource::getDbId).collect(Collectors.toList());
            result.addAll(this.datasourceService.listByIds(dbId));
        }
        return result;
    }

    public List<SysDataSource> list() {
        LambdaQueryWrapper exWrapper;
        List exList;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (this.hussarTenantProperties.isEnabled()) {
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            if (HussarUtils.isNotBlank((CharSequence)tenantCode) && !tenantCode.equals("master")) {
                queryWrapper.eq(SysDataSource::getTenantCode, (Object)tenantCode);
            } else {
                queryWrapper.eq(SysDataSource::getTenantCode, (Object)"0");
            }
            return this.datasourceService.list((Wrapper)queryWrapper);
        }
        ArrayList<SysDataSource> result = new ArrayList<SysDataSource>();
        SysDataSource master = (SysDataSource)this.datasourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getConnName, (Object)"master"), false);
        if (HussarUtils.isNotEmpty((Object)master)) {
            result.add(master);
        }
        if (HussarUtils.isNotEmpty((Object)(exList = this.datasourceService.list((Wrapper)(exWrapper = (LambdaQueryWrapper)queryWrapper.eq(SysDataSource::getDatasourceType, (Object)"2")))))) {
            result.addAll(exList);
        }
        return result;
    }
}

