/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.jxdinfo.hussar.applicationmix.dto.CodeGenerator;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarBasePluginProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarProduceProperties;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.expansion.core.service.SharePluginService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.SharePluginInfoDto;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dto.PublishExtensionProcessDto;
import com.jxdinfo.hussar.workflow.godaxe.model.GodAxeModelService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public abstract class CommonMixAppService {
    private static final Logger logger = LoggerFactory.getLogger(CommonMixAppService.class);
    @Resource
    protected HussarAppExportProperties hussarAppExportProperties;
    @Resource
    protected HussarBasePluginProperties hussarBasePluginProperties;
    @Resource
    protected HussarProduceProperties hussarProduceProperties;
    @Resource
    protected GodAxeModelService godAxeModelService;
    @Autowired(required=false)
    protected ISysTenantService sysTenantService;
    @Resource
    protected SharePluginService sharePluginService;
    @Value(value="${hussar-formdesign.open-plugin:false}")
    protected String openPlugin;
    private static final String MODULES = "packages" + File.separator + "hussar-remote-";
    private static final String expansion = "";

    protected void editPomXml(String pomUrl, String moduleName) {
        logger.info("pomUrl:{}", (Object)pomUrl);
        System.getProperty("java.classpath");
        try (FileReader fis = new FileReader(pomUrl);){
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((Reader)fis);
            List modules = model.getModules();
            if (!modules.contains(moduleName)) {
                modules.add(moduleName);
                model.setModules(modules);
            }
            try (FileWriter writer = new FileWriter(pomUrl);){
                MavenXpp3Writer mavenXpp3Writer = new MavenXpp3Writer();
                mavenXpp3Writer.write((Writer)writer, model);
            }
        }
        catch (Exception e) {
            logger.info("\u5f80\u6839\u76ee\u5f55\u7684pom\u6587\u4ef6\u4e2d\u52a0\u5165{}\u51fa\u9519:{}}", (Object)moduleName, (Object)e.getMessage());
        }
    }

    protected void executeScript(boolean isExpansion, String appName) {
        File frontProject;
        String os = System.getProperty("os.name").toLowerCase();
        boolean isWindows = os.contains("windows");
        String hussarFrontPath = this.hussarAppExportProperties.getWorkspace() + this.hussarAppExportProperties.getFrontProjectPath();
        if (!hussarFrontPath.endsWith(File.separator)) {
            hussarFrontPath = hussarFrontPath + File.separator;
        }
        if (!(frontProject = new File(hussarFrontPath = hussarFrontPath.replace("\\", "/"))).exists()) {
            return;
        }
        appName = AppContextUtil.asIdentifier((String)appName);
        String tcode = AppContextUtil.asIdentifier((String)HussarContextHolder.getHussarTenant().getTenantCode());
        String frontModulePath = MODULES + tcode + "-" + appName;
        File frontModule = new File(hussarFrontPath + frontModulePath);
        if (frontModule.exists()) {
            return;
        }
        String[] command = isWindows ? (isExpansion ? new String[]{"cmd.exe", "/c", "node", "./config/module-federation/gen-mf-extension-template.mjs", appName, tcode} : new String[]{"cmd.exe", "/c", "node", "./config/module-federation/gen-mf-template.mjs", appName, tcode}) : (isExpansion ? new String[]{"sh", "-c", "node ./config/module-federation/gen-mf-extension-template.mjs " + appName + " " + tcode} : new String[]{"sh", "-c", "node ./config/module-federation/gen-mf-template.mjs " + appName + " " + tcode});
        try {
            ProcessBuilder pb = new ProcessBuilder(command).directory(new File(hussarFrontPath.replace("\\", "/"))).redirectErrorStream(true);
            Process process = pb.start();
            try (InputStream is = process.getInputStream();){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = is.read(buffer)) != -1) {
                    logger.info("[Node Output] {}", (Object)new String(buffer, 0, bytesRead, StandardCharsets.UTF_8));
                }
            }
            int exitCode = process.waitFor();
            logger.info("\u6267\u884c\u5b8c\u6210\uff0c\u9000\u51fa\u7801: {}", (Object)exitCode);
        }
        catch (IOException | InterruptedException e) {
            logger.error(e.getMessage());
        }
    }

    protected Boolean addChildExpansionModule(Long appId, String applicationName, boolean isImport) {
        String pluginPrefix = this.hussarBasePluginProperties.getPluginPrefix();
        String modulePath = this.hussarBasePluginProperties.getModulePath();
        String prefixName = this.hussarBasePluginProperties.getPrefixName();
        String appPrefixName = this.hussarBasePluginProperties.getAppPrefixName();
        this.executeScript(true, applicationName);
        if (pluginPrefix != null && modulePath != null) {
            String absolutePath = modulePath;
            int end = absolutePath.lastIndexOf(File.separator);
            if (end != absolutePath.length() - 1) {
                absolutePath = absolutePath + File.separator;
            }
            String prefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)prefixName) ? prefixName : "hussar-plugin");
            String appPrefixPath = absolutePath + (ToolUtil.isNotEmpty((Object)appPrefixName) ? appPrefixName : "hussar-web");
            File module = new File(prefixPath);
            SecurityUser securityUser = BaseSecurityUtil.getUser();
            PublishExtensionProcessDto processDto = new PublishExtensionProcessDto();
            processDto.setAppCode(applicationName);
            processDto.setAppId(String.valueOf(appId));
            if (ToolUtil.isEmpty((Object)securityUser)) {
                throw new BaseException("\u4e8c\u6b21\u8ba4\u8bc1\u5f02\u5e38\uff0c\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25");
            }
            if (module.exists()) {
                String userCode = securityUser.getTenantCode();
                String tenantCode = AppContextUtil.asIdentifier((String)userCode);
                String applicationCode = AppContextUtil.asIdentifier((String)applicationName);
                String account = securityUser.getAccount();
                String tenantPath = prefixPath + File.separator + pluginPrefix + tenantCode;
                String tenAndApp = AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)applicationName);
                String expansionPath = tenantPath + File.separator + pluginPrefix + tenAndApp + expansion;
                File application = new File(expansionPath);
                String standardApplicationName = applicationName.length() >= 10 ? applicationName.substring(0, applicationName.length() - 10) : applicationName;
                SharePluginInfoDto sharePluginInfoDto = this.sharePluginService.queryPluginInfo(userCode, standardApplicationName);
                if (HussarUtils.isEmpty((Object)sharePluginInfoDto)) {
                    throw new BaseException("\u8bf7\u5148\u5bfc\u5165\u6807\u51c6\u5e94\u7528");
                }
                String standardPluginId = sharePluginInfoDto.getSharePluginId();
                String standardAppVersion = sharePluginInfoDto.getAppVersion();
                if (HussarUtils.isEmpty((Object)standardPluginId) || HussarUtils.isEmpty((Object)standardAppVersion)) {
                    throw new BaseException("\u6807\u51c6\u5e94\u7528\u5b58\u50a8\u4fe1\u606f\u4e3a\u7a7a");
                }
                String expansionPluginId = AppContextUtil.asIdentifier((String)tenantCode) + "-" + standardPluginId + "-" + standardAppVersion + "_extension";
                if (!application.exists() && !isImport) {
                    this.godAxeModelService.saveExtendWorkflowWithAppCode(processDto);
                    application.mkdirs();
                    String relativeRPath = "src.main.resources";
                    String resourcePath = appPrefixPath + File.separator + relativeRPath.replace(".", File.separator);
                    String relativeMainPath = "src.main";
                    String mainExpansionPath = expansionPath + File.separator + relativeMainPath.replace(".", File.separator);
                    String templatePath = resourcePath + File.separator + "templates";
                    String tenantCodeLow = tenantCode.toLowerCase();
                    String applicationCodeLowExpansion = applicationCode.toLowerCase() + expansion;
                    String expansionRelativeConfigPath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLowExpansion + ".config";
                    String expansionConfigPath = mainExpansionPath + File.separator + expansionRelativeConfigPath.replace(".", File.separator);
                    File directory = new File(expansionConfigPath);
                    if (!directory.exists()) {
                        directory.mkdirs();
                    }
                    String expansionConfigBeanTName = "ExpansionColumnInfoConfig.ftl";
                    String expansionConfigBeanFName = "ExpansionColumnInfoConfig.java";
                    HashMap<String, String> expansionConfigParams = new HashMap<String, String>();
                    expansionConfigParams.put("tenantCode", tenantCodeLow);
                    expansionConfigParams.put("applicationCode", applicationCodeLowExpansion);
                    CodeGenerator expansionConfigBeanGen = new CodeGenerator(expansionConfigBeanTName, expansionConfigParams, templatePath, expansionConfigPath, expansionConfigBeanFName);
                    expansionConfigBeanGen.gen();
                    String dbConfigBeanTName = "pluginConfigrationGen.ftl";
                    String dbConfigBeanFName = "PluginConfigration.java";
                    HashMap<String, String> dbConfigParams = new HashMap<String, String>();
                    dbConfigParams.put("tenantCode", tenantCodeLow);
                    dbConfigParams.put("applicationCode", applicationCodeLowExpansion);
                    CodeGenerator dbConfigBeanGen = new CodeGenerator(dbConfigBeanTName, dbConfigParams, templatePath, expansionConfigPath, dbConfigBeanFName);
                    dbConfigBeanGen.gen();
                    String configBeanTName = "PluginMybatisPlusConfiguration.ftl";
                    String configBeanFName = "PluginMybatisPlusConfiguration.java";
                    String appPath = tenantCodeLow + "/" + applicationCodeLowExpansion;
                    HashMap<String, String> configParams = new HashMap<String, String>();
                    configParams.put("tenantCode", tenantCodeLow);
                    configParams.put("applicationCode", applicationCodeLowExpansion);
                    configParams.put("applicationPath", appPath);
                    CodeGenerator configBeanGen = new CodeGenerator(configBeanTName, configParams, templatePath, expansionConfigPath, configBeanFName);
                    configBeanGen.gen();
                    String expansionRelativeServicePath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLowExpansion + ".service";
                    String expansionServicePath = mainExpansionPath + File.separator + expansionRelativeServicePath.replace(".", File.separator);
                    String appExpansionName = applicationName;
                    String appExpansionFirst = appExpansionName.substring(0, 1);
                    Pattern p = Pattern.compile("[a-zA-z]");
                    if (p.matcher(appExpansionFirst).find()) {
                        appExpansionName = appExpansionFirst.toUpperCase() + applicationName.substring(1);
                    }
                    String tenantUp = tenantCode;
                    String tenantFist = tenantCode.substring(0, 1);
                    if (!"_".equals(tenantFist)) {
                        tenantUp = tenantFist.toUpperCase() + tenantCode.substring(1);
                    }
                    String tenantAndExpansion = tenantUp + appExpansionName;
                    String expansionServiceBeanTName = "ExpansionColumnService.ftl";
                    String expansionServiceBeanFName = tenantAndExpansion + "ExpansionColumnService.java";
                    HashMap<String, String> expansionServiceParams = new HashMap<String, String>();
                    expansionServiceParams.put("id", tenAndApp + expansion);
                    expansionServiceParams.put("tenantCode", tenantCodeLow);
                    expansionServiceParams.put("applicationCode", applicationCodeLowExpansion);
                    expansionServiceParams.put("tenantAndExpansion", tenantAndExpansion);
                    CodeGenerator expansionServiceBeanGen = new CodeGenerator(expansionServiceBeanTName, expansionServiceParams, templatePath, expansionServicePath, expansionServiceBeanFName);
                    expansionServiceBeanGen.gen();
                    String pluginExpansionRelativePath = "java.com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLowExpansion;
                    String pluginExpansionPath = mainExpansionPath + File.separator + pluginExpansionRelativePath.replace(".", File.separator);
                    String pluginExpansionBeanTName = "PluginExpansion.ftl";
                    String pluginExpansionBeanFName = tenantAndExpansion + "PluginExpansion.java";
                    HashMap<String, String> pluginExpansionParams = new HashMap<String, String>();
                    pluginExpansionParams.put("tenantCode", tenantCodeLow);
                    pluginExpansionParams.put("applicationCode", applicationCodeLowExpansion);
                    pluginExpansionParams.put("tenantAndExpansion", tenantAndExpansion);
                    CodeGenerator plugonExpansionBeanGen = new CodeGenerator(pluginExpansionBeanTName, pluginExpansionParams, templatePath, pluginExpansionPath, pluginExpansionBeanFName);
                    plugonExpansionBeanGen.gen();
                    String expansionPluginPath = mainExpansionPath + File.separator + "resources";
                    String pluginTName = "plugin.ftl";
                    String pluginFName = "plugin.properties";
                    String expansionClassPath = "com.jxdinfo.hussar.example." + tenantCodeLow + "." + applicationCodeLowExpansion + "." + tenantAndExpansion + "PluginExpansion";
                    HashMap<String, String> expansionPluginParam = new HashMap<String, String>();
                    expansionPluginParam.put("id", expansionPluginId);
                    expansionPluginParam.put("class", expansionClassPath);
                    expansionPluginParam.put("provider", account);
                    expansionPluginParam.put("description", applicationName + expansion);
                    CodeGenerator expansionPluginGen = new CodeGenerator(pluginTName, expansionPluginParam, templatePath, expansionPluginPath, pluginFName);
                    expansionPluginGen.gen();
                    String expansionDevFilePath = expansionPluginPath + File.separator + "expansion-columninfo-dev.yml";
                    File devFile = new File(expansionDevFilePath);
                    try {
                        if (!devFile.exists()) {
                            devFile.createNewFile();
                            logger.info("\u6587\u4ef6\u5df2\u521b\u5efa: {}", (Object)devFile.getAbsolutePath());
                        } else {
                            System.out.println("\u6587\u4ef6\u5df2\u5b58\u5728: " + devFile.getAbsolutePath());
                        }
                        FileWriter writer = new FileWriter(devFile, false);
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new HussarException("expansion-columninfo-dev.yml\u6587\u4ef6\u521b\u5efa\u5931\u8d25");
                    }
                    String expansionProdFilePath = expansionPluginPath + File.separator + "expansion-columninfo-prod.yml";
                    File prodFile = new File(expansionProdFilePath);
                    try {
                        if (!prodFile.exists()) {
                            prodFile.createNewFile();
                            System.out.println("\u6587\u4ef6\u5df2\u521b\u5efa: " + prodFile.getAbsolutePath());
                        } else {
                            System.out.println("\u6587\u4ef6\u5df2\u5b58\u5728: " + prodFile.getAbsolutePath());
                        }
                        FileWriter writer = new FileWriter(prodFile, false);
                        writer.close();
                    }
                    catch (IOException e) {
                        throw new HussarException("expansion-columninfo-prod.yml\u521b\u5efa\u5931\u8d25");
                    }
                    expansionPluginParam.put("id", tenAndApp + expansion);
                    expansionPluginParam.put("class", expansionClassPath);
                    expansionPluginParam.put("provider", account);
                    expansionPluginParam.put("artifactId", pluginPrefix + tenAndApp + expansion);
                    String expansionPomTName = "expansionPom.ftl";
                    String expansionPomFName = "pom.xml";
                    CodeGenerator expansionPomGen = new CodeGenerator(expansionPomTName, expansionPluginParam, templatePath, expansionPath, expansionPomFName);
                    expansionPomGen.gen();
                    String pomUrl = absolutePath + prefixName + File.separator + "pom.xml";
                    String expansionModuleName = pluginPrefix + tenantCode + File.separator + pluginPrefix + tenAndApp + expansion;
                    this.editPomXml(pomUrl, expansionModuleName);
                    sharePluginInfoDto.setExpansionPluginId(expansionPluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                    return true;
                }
                if (application.exists() && isImport) {
                    Throwable throwable;
                    String relativeMainPath = "src.main";
                    String expansionPluginPropertiesPath = expansionPath + File.separator + relativeMainPath.replace(".", File.separator) + File.separator + "resources" + File.separator + "plugin.properties";
                    Properties properties = new Properties();
                    try {
                        throwable = null;
                        try (FileInputStream fis = new FileInputStream(expansionPluginPropertiesPath);){
                            properties.load(fis);
                            properties.setProperty("plugin.id", expansionPluginId);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (IOException e) {
                        throw new HussarException("\u4fee\u6539\u6269\u5c55\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                    }
                    try {
                        throwable = null;
                        try (FileOutputStream fos = new FileOutputStream(expansionPluginPropertiesPath);){
                            properties.store(fos, "Updated plugin.id");
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        throw new HussarException("\u4fee\u6539\u6269\u5c55\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
                    }
                    sharePluginInfoDto.setExpansionPluginId(expansionPluginId);
                    this.sharePluginService.savePluginInfo(sharePluginInfoDto);
                    return true;
                }
            }
        }
        logger.warn("\u6587\u4ef6\u6a21\u5757\u751f\u6210\u5931\u8d25");
        return false;
    }
}

