/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.applicationmix.dao.BatchImportRecordMapper;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.model.BatchImportRecord;
import com.jxdinfo.hussar.applicationmix.service.IBatchImportAppService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppFileService;
import com.jxdinfo.hussar.applicationmix.vo.MixAppInfoVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import com.jxdinfo.hussar.tenant.common.util.TenantCacheUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.applicationmix.service.impl.batchImportAppServiceImpl")
public class BatchImportAppServiceImpl
implements IBatchImportAppService {
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;
    @Lazy
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Resource
    private BatchImportRecordMapper batchImportRecordMapper;
    @Resource
    private ISysAppFileService appFileService;

    public void batchImport(File file, Long appId, String tenantCode) {
        try {
            if (HussarUtils.isBlank((CharSequence)tenantCode)) {
                return;
            }
            MixAppInfoVo appInfo = this.sysLowCodeAppExtendMapper.getMixAppInfo(appId);
            if (HussarUtils.isEmpty((Object)appInfo)) {
                return;
            }
            MultipartFile multipartFile = BatchImportAppServiceImpl.fileToMultipartFileInTest(file);
            List tenantCodeList = Arrays.stream(tenantCode.split(",")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            List sysTenants = this.sysTenantService.list((Wrapper)new LambdaQueryWrapper().in(SysTenant::getTenantCode, tenantCodeList));
            Map<String, String> map = sysTenants.stream().collect(Collectors.toMap(SysTenant::getTenantCode, SysTenant::getConnName));
            for (String tCode : tenantCodeList) {
                this.executeBatchImport(multipartFile, appInfo, tCode, map.get(tCode));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static MultipartFile fileToMultipartFileInTest(File file) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            MockMultipartFile mockMultipartFile = new MockMultipartFile(file.getName(), file.getName(), null, (InputStream)inputStream);
            return mockMultipartFile;
        }
    }

    private void executeBatchImport(MultipartFile multipartFile, MixAppInfoVo appInfo, String tenantCode, String tenantConnName) throws IOException {
        BatchImportRecord importRecord = new BatchImportRecord();
        importRecord.setImportAppId(appInfo.getId());
        importRecord.setImportAppName(appInfo.getAppName());
        importRecord.setTenantCode(tenantCode);
        HussarTenantDefinition tenantDefinition = TenantCacheUtil.loadFromCacheByTenantCode((String)tenantCode);
        importRecord.setTenantName(tenantDefinition != null ? tenantDefinition.getTenantName() : "");
        try {
            String connName = HussarContextHolder.getConnName();
            String currentTCode = HussarContextHolder.getHussarTenant().getTenantCode();
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest(servletRequestAttributes.getRequest());
            hussarHttpServletRequest.addHeader("tcode", tenantCode);
            ServletRequestAttributes newServletRequestAttributes = new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest);
            RequestContextHolder.setRequestAttributes((RequestAttributes)newServletRequestAttributes);
            HussarContextHolder.setTenant((String)tenantConnName, (String)tenantCode);
            ApiResponse response = this.appFileService.importProduceAppForTenant(multipartFile, appInfo.getId(), appInfo.getAppEnglishName(), tenantCode, connName, currentTCode);
            if (ResultCode.FAILURE.getCode() == response.getCode()) {
                importRecord.setImportStatus(Integer.valueOf(0));
                importRecord.setImportFailReason(response.getMsg());
                this.batchImportRecordMapper.insert(importRecord);
            }
        }
        catch (Exception e) {
            importRecord.setImportStatus(Integer.valueOf(0));
            importRecord.setImportFailReason("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
            this.batchImportRecordMapper.insert(importRecord);
            e.printStackTrace();
        }
        importRecord.setImportStatus(Integer.valueOf(1));
        this.batchImportRecordMapper.insert(importRecord);
    }
}

