/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.jxdinfo.hussar.applicationmix.model.SysEyImportAppMsg;
import com.jxdinfo.hussar.applicationmix.properties.HussarClusterProperties;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixExportService;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixImportCtrlService;
import com.jxdinfo.hussar.applicationmix.service.ISysAppFileService;
import com.jxdinfo.hussar.applicationmix.service.ISysEyImportAppMixMsgService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.AutoIntegrationConfiguration;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class HussarBaseAppMixImportCtrlServiceImpl
implements IHussarBaseAppMixImportCtrlService {
    private final Logger logger = LoggerFactory.getLogger(HussarBaseAppMixImportCtrlServiceImpl.class);
    @Autowired
    private ISysEyImportAppMixMsgService ISysEyImportAppMixMsgService;
    @Autowired
    private ISysAppFileService appFileService;
    @Resource
    private HussarClusterProperties hussarClusterProperties;
    @Resource
    private IHussarBaseAppMixExportService exportService;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${hussar-formdesign.page-build-address:localhost:8989}")
    private String pageBuildIp;
    @Value(value="${hussar-formdesign.nginx-package-path:G:/nginx-1.26.2/nginx-1.26.2/html/static/js}")
    private String nginxPackagePath;
    @Value(value="${cluster.clusterType:0}")
    private String clusterType;
    @Value(value="${cluster.shareFront:0}")
    private String shareFront;
    @Value(value="${cluster.localFront:0}")
    private String localFront;
    @Lazy
    @Resource
    private AutoIntegrationConfiguration autoIntegrationConfiguration;

    @HussarDs(value="#connName")
    public void doJob(String connName) {
        if (this.autoIntegrationConfiguration.enable()) {
            String name = ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasource().getName();
            if (this.isImportStatusExpect45Only0()) {
                this.logger.info("\u68c0\u6d4b\u5b8c\u6210\uff0c\u5b58\u5728\u5f85\u5bfc\u5165\u7684\u5e94\u7528\uff0c\u5f00\u59cb\u7f16\u8bd1\u5bfc\u5165\u5e94\u7528\uff0c\u5f53\u524d\u6570\u636e\u6e90\uff1a{}\u3002", (Object)name);
                this.getAndImoprtApplication();
                this.logger.info("\u6267\u884c\u5bfc\u5165\u5e94\u7528\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002");
            } else {
                this.logger.info("\u68c0\u6d4b\u5b8c\u6210\uff0c\u6ca1\u6709\u5f85\u5bfc\u5165\u7684\u5e94\u7528\u3002\u5f53\u524d\u6570\u636e\u6e90\uff1a{}\u3002\u6267\u884c\u5bfc\u5165\u5e94\u7528\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f\u3002", (Object)name);
            }
        }
    }

    public void checkAppImportMsg() {
        this.ISysEyImportAppMixMsgService.checkAppImportMsg();
    }

    private boolean isImportStatusExpect45Only0() {
        return this.ISysEyImportAppMixMsgService.isImportStatusExpect45Only0();
    }

    private void getAndImoprtApplication() {
        SysEyImportAppMsg sysEyImportAppMsg = this.ISysEyImportAppMixMsgService.getEyImportAppMsg();
        boolean flag = this.ISysEyImportAppMixMsgService.setImportStatusOne(sysEyImportAppMsg.getId());
        if (flag) {
            try {
                boolean importEyAppFlag = this.importEyApp(sysEyImportAppMsg);
                if (!importEyAppFlag) {
                    this.ISysEyImportAppMixMsgService.setImportStatusFive(sysEyImportAppMsg.getId());
                } else {
                    Map pathMap = this.appFileService.getAppFilePath(sysEyImportAppMsg.getAppId(), sysEyImportAppMsg.getServerCode());
                    String vuePathss = (String)pathMap.get("vuePath");
                    String[] vueFiles = this.getVueFiles(vuePathss);
                    this.sendPostRequest(vueFiles);
                }
            }
            catch (Exception e) {
                this.ISysEyImportAppMixMsgService.setFailReason(sysEyImportAppMsg.getId(), e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private String[] getVueFiles(String directoryPath) throws IOException {
        List<String> vuePathList;
        Path dirPath = Paths.get(directoryPath, new String[0]);
        try (Stream<Path> stream = Files.walk(dirPath, new FileVisitOption[0]);){
            vuePathList = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".vue")).map(path -> {
                String vuePath = path.toString();
                int srcIndex = vuePath.indexOf("src");
                if (srcIndex != -1) {
                    vuePath = vuePath.substring(srcIndex);
                }
                return "./" + vuePath.replace(File.separator, "/");
            }).collect(Collectors.toList());
        }
        return vuePathList.toArray(new String[0]);
    }

    private void sendPostRequest(String[] vuePaths) throws Exception {
        URL url = new URL("http://" + this.pageBuildIp + "/singlePageBuild");
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.set((Object)"appFileList", (Object)this.arrayToJson(vuePaths));
        if ("0".equals(this.clusterType)) {
            request.set((Object)"outputPath", (Object)this.nginxPackagePath);
        } else {
            request.set((Object)"outputPath", (Object)this.shareFront);
        }
        String result = (String)this.restTemplate.postForObject(url.toURI(), (Object)request, String.class);
        this.logger.info("\u524d\u53f0\u8fd4\u56de\u7f16\u8bd1\u7ed3\u679c\uff1a{}", (Object)result);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url.toURI(), (Object)request, String.class);
        this.logger.info("responseEntity.getBody() = {}", responseEntity.getBody());
    }

    private String arrayToJson(String[] array) {
        if (array == null || array.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < array.length; ++i) {
            sb.append("\"");
            sb.append(array[i]);
            sb.append("\"");
            if (i >= array.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean importEyApp(SysEyImportAppMsg sysEyImportAppMsg) {
        String importFileBackUpPath = FileUtil.posixPath((String[])new String[]{this.hussarClusterProperties.getImportFile(), File.separator, sysEyImportAppMsg.getServerCode(), File.separator, sysEyImportAppMsg.getAppId().toString(), File.separator, sysEyImportAppMsg.getId().toString()});
        try {
            this.appFileService.importAndCompileAppWithSecurity(importFileBackUpPath, sysEyImportAppMsg.getServerCode(), sysEyImportAppMsg.getAppId(), sysEyImportAppMsg.getImportMsgSql(), Arrays.asList(sysEyImportAppMsg.getImportMsgKeys().split(",")), sysEyImportAppMsg.getId(), sysEyImportAppMsg.getServerName(), sysEyImportAppMsg.getSecurityLevel());
        }
        catch (Exception e) {
            this.ISysEyImportAppMixMsgService.setFailReason(sysEyImportAppMsg.getId(), e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

