/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.applicationmix.constants.AppExportConstants;
import com.jxdinfo.hussar.applicationmix.dao.SysLowCodeAppExtendMapper;
import com.jxdinfo.hussar.applicationmix.model.SysLowCodeAppExtend;
import com.jxdinfo.hussar.applicationmix.properties.HussarAppExportProperties;
import com.jxdinfo.hussar.applicationmix.properties.HussarBasePluginProperties;
import com.jxdinfo.hussar.applicationmix.service.IHussarBaseAppMixExportService;
import com.jxdinfo.hussar.applicationmix.service.ISysLowCodeAppExtendService;
import com.jxdinfo.hussar.applicationmix.util.MavenUtil;
import com.jxdinfo.hussar.applicationmix.util.TarUtil;
import com.jxdinfo.hussar.applicationmix.util.ZipUtil;
import com.jxdinfo.hussar.applicationmix.vo.ExportParamVO;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.ISysMenuManageBoService;
import com.jxdinfo.hussar.authorization.permit.dto.QueryFunAndResDto;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesBoService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.formdesign.common.config.StorageContext;
import com.jxdinfo.hussar.formdesign.common.constant.ExportResourceConstant;
import com.jxdinfo.hussar.formdesign.common.exception.LcdpExceptionEnum;
import com.jxdinfo.hussar.formdesign.common.properties.FormDesignProperties;
import com.jxdinfo.hussar.formdesign.common.util.AppContextUtil;
import com.jxdinfo.hussar.formdesign.common.util.FileUtil;
import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import com.jxdinfo.hussar.formdesign.external.export.ExportProjectStoreService;
import com.jxdinfo.hussar.formdesign.external.export.ExportTableService;
import com.jxdinfo.hussar.formdesign.storage.client.service.StorageService;
import com.jxdinfo.hussar.formdesign.storage.common.model.StorageResult;
import com.jxdinfo.hussar.formdesign.storage.common.model.enums.CategoryEnum;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.workflow.engine.bpm.migration.dto.WorkflowDumpAppDto;
import com.jxdinfo.hussar.workflow.manage.engine.WorkflowAppMigrationService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class HussarBaseAppMixExportServiceImpl
implements IHussarBaseAppMixExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HussarBaseAppMixExportServiceImpl.class);
    private static final String MODULES = "packages" + File.separator + "hussar-remote-";
    private static final String VIEWS = "views";
    private static final String API = "api";
    private static final String SRC = "src";
    private static final String DEV = "dev";
    private static final String PROD = "prod";
    private static final String VUE_PACKAGES_DIR = File.separator + "packages" + File.separator;
    private static final String VUE_DIST_DIR = File.separator + "dist" + File.separator + "mf";
    private static final String VUE_DIST = "dist";
    private static final String expansion = "";
    @Resource
    private FormDesignProperties formDesignProperties;
    @Resource
    private HussarAppExportProperties hussarAppExportProperties;
    @Resource
    private ISysLowCodeAppExtendService iSysLowCodeAppExtendService;
    @Resource
    private StorageContext storageContext;
    @Resource
    private StorageService storageService;
    @Autowired(required=false)
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private ExportTableService exportTableService;
    @Resource
    private ExportProjectStoreService exportProjectStoreService;
    @Resource
    private HussarBasePluginProperties hussarBasePluginProperties;
    @Resource
    private ISysFunctionsBoService sysFunctionsBoService;
    @Resource
    private ISysFunctionModulesBoService sysFunctionModulesBoService;
    @Resource
    private IHussarBaseResourceService baseResourceBoService;
    @Resource
    private ISysResourceMosulesBoService sysResourceMosulesBoService;
    @Resource
    private ISysFunctionResourcesBoService sysFunctionResourcesBoService;
    @Resource
    private ISysMenuManageBoService sysMenuManageBoService;
    @Resource
    private SysLowCodeAppExtendMapper sysLowCodeAppExtendMapper;

    public Map<String, List<JSONObject>> resourceTree(String appId) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        HashMap<String, List<JSONObject>> treeMap = new HashMap<String, List<JSONObject>>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)Long.valueOf(appId));
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), SRC});
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String apiClassFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()) + "-api", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String appClassFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()) + "-application", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        ArrayList<JSONObject> classFileObjects = new ArrayList<JSONObject>();
        String appStoreName = this.getAppStoreName(appId);
        if (ToolUtil.isEmpty((Object)appStoreName)) {
            appStoreName = "appsStore";
        }
        this.addJavaFile(appInfo, apiClassFilePath, classFileObjects, appStoreName);
        this.addJavaFile(appInfo, appClassFilePath, classFileObjects, appStoreName);
        String vueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), SRC});
        String absAppNameVue = FileUtil.posixPath((String[])new String[]{vueFilePath, appStoreName});
        ArrayList<JSONObject> vueFileObjects = new ArrayList<JSONObject>();
        File[] vueFiles = new File(vueFilePath).listFiles();
        this.iterateFiles(vueFileObjects, vueFiles, vuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameVue)) || ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(".DS_Store") || ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(".gitkeep"));
        String mobileVueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileVue = FileUtil.posixPath((String[])new String[]{mobileVueFilePath, appStoreName});
        ArrayList<JSONObject> mobileVueFileObjects = new ArrayList<JSONObject>();
        File[] mobileVueFiles = new File(mobileVueFilePath).listFiles();
        this.iterateFiles(mobileVueFileObjects, mobileVueFiles, mobileVuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileVue)));
        String mobileApiJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileApiJs = FileUtil.posixPath((String[])new String[]{mobileApiJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileApiFileObjects = new ArrayList<JSONObject>();
        File[] mobileApiFiles = new File(mobileApiJsFilePath).listFiles();
        this.iterateFiles(mobileApiFileObjects, mobileApiFiles, mobileApiPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileApiJs)));
        String mobileRouterJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileRouterJs = FileUtil.posixPath((String[])new String[]{mobileRouterJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileRouterFileObjects = new ArrayList<JSONObject>();
        File[] mobileRouterFiles = new File(mobileRouterJsFilePath).listFiles();
        this.iterateFiles(mobileRouterFileObjects, mobileRouterFiles, mobileRouterPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileRouterJs)));
        treeMap.put("java", classFileObjects);
        treeMap.put("vue", vueFileObjects);
        treeMap.put("mobileVue", mobileVueFileObjects);
        treeMap.put(API, new ArrayList());
        treeMap.put("mobileApi", mobileApiFileObjects);
        treeMap.put("mobileRouter", mobileRouterFileObjects);
        try {
            treeMap.put("tableInfo", this.exportTableService.resourceTree());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return treeMap;
    }

    private void addJavaFile(SysLowCodeAppExtend appInfo, String appClassFilePath, List<JSONObject> classFileObjects, String appStoreName) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        File[] appClassFile = new File(appClassFilePath).listFiles();
        String absAppName = FileUtil.posixPath((String[])new String[]{appClassFilePath, appStoreName.toLowerCase()});
        this.iterateFiles(classFileObjects, appClassFile, appClassFilePath, classFile -> {
            String removePrefix = FileUtil.removePrefix((String)File.separator, (String)classFile.getAbsolutePath().substring(FileUtil.removePrefix((String)File.separator, (String)appClassFilePath).length()));
            return AppExportConstants.CONFIG.equals(removePrefix) || ToolUtil.pathFomatterByOS((String)classFile.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppName)) || AppExportConstants.paramPlugin((String)tenantCode, (String)appInfo.getAppEnglishName()).equals(removePrefix);
        });
    }

    private String getGeneratorFilePathPrefixByAppId(SysLowCodeAppExtend appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())});
    }

    public static String getAppBackCodePrefixByAppId(SysLowCodeAppExtend appInfo) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        return appInfo == null ? null : FileUtil.posixPath((String[])new String[]{AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName())}).toLowerCase();
    }

    private String pathToId(String prefix, String abPath) {
        return FilenameUtils.removeExtension((String)abPath.substring(prefix.length() - 1)).replaceAll("/", expansion).replaceAll("\\\\", expansion);
    }

    private void iterateFiles(List<JSONObject> fileObjects, File[] files, String prefix, Predicate<File> exclusion) {
        String finalPrefix = prefix = FileUtil.removePrefix((String)File.separator, (String)prefix);
        Optional.ofNullable(files).ifPresent(nullableFiles -> {
            for (File classFile : nullableFiles) {
                if (exclusion.test(classFile)) continue;
                JSONObject classFileObject = new JSONObject();
                String path = FileUtil.removePrefix((String)File.separator, (String)classFile.getAbsolutePath());
                String parentPath = FileUtil.removePrefix((String)File.separator, (String)classFile.getParentFile().getAbsolutePath());
                String id = this.pathToId(finalPrefix, path);
                String parentId = this.pathToId(finalPrefix, parentPath);
                if (classFile.getName().endsWith(".js")) {
                    id = id + "js";
                }
                String parent = parentPath.equals(finalPrefix) ? "#" : parentId;
                classFileObject.put("id", (Object)id);
                classFileObject.put("parent", (Object)parent);
                classFileObject.put("name", (Object)classFile.getName());
                classFileObject.put("path", (Object)classFile.getPath());
                if (classFile.isDirectory()) {
                    classFileObject.put("type", (Object)"Module");
                    fileObjects.add(classFileObject);
                    this.iterateFiles(fileObjects, classFile.listFiles(), finalPrefix, exclusion);
                    continue;
                }
                classFileObject.put("type", (Object)classFile.getName().substring(classFile.getName().indexOf(".") + 1));
                fileObjects.add(classFileObject);
            }
        });
    }

    public Map<String, String> export(ExportParamVO exportParamVO, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)Long.valueOf(exportParamVO.getAppId()));
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String hussar = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String tar = FileUtil.posixPath((String[])new String[]{hussar, appName});
        String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
        String workflowPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.WORKFLOW});
        String vuePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.VUE});
        String tableInfoPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.TABLEINFO});
        String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
        String funResMenuPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.FUN_RES_MENU});
        File tarDir = new File(tar);
        File hussarDir = new File(hussar);
        String zipFilePath = hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            boolean wpdFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getVues()) || ToolUtil.isNotEmpty((Object)exportParamVO.getApis());
            boolean flowFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getConfigs()) || ToolUtil.isNotEmpty((Object)exportParamVO.getPermissions());
            this.exportProjectStoreService.export(exportParamVO.getAppId(), projectStorePath, wpdFlag, flowFlag, exportParamVO.getExtensionFlag() == false);
            String javaFilePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName)});
            String apiJavaFilePathPrefix = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api"});
            String appJavaFilePathPrefix = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application"});
            String pomPath = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, AppExportConstants.POM});
            String apiPomPath = FileUtil.posixPath((String[])new String[]{apiJavaFilePathPrefix, AppExportConstants.POM});
            String appPomPath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, AppExportConstants.POM});
            String codePath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
            String configPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.CONFIG});
            String paramsPluginPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.paramPlugin((String)tenantCode, (String)appName)});
            String resourcesPath = FileUtil.posixPath((String[])new String[]{appJavaFilePathPrefix, this.hussarAppExportProperties.getResourcesPath()});
            this.copyFilesToTemp(exportParamVO.getJavas(), FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(pomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(apiPomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(appPomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(configPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(paramsPluginPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(resourcesPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            Map tableStructureMap = this.exportTableService.exportTables(exportParamVO.getTableInfos());
            File tableStructureFile = new File(FileUtil.posixPath((String[])new String[]{tableInfoPath, ExportResourceConstant.TABLE_INFO_JSON}));
            FileUtils.writeByteArrayToFile((File)tableStructureFile, (byte[])SerializeUtils.serialize((Object)tableStructureMap));
            ExecutorService frontendPool = Executors.newCachedThreadPool();
            ExecutorService backendPool = Executors.newWorkStealingPool();
            CompletableFuture<Void> frontendFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.buildDistToTemp(tenantCode, appName, this.hussarAppExportProperties.getFrontProjectPath(), vuePath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, frontendPool);
            CompletableFuture<Void> backendFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.packageJavaCode(javaPath, tenantCode, appName, false);
                }
                catch (IOException | MavenInvocationException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }, backendPool);
            CompletableFuture.allOf(frontendFuture, backendFuture).join();
            this.exportFunResMenu(funResMenuPath, Long.valueOf(exportParamVO.getAppId()));
            WorkflowDumpAppDto workflowDumpAppDto = new WorkflowDumpAppDto();
            workflowDumpAppDto.setAppCode(appName);
            workflowDumpAppDto.setFilePath(workflowPath);
            WorkflowAppMigrationService.dumpApp((WorkflowDumpAppDto)workflowDumpAppDto);
            this.zipAndDownload(tarDir, hussarDir, tenantCode, appName, hussar, response, 1, exportParamVO.getAppId(), tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u5bfc\u51fa\u81f3\u751f\u4ea7\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u81f3\u751f\u4ea7\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
            FileUtils.deleteDirectory((File)hussarDir);
            throw new BaseException("\u5bfc\u51fa\u81f3\u751f\u4ea7\u73af\u5883\u51fa\u9519\uff01");
        }
        return map;
    }

    public Map<String, String> exportOffline(ExportParamVO exportParamVO, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)exportParamVO.getAppId())) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)exportParamVO.getAppId());
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String expansionPath = MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + File.separator + SRC;
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), expansionPath}) + expansion;
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String javaPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String apiJavaPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api", this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String hussar = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String zipFilePath = new File(hussar).getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            String tar = FileUtil.posixPath((String[])new String[]{hussar, appName});
            String vuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.VUE});
            String mobileVuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_VUE, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String mobileApiPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_API, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String mobileRouterPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_ROUTER, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appName)});
            String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
            String tableInfoPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.TABLEINFO});
            String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
            String workflowPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.WORKFLOW});
            String appsStoreName = this.getAppStoreName(exportParamVO.getAppId());
            if (ToolUtil.isEmpty((Object)appsStoreName)) {
                appsStoreName = "appsStore";
            }
            this.exportProjectStoreService.exportOffLine(exportParamVO.getAppId(), projectStorePath);
            if (new File(javaPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotPlugin(new File(javaPathPrefix), new File(javaPath + File.separator + this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application" + this.formDesignProperties.getJavaCodePath() + this.formDesignProperties.getJavaPath() + File.separator + HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)), AppExportConstants.paramPlugin((String)AppContextUtil.asIdentifier((String)tenantCode), (String)AppContextUtil.asIdentifier((String)appName)), appsStoreName);
            }
            if (new File(apiJavaPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotPlugin(new File(apiJavaPathPrefix), new File(javaPath + File.separator + this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-api" + this.formDesignProperties.getJavaCodePath() + this.formDesignProperties.getJavaPath() + File.separator + HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)), AppExportConstants.paramPlugin((String)AppContextUtil.asIdentifier((String)tenantCode), (String)AppContextUtil.asIdentifier((String)appName)), appsStoreName);
            }
            if (new File(vuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(vuePathPrefix), new File(vuePath), appsStoreName);
            }
            if (new File(mobileVuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileVuePathPrefix), new File(mobileVuePath), appsStoreName);
            }
            if (new File(mobileApiPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileApiPathPrefix), new File(mobileApiPath), appsStoreName);
            }
            if (new File(mobileRouterPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(mobileRouterPathPrefix), new File(mobileRouterPath), appsStoreName);
            }
            Map tableStructureMap = this.exportTableService.exportTables();
            File tableStructureFile = new File(FileUtil.posixPath((String[])new String[]{tableInfoPath, ExportResourceConstant.TABLE_INFO_JSON}));
            FileUtils.writeByteArrayToFile((File)tableStructureFile, (byte[])SerializeUtils.serialize((Object)tableStructureMap));
            String appType = this.sysLowCodeAppExtendMapper.getMixAppTypeById(Long.valueOf(exportParamVO.getAppId()));
            WorkflowDumpAppDto workflowDumpAppDto = new WorkflowDumpAppDto();
            workflowDumpAppDto.setAppCode(appName);
            workflowDumpAppDto.setFilePath(workflowPath);
            workflowDumpAppDto.setAppType(appType);
            WorkflowAppMigrationService.dumpApp((WorkflowDumpAppDto)workflowDumpAppDto);
            this.zipAndDownload(new File(tar), new File(hussar), tenantCode, appName, hussar, response, 2, exportParamVO.getAppId(), tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u8de8\u79df\u6237\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.info("\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
        }
        return map;
    }

    public Map<String, String> exportExpansionOffline(ExportParamVO exportParamVO, HttpServletResponse response) {
        long start = System.currentTimeMillis();
        if (ToolUtil.isEmpty((Object)exportParamVO.getAppId())) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)Long.valueOf(exportParamVO.getAppId()));
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String appExpansionName = appName + expansion;
        String expansionPath = MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + File.separator + SRC;
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), expansionPath}) + expansion;
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)}) + expansion;
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)}) + expansion;
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)}) + expansion;
        String moduleExpansionFilePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appExpansionName)});
        String relativeResourcePath = "src.main.resources";
        String resourceExpansionPath = moduleExpansionFilePathPrefix + File.separator + relativeResourcePath.replace(".", File.separator);
        String javaExpansionPath = FileUtil.posixPath((String[])new String[]{moduleExpansionFilePathPrefix, this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        String expansionDevFilePath = resourceExpansionPath + File.separator + DEV + File.separator + "expansion-columninfo-dev.yml";
        String expansionProdFilePath = resourceExpansionPath + File.separator + PROD + File.separator + "expansion-columninfo-prod.yml";
        String hussar = FileUtil.posixPath((String[])new String[]{this.formDesignProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appExpansionName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String zipFilePath = new File(hussar).getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appExpansionName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            String appsStoreName;
            String tar = FileUtil.posixPath((String[])new String[]{hussar, appExpansionName});
            String vuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.VUE});
            String mobileVuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_VUE, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appExpansionName)});
            String mobileApiPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_API, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appExpansionName)});
            String mobileRouterPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_ROUTER, AppContextUtil.asIdentifier((String)tenantCode), AppContextUtil.asIdentifier((String)appExpansionName)});
            String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
            String resourcePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.RESOURCES});
            String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
            String workflowPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.WORKFLOW});
            this.exportProjectStoreService.exportOffLine(exportParamVO.getAppId(), projectStorePath);
            if (new File(javaExpansionPath).exists()) {
                String expansionPlugin = AppExportConstants.paramExpansionPluginNoServiceName((String)tenantCode, (String)appName);
                String expansionServicePlugin = AppExportConstants.expansionServicePluginNoServiceName((String)tenantCode, (String)appName);
                HussarBaseAppMixExportServiceImpl.copyToDirectoryNotExpansion(new File(javaExpansionPath), new File(javaPath), expansionPlugin, expansionServicePlugin);
            }
            if (new File(expansionDevFilePath).exists()) {
                FileUtils.copyFileToDirectory((File)new File(expansionDevFilePath), (File)new File(resourcePath + File.separator + DEV));
            }
            if (new File(expansionProdFilePath).exists()) {
                FileUtils.copyFileToDirectory((File)new File(expansionProdFilePath), (File)new File(resourcePath + File.separator + PROD));
            }
            if (ToolUtil.isEmpty((Object)(appsStoreName = this.getAppStoreName(exportParamVO.getAppId())))) {
                appsStoreName = "appsStore";
            }
            if (new File(vuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectoryButNotContains(new File(vuePathPrefix), new File(vuePath), appsStoreName);
            }
            if (new File(mobileVuePathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectory(new File(mobileVuePathPrefix), new File(mobileVuePath));
            }
            if (new File(mobileApiPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectory(new File(mobileApiPathPrefix), new File(mobileApiPath));
            }
            if (new File(mobileRouterPathPrefix).exists()) {
                HussarBaseAppMixExportServiceImpl.copyToDirectory(new File(mobileRouterPathPrefix), new File(mobileRouterPath));
            }
            String appType = this.sysLowCodeAppExtendMapper.getMixAppTypeById(Long.valueOf(exportParamVO.getAppId()));
            WorkflowDumpAppDto workflowDumpAppDto = new WorkflowDumpAppDto();
            workflowDumpAppDto.setAppCode(appName);
            workflowDumpAppDto.setFilePath(workflowPath);
            workflowDumpAppDto.setAppType(appType);
            WorkflowAppMigrationService.dumpApp((WorkflowDumpAppDto)workflowDumpAppDto);
            this.expansionZipAndDownload(new File(tar), new File(hussar), tenantCode, appExpansionName, hussar, response, 2, tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u8de8\u79df\u6237\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
            throw new BaseException("\u5bfc\u51fa\u81f3\u7ebf\u4e0b\u73af\u5883\u51fa\u9519\uff01");
        }
        return map;
    }

    public Map<String, List<JSONObject>> expansionResourceTree(String appId) {
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        HashMap<String, List<JSONObject>> treeMap = new HashMap<String, List<JSONObject>>();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)Long.valueOf(appId));
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String vuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), SRC});
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String moduleClassFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)});
        ArrayList<JSONObject> classFileObjects = new ArrayList<JSONObject>();
        String appStoreName = this.getAppStoreName(appId);
        if (ToolUtil.isEmpty((Object)appStoreName)) {
            appStoreName = "appsStore";
        }
        this.addExpansionJavaFile(appInfo, moduleClassFilePath, classFileObjects);
        String vueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), MODULES + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appInfo.getAppEnglishName()), SRC});
        String absAppNameVue = FileUtil.posixPath((String[])new String[]{vueFilePath, appStoreName});
        ArrayList<JSONObject> vueFileObjects = new ArrayList<JSONObject>();
        File[] vueFiles = new File(vueFilePath).listFiles();
        this.iterateFiles(vueFileObjects, vueFiles, vuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameVue)) || ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(".DS_Store") || ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(".gitkeep"));
        String mobileVueFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileVue = FileUtil.posixPath((String[])new String[]{mobileVueFilePath, appStoreName});
        ArrayList<JSONObject> mobileVueFileObjects = new ArrayList<JSONObject>();
        File[] mobileVueFiles = new File(mobileVueFilePath).listFiles();
        this.iterateFiles(mobileVueFileObjects, mobileVueFiles, mobileVuePathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileVue)));
        String mobileApiJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileApiJs = FileUtil.posixPath((String[])new String[]{mobileApiJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileApiFileObjects = new ArrayList<JSONObject>();
        File[] mobileApiFiles = new File(mobileApiJsFilePath).listFiles();
        this.iterateFiles(mobileApiFileObjects, mobileApiFiles, mobileApiPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileApiJs)));
        String mobileRouterJsFilePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath(), this.getGeneratorFilePathPrefixByAppId(appInfo)});
        String absAppNameMobileRouterJs = FileUtil.posixPath((String[])new String[]{mobileRouterJsFilePath, appStoreName.toLowerCase()});
        ArrayList<JSONObject> mobileRouterFileObjects = new ArrayList<JSONObject>();
        File[] mobileRouterFiles = new File(mobileRouterJsFilePath).listFiles();
        this.iterateFiles(mobileRouterFileObjects, mobileRouterFiles, mobileRouterPathPrefix, file -> ToolUtil.pathFomatterByOS((String)file.getAbsolutePath()).contains(ToolUtil.pathFomatterByOS((String)absAppNameMobileRouterJs)));
        treeMap.put("java", classFileObjects);
        treeMap.put("vue", vueFileObjects);
        treeMap.put("mobileVue", mobileVueFileObjects);
        treeMap.put(API, new ArrayList());
        treeMap.put("mobileApi", mobileApiFileObjects);
        treeMap.put("mobileRouter", mobileRouterFileObjects);
        try {
            treeMap.put("tableInfo", this.exportTableService.resourceTree());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return treeMap;
    }

    public Map<String, String> exportExpansion(ExportParamVO exportParamVO, HttpServletResponse response) throws Exception {
        long start = System.currentTimeMillis();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysLowCodeAppExtend::getAppId, (Object)Long.valueOf(exportParamVO.getAppId()));
        SysLowCodeAppExtend appInfo = (SysLowCodeAppExtend)this.iSysLowCodeAppExtendService.getOne((Wrapper)wrapper);
        if (ToolUtil.isEmpty((Object)appInfo)) {
            throw new BaseException(LcdpExceptionEnum.APP_NOT_FOUND.getMsg());
        }
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        String appName = appInfo.getAppEnglishName();
        String appExpansionName = appName + expansion;
        String mobileVuePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontProjectPath(), this.hussarAppExportProperties.getMobileVueCodePath()});
        String apiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getFrontProjectPath(), this.hussarAppExportProperties.getFrontApiPath(), MODULES});
        String mobileApiPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontApiAbPath()});
        String mobileRouterPathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getMobileFrontRouterAbPath()});
        String hussar = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getWorkspace(), ExportResourceConstant.RESOURCE_CACHE, ToolUtil.splicingBySeparator((String)ExportResourceConstant.UNDERLINE, (String[])new String[]{tenantCode, appExpansionName, DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss")})});
        String tar = FileUtil.posixPath((String[])new String[]{hussar, appExpansionName});
        String javaPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.JAVA});
        String workflowPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.WORKFLOW});
        String vuePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.VUE});
        String mobileVuePath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_VUE});
        String apiPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.API});
        String mobileApiPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_API});
        String mobileRouterPath = FileUtil.posixPath((String[])new String[]{tar, AppExportConstants.MOBILE_ROUTER});
        String tableInfoPath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.TABLEINFO});
        String projectStorePath = FileUtil.posixPath((String[])new String[]{tar, ExportResourceConstant.PROJECT_STORE});
        File tarDir = new File(tar);
        File hussarDir = new File(hussar);
        String zipFilePath = hussarDir.getAbsolutePath() + ExportResourceConstant._HUSSAR;
        int as = zipFilePath.lastIndexOf(File.separator) + 1;
        String tempPath = zipFilePath.substring(0, as) + appName + start;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tempPath", tempPath);
        map.put("filePath", zipFilePath);
        try {
            boolean wpdFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getVues()) || ToolUtil.isNotEmpty((Object)exportParamVO.getApis());
            boolean flowFlag = ToolUtil.isNotEmpty((Object)exportParamVO.getConfigs()) || ToolUtil.isNotEmpty((Object)exportParamVO.getPermissions());
            this.exportProjectStoreService.export(exportParamVO.getAppId(), projectStorePath, wpdFlag, flowFlag, false);
            String javaFilePathPrefix = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getPluginProjectPath(), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode), this.hussarAppExportProperties.getPluginPrefix() + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appExpansionName)});
            String pomPath = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, AppExportConstants.POM});
            String codePath = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.formDesignProperties.getJavaCodePath(), this.formDesignProperties.getJavaPath(), HussarBaseAppMixExportServiceImpl.getAppBackCodePrefixByAppId(appInfo)}) + expansion;
            String configPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.CONFIG});
            String servicePath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.SERVICE});
            String pluginExpansionPath = FileUtil.posixPath((String[])new String[]{codePath, AppExportConstants.paramExpansionPluginNoServiceName((String)tenantCode, (String)appName)});
            String serviceExpansionPath = FileUtil.posixPath((String[])new String[]{servicePath, AppExportConstants.expansionServicePluginNoServiceName((String)tenantCode, (String)appName)});
            String resourcesPath = FileUtil.posixPath((String[])new String[]{javaFilePathPrefix, this.hussarAppExportProperties.getResourcesPath()});
            this.copyFilesToTemp(exportParamVO.getJavas(), FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(pomPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(configPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(serviceExpansionPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(pluginExpansionPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(resourcesPath, FileUtil.addSuffix((String)javaFilePathPrefix), javaPath);
            this.copyFilesToTemp(exportParamVO.getMobileVues(), FileUtil.addSuffix((String)mobileVuePathPrefix), mobileVuePath);
            this.copyFilesToTemp(exportParamVO.getApis(), FileUtil.addSuffix((String)apiPathPrefix), apiPath);
            this.copyFilesToTemp(exportParamVO.getMobileApis(), FileUtil.addSuffix((String)mobileApiPathPrefix), mobileApiPath);
            this.copyFilesToTemp(exportParamVO.getMobileRouters(), FileUtil.addSuffix((String)mobileRouterPathPrefix), mobileRouterPath);
            Map tableStructureMap = this.exportTableService.exportTables(exportParamVO.getTableInfos());
            File tableStructureFile = new File(FileUtil.posixPath((String[])new String[]{tableInfoPath, ExportResourceConstant.TABLE_INFO_JSON}));
            FileUtils.writeByteArrayToFile((File)tableStructureFile, (byte[])SerializeUtils.serialize((Object)tableStructureMap));
            ExecutorService frontendPool = Executors.newCachedThreadPool();
            ExecutorService backendPool = Executors.newWorkStealingPool();
            CompletableFuture<Void> frontendFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.buildDistToTempExpansion(tenantCode, appName, this.hussarAppExportProperties.getFrontProjectPath(), vuePath);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, frontendPool);
            CompletableFuture<Void> backendFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.packageJavaCode(javaPath, tenantCode, appName, true);
                }
                catch (IOException | MavenInvocationException | XmlPullParserException e) {
                    throw new RuntimeException(e);
                }
            }, backendPool);
            CompletableFuture.allOf(frontendFuture, backendFuture).join();
            String appType = this.sysLowCodeAppExtendMapper.getMixAppTypeById(Long.valueOf(exportParamVO.getAppId()));
            WorkflowDumpAppDto workflowDumpAppDto = new WorkflowDumpAppDto();
            workflowDumpAppDto.setAppCode(appName);
            workflowDumpAppDto.setFilePath(workflowPath);
            workflowDumpAppDto.setAppType(appType);
            WorkflowAppMigrationService.dumpApp((WorkflowDumpAppDto)workflowDumpAppDto);
            this.zipAndDownload(tarDir, hussarDir, tenantCode, appName, hussar, response, 1, exportParamVO.getAppId(), tempPath);
            long end = System.currentTimeMillis();
            LOGGER.info("\u5bfc\u51fa\u81f3\u751f\u4ea7\u8017\u65f6========================>{}", (Object)String.format("%.3fs", (double)Math.abs(end - start) / 1000.0));
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51fa\u81f3\u751f\u4ea7\u73af\u5883\u51fa\u9519:{}", (Object)e.getMessage());
            FileUtils.deleteDirectory((File)hussarDir);
            throw new BaseException("\u5bfc\u51fa\u81f3\u751f\u4ea7\u73af\u5883\u51fa\u9519\uff01");
        }
        return map;
    }

    private void buildDistToTempExpansion(String tenantCode, String appName, String tarPath, String vuePath) throws Exception {
        if (tarPath.endsWith(File.separator)) {
            tarPath = tarPath.substring(0, tarPath.length() - 1);
        }
        String frontModuleName = "hussar-remote-" + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName);
        String frontAppPath = tarPath + VUE_PACKAGES_DIR + frontModuleName;
        if (0 != this.call(frontAppPath)) {
            throw new HussarException("\u524d\u7aef\u5e94\u7528\u6253\u5305\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff01");
        }
        String distPath = tarPath + VUE_PACKAGES_DIR + frontModuleName + VUE_DIST_DIR;
        String zipPath = tarPath + VUE_PACKAGES_DIR + frontModuleName + File.separator + VUE_DIST + ExportResourceConstant._HUSSAR;
        ZipUtil.zip(distPath, zipPath);
        this.copyDistZipToTemp(zipPath, vuePath);
    }

    private void addExpansionJavaFile(SysLowCodeAppExtend appInfo, String moduleClassFilePath, List<JSONObject> classFileObjects) {
        File[] appClassFile = new File(moduleClassFilePath).listFiles();
        this.iterateFiles(classFileObjects, appClassFile, moduleClassFilePath, classFile -> {
            String removePrefix = FileUtil.removePrefix((String)File.separator, (String)classFile.getAbsolutePath().substring(FileUtil.removePrefix((String)File.separator, (String)moduleClassFilePath).length()));
            String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
            return AppExportConstants.CONFIG.equals(removePrefix) || removePrefix.contains(AppExportConstants.expansionServicePluginNoServiceName((String)tenantCode, (String)appInfo.getAppEnglishName())) || AppExportConstants.paramExpansionPluginNoServiceName((String)tenantCode, (String)appInfo.getAppEnglishName()).equals(removePrefix);
        });
    }

    private void expansionZipAndDownload(File tarDir, File hussarDir, String tenantCode, String appName, String hussar, HttpServletResponse response, int importType, String tempPath) throws Exception {
        String tarPath = tarDir.getAbsolutePath() + ExportResourceConstant._TAR;
        File[] files = tarDir.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            List<String> filePaths = Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.toList());
            TarUtil.execute(filePaths, tarPath);
        }
        FileUtils.deleteDirectory((File)tarDir);
        HussarTenantDefinition tenantDefinition = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
        JSONObject meta = new JSONObject();
        meta.put("tenantId", (Object)tenantCode);
        meta.put("appName", (Object)appName);
        meta.put("javaPath", (Object)this.formDesignProperties.getJavaPath());
        meta.put("ds", (Object)(tenantDefinition == null ? "master" : tenantDefinition.getConnName()));
        meta.put("importType", (Object)importType);
        meta.put("sign", (Object)ZipUtil.getMd5(tarPath));
        meta.put("version", (Object)this.hussarAppExportProperties.getVersion());
        File metaFile = new File(FileUtil.posixPath((String[])new String[]{hussar, ExportResourceConstant.META_JSON}));
        FileUtils.writeByteArrayToFile((File)metaFile, (byte[])SerializeUtils.serialize((Object)meta));
        this.zipFile(hussarDir, ExportResourceConstant._HUSSAR, tempPath);
    }

    private static void copyToDirectoryNotExpansion(File srcDir, File destDir, String expansionPlugin, String expansionServicePlugin) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (AppExportConstants.CONFIG.equals(file.getName()) || expansionPlugin.equals(file.getName()) || expansionServicePlugin.equals(file.getName())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectory(File srcDir, File destDir) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectoryButNotPlugin(File srcDir, File destDir, String pluginApplicationName, String appStoreName) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (AppExportConstants.CONFIG.equals(file.getName()) || pluginApplicationName.equals(file.getName()) || appStoreName.equalsIgnoreCase(file.getName())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private static void copyToDirectoryButNotContains(File srcDir, File destDir, String appStoreName) throws IOException {
        for (File file : Objects.requireNonNull(srcDir.listFiles())) {
            if (appStoreName.equalsIgnoreCase(file.getName()) || "prefixCommon.js".equalsIgnoreCase(file.getName())) continue;
            if (file.isDirectory()) {
                FileUtils.copyDirectoryToDirectory((File)file, (File)destDir);
                continue;
            }
            FileUtils.copyFileToDirectory((File)file, (File)destDir);
        }
    }

    private void copyFilesToTemp(String absolutePaths, String prefix, String tempPath) throws IOException {
        if (ToolUtil.isNotEmpty((Object)absolutePaths)) {
            List codeFilePaths = ToolUtil.stringToList((String)absolutePaths);
            for (String path : codeFilePaths) {
                File file = new File(path);
                if (!file.exists()) continue;
                String relativePath = path.substring(prefix.length() - 1, path.length() - file.getName().length());
                File tempDir = new File(FileUtil.posixPath((String[])new String[]{tempPath, relativePath}));
                this.mkdir(tempDir);
                if (file.isDirectory()) {
                    FileUtils.copyDirectoryToDirectory((File)file, (File)tempDir);
                    continue;
                }
                FileUtils.copyFileToDirectory((File)file, (File)tempDir);
            }
        }
    }

    private void zipAndDownload(File tarDir, File hussarDir, String tenantId, String appName, String hussar, HttpServletResponse response, int importType, String appId, String tempPath) throws Exception {
        String tarPath = tarDir.getAbsolutePath() + ExportResourceConstant._TAR;
        File[] files = tarDir.listFiles();
        if (ToolUtil.isNotEmpty((Object)files)) {
            List<String> filePaths = Arrays.stream(files).map(File::getAbsolutePath).collect(Collectors.toList());
            TarUtil.execute(filePaths, tarPath);
        }
        FileUtils.deleteDirectory((File)tarDir);
        String codePath = FileUtil.posixPath((String[])new String[]{this.hussarAppExportProperties.getAbsoluteOfflineWorkspaceRoot(), appId, this.formDesignProperties.getProjectRootPath(), this.formDesignProperties.getProjectCodePath()});
        File[] codeFiles = new File(codePath).listFiles();
        HashMap<String, String> metaInfo = new HashMap<String, String>();
        if (ToolUtil.isNotEmpty((Object)codeFiles)) {
            for (File file : codeFiles) {
                if (!file.getName().endsWith(".meta") || file.getName().contains("appsStore")) continue;
                long fileLength = file.length();
                byte[] fileContent = new byte[(int)fileLength];
                try (FileInputStream in = null;){
                    in = new FileInputStream(file);
                    in.read(fileContent);
                }
                JSONObject modelObject = JSON.parseObject((String)new String(fileContent, StandardCharsets.UTF_8));
                metaInfo.put(file.getName(), modelObject.getString("id"));
            }
        }
        HussarTenantDefinition tenantDefinition = this.hussarBaseTenantService.getTenantByTenantCode(tenantId);
        JSONObject meta = new JSONObject();
        meta.put("tenantId", (Object)tenantId);
        meta.put("appName", (Object)appName);
        meta.put("javaPath", (Object)this.formDesignProperties.getJavaPath());
        meta.put("ds", (Object)(tenantDefinition == null ? "master" : tenantDefinition.getConnName()));
        meta.put("appId", (Object)appId);
        meta.put("importType", (Object)importType);
        meta.put("sign", (Object)ZipUtil.getMd5(tarPath));
        meta.put("version", (Object)this.hussarAppExportProperties.getVersion());
        meta.put("metaInfo", metaInfo);
        File metaFile = new File(FileUtil.posixPath((String[])new String[]{hussar, ExportResourceConstant.META_JSON}));
        FileUtils.writeByteArrayToFile((File)metaFile, (byte[])SerializeUtils.serialize((Object)meta));
        this.zipFile(hussarDir, ExportResourceConstant._HUSSAR, tempPath);
    }

    public void mkdir(File ... files) throws IOException {
        for (File file : files) {
            if (file.exists()) continue;
            FileUtils.forceMkdir((File)file);
        }
    }

    public void zipFile(File zipTempFile, String zipSuffix, String tempPath) throws Exception {
        String zipFilePath = zipTempFile.getAbsolutePath() + zipSuffix;
        File zipFile = new File(zipFilePath);
        if (!zipFile.exists()) {
            zipFile.getParentFile().mkdir();
        }
        ZipUtil.zip(zipTempFile.getAbsolutePath(), zipFilePath);
        File file = new File(tempPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileUtils.deleteDirectory((File)zipTempFile);
    }

    private String getAppStoreName(String appId) {
        StorageResult storageResult = (StorageResult)this.storageContext.with(null, appId, null, () -> this.storageService.downloadByUuid(CategoryEnum.META, "d37c273c-d0ca-4f46-a1b1-0aa62754dcb3"));
        byte[] resultData = (byte[])storageResult.getData();
        Optional<Object> data = Optional.ofNullable(storageResult.getData());
        if (data.isPresent()) {
            JSONObject jsonObject = JSON.parseObject((String)new String((byte[])data.get(), StandardCharsets.UTF_8));
            return (String)jsonObject.get((Object)"name");
        }
        return expansion;
    }

    private void exportFunResMenu(String path, Long appId) throws IOException {
        Set parentMenuIds;
        List sysFunctions = this.sysFunctionsBoService.listByAppId(appId);
        List sysFunctionModules = this.sysFunctionModulesBoService.listByAppId(appId);
        List sysResources = this.baseResourceBoService.getResListByAppId(appId);
        List sysResourceModules = this.sysResourceMosulesBoService.getListByAppId(appId);
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List resourceIds = sysResources.stream().map(SysResources::getId).collect(Collectors.toList());
        List sysFunctionResources = Lists.newArrayList();
        if (HussarUtils.isNotEmpty(functionIds) && HussarUtils.isNotEmpty(resourceIds)) {
            QueryFunAndResDto queryFunAndResDto = new QueryFunAndResDto();
            queryFunAndResDto.setFunIds(functionIds);
            queryFunAndResDto.setResIds(resourceIds);
            sysFunctionResources = this.sysFunctionResourcesBoService.getListByFunAndRes(queryFunAndResDto);
        }
        List sysMenus = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)sysFunctions)) {
            List functionsIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
            sysMenus = this.sysMenuManageBoService.getListByFunIds(functionsIds);
        }
        if (HussarUtils.isNotEmpty(sysMenus) && HussarUtils.isNotEmpty(parentMenuIds = sysMenus.stream().map(SysMenu::getParentId).collect(Collectors.toSet()))) {
            sysMenus.addAll(this.sysMenuManageBoService.getListByIds(parentMenuIds));
        }
        HashMap data = new HashMap();
        data.put("sysFunctions", sysFunctions);
        data.put("sysFunctionModules", sysFunctionModules);
        data.put("sysResources", sysResources);
        data.put("sysResourceModules", sysResourceModules);
        data.put("sysFunctionResources", sysFunctionResources);
        data.put("sysMenus", sysMenus);
        FileUtils.writeByteArrayToFile((File)new File(FileUtil.posixPath((String[])new String[]{path, AppExportConstants.FUN_RES_MENU_JSON})), (byte[])SerializeUtils.serialize(data));
    }

    private void packageJavaCode(String javaPath, String tenantCode, String appName, Boolean extension) throws MavenInvocationException, IOException, XmlPullParserException {
        File jar;
        String parentPom = FileUtil.posixPath((String[])new String[]{javaPath, "pom.xml"});
        MavenUtil.modulePackage(new File(parentPom));
        String pluginPrefix = this.hussarBasePluginProperties.getPluginPrefix();
        String appPomPath = javaPath + File.separator + pluginPrefix + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName) + "-application";
        String appPom = FileUtil.posixPath((String[])new String[]{appPomPath, "pom.xml"});
        if (extension.booleanValue()) {
            appPomPath = javaPath;
            appPom = parentPom;
        }
        MavenXpp3Reader reader = new MavenXpp3Reader();
        try (FileInputStream fis = new FileInputStream(appPom);){
            String finalName;
            Model model = reader.read((InputStream)fis);
            Build build = model.getBuild();
            String string = finalName = build == null ? expansion : build.getFinalName();
            if (HussarUtils.isNotEmpty((Object)finalName)) {
                jar = new File(new File(appPomPath, "target"), finalName + ".jar");
            } else {
                String moduleId = model.getArtifactId();
                jar = new File(new File(appPomPath, "target"), moduleId + ".jar");
            }
        }
        File renameFile = new File(new File(appPomPath, "target"), "pluginJar.jar");
        jar.renameTo(renameFile);
        File destFile = new File(javaPath, renameFile.getName());
        FileUtils.copyFile((File)renameFile, (File)destFile);
        this.cleanDirectoryExcept(new File(javaPath), renameFile.getName());
    }

    private void buildDistToTemp(String tenantCode, String appName, String tarPath, String vuePath) throws Exception {
        if (tarPath.endsWith(File.separator)) {
            tarPath = tarPath.substring(0, tarPath.length() - 1);
        }
        String frontModuleName = "hussar-remote-" + AppContextUtil.asIdentifier((String)tenantCode) + "-" + AppContextUtil.asIdentifier((String)appName);
        String frontAppPath = tarPath + VUE_PACKAGES_DIR + frontModuleName;
        if (0 != this.call(frontAppPath)) {
            throw new HussarException("\u524d\u7aef\u5e94\u7528\u6253\u5305\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\uff01");
        }
        String distPath = tarPath + VUE_PACKAGES_DIR + frontModuleName + VUE_DIST_DIR;
        String zipPath = tarPath + VUE_PACKAGES_DIR + frontModuleName + File.separator + VUE_DIST + ExportResourceConstant._HUSSAR;
        ZipUtil.zip(distPath, zipPath);
        this.copyDistZipToTemp(zipPath, vuePath);
    }

    private void cleanDirectoryExcept(File parentDir, String fileName) throws IOException {
        File[] files = parentDir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isFile() && file.getName().equals(fileName)) continue;
            if (file.isDirectory()) {
                this.deleteRecursively(file);
                continue;
            }
            FileUtils.delete((File)file);
        }
    }

    private void deleteRecursively(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File subFile : files) {
                if (subFile.isDirectory()) {
                    this.deleteRecursively(subFile);
                    continue;
                }
                FileUtils.delete((File)subFile);
            }
        }
        FileUtils.deleteDirectory((File)dir);
    }

    private void copyDistZipToTemp(String zpiPath, String tempPath) throws IOException {
        File file;
        if (ToolUtil.isNotEmpty((Object)zpiPath) && (file = new File(zpiPath)).exists()) {
            File tempDir = new File(FileUtil.posixPath((String[])new String[]{tempPath}));
            if (!tempDir.exists()) {
                this.mkdir(tempDir);
            }
            FileUtils.copyFileToDirectory((File)file, (File)tempDir);
            file.delete();
        }
    }

    public Integer call(String frontAppPath) {
        ArrayList<String> command = new ArrayList<String>();
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            command.add("cmd");
            command.add("/c");
            command.add("npm.cmd");
        } else {
            command.add("npm");
        }
        command.add("run");
        command.add("build");
        try {
            String line;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            File directory = new File(frontAppPath);
            if (!directory.exists()) {
                return 0;
            }
            processBuilder.directory(directory);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                LOGGER.info("[Npm Build] {}", (Object)line);
            }
            return process.waitFor();
        }
        catch (Exception e) {
            throw new HussarException((Throwable)e);
        }
    }
}

