/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.properties;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="production")
public class HussarProduceProperties {
    static final String Produce_PREFIX = "production";
    @Value(value="${hussar-formdesign.front-project-path:E:/hussar-front/}")
    private String frontPath;
    @Value(value="${hussar-formdesign.back-project-path:E:/hussar-web/}")
    private String webPath;
    private String WEBINFO = "WEB-INF";
    private String javaPath = this.WEBINFO + File.separator + "classes" + File.separator;
    private String staticPath = this.webPath + File.separator + "target" + File.separator + "classes" + File.separator + "static";
    private String packagePath = "http://localhost:8989/";
    @Value(value="${plugin.pluginPath:E:/hussar-plugin/}")
    private String pluginPath;
    private Boolean isSyncToProduce;
    private String producePath = "http://localhost:8081";
    @Value(value="${hussar-formdesign.workspace:c:/}")
    private String workspace;

    public String getFrontPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.frontPath));
    }

    public void setFrontPath(String frontPath) {
        this.frontPath = this.buildPath(frontPath);
    }

    public String getWebPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.webPath));
    }

    public void setWebPath(String webPath) {
        this.webPath = this.buildPath(webPath);
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = this.buildPath(javaPath);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public void setPackagePath(String packagePath) {
        this.packagePath = this.buildPath(packagePath);
    }

    public String getStaticPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.staticPath));
    }

    public void setStaticPath(String staticPath) {
        this.staticPath = this.buildPath(staticPath);
    }

    public String getPluginPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.pluginPath));
    }

    public void setPluginPath(String pluginPath) {
        this.pluginPath = this.buildPath(pluginPath);
    }

    private String buildPath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public Boolean getIsSyncToProduce() {
        return this.isSyncToProduce;
    }

    public void setIsSyncToProduce(Boolean syncToProduce) {
        this.isSyncToProduce = syncToProduce;
    }

    public String getProducePath() {
        return this.producePath;
    }

    public void setProducePath(String producePath) {
        this.producePath = this.buildPath(producePath);
    }
}

