/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.applicationmix.properties;

import com.jxdinfo.hussar.formdesign.common.util.ToolUtil;
import java.io.File;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="plugin")
public class HussarAppExportProperties {
    public static final String PREFIX = "plugin";
    public static final String views = "views";
    private String api = "api";
    @Value(value="${hussar-formdesign.back-project-path:hussar-web}")
    private String backProjectPath;
    @Value(value="${hussar-formdesign.back-project-plugin:hussar-plugins}")
    private String backProjectPlugin;
    private String pluginPrefix = "hussar-";
    @Value(value="${hussar-formdesign.version:v1.0.0}")
    private String version;
    @Value(value="${hussar-formdesign.resources-path:/src/main/resources}")
    private String resourcesPath;
    @Value(value="${hussar-formdesign.front-project-path:hussar-front}")
    private String frontProjectPath;
    @Value(value="${hussar-formdesign.mobile-front-project-path:hussar-mobile}")
    private String mobileFrontProjectPath;
    @Value(value="${hussar-formdesign.vue-code-path:/src/pages/index}")
    private String vueCodePath;
    @Value(value="${hussar-formdesign.mobile-vue-code-path:/src/views}")
    private String mobileVueCodePath;
    @Value(value="${hussar-formdesign.front-api-path:/src/pages/index}")
    private String frontApiPath;
    @Value(value="${hussar-formdesign.mobile-front-api-path:/src/api}")
    private String mobileFrontApiPath;
    @Value(value="${hussar-formdesign.mobile-front-router-path:/src/router}")
    private String mobileFrontRouterPath;
    @Value(value="${hussar-formdesign.workspace:c:/}")
    private String workspace;
    private String offlineWorkspaceRoot = ".workspaces";

    public String getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        if (workspace.length() > 0 && !workspace.endsWith(File.separator)) {
            workspace = workspace + File.separator;
        }
        this.workspace = workspace;
    }

    public String getProjectPath() {
        return this.getBackProjectPath();
    }

    public String getBackProjectPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.backProjectPath));
    }

    public String getPluginProjectPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.backProjectPlugin));
    }

    public void setBackProjectPath(String backProjectPath) {
        this.backProjectPath = backProjectPath;
    }

    public String getFrontProjectPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.frontProjectPath));
    }

    public void setFrontProjectPath(String frontProjectPath) {
        this.frontProjectPath = frontProjectPath;
    }

    public String getMobProjectPath() {
        return this.mobileFrontProjectPath;
    }

    public String getMobileFrontProjectPath() {
        return ToolUtil.pathFomatterByOS((String)(this.workspace + this.mobileFrontProjectPath));
    }

    public void setMobileFrontProjectPath(String mobileFrontProjectPath) {
        this.mobileFrontProjectPath = mobileFrontProjectPath;
    }

    public String getVueCodePath() {
        return this.vueCodePath;
    }

    public String getMobileVueCodePath() {
        return this.mobileVueCodePath;
    }

    public String getFrontApiPath() {
        return this.frontApiPath;
    }

    public String getMobileFrontApiPath() {
        return this.mobileFrontApiPath;
    }

    public void setMobileFrontApiPath(String mobileFrontApiPath) {
        this.mobileFrontApiPath = mobileFrontApiPath;
    }

    public String getBackProjectPlugin() {
        return this.backProjectPlugin;
    }

    public void setBackProjectPlugin(String backProjectPlugin) {
        this.backProjectPlugin = backProjectPlugin;
    }

    public String getPluginPrefix() {
        return this.pluginPrefix;
    }

    public void setPluginPrefix(String pluginPrefix) {
        this.pluginPrefix = pluginPrefix;
    }

    public String getMobileFrontApiAbPath() {
        return ToolUtil.pathFomatterByOS((String)(this.getMobileFrontProjectPath() + this.mobileFrontApiPath));
    }

    public String getMobileFrontRouterAbPath() {
        return ToolUtil.pathFomatterByOS((String)(this.getMobileFrontProjectPath() + this.mobileFrontRouterPath));
    }

    public String getOfflineWorkspaceRoot() {
        return this.offlineWorkspaceRoot;
    }

    public void setOfflineWorkspaceRoot(String offlineWorkspaceRoot) {
        this.offlineWorkspaceRoot = offlineWorkspaceRoot;
    }

    public String getMobileFrontRouterPath() {
        return this.mobileFrontRouterPath;
    }

    public void setMobileFrontRouterPath(String mobileFrontRouterPath) {
        this.mobileFrontRouterPath = mobileFrontRouterPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getResourcesPath() {
        return this.resourcesPath;
    }

    public void setResourcesPath(String resourcesPath) {
        this.resourcesPath = resourcesPath;
    }

    public String getAbsoluteOfflineWorkspaceRoot() {
        return new File(this.getBackProjectPath(), this.offlineWorkspaceRoot).getPath();
    }
}

