/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.application.constant.TenantAppConstant;
import com.jxdinfo.hussar.application.constant.UserEnvStatus;
import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.SysApplicationDto;
import com.jxdinfo.hussar.application.model.ExportAppFilePath;
import com.jxdinfo.hussar.application.model.ImportAppInfo;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.model.SysApplicationRecord;
import com.jxdinfo.hussar.application.model.UserDevEnv;
import com.jxdinfo.hussar.application.properties.HussarTemplateFileProperties;
import com.jxdinfo.hussar.application.properties.UserEvnProperties;
import com.jxdinfo.hussar.application.service.IHussarApplicationService;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppOperationLogService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.service.IUserDevEnvService;
import com.jxdinfo.hussar.application.service.IUserEnvPortService;
import com.jxdinfo.hussar.application.tool.annotation.ExportProgressCache;
import com.jxdinfo.hussar.application.tool.annotation.ImportProgressCache;
import com.jxdinfo.hussar.application.tool.aspect.ImportProgressCacheAspect;
import com.jxdinfo.hussar.application.tool.threadHolder.TransmittableThreadLocalHolder;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.menu.constant.MenuConstants;
import com.jxdinfo.hussar.authorization.menu.model.SysMenu;
import com.jxdinfo.hussar.authorization.menu.service.impl.SysMenuManageServiceImpl;
import com.jxdinfo.hussar.authorization.permit.constants.PermitConstants;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionModules;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctionResources;
import com.jxdinfo.hussar.authorization.permit.model.SysFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysResourceModules;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleFunctions;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleGroup;
import com.jxdinfo.hussar.authorization.permit.model.SysRoleResource;
import com.jxdinfo.hussar.authorization.permit.model.SysRoles;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.model.SysUsersAdditionalInfo;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionModulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourceMosulesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleFunctionsService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleGroupService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRoleResourceService;
import com.jxdinfo.hussar.authorization.permit.service.ISysRolesService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersAddtionalInfoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.code.plus.model.SysCodeRule;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleService;
import com.jxdinfo.hussar.common.base.HussarBaseMultipartFile;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.SerializeUtils;
import com.jxdinfo.hussar.core.config.HussarConfig;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.deploy.dto.DeployGitDto;
import com.jxdinfo.hussar.deploy.service.IHussarDeployService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.model.GitDto;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.service.IGitlabService;
import com.jxdinfo.hussar.formdesign.devtools.gitlab.util.GitlabUtil;
import com.jxdinfo.hussar.general.dict.constant.DictMigrationConstants;
import com.jxdinfo.hussar.general.dict.model.DicGroup;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicGroupService;
import com.jxdinfo.hussar.general.dict.service.ISysDicSingleService;
import com.jxdinfo.hussar.general.dict.service.ISysDicTypeService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.thread.config.HussarThreadPoolConfiguration;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.tenant.common.model.HussarTenantDefinition;
import com.jxdinfo.hussar.tenant.common.model.SysTenant;
import com.jxdinfo.hussar.tenant.common.service.IHussarBaseTenantService;
import com.jxdinfo.hussar.tenant.common.service.ISysTenantService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.TenantApplicationServiceImpl")
public class TenantApplicationServiceImpl
implements IHussarApplicationService {
    private static Logger logger = LoggerFactory.getLogger(TenantApplicationServiceImpl.class);
    private static final String DEPEN_TAG = "</dependencies>";
    private static final String MODULE_TAG = "</modules>";
    private static final String START_AUTO = "hussar.user-env.startAuto";
    private static final String MODULE_STR = "module";
    private static final String DEPENDENCIES_STR = "dependencies";
    private static final String PASSWORD_STR = "password";
    private static final String APP_ID = "appId";
    private static final String APP_CODE = "appCode";
    private static final String APP_NAME = "appName";
    private static final String APP_GROUP = "appGroup";
    private static final String APP_ICON = "appIcon";
    private static final String APP_ICON_COLOR = "appIconColor";
    private static final String APP_ICON_TYPE = "appIconType";
    private static final String DATETIME_PATTERN = "yyyyMMdd_HHmmss";
    private static final String MERGE_DEVELOP_TO_PERSONAL_BRANCH = "\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f";
    private static final String GIT_PULL_FAIL = "git\u62c9\u53d6\u5931\u8d25";
    private static final String ENCRYPT_FLAG = "encryptFlag";
    private static final String FRONT = "front";
    private static final String MOBILE = "mobile";
    @Resource
    private HussarTemplateFileProperties templateFileProperties;
    @Value(value="${spring.cloud.nacos.discovery.server-addr:localhost:8848}")
    private String serverAddr;
    @Value(value="${spring.cloud.nacos.discovery.namespace:public}")
    private String namespace;
    @Resource
    private ISysResourceMosulesService resourceMosulesService;
    @Resource
    private ISysFunctionModulesService functionModulesService;
    @Resource
    private ISysDicGroupService dicGroupService;
    @Resource
    private ISysDicTypeService sysDicTypeService;
    @Resource
    private ISysDicSingleService sysDicSingleService;
    @Resource
    private ISysRoleGroupService roleGroupService;
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysFunctionsService sysFunctionsService;
    @Resource
    private ISysResourcesService sysResourcesService;
    @Resource
    private ISysRolesService sysRolesService;
    @Resource
    private ISysCodeRuleService sysCodeRuleService;
    @Resource
    private SysMenuManageServiceImpl sysMenuService;
    @Resource
    private ISysFunctionResourcesService sysFunctionResourcesService;
    @Resource
    private ISysRoleFunctionsService sysRoleFunctionsService;
    @Resource
    private ISysRoleResourceService sysRoleResourceService;
    @Resource
    private OssService ossService;
    @Resource
    private HussarThreadPoolConfiguration hussarThreadPoolConfiguration;
    @Autowired(required=false)
    private IHussarBaseTenantService hussarBaseTenantService;
    @Resource
    private ISysApplicationRecordService sysApplicationRecordService;
    @Resource
    private IUserDevEnvService userDevEnvService;
    @Resource
    private IHussarDeployService hussarDeployService;
    @Resource
    private IUserEnvPortService userEnvPortService;
    @Autowired(required=false)
    private ISysTenantService sysTenantService;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Autowired
    private ISysAppOperationLogService sysAppOperationLogService;
    @Autowired
    private ISysAppRecycleService sysAppRecycleService;
    @Resource
    private ISysUsersAddtionalInfoService sysUsersAddtionalInfoService;
    @Resource
    private UserEvnProperties userEvnProperties;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private IGitlabService gitlabServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAppToGit(SysApplication app) {
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        String tenantCode = userDetails.getTenantCode();
        this.initFormDesignServer(app, tenantCode);
        String localRepPath = this.templateFileProperties.getTenantPath();
        localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
        try {
            File gitPush = Files.createTempDirectory("git_push_", new FileAttribute[0]).toFile();
            FileUtils.copyDirectory((File)new File(localRepPath), (File)gitPush);
            try {
                GitDto gitDto = new GitDto();
                gitDto.setBranch(this.templateFileProperties.getBranch());
                gitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"APP_LOW_ADD_APP_UPDATE_FOLDER", (String)"\u65b0\u5efa\u5e94\u7528\uff0c\u66f4\u65b0\u76ee\u5f55"));
                gitDto.setPath(gitPush.getPath());
                gitDto.setTenantCode(tenantCode);
                HussarTenantDefinition tenantByTenantCode = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
                gitDto.setGitUri(tenantByTenantCode.getGitUrl());
                SecurityUser user = BaseSecurityUtil.getUser();
                SysUsersAdditionalInfo sysUsersAdditionalInfo = (SysUsersAdditionalInfo)this.sysUsersAddtionalInfoService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsersAdditionalInfo::getUserId, (Object)user.getId()));
                String userAcccessToken = null;
                if (HussarUtils.isNotEmpty((Object)sysUsersAdditionalInfo)) {
                    userAcccessToken = sysUsersAdditionalInfo.getGitToken();
                }
                String acccessToken = HussarUtils.isNotEmpty(userAcccessToken) ? userAcccessToken : tenantByTenantCode.getGitToken();
                gitDto.setAccessToken(acccessToken);
                GitlabUtil.pushToGit((GitDto)gitDto);
            }
            finally {
                FileUtils.deleteDirectory((File)gitPush);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ApiResponse<String> getCurrentBranch() {
        return this.hussarDeployService.getCurrentBranch();
    }

    public ApiResponse<List<String>> getAllBranch() {
        return this.hussarDeployService.getAllBranch();
    }

    public ApiResponse<String> checkoutBranchAndPull(String branch) throws HussarException {
        return this.hussarDeployService.checkoutBranchAndPull(branch);
    }

    public ApiResponse<Boolean> localProjectExist() {
        return this.hussarDeployService.localProjectExist();
    }

    public void createAppGroup(SysApplication app) {
        Integer resourceModulesSeq = ((LambdaQueryChainWrapper)this.resourceMosulesService.lambdaQuery().eq(SysResourceModules::getParentModuleId, (Object)PermitConstants.ROOT_PORTAL)).list().stream().max(Comparator.comparing(SysResourceModules::getSeq)).map(SysResourceModules::getSeq).orElse(9);
        SysResourceModules resourceModules = new SysResourceModules();
        resourceModules.setModuleName(app.getAppName());
        resourceModules.setAppId(app.getId());
        resourceModules.setModuleCode(app.getAppCode());
        resourceModules.setParentModuleId(PermitConstants.ROOT_PORTAL);
        resourceModules.setSeq(Integer.valueOf(resourceModulesSeq + 1));
        this.resourceMosulesService.save((Object)resourceModules);
        Integer functionModulesSeq = ((LambdaQueryChainWrapper)this.functionModulesService.lambdaQuery().eq(SysFunctionModules::getParentModuleId, (Object)PermitConstants.ROOT_PORTAL)).list().stream().max(Comparator.comparing(SysFunctionModules::getSeq)).map(SysFunctionModules::getSeq).orElse(12);
        SysFunctionModules functionModules = new SysFunctionModules();
        functionModules.setAppId(app.getId());
        functionModules.setFunctionModuleName(app.getAppName());
        functionModules.setFunctionModuleCode(app.getAppCode());
        functionModules.setParentModuleId(PermitConstants.ROOT_PORTAL);
        functionModules.setSeq(Integer.valueOf(functionModulesSeq + 1));
        this.functionModulesService.save((Object)functionModules);
        DicGroup dicGroup = new DicGroup();
        dicGroup.setRangeType("dict");
        dicGroup.setParentId(DictMigrationConstants.ID_DICT_ROOT);
        dicGroup.setGroupDescription(app.getAppName());
        dicGroup.setAppId(app.getId());
        DicGroup lastOne = (DicGroup)this.dicGroupService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DicGroup::getParentId, (Object)dicGroup.getParentId())).orderByDesc(DicGroup::getSort), false);
        if (ToolUtil.isEmpty((Object)lastOne)) {
            dicGroup.setSort(Integer.valueOf(3));
        } else {
            dicGroup.setSort(Integer.valueOf(lastOne.getSort() + 1));
        }
        this.dicGroupService.save((Object)dicGroup);
        Integer roleGroupSeq = ((LambdaQueryChainWrapper)this.roleGroupService.lambdaQuery().eq(SysRoleGroup::getParentId, (Object)Constants.ROLE_ROOT_ID)).list().stream().max(Comparator.comparing(SysRoleGroup::getGroupOrder)).map(SysRoleGroup::getGroupOrder).orElse(4);
        SysRoleGroup roleGroup = new SysRoleGroup();
        roleGroup.setGroupName(app.getAppName());
        roleGroup.setGroupAlias(app.getAppName());
        roleGroup.setFromAppId(app.getId());
        roleGroup.setParentId(Constants.ROLE_ROOT_ID);
        roleGroup.setGroupOrder(Integer.valueOf(roleGroupSeq + 1));
        roleGroup.setIsSys("0");
        this.roleGroupService.save((Object)roleGroup);
        Integer sysMenuSeq = ((LambdaQueryChainWrapper)this.sysMenuService.lambdaQuery().eq(SysMenu::getParentId, (Object)MenuConstants.MENU_PORTAL)).list().stream().max(Comparator.comparing(SysMenu::getSeq)).map(SysMenu::getSeq).orElse(11);
        SysMenu sysMenu = new SysMenu();
        sysMenu.setId(app.getId());
        sysMenu.setText(app.getAppName());
        sysMenu.setMenuAlias(app.getAppName());
        sysMenu.setParentId(MenuConstants.MENU_PORTAL);
        sysMenu.setSeq(Integer.valueOf(sysMenuSeq + 1));
        sysMenu.setIsLeaf("0");
        sysMenu.setIcons("caidan-1Jmoren");
        sysMenu.setOpenType("inside");
        sysMenu.setMenuType("1");
        sysMenu.setCreateTime(LocalDateTime.now());
        sysMenu.setLastTime(LocalDateTime.now());
        sysMenu.setOpenMode("0");
        this.sysMenuService.save((BaseEntity)sysMenu);
    }

    private void initFormDesignServer(SysApplication app, String tenantCode) {
        String tenantPath = this.templateFileProperties.getTenantPath();
        String templateBack = this.templateFileProperties.getTemplateBack();
        String templateFront = this.templateFileProperties.getTemplateFront();
        String templateFilePath = this.templateFileProperties.getTemplateFilePath();
        String frontStartModule = this.templateFileProperties.getFrontStartModule();
        String appCode = app.getAppCode();
        String envPath = tenantPath + templateBack;
        envPath = envPath.replace("{tenantCode}", tenantCode);
        String serverPath = envPath + File.separator + appCode;
        File dir = new File(serverPath);
        dir.mkdirs();
        String frontPath = tenantPath + templateFront;
        String frontServerPath = frontPath.replace("{tenantCode}", tenantCode);
        frontServerPath = frontServerPath + File.separator + "apps" + File.separator + appCode;
        File frontDir = new File(frontServerPath);
        frontDir.mkdirs();
        String templateDir = templateFilePath + templateBack + File.separator + "${appCode}";
        String frontTemplateDir = templateFilePath + templateFront + File.separator + "apps" + File.separator + "${appCode}";
        String placeholder = "${appCode}";
        try {
            File src = new File(templateDir);
            File frontTemplate = new File(frontTemplateDir);
            this.copyFolder(frontTemplate, frontDir);
            this.copyFolder(src, dir);
            this.renameFilesAndDirectories(Paths.get(serverPath, new String[0]), placeholder, appCode);
            this.renameFilesAndDirectories(Paths.get(frontServerPath, new String[0]), placeholder, appCode);
        }
        catch (IOException e) {
            logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_COPY_FILE_ERROR", (String)"\u590d\u5236\u6587\u4ef6\u51fa\u9519:{}"), (Object)e.getMessage());
        }
        this.replaceAppCodeInFiles(serverPath, placeholder, appCode);
        this.replaceAppCodeInFiles(serverPath, "${tenantCode}", tenantCode);
        this.replaceAppCodeInFiles(frontServerPath + File.separator + TenantAppConstant.PACKAGE_JSON, placeholder, appCode);
        String appCodeLower = appCode.toLowerCase();
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(File.separator).append("${appCode}-server").append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("java").append(File.separator).append("com").append(File.separator).append("jxdinfo").append(File.separator).append("hussar").append(File.separator).append("cloud").append(File.separator).append(MODULE_STR);
        String longPath = pathBuilder.toString();
        StringBuilder pathBuilder2 = new StringBuilder();
        pathBuilder2.append(File.separator).append("${appCode}-server").append(File.separator).append("src").append(File.separator).append("main").append(File.separator).append("resources").append(File.separator).append("META-INF").append(File.separator).append("spring.factories");
        String longPath2 = pathBuilder2.toString();
        String modulePathServer = (serverPath + longPath).replace("${appCode}", appCode);
        String springPath = (serverPath + longPath2).replace("${appCode}", appCode);
        this.replaceAppCodeInFiles(springPath, appCode, appCodeLower);
        this.replaceAppCodeInFiles(modulePathServer + File.separator + appCode, appCode, appCodeLower);
        this.processFile(Paths.get(modulePathServer + File.separator + appCode, new String[0]), appCode, "${appCode}");
        this.processFile(Paths.get(modulePathServer + File.separator + "${appCode}", new String[0]), "${appCode}", appCodeLower);
        String modulePathFeign = (serverPath + longPath.replace("server", "feign")).replace("${appCode}", appCode);
        this.replaceAppCodeInFiles(modulePathFeign + File.separator + appCode, appCode, appCodeLower);
        this.processFile(Paths.get(modulePathFeign + File.separator + appCode, new String[0]), appCode, "${appCode}");
        this.processFile(Paths.get(modulePathFeign + File.separator + "${appCode}", new String[0]), "${appCode}", appCodeLower);
        String modulePathApi = (serverPath + longPath.replace("server", "api")).replace("${appCode}", appCode);
        this.replaceAppCodeInFiles(modulePathApi + File.separator + appCode, appCode, appCodeLower);
        this.processFile(Paths.get(modulePathApi + File.separator + appCode, new String[0]), appCode, "${appCode}");
        this.processFile(Paths.get(modulePathApi + File.separator + "${appCode}", new String[0]), "${appCode}", appCodeLower);
        frontPath = frontPath + frontStartModule + File.separator + TenantAppConstant.PACKAGE_JSON;
        frontPath = frontPath.replace("{tenantCode}", tenantCode);
        try {
            this.addDependencyToPackageJson(frontPath, appCode, "1.0.0-alpha.1");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String viewJsPath = tenantPath + templateFront + frontStartModule + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
        viewJsPath = viewJsPath.replace("{tenantCode}", tenantCode);
        this.insertAppView(appCode, viewJsPath);
        String workSpacePomPath = envPath + File.separator + "pom.xml";
        String pomVersion = this.getPomVersion(workSpacePomPath);
        Map<String, String> contentMap = this.getPomContent(pomVersion, appCode);
        this.updatePomContent(workSpacePomPath, contentMap.get("depen"), DEPEN_TAG);
        this.updatePomContent(workSpacePomPath, contentMap.get(MODULE_STR), MODULE_TAG);
    }

    public void insertAppView(String appCode, String jsFilePath) {
        try (BufferedReader reader = new BufferedReader(new FileReader(jsFilePath));){
            int endIndex;
            String line;
            StringBuilder sb = new StringBuilder();
            sb.append("import { allViews as ").append(appCode).append(" } from '").append(appCode).append("';\n\n");
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
            int exportIndex = sb.indexOf("export default {");
            if (exportIndex != -1) {
                endIndex = sb.indexOf("}", exportIndex);
                if (endIndex == -1) {
                    throw new RuntimeException("Cannot find closing brace for export default object.");
                }
            } else {
                throw new RuntimeException("Cannot find export default statement in the file.");
            }
            sb.insert(endIndex - 1, "\n  ..." + appCode + ",");
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(jsFilePath));){
                writer.write(sb.toString());
            }
            System.out.println("File updated successfully.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addDependencyToPackageJson(String packageJsonFilePath, String appCode, String version) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode root = objectMapper.readTree(new File(packageJsonFilePath));
        JsonNode dependenciesNode = root.get(DEPENDENCIES_STR);
        if (dependenciesNode == null || !dependenciesNode.isObject()) {
            ((ObjectNode)root).put(DEPENDENCIES_STR, (JsonNode)objectMapper.createObjectNode());
            dependenciesNode = root.get(DEPENDENCIES_STR);
        }
        ((ObjectNode)dependenciesNode).put(appCode, version);
        objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(packageJsonFilePath), (Object)root);
    }

    public void copyFolder(File src, File des) throws IOException {
        if (src.isDirectory()) {
            if (!des.exists()) {
                des.mkdir();
            }
            String[] children = src.list();
            assert (children != null);
            for (String child : children) {
                this.copyFolder(new File(src, child), new File(des, child));
            }
        } else {
            TenantApplicationServiceImpl.copyFile(src, des);
        }
    }

    public List<String> getAllBranches() {
        return (List)this.gitlabServiceImpl.getAllBranch().getData();
    }

    public List<SysApplicationVo> getAllAppbyBranch(String branch) {
        SysUsers brachUser = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)branch));
        if (!HussarUtils.isNotEmpty((Object)brachUser)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_CURRENT_BRANCH_NOT_EXIST", (String)"\u5f53\u524d\u5206\u652f\u4e0d\u5b58\u5728"));
        }
        Long userId = brachUser.getId();
        return this.sysApplicationService.getUserApplications(userId);
    }

    private static void copyFile(File src, File des) throws IOException {
        try (InputStream in = Files.newInputStream(src.toPath(), new OpenOption[0]);
             OutputStream out = Files.newOutputStream(des.toPath(), new OpenOption[0]);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
    }

    private void renameFilesAndDirectories(Path directory, String placeholder, String appCode) {
        try (Stream<Path> files = Files.list(directory);){
            files.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    path = this.processFile((Path)path, placeholder, appCode);
                    this.renameFilesAndDirectories((Path)path, placeholder, appCode);
                } else {
                    this.processFile((Path)path, placeholder, appCode);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path processFile(Path file, String placeholder, String replacement) {
        String newName;
        String oldName = file.getFileName().toString();
        Pattern pattern = Pattern.compile(Pattern.quote(placeholder));
        Matcher matcher = pattern.matcher(oldName);
        if (matcher.find() && !oldName.equals(newName = matcher.replaceAll(Matcher.quoteReplacement(replacement)))) {
            Path newPath = file.getParent().resolve(newName);
            try {
                Files.move(file, newPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to rename file: " + file, e);
            }
            System.out.println("Renamed: " + oldName + " to " + newName);
            return newPath;
        }
        return file;
    }

    public void replaceAppCodeInFiles(String directoryPath, final String placeholder, final String appCode) {
        Path directory = Paths.get(directoryPath, new String[0]);
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        String content = new String(Files.readAllBytes(file));
                        String newContent = content.replace(placeholder, appCode);
                        if (!content.equals(newContent)) {
                            Files.write(file, newContent.getBytes(), new OpenOption[0]);
                            System.out.println("Updated file: " + file);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updatePomContent(String pomPath, String content, String tag) {
        Throwable throwable;
        File file = new File(pomPath);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            throwable = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains(tag)) {
                        stringBuilder.append(content).append("\n");
                    }
                    stringBuilder.append(line).append("\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try {
            throwable = null;
            try (FileWriter writer = new FileWriter(file);){
                writer.write(stringBuilder.toString());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, String> getPomContent(String version, String appCode) {
        HashMap xmlContentMap = Maps.newHashMap();
        String dependencyContent = "        <dependency>\n            <groupId>com.jxdinfo.hussar.cloud." + appCode + "</groupId>\n            <artifactId>" + appCode + "</artifactId>\n            <version>" + version + "</version>\n        </dependency>";
        xmlContentMap.put("depen", dependencyContent);
        String moduleContent = "        <module>" + appCode + "</module>";
        xmlContentMap.put(MODULE_STR, moduleContent);
        return xmlContentMap;
    }

    private String getPomVersion(String path) {
        try {
            File pomFile = new File(path);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document doc = documentBuilder.parse(pomFile);
            doc.getDocumentElement().normalize();
            NodeList versionList = doc.getElementsByTagName("version");
            String version = versionList.item(0).getTextContent();
            System.out.println("POM Version: " + version);
            return version;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    public String exportAppData(Long recordId, Long appId, HttpServletResponse response) {
        String exportCacheKey;
        if (appId == null) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_APP_ID_NOT_EMPTY", (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String tenantCode = user.getTenantCode();
        String appCode = ((SysApplication)this.sysApplicationService.getById((Serializable)appId)).getAppCode();
        String branch = user.getAccount();
        ImportProgressCacheAspect.EXPORT_CACHE_KEY = "app_export_Progress";
        ImportProgressCacheAspect.EXPORT_CACHE_KEY = exportCacheKey = ImportProgressCacheAspect.EXPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"exportCacheKey", (Object)exportCacheKey);
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)1, (String)"", (Long)0L, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService hussarApplicationService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            hussarApplicationService.exportAppData(recordId, appId, tenantCode, branch, userId, appCode, response);
        });
        return exportCacheKey;
    }

    public String exportBatchAppData(Long recordId, List<Long> appIds, String branch, HttpServletResponse response) {
        String exportCacheKey;
        if (HussarUtils.isEmpty(appIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_APP_ID_NOT_EMPTY", (String)"\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List sysApplications = this.sysApplicationService.listByIds(appIds);
        Map<Long, String> appIdWithCode = sysApplications.stream().collect(Collectors.toMap(SysApplication::getId, SysApplication::getAppCode));
        SecurityUser user = BaseSecurityUtil.getUser();
        String tenantCode = user.getTenantCode();
        Long userId = user.getId();
        ImportProgressCacheAspect.EXPORT_CACHE_KEY = "app_export_Progress";
        ImportProgressCacheAspect.EXPORT_CACHE_KEY = exportCacheKey = ImportProgressCacheAspect.EXPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"exportCacheKey", (Object)exportCacheKey);
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)1, (String)"", (Long)0L, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService hussarApplicationService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            hussarApplicationService.exportBatchAppData(recordId, tenantCode, branch, userId, appIdWithCode, response);
        });
        return exportCacheKey;
    }

    private Map<String, Object> getAppmetaHussarData(Long recordId) {
        SysApplicationRecord record = (SysApplicationRecord)this.sysApplicationRecordService.getById((Serializable)recordId);
        HashMap<String, Object> appmetaMap = new HashMap<String, Object>();
        appmetaMap.put(PASSWORD_STR, record.getRecordFilePassword());
        Long appId = Long.parseLong(record.getAppIds());
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
        appmetaMap.put(APP_ID, appId);
        appmetaMap.put(APP_CODE, application.getAppCode());
        appmetaMap.put(APP_NAME, application.getAppName());
        appmetaMap.put(APP_GROUP, application.getAppGroupId());
        appmetaMap.put(APP_ICON, application.getAppIcon());
        appmetaMap.put(APP_ICON_COLOR, application.getAppIconColor());
        appmetaMap.put(APP_ICON_TYPE, application.getAppIconType());
        appmetaMap.put("appType", application.getAppType());
        return appmetaMap;
    }

    private Map<String, Object> getBatchAppmetaHussarData(Long recordId) {
        SysApplicationRecord record = (SysApplicationRecord)this.sysApplicationRecordService.getById((Serializable)recordId);
        HashMap<String, Object> appmetaMap = new HashMap<String, Object>();
        appmetaMap.put(PASSWORD_STR, record.getRecordFilePassword());
        String appIds = record.getAppIds();
        List<Object> appIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)appIds)) {
            appIdList = Arrays.stream(appIds.split(",")).map(Long::parseLong).collect(Collectors.toList());
        }
        for (Long appId : appIdList) {
            HashMap<String, Object> allAppmetaMap = new HashMap<String, Object>();
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            allAppmetaMap.put(APP_ID, appId);
            allAppmetaMap.put(APP_CODE, application.getAppCode());
            allAppmetaMap.put(APP_NAME, application.getAppName());
            allAppmetaMap.put(APP_GROUP, application.getAppGroupId());
            allAppmetaMap.put(APP_ICON, application.getAppIcon());
            allAppmetaMap.put(APP_ICON_COLOR, application.getAppIconColor());
            allAppmetaMap.put(APP_ICON_TYPE, application.getAppIconType());
            allAppmetaMap.put("appType", application.getAppType());
            appmetaMap.put(application.getAppCode(), allAppmetaMap);
        }
        return appmetaMap;
    }

    @ExportProgressCache(status=1, msg="\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u57fa\u7840\u4fe1\u606f")
    private Map<String, Object> getHussarData(Long appId) {
        SysMenu appMenuModule;
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)1, (String)TranslateUtil.getTranslateName((String)"APP_LOW_GET_APP_BASE_INFO", (String)"\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u57fa\u7840\u4fe1\u606f"), (Long)0L, (boolean)false));
        SysApplication sysApplication = (SysApplication)this.sysApplicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getId, (Object)appId));
        List sysFunctions = this.sysFunctionsService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctions::getAppId, (Object)appId));
        List sysFunctionModules = this.functionModulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysFunctionModules::getAppId, (Object)appId));
        List sysResources = this.sysResourcesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResources::getAppId, (Object)appId));
        List sysResourceModules = this.resourceMosulesService.list((Wrapper)new LambdaQueryWrapper().eq(SysResourceModules::getAppId, (Object)appId));
        List functionIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
        List resourceIds = sysResources.stream().map(SysResources::getId).collect(Collectors.toList());
        List sysFunctionResources = Lists.newArrayList();
        if (HussarUtils.isNotEmpty(functionIds) && HussarUtils.isNotEmpty(resourceIds)) {
            sysFunctionResources = this.sysFunctionResourcesService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysFunctionResources::getFunctionId, functionIds)).in(SysFunctionResources::getResourceId, resourceIds));
        }
        List sysRoles = this.sysRolesService.list((Wrapper)new LambdaQueryWrapper().eq(SysRoles::getFromAppId, (Object)appId));
        List roleIds = sysRoles.stream().map(SysRoles::getId).collect(Collectors.toList());
        List sysRoleFunctions = Lists.newArrayList();
        if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty(functionIds)) {
            sysRoleFunctions = this.sysRoleFunctionsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleFunctions::getRoleId, roleIds)).in(SysRoleFunctions::getFunctionId, functionIds));
        }
        List sysRoleResources = Lists.newArrayList();
        if (HussarUtils.isNotEmpty(roleIds) && HussarUtils.isNotEmpty(resourceIds)) {
            sysRoleResources = this.sysRoleResourceService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRoleResource::getRoleId, roleIds)).in(SysRoleResource::getResourceId, resourceIds));
        }
        SysRoleGroup sysRoleGroup = (SysRoleGroup)this.roleGroupService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysRoleGroup::getFromAppId, (Object)appId));
        List sysCodeRules = this.sysCodeRuleService.list((Wrapper)new LambdaQueryWrapper().eq(SysCodeRule::getAppId, (Object)appId));
        List sysDictTypes = this.sysDicTypeService.list((Wrapper)new LambdaQueryWrapper().eq(DicType::getAppId, (Object)appId));
        List sysDictSingles = this.sysDicSingleService.list((Wrapper)new LambdaQueryWrapper().eq(DicSingle::getAppId, (Object)appId));
        List sysDictGroups = this.dicGroupService.list((Wrapper)new LambdaQueryWrapper().eq(DicGroup::getAppId, (Object)appId));
        List<Object> sysMenus = new ArrayList<SysMenu>();
        if (HussarUtils.isNotEmpty((Object)sysFunctions)) {
            List functionsIds = sysFunctions.stream().map(SysFunctions::getId).collect(Collectors.toList());
            sysMenus = this.sysMenuService.list((Wrapper)new LambdaQueryWrapper().in(SysMenu::getFunctionId, functionsIds));
        }
        if (HussarUtils.isNotEmpty((Object)(appMenuModule = (SysMenu)this.sysMenuService.getById((Serializable)appId)))) {
            sysMenus.add(appMenuModule);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sysApplication", sysApplication);
        data.put("sysFunctions", sysFunctions);
        data.put("sysFunctionModules", sysFunctionModules);
        data.put("sysResources", sysResources);
        data.put("sysResourceModules", sysResourceModules);
        data.put("sysFunctionResources", sysFunctionResources);
        data.put("sysRoles", sysRoles);
        data.put("sysRoleFunctions", sysRoleFunctions);
        data.put("sysRoleResources", sysRoleResources);
        data.put("sysRoleGroup", sysRoleGroup);
        data.put("sysCodeRules", sysCodeRules);
        data.put("sysDictTypes", sysDictTypes);
        data.put("sysDictSingles", sysDictSingles);
        data.put("sysDictGroups", sysDictGroups);
        data.put("sysMenus", sysMenus);
        data.put("export_type", "app");
        return data;
    }

    @ExportProgressCache(status=2, msg="\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u57fa\u7840\u4fe1\u606f\u52a0\u5bc6\u6587\u4ef6")
    private String makeHussarFile(Map<String, Object> data) throws Exception {
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)2, (String)TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_APP_ENCRYPT_FILE", (String)"\u6b63\u5728\u5bfc\u51fa\u5e94\u7528\u57fa\u7840\u4fe1\u606f\u52a0\u5bc6\u6587\u4ef6"), (Long)0L, (boolean)false));
        byte[] serializeData = new byte[]{};
        serializeData = SerializeUtils.serialize(data);
        String newFileName = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)DATETIME_PATTERN) + ".hussar";
        HussarConfig hussarConfig = (HussarConfig)SpringContextHolder.getBean(HussarConfig.class);
        String filePath = hussarConfig.getFileUploadPath() + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(serializeData));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            if (!path.exists()) {
                logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_MISS_CREATE", (String)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}"), (Object)path);
                boolean isCreated = path.mkdirs();
                if (!isCreated) {
                    logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_MISS_CREATE", (String)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}"), (Object)path);
                }
            }
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
        }
        catch (Exception e) {
            logger.error(TranslateUtil.getTranslateName((String)"APP_LOW_OUTPUT_STREAM_ERROR", (String)"\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}"), (Object)filePath, (Object)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_OUTPUT_STREAM_ERROR", (String)"\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}") + filePath);
        }
        return file.getPath();
    }

    private String makeAppmetaHussarFile(Map<String, Object> data) throws Exception {
        byte[] serializeData = new byte[]{};
        serializeData = SerializeUtils.serialize(data);
        String newFileName = DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)DATETIME_PATTERN) + ".appmeta";
        HussarConfig hussarConfig = (HussarConfig)SpringContextHolder.getBean(HussarConfig.class);
        String filePath = hussarConfig.getFileUploadPath() + newFileName;
        File file = new File(filePath);
        File path = file.getParentFile();
        try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(serializeData));
             FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream output = new BufferedOutputStream(fos);){
            if (!path.exists()) {
                logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_MISS_CREATE", (String)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}"), (Object)path);
                boolean isCreated = path.mkdirs();
                if (!isCreated) {
                    logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_MISS_CREATE", (String)"\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u3002path={}"), (Object)path);
                }
            }
            byte[] buffer = new byte[1024];
            int length = bis.read(buffer);
            while (length != -1) {
                output.write(buffer, 0, length);
                length = bis.read(buffer);
            }
            output.flush();
        }
        catch (Exception e) {
            logger.error(TranslateUtil.getTranslateName((String)"APP_LOW_OUTPUT_STREAM_ERROR", (String)"\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}"), (Object)filePath, (Object)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_OUTPUT_STREAM_ERROR", (String)"\u8f93\u51fa\u6587\u4ef6\u6d41\u65f6\u629b\u5f02\u5e38\uff0cfilePath={}") + filePath);
        }
        return file.getPath();
    }

    @ExportProgressCache(status=3, msg="\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u4ee3\u7801")
    private ApiResponse<String> pullFileToLocal(String branch, String localGitFilePath, String tenantCode, Long userId) {
        try {
            HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)3, (String)TranslateUtil.getTranslateName((String)"APP_LOW_GET_APP_CODE", (String)"\u6b63\u5728\u83b7\u53d6\u5e94\u7528\u4ee3\u7801"), (Long)0L, (boolean)false));
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenantCode);
            gitDto.setBranch(branch);
            gitDto.setUserId(userId);
            ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
            if (!((Boolean)response.getData()).booleanValue()) {
                String refName = this.templateFileProperties.getBranch();
                gitDto.setRefName(refName);
                GitlabUtil.createRemoteBranch((GitDto)gitDto);
            }
            gitDto.setSourceBranch("develop");
            gitDto.setTargetBranch(branch);
            gitDto.setTitle(TranslateUtil.getTranslateName((String)"APP_LOW_MERGE_DEVELOP_TO_PERSONAL_BRANCH", (String)MERGE_DEVELOP_TO_PERSONAL_BRANCH));
            try {
                logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_MERGE_DEVELOP_TO_PERSONAL_BRANCH", (String)MERGE_DEVELOP_TO_PERSONAL_BRANCH));
                ApiResponse remoteMergeResponse = GitlabUtil.remoteMerge((GitDto)gitDto);
                System.out.println("-------------------------------------remoteMergeResponse = " + remoteMergeResponse.getData());
            }
            catch (Exception e) {
                logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_DEVELOP_MERGE_PERSON_FAIL", (String)"\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f\u5931\u8d25:{}"), (Object)e.getMessage());
            }
            gitDto.setPath(localGitFilePath);
            ApiResponse pullResponse = GitlabUtil.pullToLocal((GitDto)gitDto);
            if (!pullResponse.isSuccess()) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"GIT_PULL_FAIL", (String)GIT_PULL_FAIL));
            }
            return pullResponse;
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }

    @ExportProgressCache(status=4, msg="\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6")
    private String makeAppDataZip(String appCode, String zipParentPath, String appmetaHussarFilePath, String hussarFilePath, String appFrontCodePath, String appBackCodePath, String appBackWebMainPath) throws Exception {
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)4, (String)TranslateUtil.getTranslateName((String)"APP_LOW_MAKE_ZIP", (String)"\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6"), (Long)0L, (boolean)false));
        String zipNewFolderName = appCode + "-Folder";
        Path parentPath = Paths.get(zipParentPath, new String[0]);
        Path zipNewFolderPath = parentPath.resolve(zipNewFolderName);
        try {
            Files.createDirectories(zipNewFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_MAKE_TEMP_FOLDER_ERROR", (String)"\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u53d1\u751f\u9519\u8bef: ") + e.getMessage());
        }
        if (zipNewFolderPath != null) {
            Path appmetaPath = Paths.get(appmetaHussarFilePath, new String[0]);
            Path appmetaTargetPath = zipNewFolderPath.resolve(appmetaPath.getFileName());
            Path hussarPath = Paths.get(hussarFilePath, new String[0]);
            Path hussarTargetPath = zipNewFolderPath.resolve(hussarPath.getFileName());
            try {
                Files.copy(appmetaPath, appmetaTargetPath, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(hussarPath, hussarTargetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_COPY_ERROR", (String)"\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: : ") + e.getMessage());
            }
        }
        String gitFolderName = "gitFolder";
        Path gitFolderPath = zipNewFolderPath.resolve(gitFolderName);
        try {
            Files.createDirectories(gitFolderPath, new FileAttribute[0]);
            Path appFrontPath = gitFolderPath.resolve(appCode + "-front");
            Files.createDirectories(appFrontPath, new FileAttribute[0]);
            Path appWebPath = gitFolderPath.resolve(appCode + "-web");
            Files.createDirectories(appWebPath, new FileAttribute[0]);
            String appWebMainFolderName = "web-main";
            Path appWebMainFolderPath = appWebPath.resolve(appWebMainFolderName);
            Files.createDirectories(appWebMainFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackWebMainPath, new String[0]), appWebMainFolderPath);
            String hussarCloudModuleFolderName = appCode;
            Path hussarCloudModuleFolderPath = appWebPath.resolve(hussarCloudModuleFolderName);
            Files.createDirectories(hussarCloudModuleFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackCodePath, new String[0]), hussarCloudModuleFolderPath);
            String frontFolderName = appCode;
            Path frontFolderPath = appFrontPath.resolve(frontFolderName);
            Files.createDirectories(frontFolderPath, new FileAttribute[0]);
            TenantApplicationServiceImpl.copyDirectory(Paths.get(appFrontCodePath, new String[0]), frontFolderPath);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage());
        }
        Path zipPath = this.zipDirectory(zipNewFolderPath);
        return zipPath.toString();
    }

    @ExportProgressCache(status=4, msg="\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6")
    private String makeBatchAppDataZip(String zipParentPath, List<ExportAppFilePath> exportAppFilePathList) throws Exception {
        HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)4, (String)TranslateUtil.getTranslateName((String)"APP_LOW_MAKE_ZIP", (String)"\u6b63\u5728\u5236\u4f5c\u538b\u7f29\u5305\u6587\u4ef6"), (Long)0L, (boolean)false));
        String zipNewPath = zipParentPath + File.separator + "\u5e94\u7528\u5bfc\u51fa\u5305";
        Path zipPathFolder = Paths.get(zipNewPath, new String[0]);
        for (ExportAppFilePath exportAppFilePath : exportAppFilePathList) {
            String appCode = exportAppFilePath.getAppCode();
            String appmetaHussarFilePath = exportAppFilePath.getAppmetaHussarFilePath();
            String hussarFilePath = exportAppFilePath.getHussarFilePath();
            String appFrontCodePath = exportAppFilePath.getAppFrontCodePath();
            String appBackCodePath = exportAppFilePath.getAppBackCodePath();
            String appBackWebMainPath = exportAppFilePath.getAppBackWebMainPath();
            String appNewFolderName = appCode + "-Folder";
            Path parentPath = Paths.get(zipNewPath, new String[0]);
            Path appNewFolderPath = parentPath.resolve(appNewFolderName);
            try {
                Files.createDirectories(appNewFolderPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_MAKE_TEMP_FOLDER_ERROR", (String)"\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u53d1\u751f\u9519\u8bef: ") + e.getMessage());
            }
            if (appNewFolderPath != null) {
                Path appmetaPath = Paths.get(appmetaHussarFilePath, new String[0]);
                Path appmetaTargetPath = parentPath.resolve(appmetaPath.getFileName());
                Path hussarPath = Paths.get(hussarFilePath, new String[0]);
                Path hussarTargetPath = appNewFolderPath.resolve(hussarPath.getFileName());
                try {
                    Files.copy(appmetaPath, appmetaTargetPath, StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(hussarPath, hussarTargetPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_FILE_COPY_ERROR", (String)"\u590d\u5236\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: : ") + e.getMessage());
                }
            }
            String gitFolderName = "gitFolder";
            Path gitFolderPath = appNewFolderPath.resolve(gitFolderName);
            try {
                Files.createDirectories(gitFolderPath, new FileAttribute[0]);
                Path appFrontPath = gitFolderPath.resolve(appCode + "-front");
                Files.createDirectories(appFrontPath, new FileAttribute[0]);
                Path appWebPath = gitFolderPath.resolve(appCode + "-web");
                Files.createDirectories(appWebPath, new FileAttribute[0]);
                String appWebMainFolderName = "web-main";
                Path appWebMainFolderPath = appWebPath.resolve(appWebMainFolderName);
                Files.createDirectories(appWebMainFolderPath, new FileAttribute[0]);
                TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackWebMainPath, new String[0]), appWebMainFolderPath);
                String hussarCloudModuleFolderName = appCode;
                Path hussarCloudModuleFolderPath = appWebPath.resolve(hussarCloudModuleFolderName);
                Files.createDirectories(hussarCloudModuleFolderPath, new FileAttribute[0]);
                TenantApplicationServiceImpl.copyDirectory(Paths.get(appBackCodePath, new String[0]), hussarCloudModuleFolderPath);
                String frontFolderName = appCode;
                Path frontFolderPath = appFrontPath.resolve(frontFolderName);
                Files.createDirectories(frontFolderPath, new FileAttribute[0]);
                TenantApplicationServiceImpl.copyDirectory(Paths.get(appFrontCodePath, new String[0]), frontFolderPath);
            }
            catch (IOException e) {
                throw new BaseException(e.getMessage());
            }
        }
        Path zipPath = this.zipDirectory(zipPathFolder);
        return zipPath.toString();
    }

    private static void copyDirectory(final Path source, final Path dest) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Files.createDirectories(dest.resolve(source.relativize(dir)), new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.copy(file, dest.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public Path zipDirectory(Path sourceFolderPath) {
        if (!Files.exists(sourceFolderPath, new LinkOption[0]) || !Files.isDirectory(sourceFolderPath, new LinkOption[0])) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)"APP_LOW_SOURCE_DIRECTORY_ERROR", (String)"\u6e90\u6587\u4ef6\u5939\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55\uff01 "));
        }
        Path parentDir = sourceFolderPath.getParent();
        if (parentDir == null) {
            throw new IllegalArgumentException(TranslateUtil.getTranslateName((String)"APP_LOW_SOURCE_DIR_PARENT_ERROR", (String)"\u65e0\u6cd5\u83b7\u53d6\u6e90\u6587\u4ef6\u5939\u7684\u7236\u76ee\u5f55\uff01"));
        }
        String zipFileName = sourceFolderPath.getFileName().toString() + ".zip";
        Path zipFilePath = parentDir.resolve(zipFileName);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(zipFilePath, new OpenOption[0]));){
            this.zipFolder(sourceFolderPath, "", zos);
        }
        catch (IOException e) {
            throw new RuntimeException(TranslateUtil.getTranslateName((String)"APP_LOW_ZIP_FOLDER_ERROR", (String)"\u538b\u7f29\u6587\u4ef6\u5939\u65f6\u53d1\u751f\u9519\u8bef:") + e.getMessage(), e);
        }
        return zipFilePath;
    }

    private void zipFolder(Path folder, String prefix, ZipOutputStream zos) throws IOException {
        try (Stream<Path> pathStream = Files.walk(folder, new FileVisitOption[0]);){
            pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                try {
                    Path relativePath = folder.relativize((Path)path);
                    String entryName = prefix + relativePath.toString();
                    ZipEntry zipEntry = new ZipEntry(entryName);
                    zos.putNextEntry(zipEntry);
                    byte[] buffer = new byte[1024];
                    try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                        int length;
                        while ((length = fis.read(buffer)) >= 0) {
                            zos.write(buffer, 0, length);
                        }
                    }
                    zos.closeEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(TranslateUtil.getTranslateName((String)"APP_LOW_PROCESS_FOLDER_ERROR", (String)"\u5904\u7406\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: ") + e.getMessage(), e);
                }
            });
        }
    }

    public void downloadAppExportFile(Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysApplicationRecord::getRecordFileId, (Object)fileId);
        SysApplicationRecord sysApplicationRecord = (SysApplicationRecord)this.sysApplicationRecordService.getOne((Wrapper)wrapper);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_DOWNLOAD_FAIL", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01"));
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = sysApplicationRecord.getRecordFileName();
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart" + File.separator + "form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> unpackImportFile(MultipartFile file) {
        String zipFileName = file.getOriginalFilename();
        if (!zipFileName.endsWith(".zip")) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_UPLOAD_FILE_TYPE_ERROR", (String)"\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u538b\u7f29\u6587\u4ef6\uff01"));
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String importZipFileInTempPath = null;
        try {
            Path filePath = Paths.get(tempDir, zipFileName);
            File uploadFile = filePath.toFile();
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
            importZipFileInTempPath = uploadFile.getAbsolutePath();
            String parentFolderPath = uploadFile.getParent();
            String newFolderName = zipFileName.substring(0, zipFileName.lastIndexOf(46));
            Path parentFolder = Paths.get(parentFolderPath, new String[0]);
            Path newFolder = parentFolder.resolve(newFolderName);
            try {
                Files.createDirectories(newFolder, new FileAttribute[0]);
                logger.info("\u89e3\u538b\u6587\u4ef6\u5939\u5df2\u6210\u529f\u521b\u5efa\u5728: " + newFolder.toAbsolutePath());
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u51fa\u9519", (Throwable)e);
            }
            String newFolderPath = newFolder.toString() + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)DATETIME_PATTERN);
            Map<String, String> filePaths = this.unzip(importZipFileInTempPath, newFolderPath);
            String appmetaHussarFilePath = filePaths.get(".appmeta");
            String hussarFilePath = filePaths.get(".hussar");
            String appCodeFilePath = filePaths.get("gitFolder");
            if (HussarUtils.isEmpty((Object)appmetaHussarFilePath) || HussarUtils.isEmpty((Object)hussarFilePath) || HussarUtils.isEmpty((Object)appCodeFilePath)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_FILE_ERROR", (String)"\u5bfc\u5165\u6587\u4ef6\u9519\u8bef\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u6587\u4ef6"));
            }
            Map<String, Object> appmetaData = this.analyzeFileData(appmetaHussarFilePath);
            String password = (String)appmetaData.get(PASSWORD_STR);
            if (HussarUtils.isEmpty((Object)password)) {
                resultMap.put(ENCRYPT_FLAG, false);
            } else {
                resultMap.put(ENCRYPT_FLAG, true);
            }
            Long appId = (Long)appmetaData.get(APP_ID);
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            SysAppRecycle sysAppRecycle = (SysAppRecycle)this.sysAppRecycleService.getById((Serializable)appId);
            if (HussarUtils.isNotEmpty((Object)application) || HussarUtils.isNotEmpty((Object)sysAppRecycle)) {
                resultMap.put("existFlag", true);
            } else {
                resultMap.put("existFlag", false);
            }
            resultMap.put("inputFileName", file.getOriginalFilename());
            resultMap.put(APP_ID, appmetaData.get(APP_ID));
            resultMap.put(APP_CODE, appmetaData.get(APP_CODE));
            resultMap.put(APP_NAME, appmetaData.get(APP_NAME));
            resultMap.put(APP_GROUP, appmetaData.get(APP_GROUP));
            resultMap.put(APP_ICON, appmetaData.get(APP_ICON));
            resultMap.put(APP_ICON_COLOR, appmetaData.get(APP_ICON_COLOR));
            resultMap.put(APP_ICON_TYPE, appmetaData.get(APP_ICON_TYPE));
            resultMap.put("appmetaHussarFilePath", appmetaHussarFilePath);
            resultMap.put("hussarFilePath", hussarFilePath);
            resultMap.put("appCodeFilePath", appCodeFilePath);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return resultMap;
    }

    public Map<String, Object> unpackBatchImportFile(MultipartFile file) {
        String zipFileName = file.getOriginalFilename();
        if (!zipFileName.endsWith(".zip")) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_UPLOAD_FILE_TYPE_ERROR", (String)"\u4e0a\u4f20\u6587\u4ef6\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u538b\u7f29\u6587\u4ef6\uff01"));
        }
        String tempDir = System.getProperty("java.io.tmpdir");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String importZipFileInTempPath = null;
        try {
            Path filePath = Paths.get(tempDir, zipFileName);
            File uploadFile = filePath.toFile();
            Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
            importZipFileInTempPath = uploadFile.getAbsolutePath();
            String parentFolderPath = uploadFile.getParent();
            String newFolderName = zipFileName.substring(0, zipFileName.lastIndexOf(46));
            Path parentFolder = Paths.get(parentFolderPath, new String[0]);
            Path newFolder = parentFolder.resolve(newFolderName);
            try {
                Files.createDirectories(newFolder, new FileAttribute[0]);
                logger.info("\u89e3\u538b\u6587\u4ef6\u5939\u5df2\u6210\u529f\u521b\u5efa\u5728: " + newFolder.toAbsolutePath());
            }
            catch (IOException e) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5939\u65f6\u51fa\u9519", (Throwable)e);
            }
            String newFolderPath = newFolder.toString() + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)DATETIME_PATTERN);
            Map<String, Object> allFilePaths = this.unzipBatch(importZipFileInTempPath, newFolderPath);
            String appmetaHussarFilePath = allFilePaths.get(".appmeta").toString();
            resultMap.put("appmetaHussarFilePath", appmetaHussarFilePath);
            Map<String, Object> appmetaData = this.analyzeFileData(appmetaHussarFilePath);
            String password = (String)appmetaData.get(PASSWORD_STR);
            if (HussarUtils.isEmpty((Object)password)) {
                resultMap.put(ENCRYPT_FLAG, false);
            } else {
                resultMap.put(ENCRYPT_FLAG, true);
            }
            for (String appCode : allFilePaths.keySet()) {
                if (".appmeta".equals(appCode)) continue;
                Map filePaths = (Map)allFilePaths.get(appCode);
                String hussarFilePath = (String)filePaths.get(".hussar");
                String appCodeFilePath = (String)filePaths.get("gitFolder");
                if (HussarUtils.isEmpty((Object)appmetaHussarFilePath) || HussarUtils.isEmpty((Object)hussarFilePath) || HussarUtils.isEmpty((Object)appCodeFilePath)) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_FILE_ERROR", (String)"\u5bfc\u5165\u6587\u4ef6\u9519\u8bef\uff0c\u672a\u627e\u5230\u6307\u5b9a\u6570\u636e\u6587\u4ef6"));
                }
                Map appInofo = (Map)appmetaData.get(appCode);
                ImportAppInfo importAppInfo = new ImportAppInfo();
                Long appId = Long.parseLong(appInofo.get(APP_ID).toString());
                SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
                SysAppRecycle sysAppRecycle = (SysAppRecycle)this.sysAppRecycleService.getById((Serializable)appId);
                if (HussarUtils.isNotEmpty((Object)application) || HussarUtils.isNotEmpty((Object)sysAppRecycle)) {
                    importAppInfo.setExistFlag(Boolean.valueOf(true));
                } else {
                    importAppInfo.setExistFlag(Boolean.valueOf(false));
                }
                importAppInfo.setInputFileName(file.getOriginalFilename());
                importAppInfo.setAppId(appId);
                importAppInfo.setAppCode(appCode);
                importAppInfo.setAppName(appInofo.get(APP_NAME).toString());
                importAppInfo.setAppIcon(appInofo.get(APP_ICON).toString());
                importAppInfo.setAppIconColor(appInofo.get(APP_ICON_COLOR).toString());
                importAppInfo.setAppIconType(appInofo.get(APP_ICON_TYPE).toString());
                importAppInfo.setHussarFilePath(hussarFilePath);
                importAppInfo.setAppCodeFilePath(appCodeFilePath);
                resultMap.put(appCode, importAppInfo);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return resultMap;
    }

    public Boolean checkAppImportPassword(String password, String appmetaHussarFilePath) {
        if (HussarUtils.isEmpty((Object)password) || HussarUtils.isEmpty((Object)appmetaHussarFilePath)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_PARAM_NULL", (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        try {
            Map<String, Object> appmetaData = this.analyzeFileData(appmetaHussarFilePath);
            String appmetaPassword = (String)appmetaData.get(PASSWORD_STR);
            if (password.equals(appmetaPassword)) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    public String importAppData(MultipartFile file, String fileName, String filePassword, String hussarFilePath, String appCodeFilePath, Boolean ifExist, Long appId, String appCode, Long appGroupId, String appIconType, String appIconColor, String appIcon, Long recordId) {
        String importCacheKey;
        Long userId = HussarSecurityUtils.getLoginUserDetails().getUserId();
        try {
            InputStream input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        SysApplicationRecord record = new SysApplicationRecord();
        record.setRecordId(recordId);
        record.setRecordFileName(fileName);
        if (HussarUtils.isNotBlank((CharSequence)filePassword)) {
            record.setRecordFilePassword(filePassword);
        }
        record.setRecordStatus("1");
        record.setRecordFileId((Long)fileResponse.getData());
        this.sysApplicationRecordService.updateById((Object)record);
        String branch = "develop";
        ImportProgressCacheAspect.IMPORT_CACHE_KEY = "app_import_Progress";
        ImportProgressCacheAspect.IMPORT_CACHE_KEY = importCacheKey = ImportProgressCacheAspect.IMPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)1, (String)TranslateUtil.getTranslateName((String)"APP_LOW_START_IMPORT", (String)"\u5f00\u59cb\u5bfc\u5165"), (boolean)false, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService hussarApplicationService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            hussarApplicationService.importAppFileData(ifExist, appId, appCode, appGroupId, appIconType, appIconColor, appIcon, tenantCode, record, hussarFilePath, appCodeFilePath, branch, userId);
        });
        return importCacheKey;
    }

    public String importBatchAppData(MultipartFile file, String fileName, String filePassword, Long recordId, Long newAppGroupId, List<ImportAppInfo> importAppInfoList) {
        String importCacheKey;
        Long userId = HussarSecurityUtils.getLoginUserDetails().getUserId();
        try {
            InputStream input = file.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ApiResponse fileResponse = this.ossService.backgroundUpload(file);
        String tenantCode = BaseSecurityUtil.getUser().getTenantCode();
        SysApplicationRecord record = new SysApplicationRecord();
        record.setRecordId(recordId);
        record.setRecordFileName(fileName);
        if (HussarUtils.isNotBlank((CharSequence)filePassword)) {
            record.setRecordFilePassword(filePassword);
        }
        record.setRecordStatus("1");
        record.setRecordFileId((Long)fileResponse.getData());
        this.sysApplicationRecordService.updateById((Object)record);
        String branch = "develop";
        ImportProgressCacheAspect.IMPORT_CACHE_KEY = "app_import_Progress";
        ImportProgressCacheAspect.IMPORT_CACHE_KEY = importCacheKey = ImportProgressCacheAspect.IMPORT_CACHE_KEY + "_" + recordId;
        TransmittableThreadLocalHolder.set((String)"importCacheKey", (Object)importCacheKey);
        HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)1, (String)TranslateUtil.getTranslateName((String)"APP_LOW_START_IMPORT", (String)"\u5f00\u59cb\u5bfc\u5165"), (boolean)false, (boolean)false));
        Executor hussarBaseExcelExecutor = this.hussarThreadPoolConfiguration.getAsyncExecutor();
        hussarBaseExcelExecutor.execute(() -> {
            IHussarApplicationService hussarApplicationService = (IHussarApplicationService)SpringContextHolder.getBean(IHussarApplicationService.class);
            hussarApplicationService.importBatchAppFileData(tenantCode, record, branch, userId, newAppGroupId, importAppInfoList);
        });
        return importCacheKey;
    }

    public void importAppFileData(Boolean ifExist, Long appId, String appCode, Long newAppGroupId, String appIconType, String appIconColor, String appIcon, String tenantCode, SysApplicationRecord record, String hussarFilePath, String appCodeFilePath, String branch, Long userId) {
        try {
            Map<String, Object> hussarData = this.analyzeHussarFileData(hussarFilePath);
            this.importHussarData(ifExist, appId, hussarData, newAppGroupId, appIconType, appIconColor, appIcon, userId);
            this.pushCodeFileToGit(branch, TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_EXPORT_LOG_FAIL", (String)"\u5e94\u7528\u5bfc\u5165"), appCodeFilePath, tenantCode, appCode, userId);
            HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)5, (String)TranslateUtil.getTranslateName((String)"APP_LOW_APPLICATION_IMPORT_COMPLETE", (String)"\u5bfc\u5165\u5b8c\u6210"), (boolean)true, (boolean)false));
            record.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)record);
        }
        catch (Exception e) {
            HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)0, (String)(TranslateUtil.getTranslateName((String)"APP_LOW_APPLICATION_IMPORT_ERROR", (String)"\u5bfc\u5165\u5f02\u5e38") + e.getMessage()), (boolean)true, (boolean)true));
            record.setRecordStatus("3");
            this.sysApplicationRecordService.updateById((Object)record);
            throw new BaseException((Throwable)e);
        }
        finally {
            try {
                this.deleteDirectory(new File(hussarFilePath).getParent());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void importBatchAppFileData(String tenantCode, SysApplicationRecord record, String branch, Long userId, Long newAppGroupId, List<ImportAppInfo> importAppInfoList) {
        try {
            for (ImportAppInfo importAppInfo : importAppInfoList) {
                String hussarFilePath = importAppInfo.getHussarFilePath();
                Boolean ifExist = importAppInfo.getExistFlag();
                Long appId = importAppInfo.getAppId();
                String appCode = importAppInfo.getAppCode();
                String appIcon = importAppInfo.getAppIcon();
                String appIconColor = importAppInfo.getAppIconColor();
                String appIconType = importAppInfo.getAppIconType();
                String appCodeFilePath = importAppInfo.getAppCodeFilePath();
                Map<String, Object> hussarData = this.analyzeHussarFileData(hussarFilePath);
                this.importHussarData(ifExist, appId, hussarData, newAppGroupId, appIconType, appIconColor, appIcon, userId);
                this.pushCodeFileToGit(branch, TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_EXPORT_LOG_FAIL", (String)"\u5e94\u7528\u5bfc\u5165"), appCodeFilePath, tenantCode, appCode, userId);
            }
            HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)5, (String)TranslateUtil.getTranslateName((String)"APP_LOW_APPLICATION_IMPORT_COMPLETE", (String)"\u5bfc\u5165\u5b8c\u6210"), (boolean)true, (boolean)false));
            record.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)record);
        }
        catch (Exception e) {
            HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)0, (String)(TranslateUtil.getTranslateName((String)"APP_LOW_APPLICATION_IMPORT_ERROR", (String)"\u5bfc\u5165\u5f02\u5e38") + e.getMessage()), (boolean)true, (boolean)true));
            record.setRecordStatus("3");
            this.sysApplicationRecordService.updateById((Object)record);
            throw new BaseException((Throwable)e);
        }
        finally {
            try {
                String appParentPath = new File(importAppInfoList.get(0).getHussarFilePath()).getParent();
                String filePath = new File(appParentPath).getParent();
                if (Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                    this.deleteDirectory(filePath);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ImportProgressCache(status=2, msg="\u6b63\u5728\u89e3\u6790\u57fa\u7840\u6570\u636e")
    private Map<String, Object> analyzeHussarFileData(String husssarFilePath) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)2, (String)TranslateUtil.getTranslateName((String)"APP_LOW_ANALYZE_BASE_DATA", (String)"\u6b63\u5728\u89e3\u6790\u57fa\u7840\u6570\u636e"), (boolean)false, (boolean)false));
        Map<String, Object> data = this.analyzeFileData(husssarFilePath);
        return data;
    }

    @HussarTransactional
    @ImportProgressCache(status=3, msg="\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u6570\u636e")
    private void importHussarData(Boolean ifExist, Long appId, Map<String, Object> data, Long newAppGroupId, String appIconType, String appIconColor, String appIcon, Long userId) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)3, (String)TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_BASE_DATA", (String)"\u6b63\u5728\u5bfc\u5165\u57fa\u7840\u6570\u636e"), (boolean)false, (boolean)false));
        if (ifExist.booleanValue()) {
            SysAppRecycle sysAppRecycle;
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            if (HussarUtils.isNotEmpty((Object)application)) {
                this.sysApplicationService.deleteApp(appId);
            }
            if (HussarUtils.isNotEmpty((Object)(sysAppRecycle = (SysAppRecycle)this.sysAppRecycleService.getById((Serializable)appId)))) {
                this.sysAppRecycleService.deleteRecycleApp(sysAppRecycle.getId());
            }
        }
        SysApplication sysApplication = (SysApplication)data.get("sysApplication");
        SysApplicationDto applicationDto = new SysApplicationDto();
        BeanUtil.copy((Object)sysApplication, (Object)applicationDto);
        applicationDto.setAppGroupId(newAppGroupId);
        applicationDto.setAppIconType(appIconType);
        applicationDto.setAppIconColor(appIconColor);
        applicationDto.setAppIcon(appIcon);
        applicationDto.setCreator(userId);
        List sysFunctions = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysFunctions")), SysFunctions.class);
        List sysFunctionModules = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysFunctionModules")), SysFunctionModules.class);
        List sysResources = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysResources")), SysResources.class);
        List sysResourceModules = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysResourceModules")), SysResourceModules.class);
        List sysFunctionResources = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysFunctionResources")), SysFunctionResources.class);
        List sysRoles = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysRoles")), SysRoles.class);
        List sysRoleFunctions = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysRoleFunctions")), SysRoleFunctions.class);
        List sysRoleResources = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysRoleResources")), SysRoleResource.class);
        SysRoleGroup roleGroup = (SysRoleGroup)JSON.parseObject((String)JSON.toJSONString((Object)data.get("sysRoleGroup")), SysRoleGroup.class);
        List sysCodeRules = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysCodeRules")), SysCodeRule.class);
        List sysDictTypes = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysDictTypes")), DicType.class);
        List sysDictSingles = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysDictSingles")), DicSingle.class);
        List sysDictGroups = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysDictGroups")), DicGroup.class);
        List sysMenus = JSON.parseArray((String)JSON.toJSONString((Object)data.get("sysMenus")), SysMenu.class);
        this.sysApplicationService.save((Object)applicationDto);
        this.sysAppOperationLogService.saveAppOperation(appId, "2");
        this.saveApplicationDevelopTeam(applicationDto);
        this.sysResourcesService.saveBatch((Collection)sysResources);
        this.resourceMosulesService.saveBatch((Collection)sysResourceModules);
        this.sysFunctionsService.saveBatch((Collection)sysFunctions);
        this.functionModulesService.saveBatch((Collection)sysFunctionModules);
        this.sysFunctionResourcesService.saveBatch((Collection)sysFunctionResources);
        this.sysMenuService.saveBatch((Collection)sysMenus);
        this.sysRolesService.saveBatch((Collection)sysRoles);
        this.sysRoleResourceService.saveBatch((Collection)sysRoleResources);
        this.sysRoleFunctionsService.saveBatch((Collection)sysRoleFunctions);
        this.roleGroupService.save((Object)roleGroup);
        this.sysCodeRuleService.saveBatch((Collection)sysCodeRules);
        this.sysDicTypeService.saveBatch((Collection)sysDictTypes);
        this.sysDicSingleService.saveBatch((Collection)sysDictSingles);
        this.dicGroupService.saveBatch((Collection)sysDictGroups);
    }

    private void saveApplicationDevelopTeam(SysApplicationDto sysApplicationDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        Long appId = sysApplicationDto.getId();
        SysAppDevelopTeam team = (SysAppDevelopTeam)this.developTeamService.getOne((Wrapper)wrapper.eq(SysAppDevelopTeam::getAppId, (Object)appId));
        if (HussarUtils.isEmpty((Object)team)) {
            String teamName = sysApplicationDto.getAppName() + TranslateUtil.getTranslateName((String)"APP_LOW_DEVELOP_TEAM", (String)"\u5f00\u53d1\u56e2\u961f");
            AppDevelopTeamDto developTeamDto = new AppDevelopTeamDto();
            developTeamDto.setAppId(appId);
            developTeamDto.setTeamName(teamName);
            ArrayList<Long> userLists = new ArrayList<Long>();
            userLists.add(sysApplicationDto.getCreator());
            developTeamDto.setUserIds(userLists);
            developTeamDto.setOpenTeam(sysApplicationDto.getOpenTeam());
            this.developTeamService.saveAppDevelopTeam(developTeamDto);
        }
    }

    @ImportProgressCache(status=4, msg="\u6b63\u5728\u4e0a\u4f20\u4ee3\u7801\u6587\u4ef6\u5230Git")
    private void pushCodeFileToGit(String branch, String commitMsg, String appCodeFilePath, String tenantCode, String appCode, Long userId) {
        HussarCacheUtil.put((String)"app_import_progress", (Object)ImportProgressCacheAspect.IMPORT_CACHE_KEY, (Object)ImportStatusVo.put((int)4, (String)TranslateUtil.getTranslateName((String)"APP_LOW_UPLOAD_CODE_TO_GIT", (String)"\u6b63\u5728\u4e0a\u4f20\u4ee3\u7801\u6587\u4ef6\u5230Git"), (boolean)false, (boolean)false));
        String localRepPath = this.templateFileProperties.getTenantPath();
        localRepPath = localRepPath.replace("{tenantCode}", tenantCode);
        try {
            List<String> dbdFilePaths;
            String appFrontCodePath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "apps" + File.separator + appCode;
            String appBackCodePath = localRepPath + File.separator + tenantCode + "-web" + File.separator + appCode;
            this.deleteFilesInDirectory(appFrontCodePath);
            this.deleteFilesInDirectory(appBackCodePath);
            String pushFrontFolderPath = appCodeFilePath + File.separator + appCode + "-front" + File.separator + appCode;
            String pushBackFolderPath = appCodeFilePath + File.separator + appCode + "-web" + File.separator + appCode;
            this.copyChildrenToFolder(pushFrontFolderPath, appFrontCodePath);
            this.copyChildrenToFolder(pushBackFolderPath, appBackCodePath);
            String frontPath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "front-main" + File.separator + TenantAppConstant.PACKAGE_JSON;
            try {
                this.addDependencyToPackageJson(frontPath, appCode, "1.0.0-alpha.1");
                logger.info("\u524d\u7aef\u6dfb\u52a0\u4f9d\u8d56\u6210\u529f\uff0c\u5730\u5740\uff1a{},\u4f9d\u8d56\u540d\u79f0\uff1a{}", (Object)frontPath, (Object)appCode);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String viewJsPath = localRepPath + File.separator + tenantCode + "-front" + File.separator + "front-main" + File.separator + "src" + File.separator + "views" + File.separator + "views.js";
            this.insertAppView(appCode, viewJsPath);
            String currentDbName = ((DynamicDatasourceService)SpringContextHolder.getBean(DynamicDatasourceService.class)).getCurrentDatasourceName();
            String projectStorePath = appBackCodePath + File.separator + appCode + "-server" + File.separator + appCode + File.separator + ".project-store";
            File folder = new File(projectStorePath);
            if (folder.exists() && folder.isDirectory() && HussarUtils.isNotEmpty(dbdFilePaths = this.findDbdFiles(projectStorePath))) {
                for (String dbdFilePath : dbdFilePaths) {
                    this.changeDbNameForDataModel(dbdFilePath, currentDbName);
                }
            }
            String pomFilePath = localRepPath + File.separator + tenantCode + "-web" + File.separator + appCode + File.separator + "pom.xml";
            this.changeParentArtifactId(pomFilePath, tenantCode + "-web");
            HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(tenantCode);
            DeployGitDto gitDto = new DeployGitDto();
            gitDto.setAccessToken(tenant.getGitToken());
            gitDto.setGitUri(tenant.getGitUrl());
            gitDto.setTenantCode(tenantCode);
            gitDto.setBranch(branch);
            gitDto.setUserId(userId);
            gitDto.setPath(localRepPath);
            gitDto.setCommitMsg(commitMsg);
            GitlabUtil.pushToGit((GitDto)gitDto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyChildrenToFolder(String parentFolderPath, String targetFolderPath) {
        Path sourceDir = Paths.get(parentFolderPath, new String[0]);
        Path targetDir = Paths.get(targetFolderPath, new String[0]);
        try (Stream<Path> pathStream = Files.walk(sourceDir, new FileVisitOption[0]);){
            pathStream.forEach(source -> {
                try {
                    Path targetPath = targetDir.resolve(sourceDir.relativize((Path)source));
                    TenantApplicationServiceImpl.copy(source, targetPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copy(Path source, Path target) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(source);){
                for (Path file : stream) {
                    TenantApplicationServiceImpl.copy(file, target.resolve(source.relativize(file).toString()));
                }
            }
        } else {
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private Map<String, String> unzip(String zipFilePath, String newFolderPath) {
        HashMap<String, String> filePaths = new HashMap<String, String>();
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry zipEntry = zis.getNextEntry();
            ArrayList<String> gitFolderFilePaths = new ArrayList<String>();
            while (zipEntry != null) {
                String path = zipEntry.getName();
                CharSequence[] paths = path.split("/|\\\\");
                path = String.join((CharSequence)System.getProperty("file.separator"), paths);
                String filePath = newFolderPath + File.separator + path;
                if (filePath.endsWith(".hussar")) {
                    this.extractFile(zis, filePath);
                    filePaths.put(".hussar", filePath);
                } else if (filePath.endsWith(".appmeta")) {
                    this.extractFile(zis, filePath);
                    filePaths.put(".appmeta", filePath);
                } else {
                    String parentFolderPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                    this.createParentDirectoriesIfNotExists(parentFolderPath);
                    this.extractFile(zis, filePath);
                    gitFolderFilePaths.add(filePath);
                    System.out.println("\u6dfb\u52a0\u6587\u4ef6\u5939: " + filePath);
                }
                zipEntry = zis.getNextEntry();
            }
            String gitFolderPath = TenantApplicationServiceImpl.findCommonDirectory(gitFolderFilePaths);
            logger.info("\u5171\u540c\u4e0a\u7ea7\u4e3a: " + gitFolderPath);
            filePaths.put("gitFolder", gitFolderPath);
            zis.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePaths;
    }

    private Map<String, Object> unzipBatch(String zipFilePath, String newFolderPath) {
        HashMap<String, Object> filePaths = new HashMap<String, Object>();
        ArrayList<String> appCodes = new ArrayList<String>();
        File newFolder = new File(newFolderPath);
        if (!newFolder.exists()) {
            newFolder.mkdirs();
        }
        try (FileInputStream fis = new FileInputStream(zipFilePath);
             ZipInputStream zis = new ZipInputStream(fis);){
            ZipEntry zipEntry = zis.getNextEntry();
            ArrayList<String> gitFolderFilePaths = new ArrayList<String>();
            while (zipEntry != null) {
                String parentFolderPath;
                String filePath;
                String path = zipEntry.getName();
                CharSequence[] paths = path.split("/|\\\\");
                path = String.join((CharSequence)System.getProperty("file.separator"), paths);
                String appCode = null;
                if (path.contains("-Folder") && !appCodes.contains(appCode = !path.contains(File.separator) ? path.replace("-Folder", "") : path.substring(0, path.indexOf(File.separator)).replace("-Folder", ""))) {
                    appCodes.add(appCode);
                }
                if ((filePath = newFolderPath + File.separator + path).endsWith(".hussar")) {
                    parentFolderPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                    this.createParentDirectoriesIfNotExists(parentFolderPath);
                    this.extractFile(zis, filePath);
                    HashMap<String, String> singleFilePaths = new HashMap<String, String>();
                    singleFilePaths.put(".hussar", filePath);
                    filePaths.put(appCode, singleFilePaths);
                } else if (filePath.endsWith(".appmeta")) {
                    this.extractFile(zis, filePath);
                    filePaths.put(".appmeta", filePath);
                } else {
                    parentFolderPath = filePath.substring(0, filePath.lastIndexOf(File.separator));
                    this.createParentDirectoriesIfNotExists(parentFolderPath);
                    this.extractFile(zis, filePath);
                    gitFolderFilePaths.add(filePath);
                    System.out.println("\u6dfb\u52a0\u6587\u4ef6\u5939: " + filePath);
                }
                zipEntry = zis.getNextEntry();
            }
            String commonDirectory = TenantApplicationServiceImpl.findCommonDirectory(gitFolderFilePaths);
            logger.info("\u5171\u540c\u4e0a\u7ea7\u4e3a: " + commonDirectory);
            for (String appCode : appCodes) {
                if (!filePaths.containsKey(appCode)) continue;
                Map temp = (Map)filePaths.get(appCode);
                temp.put("gitFolder", commonDirectory + File.separator + appCode + "-Folder" + File.separator + "gitFolder");
                filePaths.put(appCode, temp);
            }
            zis.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePaths;
    }

    private void createParentDirectoriesIfNotExists(String folderPath) {
        ArrayList<String> directoryPaths = new ArrayList<String>();
        if (folderPath.endsWith(File.separator)) {
            folderPath = folderPath.substring(0, folderPath.length() - 1);
        }
        File file = new File(folderPath);
        directoryPaths.add(folderPath);
        for (File parentDir = file.getParentFile(); parentDir != null && !parentDir.getAbsolutePath().equals(File.separator); parentDir = parentDir.getParentFile()) {
            directoryPaths.add(parentDir.getAbsolutePath());
        }
        Collections.reverse(directoryPaths);
        for (String path : directoryPaths) {
            File dir = new File(path);
            if (dir.exists()) continue;
            if (dir.mkdirs()) {
                logger.info("\u6587\u4ef6\u5939\u521b\u5efa\u6210\u529f: " + dir.getAbsolutePath());
                continue;
            }
            logger.error("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25: " + dir.getAbsolutePath());
        }
    }

    private static String findCommonDirectory(List<String> paths) {
        ArrayList<Path> absolutePaths = new ArrayList<Path>();
        for (String path : paths) {
            Path absolutePath = Paths.get(path, new String[0]).toAbsolutePath().normalize();
            absolutePaths.add(absolutePath);
        }
        Path commonParent = (Path)absolutePaths.get(0);
        for (int i = 1; i < absolutePaths.size(); ++i) {
            Path currentPath = (Path)absolutePaths.get(i);
            while (!currentPath.startsWith(commonParent)) {
                if ((commonParent = commonParent.getParent()) != null) continue;
                throw new IllegalArgumentException("No common parent directory found for the given paths.");
            }
        }
        return commonParent.toAbsolutePath().toString();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
            bos.close();
        }
    }

    private Map<String, Object> analyzeFileData(String filePath) {
        FileInputStream fileInputStream = null;
        HashMap<String, Object> data = new HashMap();
        try {
            fileInputStream = new FileInputStream(filePath);
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(filePath, filePath, "application" + File.separator + "octet-stream", (InputStream)fileInputStream);
            byte[] fileContent = multipartFile.getBytes();
            data = (Map)SerializeUtils.deserialize((byte[])fileContent);
        }
        catch (Exception e) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_DESERIALIZE_ERROR", (String)"\u53cd\u5e8f\u5217\u5316\u6570\u636e\u51fa\u9519\uff0c\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e"));
        }
        if (ToolUtil.isEmpty(data)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_FAIL", (String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u5bfc\u5165\u5e73\u53f0\u6570\u636e"));
        }
        return data;
    }

    private List<String> findDbdFiles(String folderPath) {
        File folder = new File(folderPath);
        ArrayList<String> dbdFiles = new ArrayList<String>();
        if (!folder.exists() || !folder.isDirectory()) {
            throw new IllegalArgumentException("The given path is not a directory or does not exist.");
        }
        File[] files = folder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    dbdFiles.addAll(this.findDbdFiles(file.getAbsolutePath()));
                    continue;
                }
                if (!file.isFile() || !file.getName().endsWith(".dbd")) continue;
                dbdFiles.add(file.getAbsolutePath());
            }
        }
        return dbdFiles;
    }

    private void changeDbNameForDataModel(String dbdFilePath, String newDbName) {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject(new String(Files.readAllBytes(Paths.get(dbdFilePath, new String[0]))));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (FileReader reader = new FileReader(dbdFilePath);
             FileWriter writer = new FileWriter(dbdFilePath);){
            this.modifyDataSourceName(jsonObject, newDbName);
            writer.write(jsonObject.toString(4));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void modifyDataSourceName(JSONObject jsonObject, String newValue) {
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get(key);
            if (value instanceof JSONObject) {
                this.modifyDataSourceName((JSONObject)value, newValue);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Object arrayItem = jsonArray.get(i);
                    if (!(arrayItem instanceof JSONObject)) continue;
                    this.modifyDataSourceName((JSONObject)arrayItem, newValue);
                }
                continue;
            }
            if (!"dataSourceName".equals(key)) continue;
            jsonObject.put("dataSourceName", (Object)newValue);
        }
    }

    private String[] unzipFile(File zipFilePath, String[] destDirectories) throws IOException {
        if (destDirectories == null || destDirectories.length < 3) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_TARGET_DIR_ERROR", (String)"\u76ee\u6807\u76ee\u5f55\u8bbe\u7f6e\u9519\u8bef"));
        }
        String[] filePaths = new String[3];
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry zipEntry;
            int i = 0;
            while ((zipEntry = zis.getNextEntry()) != null) {
                String entryName = zipEntry.getName();
                String tempFilePath = null;
                if (zipEntry.isDirectory()) continue;
                tempFilePath = entryName.endsWith("hussar") ? destDirectories[0] : (entryName.startsWith(".projectstore" + File.separator) ? destDirectories[1] : destDirectories[2]);
                File tempFile = new File(tempFilePath, entryName);
                this.extractFile(zis, tempFile);
                filePaths[i] = tempFile.getPath();
                if (entryName.startsWith(".projectstore" + File.separator)) {
                    File targetFile = new File(destDirectories[1], entryName);
                    this.moveFile(tempFile, targetFile);
                }
                ++i;
                zis.closeEntry();
            }
        }
        return filePaths;
    }

    private void moveFile(File sourceFile, File targetFile) throws IOException {
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        Files.move(sourceFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void extractFile(ZipInputStream zis, File destFile) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));){
            byte[] bytesIn = new byte[4096];
            int read = 0;
            while ((read = zis.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    private void copyFileToDirectory(String sourceFilePath, String destDir) throws IOException {
        File sourceFile = new File(sourceFilePath);
        File destFile = new File(destDir, sourceFile.getName());
        Files.copy(sourceFile.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private void zipDirectory(String sourceDir, String zipFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFilePath);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            File sourceDirFile = new File(sourceDir);
            this.zipFile(sourceDirFile, sourceDirFile, zos);
        }
    }

    private void zipFile(File directory, File fileToZip, ZipOutputStream zos) throws IOException {
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            zos.putNextEntry(new ZipEntry(fileToZip.getName() + File.separator));
            zos.closeEntry();
            for (File childFile : children = fileToZip.listFiles()) {
                this.zipFile(directory, childFile, zos);
            }
            return;
        }
        try (FileInputStream fis = new FileInputStream(fileToZip);){
            int length;
            ZipEntry zipEntry = new ZipEntry(this.getPathRelativeTo(directory, fileToZip));
            zos.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zos.write(bytes, 0, length);
            }
            zos.closeEntry();
        }
    }

    private String getPathRelativeTo(File directory, File file) {
        try {
            Path directoryPath = directory.toPath();
            Path filePath = file.toPath();
            return directoryPath.relativize(filePath).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void deleteDirectory(String path) throws IOException {
        File directory = new File(path);
        if (directory.exists()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        this.deleteDirectory(file.getAbsolutePath());
                        continue;
                    }
                    file.delete();
                }
            }
            directory.delete();
        }
    }

    private void deleteFilesInDirectory(String path) throws IOException {
        File[] files;
        File directory = new File(path);
        if (directory.exists() && (files = directory.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file.getAbsolutePath());
                    continue;
                }
                file.delete();
            }
        }
    }

    private void changeParentArtifactId(String pomFilePath, String newArtifactId) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(new File(pomFilePath));
            NodeList parentNodes = doc.getElementsByTagName("parent");
            if (parentNodes.getLength() > 0) {
                Element parentElement = (Element)parentNodes.item(0);
                NodeList artifactIdNodes = parentElement.getElementsByTagName("artifactId");
                if (artifactIdNodes.getLength() > 0) {
                    Element artifactIdElement = (Element)artifactIdNodes.item(0);
                    artifactIdElement.setTextContent(newArtifactId);
                } else {
                    logger.error("<artifactId> element not found under <parent>");
                }
            } else {
                logger.error("<parent> element not found in pom.xml");
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pomFilePath));
            transformer.transform(source, result);
            logger.info("pom.xml updated successfully!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Long sendFileToOss(String fileName) {
        try (FileInputStream fileInputStream = new FileInputStream(fileName);){
            Long ossId;
            HussarBaseMultipartFile multipartFile = new HussarBaseMultipartFile(fileName, fileName, "application" + File.separator + "octet-stream", (InputStream)fileInputStream);
            ApiResponse ossResponse = this.ossService.backgroundUpload((MultipartFile)multipartFile);
            Long l = ossId = (Long)ossResponse.getData();
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void putEnvCache(String val) {
        HussarCacheUtil.put((String)"hussar_application", (Object)("user_env_states" + BaseSecurityUtil.getUser().getUserId()), (Object)val);
    }

    public void startDevelop(String appId) {
        SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)Long.valueOf(Long.parseLong(appId)));
        SecurityUser loginUser = BaseSecurityUtil.getUser();
        HussarTenantDefinition tenant = this.hussarBaseTenantService.getTenantByTenantCode(loginUser.getTenantCode());
        DeployGitDto gitDto = new DeployGitDto();
        gitDto.setAccessToken(tenant.getGitToken());
        gitDto.setGitUri(tenant.getGitUrl());
        gitDto.setTenantCode(tenant.getTenantCode());
        gitDto.setBranch(loginUser.getAccount());
        gitDto.setUserId(loginUser.getUserId());
        ApiResponse response = GitlabUtil.branchExist((GitDto)gitDto);
        boolean startAuto = this.userEvnProperties.getStartAuto();
        logger.info("\u662f\u5426\u542f\u52a8\u4e2a\u4eba\u73af\u5883\uff1a{}", (Object)startAuto);
        UserDevEnv devEnv = (UserDevEnv)this.userDevEnvService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)loginUser.getUserId())).eq(UserDevEnv::getAppId, (Object)Long.parseLong(appId)));
        Map userEnvPortByUserId = this.userEnvPortService.addUserEnvPort(Boolean.valueOf(true));
        if (((Boolean)response.getData()).booleanValue()) {
            if (devEnv == null) {
                UserDevEnv insert = new UserDevEnv();
                insert.setAppName(application.getAppName());
                insert.setUserId(loginUser.getUserId());
                insert.setAppId(Long.valueOf(Long.parseLong(appId)));
                insert.setCreator(loginUser.getUserId());
                insert.setLastEditor(loginUser.getUserId());
                insert.setCreateTime(LocalDateTime.now());
                insert.setLastTime(LocalDateTime.now());
                this.userDevEnvService.save((Object)insert);
                gitDto.setSourceBranch("develop");
                gitDto.setTargetBranch(loginUser.getAccount());
                gitDto.setTitle(TranslateUtil.getTranslateName((String)"APP_LOW_MERGE_DEVELOP_TO_PERSONAL_BRANCH", (String)MERGE_DEVELOP_TO_PERSONAL_BRANCH));
                try {
                    logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_MERGE_DEVELOP_TO_PERSONAL_BRANCH", (String)MERGE_DEVELOP_TO_PERSONAL_BRANCH));
                    ApiResponse remoteMergeResponse = GitlabUtil.remoteMerge((GitDto)gitDto);
                    System.out.println("-------------------------------------remoteMergeResponse = " + remoteMergeResponse.getData());
                }
                catch (Exception e) {
                    logger.info(TranslateUtil.getTranslateName((String)"APP_LOW_DEVELOP_MERGE_PERSON_FAIL", (String)"\u5c06develop\u5408\u5e76\u5230\u4e2a\u4eba\u5206\u652f\u5931\u8d25:{}"), (Object)e.getMessage());
                }
                this.hussarDeployService.initWorkSpace(gitDto);
                gitDto.setAppCode(application.getAppCode());
                gitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"APP_LOW_UPDATE_POM_ADD_DEPENDENCY", (String)"\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56"));
                try {
                    this.hussarDeployService.addAppDependenceInPom(gitDto);
                }
                catch (Exception e) {
                    logger.info("\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56\u5931\u8d25:{}", (Object)e.getMessage());
                }
                if (startAuto) {
                    this.putEnvCache(UserEnvStatus.ENV_STATUS_RESTART.getDesc());
                    this.hussarDeployService.stop(String.valueOf(userEnvPortByUserId.get("back")));
                    this.hussarDeployService.stop(String.valueOf(userEnvPortByUserId.get(FRONT)));
                    this.hussarDeployService.stop(String.valueOf(userEnvPortByUserId.get(MOBILE)));
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    ApiResponse start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get(FRONT)), String.valueOf(userEnvPortByUserId.get(MOBILE)), this.getAppCodes(loginUser.getUserId()));
                    if (!((Boolean)start.getData()).booleanValue()) {
                        this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
                    }
                }
            } else {
                ApiResponse envStatus;
                gitDto.setUserId(loginUser.getUserId());
                gitDto.setBranch(loginUser.getAccount());
                this.hussarDeployService.initWorkSpace(gitDto);
                if (startAuto && !((Boolean)(envStatus = this.hussarDeployService.getEnvStatus((Integer)userEnvPortByUserId.get(FRONT), (Integer)userEnvPortByUserId.get("back"), (Integer)userEnvPortByUserId.get(MOBILE))).getData()).booleanValue()) {
                    this.putEnvCache(UserEnvStatus.ENV_STATUS_STARTING.getDesc());
                    ApiResponse start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get(FRONT)), String.valueOf(userEnvPortByUserId.get(MOBILE)), this.getAppCodes(loginUser.getUserId()));
                    if (!((Boolean)start.getData()).booleanValue()) {
                        this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
                    }
                }
            }
        } else {
            ApiResponse start;
            String refName = this.templateFileProperties.getBranch();
            gitDto.setRefName(refName);
            GitlabUtil.createRemoteBranch((GitDto)gitDto);
            if (null == devEnv) {
                UserDevEnv userDevEnv = new UserDevEnv();
                userDevEnv.setUserId(loginUser.getUserId());
                userDevEnv.setAppId(Long.valueOf(appId));
                userDevEnv.setAppName(application.getAppName());
                userDevEnv.setCreator(loginUser.getUserId());
                userDevEnv.setCreateTime(LocalDateTime.now());
                userDevEnv.setLastEditor(loginUser.getUserId());
                userDevEnv.setLastTime(LocalDateTime.now());
                this.userDevEnvService.save((Object)userDevEnv);
            }
            DeployGitDto deployGitDto = new DeployGitDto();
            deployGitDto.setUserId(loginUser.getUserId());
            deployGitDto.setTenantCode(gitDto.getTenantCode());
            deployGitDto.setBranch(gitDto.getBranch());
            deployGitDto.setGitUri(gitDto.getGitUri());
            deployGitDto.setAccessToken(gitDto.getAccessToken());
            deployGitDto.setAppCode(application.getAppCode());
            try {
                this.hussarDeployService.initWorkSpace(deployGitDto);
                deployGitDto.setCommitMsg(TranslateUtil.getTranslateName((String)"APP_LOW_UPDATE_POM_ADD_DEPENDENCY", (String)"\u66f4\u65b0applicant\u7684pom\u6587\u4ef6\uff0c\u6dfb\u52a0\u5e94\u7528\u4f9d\u8d56"));
                this.hussarDeployService.addAppDependenceInPom(deployGitDto);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (startAuto && !((Boolean)(start = this.hussarDeployService.start(loginUser.getTenantCode(), loginUser.getUserId(), String.valueOf(userEnvPortByUserId.get("back")), String.valueOf(userEnvPortByUserId.get(FRONT)), String.valueOf(userEnvPortByUserId.get(MOBILE)), this.getAppCodes(loginUser.getUserId()))).getData()).booleanValue()) {
                this.putEnvCache(UserEnvStatus.ENV_STATUS_ERROR.getDesc());
            }
        }
    }

    public List<Instance> nacosInstanceInfo(String serverName) {
        try {
            Properties properties = new Properties();
            properties.put("serverAddr", this.serverAddr);
            properties.put("namespace", this.namespace);
            NamingService naming = NamingFactory.createNamingService((Properties)properties);
            return naming.getAllInstances(serverName);
        }
        catch (NacosException e) {
            return Lists.newArrayList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportAppData(Long recordId, Long appId, String tenantCode, String branch, Long userId, String appCode, HttpServletResponse response) {
        SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
        sysApplicationRecord.setRecordId(recordId);
        sysApplicationRecord.setRecordStatus("1");
        this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
        String zipFilePath = null;
        String appmetaHussarFilePath = null;
        String hussarFilePath = null;
        String localGitFilePath = null;
        try {
            Map<String, Object> appmetaData = this.getAppmetaHussarData(recordId);
            Map<String, Object> data = this.getHussarData(appId);
            appmetaHussarFilePath = this.makeAppmetaHussarFile(appmetaData);
            hussarFilePath = this.makeHussarFile(data);
            Path path = Paths.get(hussarFilePath, new String[0]);
            Path parentPath = path.getParent();
            localGitFilePath = parentPath.toString();
            ApiResponse<String> gitResponse = this.pullFileToLocal(branch, localGitFilePath, tenantCode, userId);
            if (!gitResponse.isSuccess()) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"GIT_PULL_FAIL", (String)GIT_PULL_FAIL));
            }
            String appFrontCodePath = localGitFilePath + File.separator + tenantCode + "-front" + File.separator + "apps" + File.separator + appCode;
            String appBackCodePath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + appCode;
            String appBackWebMainPath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + "web-main";
            String zipParentPath = localGitFilePath;
            zipFilePath = this.makeAppDataZip(appCode, zipParentPath, appmetaHussarFilePath, hussarFilePath, appFrontCodePath, appBackCodePath, appBackWebMainPath);
            Long ossId = this.sendFileToOss(zipFilePath);
            sysApplicationRecord.setRecordFileId(ossId);
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            String fileName = application.getAppName();
            String newFileName = fileName + "-" + DateUtil.format((Date)Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), (String)DATETIME_PATTERN) + ".zip";
            sysApplicationRecord.setRecordFileName(newFileName);
            sysApplicationRecord.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
            HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)5, (String)TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_COMPLETE", (String)"\u5bfc\u51fa\u5b8c\u6210"), (Long)ossId, (boolean)false));
        }
        catch (Exception e) {
            try {
                HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)0, (String)(TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_ERROR", (String)"\u5bfc\u51fa\u5f02\u5e38") + e.getMessage()), (Long)0L, (boolean)true));
                sysApplicationRecord.setRecordStatus("3");
                this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
                throw new BaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (localGitFilePath != null) {
                        this.deleteDirectory(localGitFilePath);
                    }
                    if (hussarFilePath != null) {
                        this.deleteDirectory(hussarFilePath);
                    }
                    if (appmetaHussarFilePath != null) {
                        this.deleteDirectory(appmetaHussarFilePath);
                    }
                    if (zipFilePath == null) throw throwable;
                    this.deleteDirectory(zipFilePath);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        try {
            if (localGitFilePath != null) {
                this.deleteDirectory(localGitFilePath);
            }
            if (hussarFilePath != null) {
                this.deleteDirectory(hussarFilePath);
            }
            if (appmetaHussarFilePath != null) {
                this.deleteDirectory(appmetaHussarFilePath);
            }
            if (zipFilePath == null) return;
            this.deleteDirectory(zipFilePath);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportBatchAppData(Long recordId, String tenantCode, String branch, Long userId, Map<Long, String> appIdWithCode, HttpServletResponse response) {
        SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
        sysApplicationRecord.setRecordId(recordId);
        sysApplicationRecord.setRecordStatus("1");
        this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
        String zipFilePath = null;
        String appmetaHussarFilePath = null;
        String hussarFilePath = null;
        String localGitFilePath = null;
        ArrayList<ExportAppFilePath> exportAppList = new ArrayList<ExportAppFilePath>();
        String fileName = "\u5e94\u7528\u5bfc\u51fa\u5305.zip";
        try {
            Map<String, Object> appmetaData = this.getBatchAppmetaHussarData(recordId);
            appmetaHussarFilePath = this.makeAppmetaHussarFile(appmetaData);
            for (Long appId : appIdWithCode.keySet()) {
                String appCode = appIdWithCode.get(appId);
                Map<String, Object> data = this.getHussarData(appId);
                hussarFilePath = this.makeHussarFile(data);
                Path path = Paths.get(hussarFilePath, new String[0]);
                Path parentPath = path.getParent();
                localGitFilePath = parentPath.toString();
                File appCodeFile = new File(localGitFilePath + File.separator + tenantCode + "-web" + File.separator + appCode);
                ApiResponse<String> gitResponse = null;
                if (!appCodeFile.exists() && !(gitResponse = this.pullFileToLocal(branch, localGitFilePath, tenantCode, userId)).isSuccess()) {
                    throw new BaseException(TranslateUtil.getTranslateName((String)"GIT_PULL_FAIL", (String)GIT_PULL_FAIL));
                }
                String appFrontCodePath = localGitFilePath + File.separator + tenantCode + "-front" + File.separator + "apps" + File.separator + appCode;
                String appBackCodePath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + appCode;
                String appBackWebMainPath = localGitFilePath + File.separator + tenantCode + "-web" + File.separator + "web-main";
                ExportAppFilePath exportAppFilePath = new ExportAppFilePath();
                exportAppFilePath.setAppCode(appCode);
                exportAppFilePath.setAppmetaHussarFilePath(appmetaHussarFilePath);
                exportAppFilePath.setAppFrontCodePath(appFrontCodePath);
                exportAppFilePath.setAppBackCodePath(appBackCodePath);
                exportAppFilePath.setAppBackWebMainPath(appBackWebMainPath);
                exportAppFilePath.setHussarFilePath(hussarFilePath);
                exportAppList.add(exportAppFilePath);
            }
            String zipParentPath = localGitFilePath;
            zipFilePath = this.makeBatchAppDataZip(zipParentPath, exportAppList);
            Long ossId = this.sendFileToOss(zipFilePath);
            sysApplicationRecord.setRecordFileId(ossId);
            sysApplicationRecord.setRecordFileName(fileName);
            sysApplicationRecord.setRecordStatus("2");
            this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
            HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)5, (String)TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_COMPLETE", (String)"\u5bfc\u51fa\u5b8c\u6210"), (Long)ossId, (boolean)false));
        }
        catch (Exception e) {
            try {
                HussarCacheUtil.put((String)"app_export_Progress", (Object)ImportProgressCacheAspect.EXPORT_CACHE_KEY, (Object)ExportStatusVo.put((int)0, (String)(TranslateUtil.getTranslateName((String)"APP_LOW_EXPORT_ERROR", (String)"\u5bfc\u51fa\u5f02\u5e38") + e.getMessage()), (Long)0L, (boolean)true));
                sysApplicationRecord.setRecordStatus("3");
                this.sysApplicationRecordService.updateById((Object)sysApplicationRecord);
                throw new BaseException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (localGitFilePath != null) {
                        this.deleteDirectory(localGitFilePath);
                    }
                    if (hussarFilePath != null) {
                        this.deleteDirectory(hussarFilePath);
                    }
                    if (appmetaHussarFilePath != null) {
                        this.deleteDirectory(appmetaHussarFilePath);
                    }
                    if (zipFilePath == null) throw throwable;
                    this.deleteDirectory(zipFilePath);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
        try {
            if (localGitFilePath != null) {
                this.deleteDirectory(localGitFilePath);
            }
            if (hussarFilePath != null) {
                this.deleteDirectory(hussarFilePath);
            }
            if (appmetaHussarFilePath != null) {
                this.deleteDirectory(appmetaHussarFilePath);
            }
            if (zipFilePath == null) return;
            this.deleteDirectory(zipFilePath);
            return;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getTenantOrAppName(Long appId, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isNotEmpty((Object)tenantCode)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysTenant::getTenantCode, (Object)tenantCode);
            SysTenant tenant = (SysTenant)this.sysTenantService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isEmpty((Object)tenant)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_TENANT_MISS", (String)"\u79df\u6237\u4e0d\u5b58\u5728"));
            }
            map.put("tenantName", tenant.getTenantName());
            map.put("tenantIconType", tenant.getTenantIconType());
            map.put("tenantIcon", tenant.getTenantIcon());
            map.put("tenantIconColor", tenant.getTenantIconColor());
            map.put("tenantDescription", tenant.getTenantDescription());
        }
        if (HussarUtils.isNotEmpty((Object)appId)) {
            SysApplication application = (SysApplication)this.sysApplicationService.getById((Serializable)appId);
            if (HussarUtils.isEmpty((Object)application)) {
                throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_APP_MISS", (String)"\u5e94\u7528\u4e0d\u5b58\u5728"));
            }
            String appName = application.getAppName();
            map.put(APP_NAME, appName);
            map.put(APP_ICON_TYPE, application.getAppIconType());
            map.put(APP_ICON, application.getAppIcon());
            map.put(APP_ICON_COLOR, application.getAppIconColor());
        }
        return map;
    }

    public String getAppCodes(Long userId) {
        List userDevEnvList = this.userDevEnvService.list((Wrapper)Wrappers.lambdaQuery().eq(UserDevEnv::getUserId, (Object)userId));
        if (CollectionUtils.isNotEmpty((Collection)userDevEnvList)) {
            List appIds = userDevEnvList.stream().map(UserDevEnv::getAppId).collect(Collectors.toList());
            List appCodeList = this.sysApplicationService.list((Wrapper)Wrappers.lambdaQuery().in(SysApplication::getId, appIds)).stream().map(SysApplication::getAppCode).collect(Collectors.toList());
            return String.join((CharSequence)",", appCodeList);
        }
        return "";
    }
}

