/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysApplicationRecordMapper;
import com.jxdinfo.hussar.application.dto.ApplicationRecordDto;
import com.jxdinfo.hussar.application.model.SysApplicationRecord;
import com.jxdinfo.hussar.application.service.ISysApplicationRecordService;
import com.jxdinfo.hussar.application.vo.ApplicationRecordVo;
import com.jxdinfo.hussar.application.vo.ExportStatusVo;
import com.jxdinfo.hussar.application.vo.ImportStatusVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.CopyPropertieUtils;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.utils.TranslateUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysApplicationRecordServiceImpl")
public class SysApplicationRecordServiceImpl
extends HussarServiceImpl<SysApplicationRecordMapper, SysApplicationRecord>
implements ISysApplicationRecordService {
    private static Logger logger = LoggerFactory.getLogger(SysApplicationRecordServiceImpl.class);
    @Resource
    private SysApplicationRecordMapper sysApplicationRecordMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Autowired
    private OssService ossService;

    public Long newApplicationRecord(String recordType, Long appId, String appMode, Long creatorId, String recordFilePwd) {
        SysApplicationRecord sysApplicationRecord = new SysApplicationRecord();
        long recordId = IdWorker.getId((Object)sysApplicationRecord);
        sysApplicationRecord.setRecordId(Long.valueOf(recordId));
        sysApplicationRecord.setRecordType(recordType);
        sysApplicationRecord.setAppIds(appId.toString());
        sysApplicationRecord.setAppMode(appMode);
        sysApplicationRecord.setCreator(creatorId);
        sysApplicationRecord.setRecordFilePassword(recordFilePwd);
        if (!this.save((BaseEntity)sysApplicationRecord)) {
            throw new HussarException(TranslateUtil.getTranslateName((String)"APP_LOW_IMPORT_EXPORT_LOG_FAIL", (String)"\u5e94\u7528\u5bfc\u5165\u5bfc\u51fa\u8bb0\u5f55\u751f\u6210\u5931\u8d25\uff01"));
        }
        return recordId;
    }

    public ApplicationRecordVo getApplicationRecordById(Long recordId) {
        SysApplicationRecord sysApplicationRecord = (SysApplicationRecord)this.sysApplicationRecordMapper.selectById(recordId);
        if (HussarUtils.isEmpty((Object)sysApplicationRecord)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_QUERY_FAIL", (String)"\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        ApplicationRecordVo applicationRecordVo = new ApplicationRecordVo();
        CopyPropertieUtils.copyProperties((Object)applicationRecordVo, (Object)sysApplicationRecord);
        SysUsers user = this.sysUsersService.getById(sysApplicationRecord.getCreator());
        String userName = user.getUserName();
        applicationRecordVo.setCreatorName(userName);
        return applicationRecordVo;
    }

    public Page<ApplicationRecordVo> getApplicationRecordVoList(PageInfo pageInfo, ApplicationRecordDto applicationRecordDto) {
        SecurityUser securityUser;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        if (ToolUtil.isEmpty((Object)pageInfo)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_QUERY_PAGE_NULL", (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (HussarUtils.isNotEmpty((Object)applicationRecordDto.getRecordType())) {
            wrapper.eq(SysApplicationRecord::getRecordType, (Object)applicationRecordDto.getRecordType());
        }
        if (HussarUtils.isNotEmpty((Object)applicationRecordDto.getAppMode())) {
            wrapper.eq(SysApplicationRecord::getAppMode, (Object)applicationRecordDto.getAppMode());
        }
        if (HussarUtils.isNotEmpty((Object)applicationRecordDto.getRecordStatus())) {
            wrapper.eq(SysApplicationRecord::getRecordStatus, (Object)applicationRecordDto.getRecordStatus());
        }
        if (HussarUtils.isNotEmpty((Object)applicationRecordDto.getRecordFileName())) {
            wrapper.like(SysApplicationRecord::getRecordFileName, (Object)applicationRecordDto.getRecordFileName());
        }
        if (!(securityUser = BaseSecurityUtil.getUser()).getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            wrapper.eq(HussarBaseEntity::getCreator, (Object)securityUser.getId());
        }
        Page sysApplicationRecordPage = (Page)this.sysApplicationRecordMapper.selectPage((IPage)page, (Wrapper)wrapper);
        List sysApplicationRecordList = sysApplicationRecordPage.getRecords();
        List<Object> applicationRecordVos = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)sysApplicationRecordList)) {
            List<Long> recordIds = sysApplicationRecordList.stream().map(SysApplicationRecord::getRecordId).collect(Collectors.toList());
            applicationRecordVos = this.getAppRecordVosByIds(recordIds);
        }
        Page applicationRecordVoPage = new Page();
        applicationRecordVoPage.setRecords(applicationRecordVos);
        applicationRecordVoPage.setTotal(sysApplicationRecordPage.getTotal());
        applicationRecordVoPage.setSize(sysApplicationRecordPage.getSize());
        applicationRecordVoPage.setCurrent(sysApplicationRecordPage.getCurrent());
        return applicationRecordVoPage;
    }

    public List<ApplicationRecordVo> getAppRecordVosByIds(List<Long> ids) {
        return this.sysApplicationRecordMapper.getAppRecordVosByIds(ids);
    }

    public boolean batchDeleteAppRecords(String taskIds) {
        if (ToolUtil.isEmpty((Object)taskIds)) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_DELETE_RECORD_ID_NULL", (String)"\u8981\u5220\u9664\u7684\u8bb0\u5f55id\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        List<String> idList = Arrays.asList(taskIds.split(","));
        List idLongList = idList.stream().map(Long::valueOf).collect(Collectors.toList());
        int result = this.sysApplicationRecordMapper.deleteBatchIds(idLongList);
        if (result < 1) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return true;
    }

    public ApiResponse<ExportStatusVo> getExportProgress(String exportCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"app_export_Progress", (Object)exportCacheKey, ExportStatusVo.class));
    }

    public ApiResponse<ImportStatusVo> getImportProgress(String importCacheKey) {
        return ApiResponse.success((Object)HussarCacheUtil.get((String)"app_import_progress", (Object)importCacheKey, ImportStatusVo.class));
    }

    public void downloadAppExportFile(Long fileId, HttpServletResponse response) {
        ApiResponse apiResponse = this.ossService.backgroundDownload(fileId);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(SysApplicationRecord::getRecordFileId, (Object)fileId);
        SysApplicationRecord sysApplicationRecord = (SysApplicationRecord)this.sysApplicationRecordMapper.selectOne((Wrapper)wrapper);
        if (apiResponse == null || !apiResponse.isSuccess()) {
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_DOWNLOAD_FAIL", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01"));
        }
        try (ServletOutputStream os = response.getOutputStream();){
            String fileName = sysApplicationRecord.getRecordFileName();
            fileName = URLEncoder.encode(fileName, "UTF-8");
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.setContentType("multipart/form-data");
            IOUtils.write((byte[])((byte[])apiResponse.getData()), (OutputStream)os);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BaseException(TranslateUtil.getTranslateName((String)"APP_LOW_DOWNLOAD_FAIL", (String)"\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01"));
        }
    }
}

