/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysAppGroupCommonMapper;
import com.jxdinfo.hussar.application.dao.SysApplicationCommonMapper;
import com.jxdinfo.hussar.application.dto.SysAppGroupDto;
import com.jxdinfo.hussar.application.model.SysAppGroup;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppDevelopTeamService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.vo.SysAppGroupVo;
import com.jxdinfo.hussar.application.vo.SysApplicationVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysAppGroupImpl")
public class SysAppGroupImpl
extends HussarServiceImpl<SysAppGroupCommonMapper, SysAppGroup>
implements ISysAppGroupService {
    @Autowired
    private IHussarBaseUserBoService userBoService;
    @Resource
    private SysAppGroupCommonMapper sysAppGroupCommonMapper;
    @Autowired
    private ISysAppDevelopTeamService developTeamService;
    @Resource
    private SysApplicationCommonMapper sysApplicationCommonMapper;

    @HussarTransactional
    public ApiResponse<Boolean> addGroup(SysAppGroupDto sysAppGroupDto) {
        List groups = this.list((Wrapper)new LambdaQueryWrapper().eq(SysAppGroup::getGroupName, (Object)sysAppGroupDto.getGroupName()));
        if (HussarUtils.isNotEmpty((Object)groups)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        sysAppGroupDto.setGroupType("2");
        Integer seq = this.sysAppGroupCommonMapper.getMaxSeq();
        seq = HussarUtils.isEmpty((Object)seq) ? 1 : seq + 1;
        sysAppGroupDto.setSEQ(seq);
        boolean flag = this.save((BaseEntity)sysAppGroupDto);
        if (!flag) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u65b0\u589e\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Boolean> updateGroup(SysAppGroupDto sysAppGroupDto) {
        List groups = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysAppGroup::getGroupName, (Object)sysAppGroupDto.getGroupName())).ne(SysAppGroup::getId, (Object)sysAppGroupDto.getId()));
        if (HussarUtils.isNotEmpty((Object)groups)) {
            throw new BaseException("\u4fee\u6539\u5931\u8d25\uff01\u5e94\u7528\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        SysAppGroup group = (SysAppGroup)this.getById(sysAppGroupDto.getId());
        Integer seq = group.getSEQ();
        sysAppGroupDto.setSEQ(seq);
        boolean flag = this.updateById((BaseEntity)sysAppGroupDto);
        if (!flag) {
            throw new BaseException("\u66f4\u65b0\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteGroup(Long groupId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysApplication::getAppGroupId, (Object)groupId);
        if (HussarUtils.isNotEmpty((Object)this.sysApplicationCommonMapper.selectList((Wrapper)wrapper))) {
            throw new BaseException("\u5220\u9664\u5931\u8d25\uff01\u5206\u7ec4\u4e0b\u5b58\u5728\u5e94\u7528\uff01");
        }
        boolean flag = this.removeById(groupId);
        if (!flag) {
            throw new BaseException("\u5220\u9664\u5931\u8d25");
        }
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    public ApiResponse<List<SysAppGroup>> getGroupList() {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.orderByAsc(HussarBaseEntity::getCreateTime);
        return ApiResponse.success((Object)this.list((Wrapper)wrapper));
    }

    public Page<SysAppGroupVo> getGroupPageList(PageInfo pageInfo, String groupName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("groupName", SqlQueryUtil.transferSpecialChar((String)StringUtils.trimToEmpty((String)groupName)));
        List<SysAppGroupVo> groups = this.sysAppGroupCommonMapper.getAppGroupPageList((Page<SysAppGroupVo>)page, queryParams);
        if (HussarUtils.isEmpty(groups)) {
            return page;
        }
        List userIds = groups.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
        Map userMap = this.userBoService.getUserInfo(userIds);
        for (SysAppGroupVo item : groups) {
            SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
            if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
            item.setCreateName(sysUsers.getUserName());
        }
        page.setRecords(groups);
        return page;
    }

    public ApiResponse<List<SysAppGroup>> listGroup() {
        List appIds = this.developTeamService.selectAppListByCurrentUser();
        if (HussarUtils.isEmpty((Object)appIds)) {
            return ApiResponse.success(Collections.emptyList());
        }
        List<SysApplicationVo> appList = this.sysApplicationCommonMapper.getAppListManage(null, null, appIds, null, null);
        if (HussarUtils.isEmpty(appList)) {
            return ApiResponse.success(Collections.emptyList());
        }
        Set groupIds = appList.stream().map(SysApplication::getAppGroupId).collect(Collectors.toSet());
        List sysAppGroups = this.sysAppGroupCommonMapper.selectList((Wrapper)new LambdaQueryWrapper().in(SysAppGroup::getId, groupIds));
        return ApiResponse.success((Object)sysAppGroups);
    }

    public Integer getMaxSeq() {
        return this.sysAppGroupCommonMapper.getMaxSeq();
    }

    @HussarTransactional
    public Boolean sortGroup(List<Long> idList) {
        if (HussarUtils.isEmpty(idList)) {
            return Boolean.FALSE;
        }
        ArrayList<SysAppGroup> list = new ArrayList<SysAppGroup>();
        int num = 1;
        for (Long groupId : idList) {
            SysAppGroup group = new SysAppGroup();
            group.setId(groupId);
            group.setSEQ(Integer.valueOf(num));
            list.add(group);
            ++num;
        }
        return super.updateBatchById(list);
    }

    @HussarTransactional
    public ApiResponse<Long> addGroupNew(SysAppGroupDto sysAppGroupDto) {
        List groups = this.list((Wrapper)new LambdaQueryWrapper().eq(SysAppGroup::getGroupName, (Object)sysAppGroupDto.getGroupName()));
        if (HussarUtils.isNotEmpty((Object)groups)) {
            throw new BaseException("\u65b0\u589e\u5931\u8d25\uff01\u5e94\u7528\u5206\u7ec4\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
        Long id = IdWorker.getId((Object)sysAppGroupDto);
        sysAppGroupDto.setId(id);
        sysAppGroupDto.setGroupType("2");
        Integer seq = this.sysAppGroupCommonMapper.getMaxSeq();
        seq = HussarUtils.isEmpty((Object)seq) ? 1 : seq + 1;
        sysAppGroupDto.setSEQ(seq);
        this.save((BaseEntity)sysAppGroupDto);
        return ApiResponse.success((Object)id);
    }

    public Page<SysAppGroupVo> getGroupPage(PageInfo pageInfo, String groupName) {
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("groupName", SqlQueryUtil.transferSpecialChar((String)StringUtils.trimToEmpty((String)groupName)));
        List<SysAppGroupVo> groups = this.sysAppGroupCommonMapper.getGroupPageOrderSeq((Page<SysAppGroupVo>)page, queryParams);
        if (HussarUtils.isEmpty(groups)) {
            return page;
        }
        List userIds = groups.stream().map(HussarBaseEntity::getCreator).collect(Collectors.toList());
        Map userMap = this.userBoService.getUserInfo(userIds);
        for (SysAppGroupVo item : groups) {
            SysUsers sysUsers = (SysUsers)userMap.get(item.getCreator());
            if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
            item.setCreateName(sysUsers.getUserName());
        }
        page.setRecords(groups);
        return page;
    }
}

