/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppDevelopTeamMemberCommonMapper;
import com.jxdinfo.hussar.application.dao.SysAppRecycleCommonMapper;
import com.jxdinfo.hussar.application.dto.SysAppRecycleDto;
import com.jxdinfo.hussar.application.factory.HussarApplicationCallBackFactory;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeam;
import com.jxdinfo.hussar.application.model.SysAppDevelopTeamMember;
import com.jxdinfo.hussar.application.model.SysAppRecycle;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysAppGroupService;
import com.jxdinfo.hussar.application.service.ISysAppRecycleService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.vo.SysAppRecycleVo;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.constant.enums.SysUserAndRole;
import com.jxdinfo.hussar.common.constant.tenant.TenantConstant;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientModelService;
import com.jxdinfo.hussar.iam.client.vo.ClientVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.application.service.impl.SysAppRecycleServiceImpl")
public class SysAppRecycleServiceImpl
extends HussarServiceImpl<SysAppRecycleCommonMapper, SysAppRecycle>
implements ISysAppRecycleService {
    @Autowired
    private ISysApplicationService sysApplicationService;
    @Resource
    private SysAppRecycleCommonMapper sysAppRecycleCommonMapper;
    @Autowired
    private ISysAppGroupService sysAppGroupService;
    @Resource
    private SysAppDevelopTeamCommonMapper developTeamMapper;
    @Resource
    private SysAppDevelopTeamMemberCommonMapper developTeamMemberMapper;
    @Autowired
    private IHussarBaseUserBoService userBoService;
    @Resource
    private IHussarIamClientModelService iHussarIamClientModelService;
    @Autowired
    private ISysAppClientService sysAppClientService;

    public Page<SysAppRecycleVo> getRecycleList(PageInfo pageInfo, String appName, List<String> appTypes) {
        Page<SysAppRecycleVo> result;
        List appRecycleVoList;
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = null;
        if (!HussarUtils.equals((Object)user.getId(), (Object)SysUserAndRole.SUPERADMIN.getValue()) && !user.getRolesList().contains(TenantConstant.ADMIN_ROLE)) {
            userId = user.getUserId();
        }
        if (HussarUtils.isNotEmpty((Object)(appRecycleVoList = (result = this.sysAppRecycleCommonMapper.getRecycleList((Page<SysAppRecycleVo>)page, userId, SqlQueryUtil.transferSpecialChar((String)appName), appTypes)).getRecords()))) {
            List userIdList = appRecycleVoList.stream().map(SysAppRecycleVo::getUserId).collect(Collectors.toList());
            Map usersMap = this.userBoService.getUserInfo(userIdList);
            for (SysAppRecycleVo item : appRecycleVoList) {
                SysUsers sysUsers = (SysUsers)usersMap.get(item.getUserId());
                if (!HussarUtils.isNotEmpty((Object)sysUsers)) continue;
                item.setUserName(sysUsers.getUserName());
            }
        }
        return result;
    }

    public Boolean revertApp(SysAppRecycleDto sysAppRecycleDto) {
        ClientVo client;
        Long appId = sysAppRecycleDto.getId();
        String appName = sysAppRecycleDto.getAppName();
        SysAppRecycle revertApp = (SysAppRecycle)this.getById(appId);
        if (HussarUtils.isEmpty((Object)this.sysAppGroupService.getById((Serializable)revertApp.getAppGroupId()))) {
            revertApp.setAppGroupId(Long.valueOf(1L));
        }
        SysApplication sysApplication = new SysApplication();
        BeanUtils.copyProperties((Object)revertApp, (Object)sysApplication);
        sysApplication.setReleaseStatus("0");
        sysApplication.setCreator(revertApp.getCreateUser());
        sysApplication.setLastEditor(revertApp.getCreateUser());
        if (HussarUtils.isNotEmpty((Object)appName)) {
            sysApplication.setAppName(appName);
        }
        this.sysApplicationService.save((Object)sysApplication);
        SysAppClient sysAppClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)sysAppClient) && HussarUtils.isNotEmpty((Object)(client = (ClientVo)this.iHussarIamClientModelService.detail(sysAppClient.getClientModelId()).getData()))) {
            this.iHussarIamClientModelService.updateClientStatus(client.getClientId(), "1");
        }
        HussarApplicationCallBackFactory.revertRecycleApp(revertApp);
        return this.removeById(appId);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public Boolean deleteRecycleApp(Long appId) {
        ClientVo client;
        SysAppRecycle appRecycle = (SysAppRecycle)this.getById(appId);
        HussarApplicationCallBackFactory.beforeDeleteRecycleApp(appRecycle);
        SysAppDevelopTeam sysAppDevelopTeam = (SysAppDevelopTeam)this.developTeamMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeam::getAppId, (Object)appId));
        this.developTeamMapper.deleteById(sysAppDevelopTeam.getId());
        this.developTeamMemberMapper.delete((Wrapper)new LambdaQueryWrapper().eq(SysAppDevelopTeamMember::getTeamId, (Object)sysAppDevelopTeam.getId()));
        SysAppClient appClient = (SysAppClient)this.sysAppClientService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        this.sysAppClientService.remove((Wrapper)new LambdaQueryWrapper().eq(SysAppClient::getAppId, (Object)appId));
        if (HussarUtils.isNotEmpty((Object)appClient) && HussarUtils.isNotEmpty((Object)(client = (ClientVo)this.iHussarIamClientModelService.detail(appClient.getClientModelId()).getData()))) {
            this.iHussarIamClientModelService.deleteClientModel(client.getClientId());
        }
        boolean flag = this.removeById(appId);
        HussarApplicationCallBackFactory.deleteRecycleApp(appRecycle);
        HussarCacheUtil.evict((String)"iam_sdk", (Object)"clientId_appId_map");
        return flag;
    }
}

