/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.dto.AppDevelopTeamDto;
import com.jxdinfo.hussar.application.dto.TransferMemberTypeDto;
import com.jxdinfo.hussar.application.dto.UpdateMemberTypeDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.IOutsideAppTeamCallBackService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class HussarApplicationTeamCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppTeamCallBackService> map = new HashMap<String, IHussarAppTeamCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppTeamCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppTeamCallBackService> beanMap) {
        for (IHussarAppTeamCallBackService appTeamCallBackService : beanMap.values()) {
            map.put(appTeamCallBackService.getAppType(), appTeamCallBackService);
        }
    }

    public static IHussarAppTeamCallBackService getAppTeamCallBackService(String appType) {
        IHussarAppTeamCallBackService appTeamCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appTeamCallBackService) ? map.get("default") : appTeamCallBackService;
    }

    private static String getServiceNameByAppId(Long appId) {
        ISysApplicationService sysApplicationService = (ISysApplicationService)SpringContextHolder.getBean(ISysApplicationService.class);
        SysApplication app = (SysApplication)sysApplicationService.getById((Serializable)appId);
        return app.getServiceName();
    }

    private static IOutsideAppTeamCallBackService getFeignService(String appType, String serviceName) {
        if (!"1".equals(appType)) {
            return null;
        }
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isBlank((CharSequence)serviceName) || serviceName.equalsIgnoreCase(currentServiceName)) {
            return null;
        }
        return (IOutsideAppTeamCallBackService)SpringContextHolder.getBean(IOutsideAppTeamCallBackService.class);
    }

    public static void saveAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        if (NacosUtil.isMicroService()) {
            Long appId = appDevelopTeamDto.getAppId();
            String serviceName = HussarApplicationTeamCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppTeamCallBackService feignService = HussarApplicationTeamCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.saveAppDevelopTeam(appDevelopTeamDto, serviceName, appType);
            } else {
                HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).saveAppDevelopTeam(appDevelopTeamDto);
            }
        } else {
            HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).saveAppDevelopTeam(appDevelopTeamDto);
        }
    }

    public static void updateAppDevelopTeam(AppDevelopTeamDto appDevelopTeamDto, String appType) {
        if (NacosUtil.isMicroService()) {
            Long appId = appDevelopTeamDto.getAppId();
            String serviceName = HussarApplicationTeamCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppTeamCallBackService feignService = HussarApplicationTeamCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.updateAppDevelopTeam(appDevelopTeamDto, appType, serviceName);
            } else {
                HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateAppDevelopTeam(appDevelopTeamDto, appType);
            }
        } else {
            HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateAppDevelopTeam(appDevelopTeamDto, appType);
        }
    }

    public static void updateMember(UpdateMemberTypeDto updateDto, String appType) {
        if (NacosUtil.isMicroService()) {
            Long appId = updateDto.getAppId();
            String serviceName = HussarApplicationTeamCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppTeamCallBackService feignService = HussarApplicationTeamCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.updateMember(updateDto, serviceName, appType);
            } else {
                HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateMember(updateDto);
            }
        } else {
            HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).updateMember(updateDto);
        }
    }

    public static void removeMembers(Long appId, Long userId, String appType) {
        if (NacosUtil.isMicroService()) {
            String serviceName = HussarApplicationTeamCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppTeamCallBackService feignService = HussarApplicationTeamCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.removeMembers(appId, userId, serviceName, appType);
            } else {
                HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).removeMembers(appId, userId);
            }
        } else {
            HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).removeMembers(appId, userId);
        }
    }

    public static void transferAdministrator(TransferMemberTypeDto transferDto, String appType) {
        if (NacosUtil.isMicroService()) {
            Long appId = transferDto.getAppId();
            String serviceName = HussarApplicationTeamCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppTeamCallBackService feignService = HussarApplicationTeamCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.transferAdministrator(transferDto, serviceName, appType);
            } else {
                HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).transferAdministrator(transferDto);
            }
        } else {
            HussarApplicationTeamCallBackFactory.getAppTeamCallBackService(appType).transferAdministrator(transferDto);
        }
    }
}

