/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.application.factory;

import com.jxdinfo.hussar.application.dto.SysAppVisitAuthorizeDto;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.IHussarAppVisitAuthCallBackService;
import com.jxdinfo.hussar.application.service.IOutsideAppVisitAuthCallBackService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.application.util.NacosUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class HussarAppVisitAuthCallBackFactory
implements ApplicationContextAware {
    private static final Map<String, IHussarAppVisitAuthCallBackService> map = new HashMap<String, IHussarAppVisitAuthCallBackService>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beanMap = applicationContext.getBeansOfType(IHussarAppVisitAuthCallBackService.class);
        this.setBeansToMap(beanMap);
    }

    private void setBeansToMap(Map<String, IHussarAppVisitAuthCallBackService> beanMap) {
        for (IHussarAppVisitAuthCallBackService appVisitAuthCallBackService : beanMap.values()) {
            map.put(appVisitAuthCallBackService.getAppType(), appVisitAuthCallBackService);
        }
    }

    public static IHussarAppVisitAuthCallBackService getAppVisitAuthCallBackService(String appType) {
        IHussarAppVisitAuthCallBackService appVisitAuthCallBackService = map.get(appType);
        return ToolUtil.isEmpty((Object)appVisitAuthCallBackService) ? map.get("default") : appVisitAuthCallBackService;
    }

    private static String getServiceNameByAppId(Long appId) {
        ISysApplicationService sysApplicationService = (ISysApplicationService)SpringContextHolder.getBean(ISysApplicationService.class);
        SysApplication app = (SysApplication)sysApplicationService.getById((Serializable)appId);
        return app.getServiceName();
    }

    private static IOutsideAppVisitAuthCallBackService getFeignService(String appType, String serviceName) {
        if (!"1".equals(appType)) {
            return null;
        }
        String currentServiceName = ((Environment)SpringContextHolder.getBean(Environment.class)).getProperty("spring.application.name");
        if (HussarUtils.isBlank((CharSequence)serviceName) || serviceName.equalsIgnoreCase(currentServiceName)) {
            return null;
        }
        return (IOutsideAppVisitAuthCallBackService)SpringContextHolder.getBean(IOutsideAppVisitAuthCallBackService.class);
    }

    public static void addAuthorization(SysAppVisitAuthorizeDto appVisitAuthorizeDto, String appType) {
        if (NacosUtil.isMicroService()) {
            Long appId = appVisitAuthorizeDto.getAppId();
            String serviceName = HussarAppVisitAuthCallBackFactory.getServiceNameByAppId(appId);
            IOutsideAppVisitAuthCallBackService feignService = HussarAppVisitAuthCallBackFactory.getFeignService(appType, serviceName);
            if (feignService != null) {
                feignService.addAuthorization(appVisitAuthorizeDto, serviceName, appType);
            } else {
                HussarAppVisitAuthCallBackFactory.getAppVisitAuthCallBackService(appType).addAuthorization(appVisitAuthorizeDto);
            }
        } else {
            HussarAppVisitAuthCallBackFactory.getAppVisitAuthCallBackService(appType).addAuthorization(appVisitAuthorizeDto);
        }
    }
}

